/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.io.FileInfo;
import ij.io.GifEncoder;
import ij.io.ImageWriter;
import ij.io.JpegEncoder;
import ij.io.SaveDialog;
import ij.io.TextEncoder;
import ij.io.TiffEncoder;
import ij.measure.Calibration;
import ij.plugin.filter.Analyzer;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileSaver {
    private static String defaultDirectory = null;
    private ImagePlus imp;
    private String name;
    private String directory;

    public FileSaver(ImagePlus imp) {
        this.imp = imp;
    }

    public boolean save() {
        return this.saveAsTiff();
    }

    String getPath(String type, String extension) {
        this.name = this.imp.getTitle();
        SaveDialog sd = new SaveDialog("Save as " + type, this.name, extension);
        this.name = sd.getFileName();
        if (this.name == null) {
            return null;
        }
        this.directory = sd.getDirectory();
        this.imp.startTiming();
        String path = String.valueOf(this.directory) + this.name;
        return path;
    }

    public boolean saveAsTiff() {
        String path = this.getPath("TIFF", ".tif");
        if (path == null) {
            return false;
        }
        if (this.imp.getStackSize() == 1) {
            return this.saveAsTiff(path);
        }
        return this.saveAsTiffStack(path);
    }

    public boolean saveAsTiff(String path) {
        FileInfo fi = this.imp.getFileInfo();
        fi.nImages = 1;
        try {
            TiffEncoder file = new TiffEncoder(fi);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
            file.write(out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        this.updateImp(fi, 2);
        return true;
    }

    public boolean saveAsTiffStack(String path) {
        FileInfo fi = this.imp.getFileInfo();
        if (fi.nImages == 1) {
            IJ.write("This is not a stack");
            return false;
        }
        try {
            TiffEncoder file = new TiffEncoder(fi);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
            file.write(out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        this.updateImp(fi, 2);
        return true;
    }

    public boolean saveAsZip() {
        String path = this.getPath("TIFF/ZIP", ".zip");
        if (path == null) {
            return false;
        }
        return this.saveAsZip(path);
    }

    public boolean saveAsZip(String path) {
        FileInfo fi = this.imp.getFileInfo();
        if (!path.endsWith(".zip")) {
            path = String.valueOf(path) + ".zip";
        }
        if (this.name == null) {
            this.name = this.imp.getTitle();
        }
        if (this.name.endsWith(".zip")) {
            this.name = this.name.substring(0, this.name.length() - 4);
        }
        if (!this.name.endsWith(".tif")) {
            this.name = String.valueOf(this.name) + ".tif";
        }
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(path));
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(zos));
            zos.putNextEntry(new ZipEntry(this.name));
            TiffEncoder te = new TiffEncoder(fi);
            te.write(out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        this.updateImp(fi, 2);
        return true;
    }

    public static boolean okForGif(ImagePlus imp) {
        int type = imp.getType();
        if (type == 4 || type == 1 || type == 2) {
            IJ.error("To save as Gif, the image must be \"8-bit\" or \"8-bit Color\".");
            return false;
        }
        return true;
    }

    public boolean saveAsGif() {
        if (!FileSaver.okForGif(this.imp)) {
            return false;
        }
        String path = this.getPath("GIF", ".gif");
        if (path == null) {
            return false;
        }
        return this.saveAsGif(path);
    }

    public boolean saveAsGif(String path) {
        if (!FileSaver.okForGif(this.imp)) {
            return false;
        }
        FileInfo fi = this.imp.getFileInfo();
        try {
            GifEncoder encoder = new GifEncoder(fi.width, fi.height, (byte[])fi.pixels, fi.reds, fi.greens, fi.blues);
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(path));
            encoder.write(output);
            ((OutputStream)output).close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        this.updateImp(fi, 3);
        return true;
    }

    public static boolean okForJpeg(ImagePlus imp) {
        int type = imp.getType();
        if (type == 1 || type == 2) {
            IJ.error("16 and 32-bit grayscale images cannot be saved as JPEG.");
            return false;
        }
        return true;
    }

    public boolean saveAsJpeg() {
        if (!FileSaver.okForJpeg(this.imp)) {
            return false;
        }
        String path = this.getPath("JPEG", ".jpg");
        if (path == null) {
            return false;
        }
        return this.saveAsJpeg(path);
    }

    public boolean saveAsJpeg(String path) {
        if (!FileSaver.okForJpeg(this.imp)) {
            return false;
        }
        FileInfo fi = this.imp.getFileInfo();
        try {
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(path));
            JpegEncoder encoder = new JpegEncoder(this.imp.getImage(), JpegEncoder.getQuality(), output);
            encoder.Compress();
            ((OutputStream)output).close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        this.updateImp(fi, 3);
        return true;
    }

    public boolean saveAsRaw() {
        String path = this.getPath("Raw", ".raw");
        if (path == null) {
            return false;
        }
        if (this.imp.getStackSize() == 1) {
            return this.saveAsRaw(path);
        }
        return this.saveAsRawStack(path);
    }

    public boolean saveAsRaw(String path) {
        FileInfo fi = this.imp.getFileInfo();
        fi.nImages = 1;
        try {
            ImageWriter file = new ImageWriter(fi);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(path));
            file.write(out);
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        this.updateImp(fi, 1);
        return true;
    }

    public boolean saveAsRawStack(String path) {
        FileInfo fi = this.imp.getFileInfo();
        if (fi.nImages == 1) {
            IJ.write("This is not a stack");
            return false;
        }
        try {
            ImageWriter file = new ImageWriter(fi);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(path));
            file.write(out);
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        this.updateImp(fi, 1);
        return true;
    }

    public boolean saveAsText() {
        String path = this.getPath("Text", ".txt");
        if (path == null) {
            return false;
        }
        return this.saveAsText(path);
    }

    public boolean saveAsText(String path) {
        try {
            Calibration cal = this.imp.getCalibration();
            int precision = Analyzer.getPrecision();
            TextEncoder file = new TextEncoder(this.imp.getProcessor(), cal, precision);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
            file.write(out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        return true;
    }

    public boolean saveAsLut() {
        if (this.imp.getType() == 4) {
            IJ.error("RGB Images do not have a LUT.");
            return false;
        }
        String path = this.getPath("LUT", ".lut");
        if (path == null) {
            return false;
        }
        return this.saveAsLut(path);
    }

    public boolean saveAsLut(String path) {
        LookUpTable lut = this.imp.createLut();
        int mapSize = lut.getMapSize();
        if (mapSize == 0) {
            IJ.error("RGB Images do not have a LUT.");
            return false;
        }
        if (mapSize < 256) {
            IJ.error("Cannot save LUTs with less than 256 entries.");
            return false;
        }
        byte[] reds = lut.getReds();
        byte[] greens = lut.getGreens();
        byte[] blues = lut.getBlues();
        byte[] pixels = new byte[768];
        int i = 0;
        while (i < 256) {
            pixels[i] = reds[i];
            pixels[i + 256] = greens[i];
            pixels[i + 512] = blues[i];
            ++i;
        }
        FileInfo fi = new FileInfo();
        fi.width = 768;
        fi.height = 1;
        fi.pixels = pixels;
        try {
            ImageWriter file = new ImageWriter(fi);
            FileOutputStream out = new FileOutputStream(path);
            file.write(out);
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        return true;
    }

    private void updateImp(FileInfo fi, int fileFormat) {
        this.imp.changes = false;
        if (this.name != null) {
            fi.fileFormat = fileFormat;
            fi.fileName = this.name;
            fi.directory = this.directory;
            if (fileFormat == 2) {
                fi.offset = 768;
            }
            this.imp.setTitle(this.name);
            this.imp.setFileInfo(fi);
        }
    }

    void showErrorMessage(IOException e) {
        IJ.error("An error occured writing the file.\n \n" + e);
    }
}

