/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.process.ColorProcessor;
import java.awt.Color;

class ColorGenerator
extends ColorProcessor {
    int w;
    int h;
    int[] colors;

    public ColorGenerator(int width, int height, int[] pixels) {
        super(width, height, pixels);
        int[] nArray = new int[48];
        nArray[0] = 0xFFFFFF;
        nArray[1] = 0x700000;
        nArray[2] = 0xB00000;
        nArray[3] = 0xFF0000;
        nArray[4] = 0xFF6000;
        nArray[5] = 0xFFAABB;
        nArray[6] = 14381203;
        nArray[7] = 16716947;
        nArray[8] = 0xCD5C5C;
        nArray[9] = 0x900090;
        nArray[10] = 12211667;
        nArray[11] = 0xEE82EE;
        nArray[12] = 0xFF00FF;
        nArray[13] = 4734347;
        nArray[14] = 0xBB0088;
        nArray[16] = 112;
        nArray[17] = 176;
        nArray[18] = 255;
        nArray[19] = 11584734;
        nArray[20] = 49151;
        nArray[21] = 6266528;
        nArray[22] = 65535;
        nArray[23] = 2142890;
        nArray[24] = 6737322;
        nArray[25] = 64154;
        nArray[26] = 28672;
        nArray[27] = 45056;
        nArray[28] = 65280;
        nArray[29] = 28768;
        nArray[30] = 10145074;
        nArray[31] = 0x808000;
        nArray[32] = 0xFFFFC0;
        nArray[33] = 0xFFFF00;
        nArray[34] = 12433259;
        nArray[35] = 15787660;
        nArray[36] = 12092939;
        nArray[37] = 16762880;
        nArray[38] = 16768685;
        nArray[39] = 16750080;
        nArray[40] = 13789470;
        nArray[41] = 15308410;
        nArray[42] = 14729436;
        nArray[43] = 16772043;
        nArray[44] = 0x606000;
        nArray[45] = 0x600060;
        nArray[46] = 0x8080A0;
        nArray[47] = 0x80A080;
        this.colors = nArray;
    }

    void drawColors(int colorWidth, int colorHeight, int columns, int rows) {
        this.w = colorWidth;
        this.h = colorHeight;
        this.drawRamp();
        int x = 0;
        int y = 1;
        int i = 0;
        while (i < this.colors.length) {
            this.drawColor(x, y, new Color(this.colors[i]));
            if (++x == columns) {
                x = 0;
                if (++y == rows) break;
            }
            ++i;
        }
        this.setRoi(null);
    }

    void drawColor(int x, int y, Color c) {
        this.setRoi(x * this.w, y * this.h, this.w, this.h);
        this.setColor(c);
        this.fill();
    }

    void drawRamp() {
        int y = 0;
        while (y < this.h) {
            int x = 0;
            while (x < 256) {
                byte b;
                byte g = b = (byte)x;
                byte r = b;
                this.pixels[y * this.width + x] = 0xFF000000 | r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF;
                ++x;
            }
            ++y;
        }
    }
}

