/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.io.FileInfo;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

class FitsDecoder {
    private String directory;
    private String fileName;
    private DataInputStream f;
    private StringBuffer info = new StringBuffer(512);
    double bscale;
    double bzero;

    public FitsDecoder(String directory, String fileName) {
        this.directory = directory;
        this.fileName = fileName;
    }

    /*
     * Enabled aggressive block sorting
     */
    FileInfo getInfo() throws IOException {
        FileInfo fi = new FileInfo();
        fi.fileFormat = 4;
        fi.fileName = this.fileName;
        fi.directory = this.directory;
        fi.width = 0;
        fi.height = 0;
        fi.offset = 0;
        this.f = new DataInputStream(new FileInputStream(String.valueOf(this.directory) + this.fileName));
        String s = this.getString(80);
        this.info.append(String.valueOf(s) + "\n");
        if (!s.startsWith("SIMPLE")) {
            this.f.close();
            return null;
        }
        int count = 1;
        do {
            block14: {
                block15: {
                    int bitsPerPixel;
                    block16: {
                        ++count;
                        s = this.getString(80);
                        this.info.append(String.valueOf(s) + "\n");
                        if (!s.startsWith("BITPIX")) break block15;
                        bitsPerPixel = this.getInteger(s);
                        if (bitsPerPixel != 8) break block16;
                        fi.fileType = 0;
                        break block14;
                    }
                    if (bitsPerPixel == 16) {
                        fi.fileType = 1;
                        break block14;
                    } else if (bitsPerPixel == 32) {
                        fi.fileType = 3;
                        break block14;
                    } else {
                        if (bitsPerPixel != -32) {
                            IJ.error("BITPIX must be 8, 16, 32 or -32 (float).");
                            this.f.close();
                            return null;
                        }
                        fi.fileType = 4;
                    }
                    break block14;
                }
                if (s.startsWith("NAXIS1")) {
                    fi.width = this.getInteger(s);
                } else if (s.startsWith("NAXIS2")) {
                    fi.height = this.getInteger(s);
                } else if (s.startsWith("BSCALE")) {
                    this.bscale = this.getFloat(s);
                } else if (s.startsWith("BZERO")) {
                    this.bzero = this.getFloat(s);
                }
            }
            if (count <= 360) continue;
            this.f.close();
            return null;
        } while (!s.startsWith("END"));
        this.f.close();
        fi.offset = 2880 + 2880 * (count * 80 / 2880);
        return fi;
    }

    String getString(int length) throws IOException {
        byte[] b = new byte[length];
        this.f.read(b);
        return new String(b);
    }

    int getInteger(String s) {
        s = s.substring(10, 30);
        s = s.trim();
        return Integer.parseInt(s);
    }

    double getFloat(String s) {
        Double d;
        s = s.substring(10, 30);
        s = s.trim();
        try {
            d = new Double(s);
        }
        catch (NumberFormatException numberFormatException) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    String getHeaderInfo() {
        return new String(this.info);
    }
}

