/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import java.awt.Checkbox;
import java.awt.Label;
import java.awt.event.ItemEvent;

class FolderOpenerDialog
extends GenericDialog {
    ImagePlus imp;
    int fileCount;
    boolean eightBits;
    boolean halfSize;

    public FolderOpenerDialog(String title, ImagePlus imp, int fileCount) {
        super(title);
        this.imp = imp;
        this.fileCount = fileCount;
    }

    protected void setup() {
        this.setStackInfo();
    }

    public void itemStateChanged(ItemEvent e) {
        this.setStackInfo();
    }

    void setStackInfo() {
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        int bytesPerPixel = 1;
        this.eightBits = ((Checkbox)this.checkbox.elementAt(0)).getState();
        this.halfSize = ((Checkbox)this.checkbox.elementAt(1)).getState();
        switch (this.imp.getType()) {
            case 1: {
                bytesPerPixel = 2;
                break;
            }
            case 2: 
            case 4: {
                bytesPerPixel = 4;
                break;
            }
        }
        if (this.eightBits) {
            bytesPerPixel = 1;
        }
        if (this.halfSize) {
            width /= 2;
            height /= 2;
        }
        double size = (double)(width * height * this.fileCount * bytesPerPixel) / 1048576.0;
        ((Label)this.theLabel).setText(String.valueOf(width) + " x " + height + " x " + this.fileCount + " (" + IJ.d2s(size, 1) + "MB)");
    }
}

