/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class LutLoader
extends ImagePlus
implements PlugIn {
    private static String defaultDirectory = null;

    public void run(String arg) {
        FileInfo fi = new FileInfo();
        fi.reds = new byte[256];
        fi.greens = new byte[256];
        fi.blues = new byte[256];
        fi.lutSize = 256;
        int nColors = 0;
        if (arg.equals("invert")) {
            this.invertLut();
            return;
        }
        if (arg.equals("fire")) {
            nColors = this.fire(fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("grays")) {
            nColors = this.grays(fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("ice")) {
            nColors = this.ice(fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("spectrum")) {
            nColors = this.spectrum(fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("3-3-2 RGB")) {
            nColors = this.rgb332(fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("red")) {
            nColors = this.primaryColor(4, fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("green")) {
            nColors = this.primaryColor(2, fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("blue")) {
            nColors = this.primaryColor(1, fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("cyan")) {
            nColors = this.primaryColor(3, fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("magenta")) {
            nColors = this.primaryColor(5, fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("yellow")) {
            nColors = this.primaryColor(6, fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("redgreen")) {
            nColors = this.redGreen(fi.reds, fi.greens, fi.blues);
        }
        if (nColors > 0) {
            if (nColors < 256) {
                this.interpolate(fi.reds, fi.greens, fi.blues, nColors);
            }
            fi.fileName = arg;
            this.showLut(fi, true);
            return;
        }
        OpenDialog od = new OpenDialog("Open LUT...", arg);
        fi.directory = od.getDirectory();
        fi.fileName = od.getFileName();
        if (fi.fileName == null) {
            return;
        }
        IJ.showStatus("Opening: " + fi.directory + fi.fileName);
        try {
            int size = this.readLut(fi, false);
            if (size == 0) {
                this.readLut(fi, true);
            }
        }
        catch (IOException e) {
            IJ.error(e.getMessage());
            return;
        }
        this.showLut(fi, arg.equals(""));
        IJ.showStatus("");
    }

    void showLut(FileInfo fi, boolean showImage) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            if (imp.getType() == 4) {
                IJ.error("Color tables cannot be assiged to RGB Images.");
            } else {
                ImageProcessor ip = imp.getProcessor();
                IndexColorModel cm = new IndexColorModel(8, 256, fi.reds, fi.greens, fi.blues);
                ip.setColorModel(cm);
                if (imp.getStackSize() > 1) {
                    imp.getStack().setColorModel(cm);
                }
                imp.updateAndDraw();
            }
        } else {
            this.createImage(fi, showImage);
        }
    }

    void invertLut() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        if (imp.getType() == 4) {
            IJ.error("RGB images do not use LUTs");
            return;
        }
        ImageProcessor ip = imp.getProcessor();
        ip.invertLut();
        if (imp.getStackSize() > 1) {
            imp.getStack().setColorModel(ip.getColorModel());
        }
        imp.updateAndDraw();
        if (imp.getRoi() != null) {
            imp.draw();
        }
    }

    int fire(byte[] reds, byte[] greens, byte[] blues) {
        int[] nArray = new int[32];
        nArray[2] = 1;
        nArray[3] = 25;
        nArray[4] = 49;
        nArray[5] = 73;
        nArray[6] = 98;
        nArray[7] = 122;
        nArray[8] = 146;
        nArray[9] = 162;
        nArray[10] = 173;
        nArray[11] = 184;
        nArray[12] = 195;
        nArray[13] = 207;
        nArray[14] = 217;
        nArray[15] = 229;
        nArray[16] = 240;
        nArray[17] = 252;
        nArray[18] = 255;
        nArray[19] = 255;
        nArray[20] = 255;
        nArray[21] = 255;
        nArray[22] = 255;
        nArray[23] = 255;
        nArray[24] = 255;
        nArray[25] = 255;
        nArray[26] = 255;
        nArray[27] = 255;
        nArray[28] = 255;
        nArray[29] = 255;
        nArray[30] = 255;
        nArray[31] = 255;
        int[] r = nArray;
        int[] nArray2 = new int[32];
        nArray2[13] = 14;
        nArray2[14] = 35;
        nArray2[15] = 57;
        nArray2[16] = 79;
        nArray2[17] = 101;
        nArray2[18] = 117;
        nArray2[19] = 133;
        nArray2[20] = 147;
        nArray2[21] = 161;
        nArray2[22] = 175;
        nArray2[23] = 190;
        nArray2[24] = 205;
        nArray2[25] = 219;
        nArray2[26] = 234;
        nArray2[27] = 248;
        nArray2[28] = 255;
        nArray2[29] = 255;
        nArray2[30] = 255;
        nArray2[31] = 255;
        int[] g = nArray2;
        int[] nArray3 = new int[32];
        nArray3[0] = 31;
        nArray3[1] = 61;
        nArray3[2] = 96;
        nArray3[3] = 130;
        nArray3[4] = 165;
        nArray3[5] = 192;
        nArray3[6] = 220;
        nArray3[7] = 227;
        nArray3[8] = 210;
        nArray3[9] = 181;
        nArray3[10] = 151;
        nArray3[11] = 122;
        nArray3[12] = 93;
        nArray3[13] = 64;
        nArray3[14] = 35;
        nArray3[15] = 5;
        nArray3[27] = 35;
        nArray3[28] = 98;
        nArray3[29] = 160;
        nArray3[30] = 223;
        nArray3[31] = 255;
        int[] b = nArray3;
        int i = 0;
        while (i < r.length) {
            reds[i] = (byte)r[i];
            greens[i] = (byte)g[i];
            blues[i] = (byte)b[i];
            ++i;
        }
        return r.length;
    }

    int grays(byte[] reds, byte[] greens, byte[] blues) {
        int i = 0;
        while (i < 256) {
            reds[i] = (byte)i;
            greens[i] = (byte)i;
            blues[i] = (byte)i;
            ++i;
        }
        return 256;
    }

    int primaryColor(int color, byte[] reds, byte[] greens, byte[] blues) {
        int i = 0;
        while (i < 256) {
            if ((color & 4) != 0) {
                reds[i] = (byte)i;
            }
            if ((color & 2) != 0) {
                greens[i] = (byte)i;
            }
            if ((color & 1) != 0) {
                blues[i] = (byte)i;
            }
            ++i;
        }
        return 256;
    }

    int ice(byte[] reds, byte[] greens, byte[] blues) {
        int[] nArray = new int[32];
        nArray[6] = 19;
        nArray[7] = 29;
        nArray[8] = 50;
        nArray[9] = 48;
        nArray[10] = 79;
        nArray[11] = 112;
        nArray[12] = 134;
        nArray[13] = 158;
        nArray[14] = 186;
        nArray[15] = 201;
        nArray[16] = 217;
        nArray[17] = 229;
        nArray[18] = 242;
        nArray[19] = 250;
        nArray[20] = 250;
        nArray[21] = 250;
        nArray[22] = 250;
        nArray[23] = 251;
        nArray[24] = 250;
        nArray[25] = 250;
        nArray[26] = 250;
        nArray[27] = 250;
        nArray[28] = 251;
        nArray[29] = 251;
        nArray[30] = 243;
        nArray[31] = 230;
        int[] r = nArray;
        int[] nArray2 = new int[32];
        nArray2[0] = 156;
        nArray2[1] = 165;
        nArray2[2] = 176;
        nArray2[3] = 184;
        nArray2[4] = 190;
        nArray2[5] = 196;
        nArray2[6] = 193;
        nArray2[7] = 184;
        nArray2[8] = 171;
        nArray2[9] = 162;
        nArray2[10] = 146;
        nArray2[11] = 125;
        nArray2[12] = 107;
        nArray2[13] = 93;
        nArray2[14] = 81;
        nArray2[15] = 87;
        nArray2[16] = 92;
        nArray2[17] = 97;
        nArray2[18] = 95;
        nArray2[19] = 93;
        nArray2[20] = 93;
        nArray2[21] = 90;
        nArray2[22] = 85;
        nArray2[23] = 69;
        nArray2[24] = 64;
        nArray2[25] = 54;
        nArray2[26] = 47;
        nArray2[27] = 35;
        nArray2[28] = 19;
        nArray2[30] = 4;
        int[] g = nArray2;
        int[] b = new int[]{140, 147, 158, 166, 170, 176, 209, 220, 234, 225, 236, 246, 250, 251, 250, 250, 245, 230, 230, 222, 202, 180, 163, 142, 123, 114, 106, 94, 84, 64, 26, 27};
        int i = 0;
        while (i < r.length) {
            reds[i] = (byte)r[i];
            greens[i] = (byte)g[i];
            blues[i] = (byte)b[i];
            ++i;
        }
        return r.length;
    }

    int spectrum(byte[] reds, byte[] greens, byte[] blues) {
        int i = 0;
        while (i < 256) {
            Color c = Color.getHSBColor((float)i / 255.0f, 1.0f, 1.0f);
            reds[i] = (byte)c.getRed();
            greens[i] = (byte)c.getGreen();
            blues[i] = (byte)c.getBlue();
            ++i;
        }
        return 256;
    }

    int rgb332(byte[] reds, byte[] greens, byte[] blues) {
        int i = 0;
        while (i < 256) {
            reds[i] = (byte)(i & 0xE0);
            greens[i] = (byte)(i << 3 & 0xE0);
            blues[i] = (byte)(i << 6 & 0xC0);
            ++i;
        }
        return 256;
    }

    int redGreen(byte[] reds, byte[] greens, byte[] blues) {
        int i = 0;
        while (i < 128) {
            reds[i] = (byte)(i * 2);
            greens[i] = 0;
            blues[i] = 0;
            ++i;
        }
        int i2 = 128;
        while (i2 < 256) {
            reds[i2] = 0;
            greens[i2] = (byte)(i2 * 2);
            blues[i2] = 0;
            ++i2;
        }
        return 256;
    }

    void interpolate(byte[] reds, byte[] greens, byte[] blues, int nColors) {
        byte[] r = new byte[nColors];
        byte[] g = new byte[nColors];
        byte[] b = new byte[nColors];
        System.arraycopy(reds, 0, r, 0, nColors);
        System.arraycopy(greens, 0, g, 0, nColors);
        System.arraycopy(blues, 0, b, 0, nColors);
        double scale = (double)nColors / 256.0;
        int i = 0;
        while (i < 256) {
            int i1 = (int)((double)i * scale);
            int i2 = i1 + 1;
            if (i2 == nColors) {
                i2 = nColors - 1;
            }
            double fraction = (double)i * scale - (double)i1;
            reds[i] = (byte)((1.0 - fraction) * (double)(r[i1] & 0xFF) + fraction * (double)(r[i2] & 0xFF));
            greens[i] = (byte)((1.0 - fraction) * (double)(g[i1] & 0xFF) + fraction * (double)(g[i2] & 0xFF));
            blues[i] = (byte)((1.0 - fraction) * (double)(b[i1] & 0xFF) + fraction * (double)(b[i2] & 0xFF));
            ++i;
        }
    }

    int readLut(FileInfo fi, boolean raw) throws IOException {
        InputStream is = fi.url == null || fi.url.equals("") ? new FileInputStream(String.valueOf(fi.directory) + fi.fileName) : new URL(String.valueOf(fi.url) + fi.fileName).openStream();
        DataInputStream f = new DataInputStream(is);
        int nColors = 256;
        if (!raw) {
            int id = f.readInt();
            if (id != 1229147980) {
                return 0;
            }
            short version = f.readShort();
            nColors = f.readShort();
            short start = f.readShort();
            short end = f.readShort();
            long fill1 = f.readLong();
            long fill2 = f.readLong();
            int n = f.readInt();
        }
        f.read(fi.reds, 0, nColors);
        f.read(fi.greens, 0, nColors);
        f.read(fi.blues, 0, nColors);
        if (nColors < 256) {
            this.interpolate(fi.reds, fi.greens, fi.blues, nColors);
        }
        f.close();
        return 256;
    }

    void createImage(FileInfo fi, boolean show) {
        int width = 256;
        int height = 32;
        IndexColorModel cm = new IndexColorModel(8, 256, fi.reds, fi.greens, fi.blues);
        byte[] pixels = new byte[width * height];
        ByteProcessor bp = new ByteProcessor(width, height, pixels, cm);
        int[] ramp = new int[width];
        int i = 0;
        while (i < width) {
            ramp[i] = i;
            ++i;
        }
        int y = 0;
        while (y < height) {
            bp.putRow(0, y, ramp, width);
            ++y;
        }
        this.setProcessor(fi.fileName, bp);
        if (show) {
            this.show();
        }
    }
}

