/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import java.awt.Color;

public class MontageMaker
implements PlugIn {
    private static int columns;
    private static int rows;
    private static int first;
    private static int last;
    private static int inc;
    private static double scale;
    private static boolean label;
    private static boolean borders;
    private static int saveID;
    static /* synthetic */ Class class$ij$plugin$MontageMaker;

    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null || imagePlus.getStackSize() == 1) {
            IJ.error("Stack required");
            return;
        }
        this.makeMontage(imagePlus);
        saveID = imagePlus.getID();
        IJ.register(class$ij$plugin$MontageMaker != null ? class$ij$plugin$MontageMaker : (class$ij$plugin$MontageMaker = MontageMaker.class$("ij.plugin.MontageMaker")));
    }

    public void makeMontage(ImagePlus imagePlus) {
        int n = imagePlus.getStackSize();
        if (columns == 0 || imagePlus.getID() != saveID) {
            rows = columns = (int)Math.sqrt(n);
            int n2 = n - columns * rows;
            if (n2 > 0) {
                columns += (int)Math.ceil((double)n2 / (double)rows);
            }
            scale = 1.0;
            if (imagePlus.getWidth() * columns > 800) {
                scale = 0.5;
            }
            if (imagePlus.getWidth() * columns > 1600) {
                scale = 0.25;
            }
            inc = 1;
            first = 1;
            last = n;
        }
        GenericDialog genericDialog = new GenericDialog("Make Montage", IJ.getInstance());
        genericDialog.addNumericField("Columns:", columns, 0);
        genericDialog.addNumericField("Rows:", rows, 0);
        genericDialog.addNumericField("Scale Factor:", scale, 2);
        genericDialog.addNumericField("First Slice:", first, 0);
        genericDialog.addNumericField("Last Slice:", last, 0);
        genericDialog.addNumericField("Increment:", inc, 0);
        genericDialog.addCheckbox("Label Slices", label);
        genericDialog.addCheckbox("Borders", borders);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        columns = (int)genericDialog.getNextNumber();
        rows = (int)genericDialog.getNextNumber();
        scale = genericDialog.getNextNumber();
        first = (int)genericDialog.getNextNumber();
        last = (int)genericDialog.getNextNumber();
        inc = (int)genericDialog.getNextNumber();
        if (first < 1) {
            first = 1;
        }
        if (last > n) {
            last = n;
        }
        if (inc < 1) {
            inc = 1;
        }
        if (genericDialog.invalidNumber()) {
            IJ.error("Invalid number");
            return;
        }
        label = genericDialog.getNextBoolean();
        borders = genericDialog.getNextBoolean();
        this.makeMontage(imagePlus, columns, rows, scale, first, last, inc, label, borders);
    }

    public void makeMontage(ImagePlus imagePlus, int n, int n2, double d, int n3, int n4, int n5, boolean bl, boolean bl2) {
        boolean bl3;
        int n6 = imagePlus.getWidth();
        int n7 = imagePlus.getHeight();
        imagePlus.getStackSize();
        int n8 = (int)((double)n6 * d);
        int n9 = (int)((double)n7 * d);
        int n10 = n8 * n;
        int n11 = n9 * n2;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        ImageProcessor imageProcessor2 = imageProcessor.createProcessor(n10, n11);
        ImageStatistics imageStatistics = imagePlus.getStatistics();
        boolean bl4 = bl3 = imageStatistics.mode < 200;
        if (imagePlus.isInvertedLut()) {
            bl3 ^= true;
        }
        if (imageProcessor instanceof ShortProcessor || imageProcessor instanceof FloatProcessor) {
            bl3 = true;
        }
        if (bl3) {
            imageProcessor2.setColor(Color.black);
            imageProcessor2.fill();
            imageProcessor2.setColor(Color.white);
        } else {
            imageProcessor2.setColor(Color.white);
            imageProcessor2.fill();
            imageProcessor2.setColor(Color.black);
        }
        ImageStack imageStack = imagePlus.getStack();
        int n12 = 0;
        int n13 = 0;
        int n14 = n3;
        while (n14 <= n4) {
            ImageProcessor imageProcessor3 = imageStack.getProcessor(n14);
            if (d != 1.0) {
                imageProcessor3 = imageProcessor3.resize(n8, n9);
            }
            imageProcessor2.insert(imageProcessor3, n12, n13);
            if (bl2) {
                this.drawBorder(imageProcessor2, n12, n13, n8, n9);
            }
            if (bl) {
                this.drawLabel(imageProcessor2, n14, n12, n13, n8, n9);
            }
            if ((n12 += n8) >= n10) {
                n12 = 0;
                if ((n13 += n9) >= n11) break;
            }
            IJ.showProgress((double)(n14 - n3) / (double)(n4 - n3));
            n14 += n5;
        }
        if (bl2) {
            this.drawBorder(imageProcessor2, 0, 0, n10 - 1, n11 - 1);
        }
        IJ.showProgress(1.0);
        new ImagePlus("Montage", imageProcessor2).show();
    }

    void drawBorder(ImageProcessor imageProcessor, int n, int n2, int n3, int n4) {
        imageProcessor.moveTo(n, n2);
        imageProcessor.lineTo(n + n3, n2);
        imageProcessor.lineTo(n + n3, n2 + n4);
        imageProcessor.lineTo(n, n2 + n4);
        imageProcessor.lineTo(n, n2);
    }

    void drawLabel(ImageProcessor imageProcessor, int n, int n2, int n3, int n4, int n5) {
        String string = String.valueOf(n);
        int n6 = imageProcessor.getStringWidth(string);
        imageProcessor.moveTo(n2 += n4 / 2 - n6 / 2, n3 += n5);
        imageProcessor.drawString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        label = false;
        borders = false;
    }
}

