/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class ImageProperties
implements PlugInFilter {
    ImagePlus imp;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 159;
    }

    public void run(ImageProcessor imageProcessor) {
        this.showDialog(this.imp);
    }

    void showDialog(ImagePlus imagePlus) {
        Calibration calibration = imagePlus.getCalibration();
        GenericDialog genericDialog = new GenericDialog(imagePlus.getTitle());
        genericDialog.addStringField("Unit of Measure:", calibration.getUnit());
        double d = calibration.pixelWidth != 0.0 ? 1.0 / calibration.pixelWidth : 0.0;
        genericDialog.addNumericField("Pixels/Unit:", d, (double)((int)d) == d ? 0 : 2);
        int n = imagePlus.getStackSize();
        if (n > 1) {
            genericDialog.addMessage("");
            genericDialog.addNumericField("Slice Spacing:", calibration.pixelDepth, 2);
            double d2 = calibration.frameInterval > 0.0 ? 1.0 / calibration.frameInterval : 0.0;
            genericDialog.addNumericField("Frames per Second:", d2, (double)((int)d2) == d2 ? 0 : 2);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        String string = genericDialog.getNextString();
        double d3 = genericDialog.getNextNumber();
        if (string.equals("") || string.equalsIgnoreCase("pixel") || d3 == 0.0) {
            calibration.setUnit(null);
            calibration.pixelWidth = 1.0;
            calibration.pixelHeight = 1.0;
        } else {
            calibration.setUnit(string);
            calibration.pixelWidth = 1.0 / d3;
            calibration.pixelHeight = 1.0 / d3;
        }
        if (n > 1) {
            double d4 = genericDialog.getNextNumber();
            double d5 = genericDialog.getNextNumber();
            calibration.pixelDepth = d4;
            calibration.frameInterval = d5 != 0.0 ? 1.0 / d5 : 0.0;
        }
        imagePlus.repaintWindow();
    }
}

