/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.YesNoCancelDialog;
import ij.measure.Calibration;
import ij.plugin.frame.ContrastPlot;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.StackProcessor;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowEvent;

public class ContrastAdjuster
extends PlugInFrame
implements Runnable,
ActionListener,
AdjustmentListener {
    static final int AUTO_THRESHOLD = 5000;
    ContrastPlot plot = new ContrastPlot();
    Thread thread;
    private static Frame instance;
    int brightnessValue = -1;
    int contrastValue = -1;
    int sliderRange = 256;
    boolean doAutoAdjust;
    boolean doReset;
    boolean doSet;
    boolean doApplyLut;
    boolean doThreshold;
    boolean doUpdate;
    Panel panel;
    Panel tPanel;
    Button autoB;
    Button resetB;
    Button setB;
    Button applyB;
    Button threshB;
    Button updateB;
    int previousImageID;
    int previousType;
    ImageJ ij;
    double min;
    double max;
    double previousMin;
    double previousMax;
    double defaultMin;
    double defaultMax;
    int contrast;
    int brightness;
    boolean RGBImage;
    Scrollbar contrastSlider;
    Scrollbar brightnessSlider;
    Label minLabel;
    Label maxLabel;
    Label brightnessLabel;
    Label contrastLabel;
    boolean done;
    int autoThreshold;
    static final int RESET = 0;
    static final int AUTO = 1;
    static final int SET = 2;
    static final int APPLY = 3;
    static final int THRESHOLD = 4;
    static final int BRIGHTNESS = 5;
    static final int CONTRAST = 6;
    static final int UPDATE = 7;
    static /* synthetic */ Class class$ij$plugin$frame$ContrastAdjuster;

    public ContrastAdjuster() {
        super("B&C");
        if (instance != null) {
            instance.toFront();
            return;
        }
        instance = this;
        IJ.register(class$ij$plugin$frame$ContrastAdjuster != null ? class$ij$plugin$frame$ContrastAdjuster : (class$ij$plugin$frame$ContrastAdjuster = ContrastAdjuster.class$("ij.plugin.frame.ContrastAdjuster")));
        WindowManager.addWindow(this);
        this.ij = IJ.getInstance();
        Font font = new Font("Monospaced", 0, 12);
        Font font2 = new Font("SansSerif", 0, 12);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagLayout.setConstraints(this.plot, gridBagConstraints);
        this.add(this.plot);
        this.panel = new Panel();
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagLayout.setConstraints(this.panel, gridBagConstraints);
        this.panel.setLayout(new BorderLayout());
        this.minLabel = new Label("      ", 0);
        this.minLabel.setFont(font);
        this.panel.add("West", this.minLabel);
        this.maxLabel = new Label("      ", 2);
        this.maxLabel.setFont(font);
        this.panel.add("East", this.maxLabel);
        this.add(this.panel);
        this.brightnessSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        gridBagLayout.setConstraints(this.brightnessSlider, gridBagConstraints);
        this.add(this.brightnessSlider);
        this.brightnessSlider.addAdjustmentListener(this);
        this.brightnessSlider.setUnitIncrement(1);
        this.panel = new Panel();
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagLayout.setConstraints(this.panel, gridBagConstraints);
        this.panel.setLayout(new FlowLayout(1, 0, 0));
        Label label = new Label("Brightness");
        label.setFont(font2);
        this.panel.add(label);
        this.brightnessLabel = new Label("", 0);
        this.brightnessLabel.setFont(font);
        this.panel.add(this.brightnessLabel);
        this.add(this.panel);
        this.contrastSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        gridBagLayout.setConstraints(this.contrastSlider, gridBagConstraints);
        this.add(this.contrastSlider);
        this.contrastSlider.addAdjustmentListener(this);
        this.contrastSlider.setUnitIncrement(1);
        this.panel = new Panel();
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagLayout.setConstraints(this.panel, gridBagConstraints);
        this.panel.setLayout(new FlowLayout(1, 0, 0));
        label = new Label("Contrast");
        label.setFont(font2);
        this.panel.add(label);
        this.contrastLabel = new Label("", 0);
        this.contrastLabel.setFont(font);
        this.panel.add(this.contrastLabel);
        this.add(this.panel);
        this.panel = new Panel();
        this.panel.setLayout(new GridLayout(3, 2, 0, 0));
        this.autoB = new Button("Auto");
        this.autoB.addActionListener(this);
        this.autoB.addKeyListener(this.ij);
        this.panel.add(this.autoB);
        this.resetB = new Button("Reset");
        this.resetB.addActionListener(this);
        this.resetB.addKeyListener(this.ij);
        this.panel.add(this.resetB);
        this.setB = new Button("Set");
        this.setB.addActionListener(this);
        this.setB.addKeyListener(this.ij);
        this.panel.add(this.setB);
        this.applyB = new Button("Apply");
        this.applyB.addActionListener(this);
        this.applyB.addKeyListener(this.ij);
        this.panel.add(this.applyB);
        this.threshB = new Button("Thresh");
        this.threshB.addActionListener(this);
        this.threshB.addKeyListener(this.ij);
        this.panel.add(this.threshB);
        this.updateB = new Button("Update");
        this.updateB.addActionListener(this);
        this.updateB.addKeyListener(this.ij);
        this.panel.add(this.updateB);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        gridBagLayout.setConstraints(this.panel, gridBagConstraints);
        this.add(this.panel);
        this.addKeyListener(this.ij);
        this.pack();
        GUI.center(this);
        ((Component)this).setVisible(true);
        this.thread = new Thread((Runnable)this, "ContrastAdjuster");
        this.thread.start();
        this.setup();
    }

    void setup() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            this.setup(imagePlus);
            this.updatePlot();
            this.updateLabels(imagePlus, imageProcessor);
            imagePlus.updateAndDraw();
        }
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.contrastSlider) {
            this.contrastValue = this.contrastSlider.getValue();
        } else {
            this.brightnessValue = this.brightnessSlider.getValue();
        }
        this.notify();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        Button button = (Button)actionEvent.getSource();
        if (button == null) {
            return;
        }
        if (button == this.resetB) {
            this.doReset = true;
        } else if (button == this.autoB) {
            this.doAutoAdjust = true;
        } else if (button == this.setB) {
            this.doSet = true;
        } else if (button == this.applyB) {
            this.doApplyLut = true;
        } else if (button == this.threshB) {
            this.doThreshold = true;
        } else if (button == this.updateB) {
            this.doUpdate = true;
        }
        this.notify();
    }

    ImageProcessor setup(ImagePlus imagePlus) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        int n = imagePlus.getType();
        this.RGBImage = n == 4;
        boolean bl = imagePlus.isProcessor() ^ true;
        if (imagePlus.getID() != this.previousImageID || this.RGBImage && bl || n != this.previousType) {
            this.setupNewImage(imagePlus, imageProcessor);
        }
        this.previousImageID = imagePlus.getID();
        this.previousType = n;
        return imageProcessor;
    }

    void setupNewImage(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        this.previousMin = this.min;
        this.previousMax = this.max;
        if (this.RGBImage) {
            imageProcessor.snapshot();
        }
        double d = imageProcessor.getMin();
        double d2 = imageProcessor.getMax();
        if (imagePlus.getType() == 4) {
            d = 0.0;
            d2 = 255.0;
        }
        if (imageProcessor instanceof ShortProcessor || imageProcessor instanceof FloatProcessor) {
            imageProcessor.resetMinAndMax();
            this.defaultMin = imageProcessor.getMin();
            this.defaultMax = imageProcessor.getMax();
        } else {
            this.defaultMin = 0.0;
            this.defaultMax = 255.0;
        }
        imageProcessor.setMinAndMax(d, d2);
        this.min = imageProcessor.getMin();
        this.max = imageProcessor.getMax();
        if (IJ.debugMode) {
            IJ.write("min: " + this.min);
            IJ.write("max: " + this.max);
            IJ.write("defaultMin: " + this.defaultMin);
            IJ.write("defaultMax: " + this.defaultMax);
        }
        this.plot.defaultMin = this.defaultMin;
        this.plot.defaultMax = this.defaultMax;
        this.updateScrollBars();
        if (!this.doReset) {
            this.plotHistogram(imagePlus);
        }
        this.autoThreshold = 0;
    }

    void updatePlot() {
        this.plot.min = this.min;
        this.plot.max = this.max;
        this.plot.repaint();
    }

    void updateLabels(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        boolean bl;
        double d = imageProcessor.getMin();
        double d2 = imageProcessor.getMax();
        int n = imagePlus.getType();
        Calibration calibration = imagePlus.getCalibration();
        boolean bl2 = bl = n == 2;
        if (calibration.calibrated()) {
            d = calibration.getCValue((int)d);
            d2 = calibration.getCValue((int)d2);
            if (n != 1) {
                bl = true;
            }
        }
        if (bl) {
            this.minLabel.setText(String.valueOf(IJ.d2s(d)));
            this.maxLabel.setText(String.valueOf(IJ.d2s(d2)));
        } else {
            this.minLabel.setText(IJ.d2s(d, 0));
            this.maxLabel.setText(IJ.d2s(d2, 0));
        }
    }

    void updateScrollBars() {
        double d = this.sliderRange / 2;
        double d2 = (this.defaultMax - this.defaultMin) / (this.max - this.min) * d;
        if (d2 > d) {
            d2 = (double)this.sliderRange - (this.max - this.min) / (this.defaultMax - this.defaultMin) * d;
        }
        this.contrast = (int)d2;
        this.contrastSlider.setValue(this.contrast);
        double d3 = this.min + (this.max - this.min) / 2.0;
        double d4 = 1.0 - (d3 - this.defaultMin) / (this.defaultMax - this.defaultMin);
        this.brightness = (int)(d4 * (double)this.sliderRange);
        this.brightnessSlider.setValue(this.brightness);
    }

    void doMasking(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        int[] nArray = imagePlus.getMask();
        if (nArray != null) {
            imageProcessor.reset(nArray);
        }
    }

    void adjustBrightness(ImagePlus imagePlus, ImageProcessor imageProcessor, double d) {
        double d2 = this.defaultMin + (this.defaultMax - this.defaultMin) * (((double)this.sliderRange - d) / (double)this.sliderRange);
        double d3 = this.max - this.min;
        this.min = d2 - d3 / 2.0;
        this.max = d2 + d3 / 2.0;
        imageProcessor.setMinAndMax(this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(imageProcessor);
        }
        if (this.RGBImage) {
            this.doMasking(imagePlus, imageProcessor);
        }
    }

    void adjustContrast(ImagePlus imagePlus, ImageProcessor imageProcessor, int n) {
        double d = this.min + (this.max - this.min) / 2.0;
        double d2 = this.defaultMax - this.defaultMin;
        double d3 = this.sliderRange / 2;
        double d4 = (double)n <= d3 ? (double)n / d3 : d3 / (double)(this.sliderRange - n);
        if (d4 > 0.0) {
            this.min = d - 0.5 * d2 / d4;
            this.max = d + 0.5 * d2 / d4;
        }
        imageProcessor.setMinAndMax(this.min, this.max);
        if (this.RGBImage) {
            this.doMasking(imagePlus, imageProcessor);
        }
    }

    void reset(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        if (this.RGBImage) {
            imageProcessor.reset();
        }
        if (imageProcessor instanceof ShortProcessor || imageProcessor instanceof FloatProcessor) {
            imageProcessor.resetMinAndMax();
            this.defaultMin = imageProcessor.getMin();
            this.defaultMax = imageProcessor.getMax();
            this.plot.defaultMin = this.defaultMin;
            this.plot.defaultMax = this.defaultMax;
        }
        this.min = this.defaultMin;
        this.max = this.defaultMax;
        imageProcessor.setMinAndMax(this.min, this.max);
        this.updateScrollBars();
        this.plotHistogram(imagePlus);
        this.autoThreshold = 0;
    }

    void update(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        if (this.previousMin == 0.0 && this.previousMax == 0.0 || imagePlus.getType() != this.previousType) {
            IJ.beep();
        } else {
            this.min = this.previousMin;
            this.max = this.previousMax;
            imageProcessor.setMinAndMax(this.min, this.max);
            this.updateScrollBars();
            this.plotHistogram(imagePlus);
        }
    }

    void plotHistogram(ImagePlus imagePlus) {
        this.plot.setHistogram(imagePlus.getStatistics());
    }

    void apply(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        if (this.RGBImage) {
            imagePlus.unlock();
        }
        if (!imagePlus.lock()) {
            return;
        }
        if (imagePlus.getType() == 4 && imagePlus.getStackSize() > 1) {
            this.applyRGBStack(imagePlus);
            imagePlus.unlock();
            return;
        }
        if (imagePlus.getType() != 0) {
            IJ.beep();
            IJ.showStatus("Apply requires an 8-bit grayscale image or an RGB stack");
            imagePlus.unlock();
            return;
        }
        int[] nArray = new int[256];
        int n = (int)imageProcessor.getMin();
        int n2 = (int)imageProcessor.getMax();
        int n3 = 0;
        while (n3 < 256) {
            nArray[n3] = n3 <= n ? 0 : (n3 >= n2 ? 255 : (int)((double)(n3 - n) / (double)(n2 - n) * 255.0));
            ++n3;
        }
        if (imagePlus.getStackSize() > 1) {
            ImageStack imageStack = imagePlus.getStack();
            YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)this, "Entire Stack?", "Apply LUT to all " + imageStack.getSize() + " slices in the stack?");
            if (yesNoCancelDialog.cancelPressed()) {
                imagePlus.unlock();
                return;
            }
            if (yesNoCancelDialog.yesPressed()) {
                new StackProcessor(imageStack, imageProcessor).applyTable(nArray);
            } else {
                imageProcessor.applyTable(nArray);
            }
        } else {
            imageProcessor.applyTable(nArray);
        }
        this.reset(imagePlus, imageProcessor);
        imagePlus.changes = true;
        imagePlus.unlock();
    }

    void applyRGBStack(ImagePlus imagePlus) {
        int n = imagePlus.getCurrentSlice();
        int n2 = imagePlus.getStackSize();
        if (!IJ.showMessageWithCancel("Update Entire Stack?", "Apply brightness and contrast settings\nto all " + n2 + " slices in the stack?\n \n" + "NOTE: There is no Undo for this operation.")) {
            return;
        }
        int n3 = 1;
        while (n3 <= n2) {
            if (n3 != n) {
                imagePlus.setSlice(n3);
                ImageProcessor imageProcessor = imagePlus.getProcessor();
                imageProcessor.setMinAndMax(this.min, this.max);
                IJ.showProgress((double)n3 / (double)n2);
            }
            ++n3;
        }
        imagePlus.setSlice(n);
        imagePlus.changes = true;
    }

    void threshold(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        int n = (int)((this.defaultMax - this.defaultMin) / 2.0);
        this.min = n;
        this.max = n;
        imageProcessor.setMinAndMax(this.min, this.max);
        this.setThreshold(imageProcessor);
        this.updateScrollBars();
    }

    void setThreshold(ImageProcessor imageProcessor) {
        if (!(imageProcessor instanceof ByteProcessor)) {
            return;
        }
        if (((ByteProcessor)imageProcessor).isInvertedLut()) {
            imageProcessor.setThreshold(this.max, 255.0, 2);
        } else {
            imageProcessor.setThreshold(0.0, this.max, 2);
        }
    }

    void autoAdjust(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        int[] nArray;
        if (this.RGBImage) {
            imageProcessor.reset();
        }
        Calibration calibration = imagePlus.getCalibration();
        imagePlus.setCalibration(null);
        ImageStatistics imageStatistics = imagePlus.getStatistics();
        imagePlus.setCalibration(calibration);
        int[] nArray2 = imageStatistics.histogram;
        this.autoThreshold = this.autoThreshold < 10 ? 5000 : (this.autoThreshold /= 2);
        int n = imageStatistics.pixelCount / this.autoThreshold;
        int n2 = -1;
        boolean bl = false;
        do {
            boolean bl2 = bl = nArray2[++n2] > n;
        } while (!bl && n2 < 255);
        int n3 = n2;
        n2 = 256;
        do {
            boolean bl3 = bl = nArray2[--n2] > n;
        } while (!bl && n2 > 0);
        int n4 = n2;
        if (n4 >= n3) {
            imagePlus.killRoi();
            this.min = imageStatistics.histMin + (double)n3 * imageStatistics.binSize;
            this.max = imageStatistics.histMin + (double)n4 * imageStatistics.binSize;
            if (this.min == this.max) {
                this.min = imageStatistics.min;
                this.max = imageStatistics.max;
            }
        } else {
            this.reset(imagePlus, imageProcessor);
            return;
        }
        imageProcessor.setMinAndMax(this.min, this.max);
        this.updateScrollBars();
        Roi roi = imagePlus.getRoi();
        if (roi != null && (nArray = roi.getMask()) != null) {
            imageProcessor.reset(nArray);
        }
    }

    void setMinAndMax(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        GenericDialog genericDialog = new GenericDialog("Set Min and Max");
        genericDialog.addNumericField("Minimum Displayed Value: ", this.min, 0);
        genericDialog.addNumericField("Minimum Displayed Value: ", this.max, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        double d = genericDialog.getNextNumber();
        double d2 = genericDialog.getNextNumber();
        if (d2 >= d) {
            this.min = d;
            this.max = d2;
            imageProcessor.setMinAndMax(d, d2);
            if (this.RGBImage) {
                this.doMasking(imagePlus, imageProcessor);
            }
            if (Recorder.record) {
                Recorder.record("setMinAndMax", (int)d, (int)d2);
            }
        }
    }

    public void run() {
        while (!this.done) {
            ContrastAdjuster contrastAdjuster = this;
            synchronized (contrastAdjuster) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.doUpdate();
        }
    }

    void doUpdate() {
        int n;
        int n2 = this.brightnessValue;
        int n3 = this.contrastValue;
        if (this.doReset) {
            n = 0;
        } else if (this.doAutoAdjust) {
            n = 1;
        } else if (this.doSet) {
            n = 2;
        } else if (this.doApplyLut) {
            n = 3;
        } else if (this.doThreshold) {
            n = 4;
        } else if (this.doUpdate) {
            n = 7;
        } else if (this.brightnessValue >= 0) {
            n = 5;
        } else if (this.contrastValue >= 0) {
            n = 6;
        } else {
            return;
        }
        this.brightnessValue = -1;
        this.contrastValue = -1;
        this.doReset = false;
        this.doAutoAdjust = false;
        this.doSet = false;
        this.doApplyLut = false;
        this.doThreshold = false;
        this.doUpdate = false;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.beep();
            IJ.showStatus("No image");
            return;
        }
        ImageProcessor imageProcessor = n != 7 ? this.setup(imagePlus) : imagePlus.getProcessor();
        if (this.RGBImage && !imagePlus.lock()) {
            imagePlus = null;
            return;
        }
        switch (n) {
            case 0: {
                this.reset(imagePlus, imageProcessor);
                break;
            }
            case 1: {
                this.autoAdjust(imagePlus, imageProcessor);
                break;
            }
            case 2: {
                this.setMinAndMax(imagePlus, imageProcessor);
                break;
            }
            case 3: {
                this.apply(imagePlus, imageProcessor);
                break;
            }
            case 4: {
                this.threshold(imagePlus, imageProcessor);
                break;
            }
            case 7: {
                this.update(imagePlus, imageProcessor);
                break;
            }
            case 5: {
                this.adjustBrightness(imagePlus, imageProcessor, n2);
                break;
            }
            case 6: {
                this.adjustContrast(imagePlus, imageProcessor, n3);
                break;
            }
        }
        this.updatePlot();
        this.updateLabels(imagePlus, imageProcessor);
        imagePlus.updateAndDraw();
        if (this.RGBImage) {
            imagePlus.unlock();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        super.windowClosing(windowEvent);
        instance = null;
        this.done = true;
        ContrastAdjuster contrastAdjuster = this;
        synchronized (contrastAdjuster) {
            this.notify();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.setup();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

