/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.process.BinaryProcessor;
import ij.process.ByteBlitter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Random;

public class ByteProcessor
extends ImageProcessor {
    protected byte[] pixels;
    protected byte[] snapshotPixels;
    private int bgColor = 255;
    private int min = 0;
    private int max = 255;
    static double oldx;
    static double oldy;

    public ByteProcessor(Image img) {
        this.width = img.getWidth(null);
        this.height = img.getHeight(null);
        this.setRoi(null);
        this.pixels = new byte[this.width * this.height];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, this.width, this.height, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println(e);
        }
        this.cm = pg.getColorModel();
        if (this.cm instanceof IndexColorModel) {
            this.pixels = (byte[])pg.getPixels();
        } else {
            System.err.println("ByteProcessor: not 8-bit image");
        }
    }

    public ByteProcessor(int width, int height) {
        this(width, height, new byte[width * height], null);
    }

    public ByteProcessor(int width, int height, byte[] pixels, ColorModel cm) {
        if (width * height != pixels.length) {
            throw new IllegalArgumentException("(width*height) != pixels.length");
        }
        this.width = width;
        this.height = height;
        this.setRoi(null);
        this.pixels = pixels;
        this.cm = cm;
    }

    public Image createImage() {
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        if (this.source == null || IJ.isMacintosh() && !IJ.isJava2()) {
            this.source = new MemoryImageSource(this.width, this.height, this.cm, this.pixels, 0, this.width);
            this.source.setAnimated(true);
            this.source.setFullBufferUpdates(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.source);
        } else if (this.newPixels) {
            this.source.newPixels(this.pixels, this.cm, 0, this.width);
            this.newPixels = false;
        } else {
            this.source.newPixels();
        }
        return this.img;
    }

    public ImageProcessor createProcessor(int width, int height) {
        ByteProcessor ip2 = new ByteProcessor(width, height, new byte[width * height], this.getColorModel());
        if (this.baseCM != null) {
            ((ImageProcessor)ip2).setMinAndMax(this.min, this.max);
        }
        return ip2;
    }

    public ImageProcessor crop() {
        ImageProcessor ip2 = this.createProcessor(this.roiWidth, this.roiHeight);
        byte[] pixels2 = (byte[])ip2.getPixels();
        int ys = this.roiY;
        while (ys < this.roiY + this.roiHeight) {
            int offset1 = (ys - this.roiY) * this.roiWidth;
            int offset2 = ys * this.width + this.roiX;
            int xs = 0;
            while (xs < this.roiWidth) {
                pixels2[offset1++] = this.pixels[offset2++];
                ++xs;
            }
            ++ys;
        }
        return ip2;
    }

    public void snapshot() {
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
        if (this.snapshotPixels == null || this.snapshotPixels != null && this.snapshotPixels.length != this.pixels.length) {
            this.snapshotPixels = new byte[this.width * this.height];
        }
        System.arraycopy(this.pixels, 0, this.snapshotPixels, 0, this.width * this.height);
        this.newSnapshot = true;
    }

    public void reset() {
        if (this.snapshotPixels == null) {
            return;
        }
        System.arraycopy(this.snapshotPixels, 0, this.pixels, 0, this.width * this.height);
        this.newSnapshot = true;
    }

    public void reset(int[] mask) {
        if (mask == null || this.snapshotPixels == null) {
            return;
        }
        if (mask.length != this.roiWidth * this.roiHeight) {
            throw new IllegalArgumentException("mask.length!=roiWidth*roiHeight");
        }
        int y = this.roiY;
        int my = 0;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int mi = my * this.roiWidth;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                if (mask[mi++] != -16777216) {
                    this.pixels[i] = this.snapshotPixels[i];
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
    }

    public void fill(int[] mask) {
        if (mask == null) {
            this.fill();
            return;
        }
        int y = this.roiY;
        int my = 0;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int mi = my * this.roiWidth;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                if (mask[mi++] == -16777216) {
                    this.pixels[i] = (byte)this.fgColor;
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
    }

    public int getPixel(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            return this.pixels[y * this.width + x] & 0xFF;
        }
        return 0;
    }

    public final int getUncheckedPixel(int x, int y) {
        return this.pixels[y * this.width + x] & 0xFF;
    }

    public double getInterpolatedPixel(double x, double y) {
        if (x < 0.0) {
            x = 0.0;
        }
        if (x >= (double)this.width - 1.0) {
            x = (double)this.width - 1.001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if (y >= (double)this.height - 1.0) {
            y = (double)this.height - 1.001;
        }
        return this.getInterpolatedPixel(x, y, this.pixels);
    }

    public double getInterpolatedValue(double x, double y) {
        if (this.cTable == null) {
            return this.getInterpolatedPixel(x, y);
        }
        if (x < 0.0) {
            x = 0.0;
        }
        if (x >= (double)this.width - 1.0) {
            x = (double)this.width - 1.001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if (y >= (double)this.height - 1.0) {
            y = (double)this.height - 1.001;
        }
        int xbase = (int)x;
        int ybase = (int)y;
        double xFraction = x - (double)xbase;
        double yFraction = y - (double)ybase;
        int offset = ybase * this.width + xbase;
        double lowerLeft = this.cTable[this.pixels[offset] & 0xFF];
        if (xbase >= this.width - 1 || ybase >= this.height - 1) {
            return lowerLeft;
        }
        double lowerRight = this.cTable[this.pixels[offset + 1] & 0xFF];
        double upperRight = this.cTable[this.pixels[offset + this.width + 1] & 0xFF];
        double upperLeft = this.cTable[this.pixels[offset + this.width] & 0xFF];
        double upperAverage = upperLeft + xFraction * (upperRight - upperLeft);
        double lowerAverage = lowerLeft + xFraction * (lowerRight - lowerLeft);
        return lowerAverage + yFraction * (upperAverage - lowerAverage);
    }

    public float getPixelValue(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            if (this.cTable == null) {
                return this.pixels[y * this.width + x] & 0xFF;
            }
            return this.cTable[this.pixels[y * this.width + x] & 0xFF];
        }
        IJ.write("getPixelValue: " + x + " " + y);
        return 0.0f;
    }

    public void setColor(Color color) {
        this.fgColor = this.getBestIndex(color);
    }

    public void setValue(double value) {
        this.fgColor = (int)value;
        if (this.fgColor < 0) {
            this.fgColor = 0;
        }
        if (this.fgColor > 255) {
            this.fgColor = 255;
        }
    }

    public void putPixelValue(int x, int y, double value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.pixels[y * this.width + x] = (byte)value;
        }
    }

    public void putPixel(int x, int y, int value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.pixels[y * this.width + x] = (byte)value;
        }
    }

    public void putUncheckedPixel(int x, int y, int value) {
        this.pixels[y * this.width + x] = (byte)value;
    }

    public void drawPixel(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.pixels[y * this.width + x] = (byte)this.fgColor;
        }
    }

    public Object getPixels() {
        return this.pixels;
    }

    public Object getPixelsCopy() {
        if (this.snapshotPixels != null && this.newSnapshot) {
            return this.snapshotPixels;
        }
        byte[] pixels2 = new byte[this.width * this.height];
        System.arraycopy(this.pixels, 0, pixels2, 0, this.width * this.height);
        return pixels2;
    }

    public void setPixels(Object pixels) {
        if (pixels != null && ((byte[])pixels).length != this.pixels.length) {
            throw new IllegalArgumentException("");
        }
        this.pixels = (byte[])pixels;
        this.resetPixels(pixels);
        this.snapshotPixels = null;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMinAndMax(double min, double max) {
        if (max < min) {
            return;
        }
        this.min = (int)min;
        this.max = (int)max;
        if (this.rLUT1 == null) {
            if (this.cm == null) {
                this.makeDefaultColorModel();
            }
            this.baseCM = this.cm;
            IndexColorModel m = (IndexColorModel)this.cm;
            this.rLUT1 = new byte[256];
            this.gLUT1 = new byte[256];
            this.bLUT1 = new byte[256];
            m.getReds(this.rLUT1);
            m.getGreens(this.gLUT1);
            m.getBlues(this.bLUT1);
            this.rLUT2 = new byte[256];
            this.gLUT2 = new byte[256];
            this.bLUT2 = new byte[256];
        }
        int i = 0;
        while (i < 256) {
            if ((double)i < min) {
                this.rLUT2[i] = this.rLUT1[0];
                this.gLUT2[i] = this.gLUT1[0];
                this.bLUT2[i] = this.bLUT1[0];
            } else if ((double)i > max) {
                this.rLUT2[i] = this.rLUT1[255];
                this.gLUT2[i] = this.gLUT1[255];
                this.bLUT2[i] = this.bLUT1[255];
            } else {
                int index = i - this.min;
                if ((index = (int)(256.0 * (double)index / (max - min))) < 0) {
                    index = 0;
                }
                if (index > 255) {
                    index = 255;
                }
                this.rLUT2[i] = this.rLUT1[index];
                this.gLUT2[i] = this.gLUT1[index];
                this.bLUT2[i] = this.bLUT1[index];
            }
            ++i;
        }
        this.cm = new IndexColorModel(8, 256, this.rLUT2, this.gLUT2, this.bLUT2);
        this.newPixels = true;
        this.minThreshold = -808080.0;
    }

    public void resetMinAndMax() {
        this.setMinAndMax(0.0, 255.0);
    }

    public void copyBits(ImageProcessor ip, int xloc, int yloc, int mode) {
        if (!(ip instanceof ByteProcessor) && !(ip instanceof ColorProcessor)) {
            throw new IllegalArgumentException("8-bit or RGB image required");
        }
        new ByteBlitter(this).copyBits(ip, xloc, yloc, mode);
    }

    public void applyTable(int[] lut) {
        int y = this.roiY;
        while (y < this.roiY + this.roiHeight) {
            int lineEnd;
            int lineStart = y * this.width + this.roiX;
            int i = lineEnd = lineStart + this.roiWidth;
            while (--i >= lineStart) {
                this.pixels[i] = (byte)lut[this.pixels[i] & 0xFF];
            }
            ++y;
        }
    }

    public void convolve3x3(int[] kernel) {
        int inc;
        int k1 = kernel[0];
        int k2 = kernel[1];
        int k3 = kernel[2];
        int k4 = kernel[3];
        int k5 = kernel[4];
        int k6 = kernel[5];
        int k7 = kernel[6];
        int k8 = kernel[7];
        int k9 = kernel[8];
        int scale = 0;
        int i = 0;
        while (i < kernel.length) {
            scale += kernel[i];
            ++i;
        }
        if (scale == 0) {
            scale = 1;
        }
        if ((inc = this.roiHeight / 25) < 1) {
            inc = 1;
        }
        byte[] pixels2 = (byte[])this.getPixelsCopy();
        int rowOffset = this.width;
        int y = this.yMin;
        while (y <= this.yMax) {
            int offset = this.xMin + y * this.width;
            int p1 = 0;
            int p2 = pixels2[offset - rowOffset - 1] & 0xFF;
            int p3 = pixels2[offset - rowOffset] & 0xFF;
            int p4 = 0;
            int p5 = pixels2[offset - 1] & 0xFF;
            int p6 = pixels2[offset] & 0xFF;
            int p7 = 0;
            int p8 = pixels2[offset + rowOffset - 1] & 0xFF;
            int p9 = pixels2[offset + rowOffset] & 0xFF;
            int x = this.xMin;
            while (x <= this.xMax) {
                p1 = p2;
                p2 = p3;
                p3 = pixels2[offset - rowOffset + 1] & 0xFF;
                p4 = p5;
                p5 = p6;
                p6 = pixels2[offset + 1] & 0xFF;
                p7 = p8;
                p8 = p9;
                p9 = pixels2[offset + rowOffset + 1] & 0xFF;
                int sum = k1 * p1 + k2 * p2 + k3 * p3 + k4 * p4 + k5 * p5 + k6 * p6 + k7 * p7 + k8 * p8 + k9 * p9;
                if ((sum /= scale) > 255) {
                    sum = 255;
                }
                if (sum < 0) {
                    sum = 0;
                }
                this.pixels[offset++] = (byte)sum;
                ++x;
            }
            if (y % inc == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        this.hideProgress();
    }

    public void filter(int type) {
        int inc = this.roiHeight / 25;
        if (inc < 1) {
            inc = 1;
        }
        byte[] pixels2 = (byte[])this.getPixelsCopy();
        int sum2 = 0;
        int sum = 0;
        int[] values = new int[10];
        if (type == 2) {
            values = new int[10];
        }
        int rowOffset = this.width;
        boolean count = false;
        int y = this.yMin;
        while (y <= this.yMax) {
            int offset = this.xMin + y * this.width;
            int p2 = pixels2[offset - rowOffset - 1] & 0xFF;
            int p3 = pixels2[offset - rowOffset] & 0xFF;
            int p5 = pixels2[offset - 1] & 0xFF;
            int p6 = pixels2[offset] & 0xFF;
            int p8 = pixels2[offset + rowOffset - 1] & 0xFF;
            int p9 = pixels2[offset + rowOffset] & 0xFF;
            int x = this.xMin;
            while (x <= this.xMax) {
                int p1 = p2;
                p2 = p3;
                p3 = pixels2[offset - rowOffset + 1] & 0xFF;
                int p4 = p5;
                p5 = p6;
                p6 = pixels2[offset + 1] & 0xFF;
                int p7 = p8;
                p8 = p9;
                p9 = pixels2[offset + rowOffset + 1] & 0xFF;
                switch (type) {
                    case 0: {
                        sum = (p1 + p2 + p3 + p4 + p5 + p6 + p7 + p8 + p9) / 9;
                        break;
                    }
                    case 1: {
                        int sum1 = p1 + 2 * p2 + p3 - p7 - 2 * p8 - p9;
                        sum2 = p1 + 2 * p4 + p7 - p3 - 2 * p6 - p9;
                        sum = (int)Math.sqrt(sum1 * sum1 + sum2 * sum2);
                        if (sum <= 255) break;
                        sum = 255;
                        break;
                    }
                    case 2: {
                        values[1] = p1;
                        values[2] = p2;
                        values[3] = p3;
                        values[4] = p4;
                        values[5] = p5;
                        values[6] = p6;
                        values[7] = p7;
                        values[8] = p8;
                        values[9] = p9;
                        sum = this.findMedian(values);
                        break;
                    }
                    case 3: {
                        sum = p5;
                        if (p1 < sum) {
                            sum = p1;
                        }
                        if (p2 < sum) {
                            sum = p2;
                        }
                        if (p3 < sum) {
                            sum = p3;
                        }
                        if (p4 < sum) {
                            sum = p4;
                        }
                        if (p6 < sum) {
                            sum = p6;
                        }
                        if (p7 < sum) {
                            sum = p7;
                        }
                        if (p8 < sum) {
                            sum = p8;
                        }
                        if (p9 >= sum) break;
                        sum = p9;
                        break;
                    }
                    case 4: {
                        sum = p5;
                        if (p1 > sum) {
                            sum = p1;
                        }
                        if (p2 > sum) {
                            sum = p2;
                        }
                        if (p3 > sum) {
                            sum = p3;
                        }
                        if (p4 > sum) {
                            sum = p4;
                        }
                        if (p6 > sum) {
                            sum = p6;
                        }
                        if (p7 > sum) {
                            sum = p7;
                        }
                        if (p8 > sum) {
                            sum = p8;
                        }
                        if (p9 <= sum) break;
                        sum = p9;
                        break;
                    }
                }
                this.pixels[offset++] = (byte)sum;
                ++x;
            }
            if (y % inc == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        this.hideProgress();
    }

    public void erode() {
        if (this.isInvertedLut()) {
            this.filter(3);
        } else {
            this.filter(4);
        }
    }

    public void dilate() {
        if (this.isInvertedLut()) {
            this.filter(4);
        } else {
            this.filter(3);
        }
    }

    public void outline() {
        new BinaryProcessor(this).outline();
    }

    public void skeletonize() {
        new BinaryProcessor(this).skeletonize();
    }

    private final int findMedian(int[] values) {
        int max;
        int i = 1;
        while (i <= 4) {
            max = 0;
            int mj = 1;
            int j = 1;
            while (j <= 9) {
                if (values[j] > max) {
                    max = values[j];
                    mj = j;
                }
                ++j;
            }
            values[mj] = 0;
            ++i;
        }
        max = 0;
        int j = 1;
        while (j <= 9) {
            if (values[j] > max) {
                max = values[j];
            }
            ++j;
        }
        return max;
    }

    public void medianFilter() {
        this.filter(2);
    }

    public void noise(double range) {
        Random rnd = new Random();
        int y = this.roiY;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                int RandomBrightness = (int)Math.round(rnd.nextGaussian() * range);
                int v = (this.pixels[i] & 0xFF) + RandomBrightness;
                if (v < 0) {
                    v = 0;
                }
                if (v > 255) {
                    v = 255;
                }
                this.pixels[i] = (byte)v;
                ++i;
                ++x;
            }
            if (y % 10 == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        this.hideProgress();
    }

    public void scale(double xScale, double yScale) {
        int ymax;
        int ymin;
        int xmax;
        int xmin;
        double xCenter = (double)this.roiX + (double)this.roiWidth / 2.0;
        double yCenter = (double)this.roiY + (double)this.roiHeight / 2.0;
        if (this.isInvertedLut()) {
            this.bgColor = 0;
        }
        if (xScale > 1.0 && yScale > 1.0) {
            xmin = (int)(xCenter - (xCenter - (double)this.roiX) * xScale);
            if (xmin < 0) {
                xmin = 0;
            }
            if ((xmax = xmin + (int)((double)this.roiWidth * xScale) - 1) >= this.width) {
                xmax = this.width - 1;
            }
            if ((ymin = (int)(yCenter - (yCenter - (double)this.roiY) * yScale)) < 0) {
                ymin = 0;
            }
            if ((ymax = ymin + (int)((double)this.roiHeight * yScale) - 1) >= this.height) {
                ymax = this.height - 1;
            }
        } else {
            xmin = this.roiX;
            xmax = this.roiX + this.roiWidth - 1;
            ymin = this.roiY;
            ymax = this.roiY + this.roiHeight - 1;
        }
        byte[] pixels2 = (byte[])this.getPixelsCopy();
        boolean checkCoordinates = xScale < 1.0 || yScale < 1.0;
        int y = ymin;
        while (y <= ymax) {
            double ys = ((double)y - yCenter) / yScale + yCenter;
            int ysi = (int)ys;
            int index1 = y * this.width + xmin;
            int index2 = this.width * (int)ys;
            int x = xmin;
            while (x <= xmax) {
                double xs = ((double)x - xCenter) / xScale + xCenter;
                int xsi = (int)xs;
                this.pixels[index1++] = checkCoordinates && (xsi < xmin || xsi > xmax || ysi < ymin || ys > (double)ymax) ? (byte)this.bgColor : (this.interpolate ? (byte)((int)(this.getInterpolatedPixel(xs, ys, pixels2) + 0.5) & 0xFF) : pixels2[index2 + xsi]);
                ++x;
            }
            if (y % 20 == 0) {
                this.showProgress((double)(y - ymin) / (double)this.height);
            }
            ++y;
        }
        this.hideProgress();
    }

    private final double getInterpolatedPixel(double x, double y, byte[] pixels) {
        int xbase = (int)x;
        int ybase = (int)y;
        double xFraction = x - (double)xbase;
        double yFraction = y - (double)ybase;
        int offset = ybase * this.width + xbase;
        int lowerLeft = pixels[offset] & 0xFF;
        if (xbase >= this.width - 1 || ybase >= this.height - 1) {
            return lowerLeft;
        }
        int lowerRight = pixels[offset + 1] & 0xFF;
        int upperRight = pixels[offset + this.width + 1] & 0xFF;
        int upperLeft = pixels[offset + this.width] & 0xFF;
        double upperAverage = (double)upperLeft + xFraction * (double)(upperRight - upperLeft);
        double lowerAverage = (double)lowerLeft + xFraction * (double)(lowerRight - lowerLeft);
        return lowerAverage + yFraction * (upperAverage - lowerAverage);
    }

    public ImageProcessor resize(int dstWidth, int dstHeight) {
        if (this.roiWidth == dstWidth && this.roiHeight == dstHeight) {
            return this.crop();
        }
        double srcCenterX = (double)this.roiX + (double)this.roiWidth / 2.0;
        double srcCenterY = (double)this.roiY + (double)this.roiHeight / 2.0;
        double dstCenterX = (double)dstWidth / 2.0;
        double dstCenterY = (double)dstHeight / 2.0;
        double xScale = (double)dstWidth / (double)this.roiWidth;
        double yScale = (double)dstHeight / (double)this.roiHeight;
        ImageProcessor ip2 = this.createProcessor(dstWidth, dstHeight);
        byte[] pixels2 = (byte[])ip2.getPixels();
        int y = 0;
        while (y <= dstHeight - 1) {
            double ys = ((double)y - dstCenterY) / yScale + srcCenterY;
            int index1 = this.width * (int)ys;
            int index2 = y * dstWidth;
            int x = 0;
            while (x <= dstWidth - 1) {
                double xs = ((double)x - dstCenterX) / xScale + srcCenterX;
                pixels2[index2++] = this.interpolate ? (byte)((int)(this.getInterpolatedPixel(xs, ys, this.pixels) + 0.5) & 0xFF) : this.pixels[index1 + (int)xs];
                ++x;
            }
            if (y % 20 == 0) {
                this.showProgress((double)y / (double)dstHeight);
            }
            ++y;
        }
        this.hideProgress();
        return ip2;
    }

    public void rotate(double angle) {
        if (angle % 360.0 == 0.0) {
            return;
        }
        byte[] pixels2 = (byte[])this.getPixelsCopy();
        double centerX = (double)this.roiX + (double)(this.roiWidth - 1) / 2.0;
        double centerY = (double)this.roiY + (double)(this.roiHeight - 1) / 2.0;
        int xMax = this.roiX + this.roiWidth - 1;
        if (this.isInvertedLut()) {
            this.bgColor = 0;
        }
        double angleRadians = -angle / 57.29577951308232;
        double ca = Math.cos(angleRadians);
        double sa = Math.sin(angleRadians);
        double tmp1 = centerY * sa - centerX * ca;
        double tmp2 = -centerX * sa - centerY * ca;
        double dwidth = this.width;
        double dheight = this.height;
        int y = this.roiY;
        while (y < this.roiY + this.roiHeight) {
            int index = y * this.width + this.roiX;
            double tmp3 = tmp1 - (double)y * sa + centerX;
            double tmp4 = tmp2 + (double)y * ca + centerY;
            int x = this.roiX;
            while (x <= xMax) {
                double xs = (double)x * ca + tmp3;
                double ys = (double)x * sa + tmp4;
                if (xs >= -0.01 && xs < dwidth && ys >= -0.01 && ys < dheight) {
                    if (this.interpolate) {
                        this.pixels[index++] = (byte)((int)(this.getInterpolatedPixel(xs, ys, pixels2) + 0.5) & 0xFF);
                    } else {
                        int ixs = (int)(xs + 0.5);
                        int iys = (int)(ys + 0.5);
                        if (ixs >= this.width) {
                            ixs = this.width - 1;
                        }
                        if (iys >= this.height) {
                            iys = this.height - 1;
                        }
                        this.pixels[index++] = pixels2[this.width * iys + ixs];
                    }
                } else {
                    this.pixels[index++] = (byte)this.bgColor;
                }
                ++x;
            }
            if (y % 30 == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        this.hideProgress();
    }

    public void flipVertical() {
        int y = 0;
        while (y < this.roiHeight / 2) {
            int index1 = (this.roiY + y) * this.width + this.roiX;
            int index2 = (this.roiY + this.roiHeight - 1 - y) * this.width + this.roiX;
            int i = 0;
            while (i < this.roiWidth) {
                byte tmp = this.pixels[index1];
                this.pixels[index1++] = this.pixels[index2];
                this.pixels[index2++] = tmp;
                ++i;
            }
            ++y;
        }
        this.newSnapshot = false;
    }

    public int[] getHistogram() {
        if (this.mask != null) {
            return this.getHistogram(this.mask);
        }
        int[] histogram = new int[256];
        int y = this.roiY;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                int v;
                int n = v = this.pixels[i++] & 0xFF;
                histogram[n] = histogram[n] + 1;
                ++x;
            }
            ++y;
        }
        return histogram;
    }

    public int[] getHistogram(int[] mask) {
        int[] histogram = new int[256];
        int y = this.roiY;
        int my = 0;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int mi = my * this.roiWidth;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                if (mask[mi++] == -16777216) {
                    int v;
                    int n = v = this.pixels[i] & 0xFF;
                    histogram[n] = histogram[n] + 1;
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
        return histogram;
    }

    public void threshold(int level) {
        int i = 0;
        while (i < this.width * this.height) {
            this.pixels[i] = (this.pixels[i] & 0xFF) <= level ? 0 : -1;
            ++i;
        }
        this.newSnapshot = false;
    }

    public int getAutoThreshold() {
        double tempSum4;
        double tempSum3;
        double tempSum2;
        double tempSum1;
        double result;
        int[] histogram = this.getHistogram();
        histogram[0] = 0;
        histogram[255] = 0;
        int min = 0;
        while (histogram[min] == 0 && min < 255) {
            ++min;
        }
        int max = 255;
        while (histogram[max] == 0 && max > 0) {
            --max;
        }
        if (min >= max) {
            int level = 128;
            return level;
        }
        int movingIndex = min;
        do {
            tempSum4 = 0.0;
            tempSum3 = 0.0;
            tempSum2 = 0.0;
            tempSum1 = 0.0;
            int i = min;
            while (i <= movingIndex) {
                tempSum1 += (double)(i * histogram[i]);
                tempSum2 += (double)histogram[i];
                ++i;
            }
            int i2 = movingIndex + 1;
            while (i2 <= max) {
                tempSum3 += (double)(i2 * histogram[i2]);
                tempSum4 += (double)histogram[i2];
                ++i2;
            }
        } while ((double)(++movingIndex + 1) <= (result = tempSum1 / tempSum2 / 2.0 + tempSum3 / tempSum4 / 2.0) && movingIndex <= max - 1);
        int level = (int)Math.round(result);
        return level;
    }

    public void autoThreshold() {
        this.threshold(this.getAutoThreshold());
    }

    public void applyLut() {
        if (this.rLUT2 == null) {
            return;
        }
        if (this.isInvertedLut()) {
            int i = 0;
            while (i < this.width * this.height) {
                this.pixels[i] = (byte)(255 - this.rLUT2[this.pixels[i] & 0xFF]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.width * this.height) {
                this.pixels[i] = this.rLUT2[this.pixels[i] & 0xFF];
                ++i;
            }
        }
        this.setMinAndMax(0.0, 255.0);
    }
}

