/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class FloatStatistics
extends ImageStatistics {
    public FloatStatistics(ImageProcessor ip) {
        this(ip, 27, null);
    }

    public FloatStatistics(ImageProcessor ip, int mOptions, Calibration cal) {
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.setup(ip, cal);
        this.getStatistics(ip);
        if ((mOptions & 8) != 0) {
            this.getMode();
        }
        if ((mOptions & 0x800) != 0) {
            this.fitEllipse(ip);
        } else if ((mOptions & 0x20) != 0) {
            this.getCentroid(ip);
        }
        if ((mOptions & 0x40) != 0) {
            this.getCenterOfMass(ip);
        }
    }

    void getStatistics(ImageProcessor ip) {
        double v;
        int y;
        float[] pixels = (float[])ip.getPixels();
        this.nBins = ip.getHistogramSize();
        this.histogram = new int[this.nBins];
        double sum = 0.0;
        double sum2 = 0.0;
        int[] mask = ip.getMask();
        double roiMin = Double.MAX_VALUE;
        double roiMax = -1.7976931348623157E308;
        if (mask != null) {
            y = this.ry;
            int my = 0;
            while (y < this.ry + this.rh) {
                int i = y * this.width + this.rx;
                int mi = my * this.rw;
                int x = this.rx;
                while (x < this.rx + this.rw) {
                    if (mask[mi++] == -16777216) {
                        v = pixels[i];
                        if (v < roiMin) {
                            roiMin = v;
                        }
                        if (v > roiMax) {
                            roiMax = v;
                        }
                    }
                    ++i;
                    ++x;
                }
                ++y;
                ++my;
            }
        } else {
            y = this.ry;
            while (y < this.ry + this.rh) {
                int i = y * this.width + this.rx;
                int x = this.rx;
                while (x < this.rx + this.rw) {
                    int n = i++;
                    v = pixels[n];
                    if (v < roiMin) {
                        roiMin = v;
                    }
                    if (v > roiMax) {
                        roiMax = v;
                    }
                    ++x;
                }
                ++y;
            }
        }
        this.min = roiMin;
        this.max = roiMax;
        this.histMin = this.min;
        this.histMax = this.max;
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        double scale = (double)this.nBins / (this.histMax - this.histMin);
        this.pixelCount = 0;
        int y2 = this.ry;
        int my = 0;
        while (y2 < this.ry + this.rh) {
            int i = y2 * this.width + this.rx;
            int mi = my * this.rw;
            int x = this.rx;
            while (x < this.rx + this.rw) {
                if (mask == null || mask[mi++] == -16777216) {
                    v = pixels[i];
                    ++this.pixelCount;
                    sum += v;
                    sum2 += v * v;
                    int index = (int)(scale * (v - this.histMin));
                    if (index >= this.nBins) {
                        index = this.nBins - 1;
                    }
                    int n = index;
                    this.histogram[n] = this.histogram[n] + 1;
                }
                ++i;
                ++x;
            }
            ++y2;
            ++my;
        }
        this.min = roiMin;
        this.max = roiMax;
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.mean = sum / (double)this.pixelCount;
        this.calculateStdDev(this.pixelCount, sum, sum2);
    }

    void getMode() {
        this.maxCount = 0;
        int i = 0;
        while (i < this.nBins) {
            int count = this.histogram[i];
            if (count > this.maxCount) {
                this.maxCount = count;
                this.mode = i;
            }
            ++i;
        }
        this.dmode = this.histMin + (double)this.mode * this.binSize + this.binSize / 2.0;
    }

    void getCenterOfMass(ImageProcessor ip) {
        float[] pixels = (float[])ip.getPixels();
        int[] mask = ip.getMask();
        double count = 0.0;
        double xsum = 0.0;
        double ysum = 0.0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            int x = this.rx;
            while (x < this.rx + this.rw) {
                if (mask == null || mask[mi++] == -16777216) {
                    double v = (double)pixels[i] + Double.MIN_VALUE;
                    count += v;
                    xsum += (double)x * v;
                    ysum += (double)y * v;
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
        this.xCenterOfMass = (xsum / count + 0.5) * this.pw;
        this.yCenterOfMass = (ysum / count + 0.5) * this.ph;
    }
}

