/*
 * Decompiled with CFR 0.152.
 */
package rad.dicom.ima;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import rad.dicom.ima.GeneralImageIOD;
import rad.dicom.ima.ImaUtil;

public class ImagePanel
extends JPanel {
    public static final int CW_DEFAULT = 0;
    public static final int CW_AUTO = 1;
    private boolean scrollable = false;
    private boolean windowable = true;
    private Dimension preferredSize = new Dimension(262, 262);
    private Dimension minimumSize = new Dimension(38, 38);
    private Color background = Color.darkGray;
    private GeneralImageIOD genIma = null;
    private Image img = null;
    private ImageIcon iIcon = null;
    private long lastWhen;
    private int lastX;
    private int lastY;
    private int defCenter;
    private int defWidth;
    private int theCenter;
    private int theWidth;
    JLabel iconLabel = new JLabel();
    JScrollPane scrollPane = new JScrollPane();
    Border grayBorder = new LineBorder(Color.darkGray, 1);
    Border greenBorder = new LineBorder(Color.green, 1);
    BorderLayout borderLayout1 = new BorderLayout();
    private int lastCenter;
    private int lastWidth;

    public ImagePanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setImage(GeneralImageIOD gi) {
        this.genIma = gi;
        if (this.genIma.pixel16.length == 0) {
            return;
        }
        if (this.genIma.isCenterWidth) {
            if (this.genIma.classUID.compareTo("1.2.840.10008.5.1.4.1.1.2") == 0) {
                int[] window = new int[]{this.genIma.windowCenter, this.genIma.windowWidth};
                this.genIma.hu2pv(window);
                this.defCenter = window[0];
                this.defWidth = window[1];
            } else {
                this.defCenter = this.genIma.windowCenter;
                this.defWidth = this.genIma.windowWidth;
            }
        } else {
            this.defCenter = this.genIma.autoCenter;
            this.defWidth = this.genIma.autoWidth;
        }
        this.theCenter = this.defCenter;
        this.theWidth = this.defWidth;
        this.genIma.lastCenter = this.theCenter;
        this.genIma.lastWidth = this.theWidth;
        this.iconLabel = new JLabel();
        this.iconLabel.setOpaque(true);
        this.iconLabel.setBackground(this.background);
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setVerticalAlignment(0);
        this.updateIconLabel();
        if (this.scrollPane != null) {
            this.remove(this.scrollPane);
        }
        this.scrollPane = new JScrollPane(this.iconLabel);
        this.scrollPane.setBackground(this.background);
        this.add((Component)this.scrollPane, "Center");
        this.validate();
    }

    public void setCW(int type) {
        switch (type) {
            case 0: {
                this.theCenter = this.defCenter;
                this.theWidth = this.defWidth;
                break;
            }
            case 1: {
                this.theCenter = this.genIma.autoCenter;
                this.theWidth = this.genIma.autoWidth;
            }
        }
        this.genIma.lastCenter = this.theCenter;
        this.genIma.lastWidth = this.theWidth;
        this.updateIconLabel();
    }

    public void setCW(int center, int width) {
        this.theCenter = center;
        this.theWidth = width;
        this.genIma.lastCenter = this.theCenter;
        this.genIma.lastWidth = this.theWidth;
        this.updateIconLabel();
    }

    public int getCenter() {
        return this.theCenter;
    }

    public int getWidth() {
        return this.theWidth;
    }

    public ImageIcon getImageIcon() {
        return this.iIcon;
    }

    public void setScrollable(boolean scr) {
        this.scrollable = scr;
        if (this.genIma != null) {
            this.updateIconLabel();
        }
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setWindowable(boolean win) {
        this.windowable = win;
    }

    public boolean isWindowable() {
        return this.windowable;
    }

    private void updateIconLabel() {
        if (this.genIma == null) {
            return;
        }
        if (this.img != null) {
            this.img.flush();
        }
        this.img = ImaUtil.GIODtoImage(this.genIma, this.theCenter, this.theWidth);
        double imW = this.img.getWidth(this);
        double imH = this.img.getHeight(this);
        if (this.scrollable) {
            this.iIcon = new ImageIcon(this.img);
        } else {
            Dimension size = this.getSize();
            double wFac = imW / (double)(size.width - 6);
            double hFac = imH / (double)(size.height - 6);
            double fac = wFac >= hFac ? wFac : hFac;
            this.iIcon = new ImageIcon(this.img.getScaledInstance((int)(imW / fac), (int)(imH / fac), 1));
        }
        this.iconLabel.setIcon(this.iIcon);
        this.iconLabel.setSize(this.iIcon.getIconWidth(), this.iIcon.getIconHeight());
        this.validate();
    }

    public void repaint() {
        this.updateIconLabel();
        super.repaint();
    }

    void this_mousePressed(MouseEvent e) {
        if (!this.windowable) {
            return;
        }
        this.lastX = e.getX();
        this.lastY = e.getY();
        this.lastCenter = this.getCenter();
        this.lastWidth = this.getWidth();
        this.lastWhen = e.getWhen();
        this.setBorder(this.greenBorder);
        this.repaint();
    }

    void this_mouseReleased(MouseEvent e) {
        if (!this.windowable) {
            return;
        }
        this.setBorder(this.grayBorder);
        this.repaint();
    }

    void this_mouseDragged(MouseEvent e) {
        if (!this.windowable) {
            return;
        }
        long actWhen = e.getWhen();
        int deltaT = (int)(actWhen - this.lastWhen);
        if (deltaT < 100) {
            return;
        }
        int actX = e.getX();
        int actY = e.getY();
        int deltaX = actX - this.lastX;
        int deltaY = this.lastY - actY;
        if (Math.abs(deltaX) > 10) {
            deltaX *= 5;
        }
        if (Math.abs(deltaY) > 10) {
            deltaY *= 5;
        }
        this.setCW(this.lastCenter + deltaY, this.lastWidth + deltaX);
        this.updateIconLabel();
        this.lastX = actX;
        this.lastY = actY;
        this.lastCenter = this.getCenter();
        this.lastWidth = this.getWidth();
        this.lastWhen = actWhen;
    }

    private void jbInit() throws Exception {
        this.iconLabel.setOpaque(true);
        this.iconLabel.setBackground(this.background);
        this.scrollPane.setBackground(this.background);
        this.setMinimumSize(this.minimumSize);
        this.setPreferredSize(this.preferredSize);
        this.setBorder(this.grayBorder);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                ImagePanel.this.this_mouseDragged(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                ImagePanel.this.this_mouseReleased(e);
            }

            public void mousePressed(MouseEvent e) {
                ImagePanel.this.this_mousePressed(e);
            }
        });
        this.setLayout(this.borderLayout1);
        this.iconLabel.setMinimumSize(new Dimension(32, 32));
        this.iconLabel.setPreferredSize(new Dimension(256, 256));
        this.scrollPane.setMinimumSize(new Dimension(37, 37));
        this.scrollPane.setPreferredSize(new Dimension(261, 261));
        this.scrollPane.getViewport().add((Component)this.iconLabel, null);
        this.add((Component)this.scrollPane, "Center");
    }

    static {
        CW_DEFAULT = 0;
        CW_AUTO = 1;
    }
}

