/*
 * Decompiled with CFR 0.152.
 */
package mrcp.LineareAlgebra;

import mrcp.LineareAlgebra.NotFullRankException;

public class Triangular {
    public void solveLower(double[][] l, double[] y, double[] b, int n) throws NotFullRankException {
        boolean err = false;
        int i = 0;
        while (i < n) {
            if (l[i][i] == 0.0) {
                System.out.println("\nTriangular.solveLower error:  Diagonal element " + i + " of the L matrix is zero.\n");
                err = true;
            }
            ++i;
        }
        if (err) {
            throw new NotFullRankException();
        }
        i = 0;
        while (i < n) {
            double sum = 0.0;
            int j = 0;
            while (j < i) {
                sum += l[i][j] * y[j];
                ++j;
            }
            y[i] = (b[i] - sum) / l[i][i];
            ++i;
        }
    }

    public void solveUpper(double[][] u, double[] x, double[] y, int n) throws NotFullRankException {
        boolean err = false;
        int i = 0;
        while (i < n) {
            if (u[i][i] == 0.0) {
                System.out.println("\nTriangular.solveUpper error:  Diagonal element " + i + " of the U matrix is zero.\n");
                err = true;
            }
            ++i;
        }
        if (err) {
            throw new NotFullRankException();
        }
        i = n - 1;
        while (i > -1) {
            double sum = 0.0;
            int j = i + 1;
            while (j < n) {
                sum += u[i][j] * x[j];
                ++j;
            }
            x[i] = (y[i] - sum) / u[i][i];
            --i;
        }
    }

    public void invertLower(double[][] l, int n) throws NotFullRankException {
        boolean err = false;
        int i = 0;
        while (i < n) {
            if (l[i][i] == 0.0) {
                System.out.println("\nTriangular.invertLower error:  Diagonal element " + i + " of the L matrix is zero.\n");
                err = true;
            }
            ++i;
        }
        if (err) {
            throw new NotFullRankException();
        }
        int j = 0;
        while (j < n) {
            l[j][j] = 1.0 / l[j][j];
            i = j + 1;
            while (i < n) {
                double sum = 0.0;
                int k = j;
                while (k < i) {
                    sum -= l[i][k] * l[k][j];
                    ++k;
                }
                l[i][j] = sum / l[i][i];
                ++i;
            }
            ++j;
        }
    }

    public void invertUpper(double[][] u, int n) throws NotFullRankException {
        boolean err = false;
        int i = 0;
        while (i < n) {
            if (u[i][i] == 0.0) {
                System.out.println("\nTriangular.invertUpper error:  Diagonal element " + i + " of the U matrix is zero.\n");
                err = true;
            }
            ++i;
        }
        if (err) {
            throw new NotFullRankException();
        }
        int j = n - 1;
        while (j > -1) {
            u[j][j] = 1.0 / u[j][j];
            i = j - 1;
            while (i > -1) {
                double sum = 0.0;
                int k = j;
                while (k > i) {
                    sum -= u[i][k] * u[k][j];
                    --k;
                }
                u[i][j] = sum / u[i][i];
                --i;
            }
            --j;
        }
    }
}

