/*
 * Decompiled with CFR 0.152.
 */
package mrcp.control;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.ProgressMonitor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mrcp.graphics.Update_control;
import mrcp.gui.Optionen_Dialog;
import mrcp.gui.Slice_Dialog;
import mrcp.gui.gui;
import mrcp.tools.Global_Options;
import mrcp.tools.Point3D;
import mrcp.tools.SwingWorker;

public class Adjustment_control
implements ActionListener,
MouseMotionListener,
MouseListener,
ChangeListener,
ItemListener {
    private gui my_gui;
    private int transX = 0;
    private int transY = 0;
    private int oldx = 0;
    private int oldy = 0;
    private float trans_sel_X = 0.0f;
    private float trans_sel_Y = 0.0f;
    private float trans_sel_Z = 0.0f;
    private int old_sel_X = 0;
    private int old_sel_Y = 0;
    private int old_sel_Z = 0;

    public Adjustment_control(gui my_gui) {
        this.my_gui = my_gui;
    }

    private gui getGui() {
        return this.my_gui;
    }

    public void actionPerformed(ActionEvent e) {
        if ("Optionen einstellen".equals(e.getActionCommand())) {
            Optionen_Dialog d = new Optionen_Dialog(this.getGui(), "Optionen", true);
            d.show();
            d.dispose();
            this.getGui().Sourceselection.source_control.redraw = true;
            this.getGui().Sourceselection.jPanelDicomCube.update = true;
        }
        if ("Schlie\u00dfen".equals(e.getActionCommand())) {
            System.exit(0);
        }
        if ("Rotate Y Left".equals(e.getActionCommand())) {
            Update_control.NewPreView = true;
            Update_control.rotateY(Global_Options.RotateStep);
            this.getGui().Adjustments3D.repaint();
        } else if ("Rotate Y Right".equals(e.getActionCommand())) {
            Update_control.NewPreView = true;
            Update_control.rotateY(-Global_Options.RotateStep);
            this.getGui().Adjustments3D.repaint();
        } else if ("Rotate Z Right".equals(e.getActionCommand())) {
            Update_control.NewPreView = true;
            Update_control.rotateZ(-Global_Options.RotateStep);
            this.getGui().Adjustments3D.repaint();
        } else if ("Rotate Z Left".equals(e.getActionCommand())) {
            Update_control.NewPreView = true;
            Update_control.rotateZ(Global_Options.RotateStep);
            this.getGui().Adjustments3D.repaint();
        } else if ("Rotate X Left".equals(e.getActionCommand())) {
            Update_control.NewPreView = true;
            Update_control.rotateX(-Global_Options.RotateStep);
            this.getGui().Adjustments3D.repaint();
        } else if ("Rotate X Right".equals(e.getActionCommand())) {
            Update_control.NewPreView = true;
            Update_control.rotateX(Global_Options.RotateStep);
            this.getGui().Adjustments3D.repaint();
        }
        if ("BG -z".equals(e.getActionCommand())) {
            Update_control.Trans_Z -= 5.0f;
            this.showTra();
        } else if ("BG +z".equals(e.getActionCommand())) {
            Update_control.Trans_Z += 5.0f;
            this.showTra();
        } else if ("BG -x".equals(e.getActionCommand())) {
            Update_control.Sag_X -= 5.0f;
            this.showSag();
        } else if ("BG +x".equals(e.getActionCommand())) {
            Update_control.Sag_X += 5.0f;
            this.showSag();
        } else if ("BG -y".equals(e.getActionCommand())) {
            Update_control.Cor_Y -= 5.0f;
            this.showCor();
        } else if ("BG +y".equals(e.getActionCommand())) {
            Update_control.Cor_Y += 5.0f;
            this.showCor();
        } else if ("width-".equals(e.getActionCommand())) {
            Update_control.NewPreView = true;
            Update_control.translateWidth(-3.0f);
            this.getGui().Adjustments3D.repaint();
        } else if ("width+".equals(e.getActionCommand())) {
            Update_control.NewPreView = true;
            Update_control.translateWidth(4.0f);
            this.getGui().Adjustments3D.repaint();
        } else if ("heigth-".equals(e.getActionCommand())) {
            Update_control.NewPreView = true;
            Update_control.translateHeigth(-4.0f);
            this.getGui().Adjustments3D.repaint();
        } else if ("heigth+".equals(e.getActionCommand())) {
            Update_control.NewPreView = true;
            Update_control.translateHeigth(4.0f);
            this.getGui().Adjustments3D.repaint();
        } else if ("depth-".equals(e.getActionCommand())) {
            Update_control.NewPreView = true;
            Update_control.translateDepth(-1.0f);
            this.getGui().Adjustments3D.repaint();
        } else if ("depth+".equals(e.getActionCommand())) {
            Update_control.NewPreView = true;
            Update_control.translateDepth(1.0f);
            this.getGui().Adjustments3D.repaint();
        } else if ("set".equals(e.getActionCommand())) {
            Slice_Dialog sd = new Slice_Dialog(this.getGui(), "Bestimmen Sie die Schichtparameter", true);
            sd.show();
            if (sd.isCanceld) {
                return;
            }
            this.getGui().slicetree.setSelectedSeries();
            this.showOrtho();
        } else if ("Update".equals(e.getActionCommand())) {
            this.showUpdate();
        } else if ("next".equals(e.getActionCommand())) {
            Update_control.NewPreView = true;
            Update_control.increment();
            this.showUpdate();
            this.getGui().Adjustments3D.repaint();
        } else if ("prev".equals(e.getActionCommand())) {
            Update_control.NewPreView = true;
            Update_control.decrement();
            this.showUpdate();
            this.getGui().Adjustments3D.repaint();
        } else if ("ImageJ".equals(e.getActionCommand())) {
            this.showImages();
        } else if ("Export".equals(e.getActionCommand())) {
            this.exportDicom();
        }
    }

    public void mouseMoved(MouseEvent m) {
    }

    public void mouseDragged(MouseEvent e) {
        JPanel pan;
        if (this.getGui().slicetree.NumberOfSelectesSeries <= 0) {
            return;
        }
        Object ob = e.getSource();
        String name = ob.getClass().getName();
        if (ob.getClass().getName().indexOf("JPanel_Cube") > 0) {
            this.transX += -this.oldx + e.getX();
            this.transY += -this.oldy + e.getY();
            this.oldx = e.getX();
            this.oldy = e.getY();
            Update_control.View3D_transX = this.transX;
            Update_control.View3D_transY = this.transY;
            this.getGui().jPanel_cube.repaint();
        }
        if ((name = (pan = (JPanel)ob).getName()) == null) {
            return;
        }
        if (name.compareTo("Tra") == 0) {
            Update_control.NewPreView = true;
            this.trans_sel_X = -this.old_sel_X + e.getX();
            this.trans_sel_Y = -this.old_sel_Y + e.getY();
            Update_control.translate(this.trans_sel_X, this.trans_sel_Y, 0.0f);
            this.getGui().Adjustments3D.repaint();
            this.old_sel_X = e.getX();
            this.old_sel_Y = e.getY();
        }
        if (name.compareTo("Sag") == 0) {
            Update_control.NewPreView = true;
            this.trans_sel_Y = -this.old_sel_Y + e.getX();
            this.trans_sel_Z = -this.old_sel_Z + e.getY();
            Update_control.translate(0.0f, this.trans_sel_Y, -this.trans_sel_Z);
            this.getGui().Adjustments3D.repaint();
            this.old_sel_Y = e.getX();
            this.old_sel_Z = e.getY();
        }
        if (name.compareTo("Cor") == 0) {
            Update_control.NewPreView = true;
            this.trans_sel_X = -this.old_sel_X + e.getX();
            this.trans_sel_Z = -this.old_sel_Z + e.getY();
            Update_control.translate(this.trans_sel_X, 0.0f, -this.trans_sel_Z);
            this.getGui().Adjustments3D.repaint();
            this.old_sel_X = e.getX();
            this.old_sel_Z = e.getY();
        }
    }

    public void mousePressed(MouseEvent e) {
        JPanel pan;
        Object ob = e.getSource();
        String name = ob.getClass().getName();
        if (name.indexOf("JPanel_Cube") > 0) {
            this.oldx = e.getX();
            this.oldy = e.getY();
        }
        if ((name = (pan = (JPanel)ob).getName()) == null) {
            return;
        }
        if (name.compareTo("Tra") == 0) {
            this.old_sel_X = e.getX();
            this.old_sel_Y = e.getY();
        } else if (name.compareTo("Sag") == 0) {
            this.old_sel_Y = e.getX();
            this.old_sel_Z = e.getY();
        } else if (name.compareTo("Cor") == 0) {
            this.old_sel_X = e.getX();
            this.old_sel_Z = e.getY();
        }
    }

    public void mouseReleased(MouseEvent m) {
    }

    public void mouseClicked(MouseEvent m) {
    }

    public void mouseEntered(MouseEvent m) {
    }

    public void mouseExited(MouseEvent m) {
    }

    public void stateChanged(ChangeEvent ce) {
        JSlider source = (JSlider)ce.getSource();
        boolean isadj = source.getValueIsAdjusting();
        if (isadj) {
            // empty if block
        }
        Update_control.scale = (float)source.getValue() * 0.01f;
        this.getGui().jPanel_cube.repaint();
    }

    public void itemStateChanged(ItemEvent ie) {
        Update_control.showAll = !Update_control.showAll;
        this.getGui().Adjustments3D.repaint();
    }

    private void exportDicom() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.write((String)"Keine Bilder in ImageJ ge\u00f6ffnet");
        }
        IJ.runPlugIn((String)"DICOM_export", (String)"");
    }

    private void showImages() {
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                Point3D RowVector = Update_control.RowVec;
                Point3D ColVector = Update_control.ColVec;
                Point3D SliceVector = Update_control.SliceVec;
                float RowSpacing = Update_control.width / (float)Update_control.Cols;
                float ColSpacing = Update_control.heigth / (float)Update_control.Rows;
                byte[] cTab = new byte[256];
                int i = 0;
                while (i < 256) {
                    cTab[i] = (byte)i;
                    ++i;
                }
                IndexColorModel cModel = new IndexColorModel(8, 256, cTab, cTab, cTab);
                ProgressMonitor mon = new ProgressMonitor((Component)IJ.getInstance(), "Berechne Schicht(en)", "", 0, Update_control.Rows * Update_control.CubeArray.size());
                ImageStack is = new ImageStack(Update_control.Cols, Update_control.Rows);
                int old = Update_control.currentSlice;
                Update_control.currentSlice = 0;
                Point3D Origin = Update_control.getOrigin();
                Update_control.currentSlice = old;
                if (Origin == null) {
                    return null;
                }
                short[][] Pixels = ((Adjustment_control)Adjustment_control.this).getGui().slicetree.getSlices(Origin, RowVector, ColVector, SliceVector, RowSpacing, ColSpacing, Update_control.depth, Update_control.Rows, Update_control.Cols, mon, Update_control.CubeArray.size(), Update_control.slicedist);
                int i2 = 0;
                while (i2 < Update_control.CubeArray.size()) {
                    ShortProcessor proc = new ShortProcessor(Update_control.Cols, Update_control.Rows, Pixels[i2], (ColorModel)cModel, false);
                    is.addSlice("test" + new Integer(i2).toString(), (ImageProcessor)proc);
                    ++i2;
                }
                String name = "Interpol : ";
                name = name + new Integer(Global_Options.Interpolationmodel).toString();
                ImagePlus imp = new ImagePlus("Test Bild " + name, is);
                imp.show();
                return null;
            }
        };
    }

    private void showOrtho() {
        if (this.getGui().slicetree.NumberOfSelectesSeries <= 0) {
            return;
        }
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                Update_control.NewPreView = true;
                ((Adjustment_control)Adjustment_control.this).getGui().jPanel_cube.repaint();
                ((Adjustment_control)Adjustment_control.this).getGui().jPanel_Cor.setImage();
                ((Adjustment_control)Adjustment_control.this).getGui().jPanel_Tra.setImage();
                ((Adjustment_control)Adjustment_control.this).getGui().jPanel_Sag.setImage();
                ((Adjustment_control)Adjustment_control.this).getGui().jPanel_Cor.repaint();
                ((Adjustment_control)Adjustment_control.this).getGui().jPanel_Tra.repaint();
                ((Adjustment_control)Adjustment_control.this).getGui().jPanel_Sag.repaint();
                ((Adjustment_control)Adjustment_control.this).getGui().jPanel_Preview.setImage();
                ((Adjustment_control)Adjustment_control.this).getGui().jPanel_Preview.repaint();
                return null;
            }
        };
    }

    private void showUpdate() {
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                ((Adjustment_control)Adjustment_control.this).getGui().jPanel_Preview.setImage();
                ((Adjustment_control)Adjustment_control.this).getGui().jPanel_Preview.repaint();
                return null;
            }
        };
    }

    private void showCor() {
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                ((Adjustment_control)Adjustment_control.this).getGui().jPanel_Cor.setImage();
                ((Adjustment_control)Adjustment_control.this).getGui().jPanel_Cor.repaint();
                return null;
            }
        };
    }

    private void showSag() {
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                ((Adjustment_control)Adjustment_control.this).getGui().jPanel_Sag.setImage();
                ((Adjustment_control)Adjustment_control.this).getGui().jPanel_Sag.repaint();
                return null;
            }
        };
    }

    private void showTra() {
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                ((Adjustment_control)Adjustment_control.this).getGui().jPanel_Tra.setImage();
                ((Adjustment_control)Adjustment_control.this).getGui().jPanel_Tra.repaint();
                return null;
            }
        };
    }
}

