/*
 * Decompiled with CFR 0.152.
 */
package mrcp.control;

import ij.ImagePlus;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Enumeration;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mrcp.dd.Dicom_Slice;
import mrcp.ddd.Series_Node;
import mrcp.ddd.Slice_Leaf;
import mrcp.graphics.Update_control;
import mrcp.gui.JPanel_Composite;
import mrcp.gui.gui;
import mrcp.tools.Global_Options;
import mrcp.tools.Point2D;
import mrcp.tools.Point3D;
import mrcp.tools.SwingWorker;

public class Composite_control
implements ActionListener,
ChangeListener {
    public gui Document;
    public JPanel_Composite source;
    public float alpha_one = 0.5f;
    public float alpha_two = 0.5f;
    public float Contrast1 = 1.0f;
    public float Bright1 = 0.0f;
    public float Contrast2 = 1.0f;
    public float Bright2 = 0.0f;
    public short[][] pix1;
    public short[][] pix2;
    public Point2D trans = new Point2D(0.0f, 0.0f);
    public Image i1;
    public Image i2;
    public ColorModel cModel1;
    public ColorModel cModel2;
    public ShortProcessor sp;
    public ShortProcessor sp2;
    public boolean newPics = true;
    public float rotation = 0.0f;

    public Composite_control(gui doc) {
        this.Document = doc;
        this.setColorModel();
    }

    public void setColorModel() {
        byte[] aTab = new byte[256];
        byte[] rTab = new byte[256];
        byte[] gTab = new byte[256];
        byte[] bTab = new byte[256];
        int r1 = Global_Options.Channel_one.getRed();
        int g1 = Global_Options.Channel_one.getGreen();
        int b1 = Global_Options.Channel_one.getBlue();
        float[] hsb = Color.RGBtoHSB(r1, g1, b1, null);
        float b = hsb[2];
        float fr1 = (float)r1 / (b * 100.0f) * 100.0f / 256.0f;
        float fg1 = (float)g1 / (b * 100.0f) * 100.0f / 256.0f;
        float fb1 = (float)b1 / (b * 100.0f) * 100.0f / 256.0f;
        byte[] aTab2 = new byte[256];
        byte[] rTab2 = new byte[256];
        byte[] gTab2 = new byte[256];
        byte[] bTab2 = new byte[256];
        int r2 = Global_Options.Channel_two.getRed();
        int g2 = Global_Options.Channel_two.getGreen();
        int b2 = Global_Options.Channel_two.getBlue();
        float[] hsb2 = Color.RGBtoHSB(r2, g2, b2, null);
        b = hsb[2];
        float fr2 = (float)r2 / (b * 100.0f) * 100.0f / 256.0f;
        float fg2 = (float)g2 / (b * 100.0f) * 100.0f / 256.0f;
        float fb2 = (float)b2 / (b * 100.0f) * 100.0f / 256.0f;
        int i = 0;
        while (i < 256) {
            int temp = (int)((float)i * fr1 * this.Contrast1 + this.Bright1);
            rTab[i] = (byte)temp;
            if (temp > 255) {
                rTab[i] = -1;
            }
            temp = (int)((float)i * fg1 * this.Contrast1 + this.Bright1);
            gTab[i] = (byte)temp;
            if (temp > 255) {
                gTab[i] = -1;
            }
            temp = (int)((float)i * fb1 * this.Contrast1 + this.Bright1);
            bTab[i] = (byte)temp;
            if (temp > 255) {
                bTab[i] = -1;
            }
            temp = (int)((float)i * fr2 * this.Contrast2 + this.Bright2);
            rTab2[i] = (byte)temp;
            if (temp > 255) {
                rTab2[i] = -1;
            }
            temp = (int)((float)i * fg2 * this.Contrast2 + this.Bright2);
            gTab2[i] = (byte)temp;
            if (temp > 255) {
                gTab2[i] = -1;
            }
            temp = (int)((float)i * fb2 * this.Contrast2 + this.Bright2);
            bTab2[i] = (byte)temp;
            if (temp > 255) {
                bTab2[i] = -1;
            }
            ++i;
        }
        this.cModel1 = new IndexColorModel(8, 256, rTab, gTab, bTab);
        this.cModel2 = new IndexColorModel(8, 256, rTab2, gTab2, bTab2);
    }

    public Composite_control() {
    }

    public void stateChanged(ChangeEvent ce) {
        JSlider sl = (JSlider)ce.getSource();
        float val = (float)sl.getValue() / 100.0f;
        if (sl.getName().compareTo("Source") == 0) {
            this.alpha_one = val;
            this.Document.Composite.Picture.repaint();
        } else if (sl.getName().compareTo("Dest") == 0) {
            this.alpha_two = val;
            this.Document.Composite.Picture.repaint();
        } else if (sl.getName().compareTo("Bright1") == 0) {
            this.Bright1 = val * 100.0f;
            this.setColorModel();
            this.newPics = false;
            this.setPicture();
            this.Document.Composite.Picture.repaint();
        } else if (sl.getName().compareTo("Bright2") == 0) {
            this.Bright2 = val * 100.0f;
            this.setColorModel();
            this.newPics = false;
            this.setPicture();
            this.Document.Composite.Picture.repaint();
        } else if (sl.getName().compareTo("Contrast2") == 0) {
            this.Contrast2 = val * 5.0f;
            this.setColorModel();
            this.newPics = false;
            this.setPicture();
            this.Document.Composite.Picture.repaint();
        } else {
            this.Contrast1 = val * 5.0f;
            this.setColorModel();
            this.newPics = false;
            this.setPicture();
            this.Document.Composite.Picture.repaint();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if ("Draw".equals(e.getActionCommand())) {
            this.newPics = true;
            this.setColorModel();
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    Composite_control.this.setPicture();
                    Composite_control.this.Document.Composite.Picture.repaint();
                    return null;
                }
            };
        }
        if ("up".equals(e.getActionCommand())) {
            this.trans.translate(0.0f, -1.0f);
            this.Document.Composite.Picture.repaint();
            this.update_SliceTree(0.0f, -1.0f);
        }
        if ("down".equals(e.getActionCommand())) {
            this.trans.translate(0.0f, 1.0f);
            this.Document.Composite.Picture.repaint();
            this.update_SliceTree(0.0f, 1.0f);
        }
        if ("left".equals(e.getActionCommand())) {
            this.trans.translate(-1.0f, 0.0f);
            this.Document.Composite.Picture.repaint();
            this.update_SliceTree(-1.0f, 0.0f);
        }
        if ("rigth".equals(e.getActionCommand())) {
            this.trans.translate(1.0f, 0.0f);
            this.Document.Composite.Picture.repaint();
            this.update_SliceTree(1.0f, 0.0f);
        }
        if ("rotl".equals(e.getActionCommand())) {
            this.rotation = (float)((double)this.rotation + -0.02454369260617026);
            this.Document.Composite.Picture.repaint();
        }
        if ("rotr".equals(e.getActionCommand())) {
            this.rotation = (float)((double)this.rotation + 0.02454369260617026);
            this.Document.Composite.Picture.repaint();
        }
        if ("slr".equals(e.getActionCommand())) {
            Update_control.increment();
            this.setPicture2();
            this.Document.Composite.Picture.repaint();
        }
        if ("sll".equals(e.getActionCommand())) {
            Update_control.decrement();
            this.setPicture2();
            this.Document.Composite.Picture.repaint();
        }
    }

    public void setPicture() {
        if (this.newPics) {
            JProgressBar bar = this.Document.Composite.jProgressBar1;
            bar.setMinimum(0);
            bar.setMaximum(Update_control.Rows * Update_control.CubeArray.size());
            int[] ser1 = this.Document.Composite.jList1.getSelectedIndices();
            int[] ser2 = this.Document.Composite.jList_ser2.getSelectedIndices();
            if (ser1.length <= 0 || ser2.length <= 0) {
                return;
            }
            this.Document.slicetree.setSelectedSeries(ser1);
            Point3D RowVector = Update_control.RowVec;
            Point3D ColVector = Update_control.ColVec;
            Point3D SliceVector = Update_control.SliceVec;
            float RowSpacing = Update_control.width / (float)Update_control.Cols;
            float ColSpacing = Update_control.heigth / (float)Update_control.Rows;
            int old = Update_control.currentSlice;
            Update_control.currentSlice = 0;
            Point3D Origin = Update_control.getOrigin();
            Update_control.currentSlice = old;
            if (Origin == null) {
                return;
            }
            this.pix1 = this.Document.slicetree.getSlices_2(Origin, RowVector, ColVector, SliceVector, RowSpacing, ColSpacing, Update_control.depth, Update_control.Rows, Update_control.Cols, bar, Update_control.CubeArray.size(), Update_control.slicedist);
            this.Document.slicetree.setSelectedSeries(ser2);
            old = Update_control.currentSlice;
            Update_control.currentSlice = 0;
            Origin = Update_control.getOrigin();
            Update_control.currentSlice = old;
            if (Origin == null) {
                return;
            }
            this.pix2 = this.Document.slicetree.getSlices_2(Origin, RowVector, ColVector, SliceVector, RowSpacing, ColSpacing, Update_control.depth, Update_control.Rows, Update_control.Cols, bar, Update_control.CubeArray.size(), Update_control.slicedist);
            this.newPics = false;
        }
        this.sp2 = new ShortProcessor(Update_control.Cols, Update_control.Rows, this.pix2[Update_control.currentSlice], this.cModel2, false);
        this.sp = new ShortProcessor(Update_control.Cols, Update_control.Rows, this.pix1[Update_control.currentSlice], this.cModel1, false);
        if (this.newPics) {
            ImagePlus imp = new ImagePlus("", (ImageProcessor)this.sp);
            this.autoAdjust(imp, (ImageProcessor)this.sp);
            ImagePlus imp2 = new ImagePlus("", (ImageProcessor)this.sp2);
            this.autoAdjust(imp2, (ImageProcessor)this.sp2);
        }
        this.i1 = this.sp.createImage();
        this.i2 = this.sp2.createImage();
    }

    public void autoAdjust(ImagePlus imp, ImageProcessor ip) {
        ImageStatistics stats = imp.getStatistics();
        int[] histogram = stats.histogram;
        int threshold = stats.pixelCount / 5000;
        int i = -1;
        boolean found = false;
        do {
            boolean bl = found = histogram[++i] > threshold;
        } while (!found && i < 255);
        int hmin = i;
        i = 256;
        do {
            boolean bl = found = histogram[--i] > threshold;
        } while (!found && i > 0);
        int hmax = i;
        if (hmax > hmin) {
            imp.killRoi();
            double min = stats.histMin + (double)hmin * stats.binSize;
            double max = stats.histMin + (double)hmax * stats.binSize;
            ip.setMinAndMax(min, max);
        }
    }

    public void setPicture2() {
        if (this.pix1 == null || this.pix2 == null) {
            return;
        }
        this.sp2 = new ShortProcessor(Update_control.Cols, Update_control.Rows, this.pix2[Update_control.currentSlice], this.cModel2, false);
        this.sp = new ShortProcessor(Update_control.Cols, Update_control.Rows, this.pix1[Update_control.currentSlice], this.cModel1, false);
        ImagePlus imp = new ImagePlus("", (ImageProcessor)this.sp);
        this.autoAdjust(imp, (ImageProcessor)this.sp);
        ImagePlus imp2 = new ImagePlus("", (ImageProcessor)this.sp2);
        this.autoAdjust(imp2, (ImageProcessor)this.sp2);
        this.i1 = this.sp.createImage();
        this.i2 = this.sp2.createImage();
    }

    public void update_SliceTree(float x, float y) {
        int[] ser = this.Document.Composite.jList_ser2.getSelectedIndices();
        int i = 0;
        while (i < ser.length) {
            DefaultMutableTreeNode Serie = (DefaultMutableTreeNode)this.Document.slicetree.root.getChildAt(ser[i]);
            DefaultMutableTreeNode FirstChild = (DefaultMutableTreeNode)Serie.getFirstChild();
            Slice_Leaf leaf = (Slice_Leaf)FirstChild.getUserObject();
            Dicom_Slice FirstSlice = leaf.cube.ds;
            Series_Node sn = (Series_Node)Serie.getUserObject();
            Enumeration<TreeNode> leafs = Serie.children();
            while (leafs.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)leafs.nextElement();
                Slice_Leaf sl = (Slice_Leaf)child.getUserObject();
                float wid = this.Document.Composite.Picture.wid;
                float factor = wid / Update_control.width;
                Point3D trans1 = Update_control.RowVec.Sk_Mult(factor * x);
                Point3D trans2 = Update_control.ColVec.Sk_Mult(factor * y);
                sl.cube.translate(trans1.getX(), trans1.getY(), trans1.getZ());
                sl.cube.translate(trans2.getX(), trans2.getY(), trans2.getZ());
                sl.cube.ds.setValues();
            }
            ++i;
        }
        this.Document.slicetree.resetBB();
        this.Document.slicetree.update();
    }
}

