/*
 * Decompiled with CFR 0.152.
 */
package mrcp.control;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Enumeration;
import javax.swing.JSlider;
import javax.swing.ProgressMonitor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mrcp.dd.Dicom_Slice;
import mrcp.ddd.Series_Node;
import mrcp.ddd.Slice_Leaf;
import mrcp.ddd.Slice_Tree;
import mrcp.graphics.Bounding_Cube;
import mrcp.graphics.Slice_Cube;
import mrcp.graphics.Update_control;
import mrcp.gui.JPanel_Source;
import mrcp.gui.gui;
import mrcp.tools.Global_Options;
import mrcp.tools.MathTools;
import mrcp.tools.Point3D;
import mrcp.tools.SwingWorker;
import rad.dicom.dcm.DcmDataObject;

public class Source_control
implements TreeSelectionListener,
ActionListener,
ChangeListener,
MouseMotionListener,
MouseListener {
    gui Document;
    JPanel_Source gui;
    boolean BoundingBox = false;
    boolean IntersectionBox = false;
    byte Projection_Type = 0;
    float Zoom = 0.5f;
    public boolean redraw = true;
    private final byte unknown = 0;
    private final byte Tra = 1;
    private final byte Tra_Cor = (byte)2;
    private final byte Tra_Sag = (byte)3;
    private final byte Sag = (byte)4;
    private final byte Sag_Tra = (byte)5;
    private final byte Sag_Cor = (byte)6;
    private final byte Cor = (byte)7;
    private final byte Cor_Tra = (byte)8;
    private final byte Cor_Sag = (byte)9;
    private final int bigger = 2;
    private final int smaller = 1;
    private final int equal = 0;
    private final int NewSerie = -1;
    int transX;
    int transY = 0;
    int oldx = 0;
    int oldy = 0;
    private final String separator = System.getProperty("file.separator");
    static String SelectedSeries = "";

    public Source_control(gui Document2, JPanel_Source gui2) {
        this.Document = Document2;
        this.gui = gui2;
    }

    public gui getDocument() {
        return this.Document;
    }

    public JPanel_Source getGui() {
        return this.gui;
    }

    public void actionPerformed(ActionEvent e) {
        Graphics g;
        if ("Add Files".equals(e.getActionCommand())) {
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    Source_control.this.readSlices();
                    return null;
                }
            };
        }
        if ("Delete File".equals(e.getActionCommand())) {
            DefaultMutableTreeNode currentNode;
            MutableTreeNode parent;
            TreePath[] paths = this.getGui().tree.getSelectionPaths();
            if (paths == null) {
                return;
            }
            Slice_Tree tree = this.getGui().tree;
            DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
            TreePath currentSelection = paths[0];
            if (currentSelection != null && (parent = (MutableTreeNode)(currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent()).getParent()) != null) {
                try {
                    model.removeNodeFromParent(currentNode);
                }
                catch (Exception trex) {
                    // empty catch block
                }
            }
            this.getGui().tree.resetBB();
            this.getGui().tree.update();
            this.getGui().g.Composite.setSeriesStrings();
            Point3D p1 = new Point3D(this.getGui().tree.MinX, this.getGui().tree.MinY, this.getGui().tree.MinZ);
            Point3D p2 = new Point3D(this.getGui().tree.MaxX, this.getGui().tree.MinY, this.getGui().tree.MinZ);
            Point3D p3 = new Point3D(this.getGui().tree.MinX, this.getGui().tree.MaxY, this.getGui().tree.MinZ);
            Point3D p4 = new Point3D(this.getGui().tree.MaxX, this.getGui().tree.MaxY, this.getGui().tree.MinZ);
            Point3D p5 = new Point3D(this.getGui().tree.MinX, this.getGui().tree.MinY, this.getGui().tree.MaxZ);
            Point3D p6 = new Point3D(this.getGui().tree.MaxX, this.getGui().tree.MinY, this.getGui().tree.MaxZ);
            Point3D p7 = new Point3D(this.getGui().tree.MinX, this.getGui().tree.MaxY, this.getGui().tree.MaxZ);
            Point3D p8 = new Point3D(this.getGui().tree.MaxX, this.getGui().tree.MaxY, this.getGui().tree.MaxZ);
            Update_control.BB = new Bounding_Cube(p1, p2, p3, p4, p5, p6, p7, p8, Global_Options.BP);
            p1 = new Point3D(this.getGui().tree.MinX2, this.getGui().tree.MinY2, this.getGui().tree.MinZ2);
            p2 = new Point3D(this.getGui().tree.MaxX2, this.getGui().tree.MinY2, this.getGui().tree.MinZ2);
            p3 = new Point3D(this.getGui().tree.MinX2, this.getGui().tree.MaxY2, this.getGui().tree.MinZ2);
            p4 = new Point3D(this.getGui().tree.MaxX2, this.getGui().tree.MaxY2, this.getGui().tree.MinZ2);
            p5 = new Point3D(this.getGui().tree.MinX2, this.getGui().tree.MinY2, this.getGui().tree.MaxZ2);
            p6 = new Point3D(this.getGui().tree.MaxX2, this.getGui().tree.MinY2, this.getGui().tree.MaxZ2);
            p7 = new Point3D(this.getGui().tree.MinX2, this.getGui().tree.MaxY2, this.getGui().tree.MaxZ2);
            p8 = new Point3D(this.getGui().tree.MaxX2, this.getGui().tree.MaxY2, this.getGui().tree.MaxZ2);
            Update_control.IB = new Bounding_Cube(p1, p2, p3, p4, p5, p6, p7, p8, Global_Options.BP);
            return;
        }
        if ("Clear".equals(e.getActionCommand())) {
            this.getGui().tree.clearSelection2();
            this.getGui().jPanelDicomCube.repaint();
        }
        if ("SelectAll".equals(e.getActionCommand())) {
            DefaultTreeModel model = (DefaultTreeModel)this.getGui().tree.getModel();
            DefaultMutableTreeNode top = (DefaultMutableTreeNode)model.getRoot();
            this.getGui().tree.addSelectionInterval(0, 0);
            this.valueChanged(null);
        }
        if ("Borders".equals(e.getActionCommand())) {
            this.calcBorders();
        }
        if ("P_3D".equals(e.getActionCommand())) {
            this.Projection_Type = 0;
            this.getGui().jButton_P_Cor.setSelected(false);
            this.getGui().jButton_P_Tra.setSelected(false);
            this.getGui().jButton_P_Sag.setSelected(false);
            this.redraw = true;
            this.getGui().jPanelDicomCube.update = true;
            this.getGui().jPanelDicomCube.repaint();
        }
        if ("BB".equals(e.getActionCommand())) {
            g = this.getGui().jPanelDicomCube.getGraphics();
            this.BoundingBox = !this.BoundingBox;
            this.getGui().jPanelDicomCube.update = true;
            this.getGui().jPanelDicomCube.repaint();
        }
        if ("Eval".equals(e.getActionCommand())) {
            this.getGui().tree.setSelectedSeries();
            GenericDialog gd = new GenericDialog("Schicht Parameter", (Frame)IJ.getInstance());
            gd.setBackground(Color.lightGray);
            String[] Ansichten = new String[]{"Special", "Transversal", "Coronar", "Sagittal"};
            gd.addChoice("Orientierung", Ansichten, "Special");
            gd.addNumericField("Ankerpunkt X-Koord", (double)Update_control.Origin_x, 2);
            gd.addNumericField("Ankerpunkt Y-Koord", (double)Update_control.Origin_y, 2);
            gd.addNumericField("Ankerpunkt Z-Koord", (double)Update_control.Origin_z, 2);
            gd.addNumericField("Zeilen Vektor X-Coord", (double)Update_control.Row_x, 2);
            gd.addNumericField("Zeilen Vektor Y-Coord", (double)Update_control.Row_y, 2);
            gd.addNumericField("Zeilen Vektor Z-Coord", (double)Update_control.Row_z, 2);
            gd.addNumericField("Spalten Vektor X-Koord", (double)Update_control.Col_x, 2);
            gd.addNumericField("Spalten Vektor Y-Koord", (double)Update_control.Col_y, 2);
            gd.addNumericField("Spalten Vektor Z-Koord", (double)Update_control.Col_z, 2);
            gd.addNumericField("Reihenaufl\u00f6sung", (double)Update_control.RowSpacing, 2);
            gd.addNumericField("Spaltenaufl\u00f6sung", (double)Update_control.ColSpacing, 2);
            gd.addNumericField("Schichtdicke", (double)Update_control.SliceThickness, 2);
            gd.addNumericField("Anzahl der Reihen", (double)Update_control.Rows, 0);
            gd.addNumericField("Anzahl der Spalten", (double)Update_control.Cols, 0);
            gd.addNumericField("Anzahl der Schichten", (double)Update_control.numslices, 0);
            gd.addNumericField("Schichtabstand", (double)Update_control.slicedist, 2);
            this.getDocument().slicetree.setSelectedSeries();
            int q = 0;
            while (q < this.getDocument().slicetree.NumberOfSelectesSeries) {
                SelectedSeries = SelectedSeries + this.getDocument().slicetree.SelectedSlices[q] + ",";
                ++q;
            }
            SelectedSeries = SelectedSeries.substring(0, SelectedSeries.length() - 1);
            gd.addStringField("Selektierte Serien", SelectedSeries);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            Update_control.Origin_x = (float)gd.getNextNumber();
            Update_control.Origin_y = (float)gd.getNextNumber();
            Update_control.Origin_z = (float)gd.getNextNumber();
            final Point3D Origin = new Point3D(Update_control.Origin_x, Update_control.Origin_y, Update_control.Origin_z);
            Update_control.Row_x = (float)gd.getNextNumber();
            Update_control.Row_y = (float)gd.getNextNumber();
            Update_control.Row_z = (float)gd.getNextNumber();
            final Point3D RowVector = new Point3D(Update_control.Row_x, Update_control.Row_y, Update_control.Row_z);
            Update_control.Col_x = (float)gd.getNextNumber();
            Update_control.Col_y = (float)gd.getNextNumber();
            Update_control.Col_z = (float)gd.getNextNumber();
            final Point3D ColVector = new Point3D(Update_control.Col_x, Update_control.Col_y, Update_control.Col_z);
            final Point3D SliceVector = RowVector.VC_Mult(ColVector);
            Update_control.RowSpacing = (float)gd.getNextNumber();
            Update_control.ColSpacing = (float)gd.getNextNumber();
            Update_control.SliceThickness = (float)gd.getNextNumber();
            Update_control.Rows = (int)gd.getNextNumber();
            Update_control.Cols = (int)gd.getNextNumber();
            Update_control.numslices = (int)gd.getNextNumber();
            Update_control.slicedist = (float)gd.getNextNumber();
            this.getDocument().slicetree.update();
            final Slice_Tree tree = this.getDocument().slicetree;
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    ProgressMonitor mon = new ProgressMonitor((Component)IJ.getInstance(), "Berechne Schicht(en)", "", 0, Update_control.Rows * Update_control.numslices);
                    short[][] Pixels = tree.getSlices(Origin, RowVector, ColVector, SliceVector, Update_control.RowSpacing, Update_control.ColSpacing, Update_control.SliceThickness, Update_control.Rows, Update_control.Cols, mon, Update_control.numslices, Update_control.slicedist);
                    byte[] cTab = new byte[256];
                    int i = 0;
                    while (i < 256) {
                        cTab[i] = (byte)i;
                        ++i;
                    }
                    IndexColorModel cModel = new IndexColorModel(8, 256, cTab, cTab, cTab);
                    ImageStack is = new ImageStack(Update_control.Cols, Update_control.Rows);
                    int i2 = 0;
                    while (i2 < Update_control.numslices) {
                        ShortProcessor proc = new ShortProcessor(Update_control.Cols, Update_control.Rows, Pixels[i2], (ColorModel)cModel, false);
                        is.addSlice("test" + new Integer(i2).toString(), (ImageProcessor)proc);
                        ++i2;
                    }
                    String name = "Interpol : ";
                    name = name + new Integer(Global_Options.Interpolationmodel).toString();
                    ImagePlus imp = new ImagePlus("Test Bild " + name, is);
                    imp.show();
                    return null;
                }
            };
        }
        if ("P_Cor".equals(e.getActionCommand())) {
            this.getGui().jButton_P_3D.setSelected(false);
            this.getGui().jButton_P_Tra.setSelected(false);
            this.getGui().jButton_P_Sag.setSelected(false);
            this.Projection_Type = (byte)3;
            this.getGui().jPanelDicomCube.update = true;
            this.getGui().jPanelDicomCube.repaint();
        }
        if ("P_Tra".equals(e.getActionCommand())) {
            this.getGui().jButton_P_3D.setSelected(false);
            this.getGui().jButton_P_Cor.setSelected(false);
            this.getGui().jButton_P_Sag.setSelected(false);
            this.Projection_Type = 1;
            this.getGui().jPanelDicomCube.update = true;
            this.getGui().jPanelDicomCube.repaint();
        }
        if ("P_Sag".equals(e.getActionCommand())) {
            this.Projection_Type = (byte)2;
            this.getGui().jButton_P_3D.setSelected(false);
            this.getGui().jButton_P_Tra.setSelected(false);
            this.getGui().jButton_P_Cor.setSelected(false);
            this.getGui().jPanelDicomCube.update = true;
            this.getGui().jPanelDicomCube.repaint();
        }
        if ("IB".equals(e.getActionCommand())) {
            g = this.getGui().jPanelDicomCube.getGraphics();
            this.IntersectionBox = !this.IntersectionBox;
            this.getGui().tree.resetBB();
            this.getGui().tree.update();
            this.getGui().jPanelDicomCube.update = true;
            this.getGui().jPanelDicomCube.repaint();
        }
        if ("Calc".equals(e.getActionCommand())) {
            this.getDocument().slicetree.update();
        }
    }

    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        boolean isadj = source.getValueIsAdjusting();
        int t = source.getModel().getValue();
        this.Zoom = (float)source.getValue() * 0.04f;
        this.getGui().jPanelDicomCube.update = true;
        this.redraw = false;
        this.getGui().jPanelDicomCube.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        if (this.Projection_Type == 1) {
            Graphics g = this.getGui().jPanelDicomCube.getGraphics();
            int h = this.getGui().jPanelDicomCube.getHeight();
            int w = this.getGui().jPanelDicomCube.getWidth();
            g.clearRect(2, 2, 100, 10);
            g.drawString("X : " + Integer.toString(MathTools.round((float)(e.getX() - this.transX - 200) / this.Zoom)), 2, 12);
            g.drawString("Y : " + Integer.toString(MathTools.round((float)(e.getY() - this.transY - 200) / this.Zoom)), 52, 12);
        } else if (this.Projection_Type == 2) {
            Graphics g = this.getGui().jPanelDicomCube.getGraphics();
            int h = this.getGui().jPanelDicomCube.getHeight();
            int w = this.getGui().jPanelDicomCube.getWidth();
            g.clearRect(2, 2, 100, 10);
            g.drawString("Z : " + Integer.toString(MathTools.round((float)(e.getX() - this.transX - 200) / this.Zoom)), 2, 12);
            g.drawString("Y : " + Integer.toString(MathTools.round((float)(e.getY() - this.transY - 200) / this.Zoom)), 52, 12);
        } else if (this.Projection_Type == 3) {
            Graphics g = this.getGui().jPanelDicomCube.getGraphics();
            int h = this.getGui().jPanelDicomCube.getHeight();
            int w = this.getGui().jPanelDicomCube.getWidth();
            g.clearRect(2, 2, 100, 10);
            g.drawString("X : " + Integer.toString(MathTools.round((float)(e.getX() - this.transX - 200) / this.Zoom)), 2, 12);
            g.drawString("Z : " + Integer.toString(MathTools.round((float)(e.getY() - this.transY - 200) / this.Zoom)), 52, 12);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.oldx = e.getX();
        this.oldy = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
        this.redraw = true;
        this.getGui().jPanelDicomCube.update = true;
        this.getGui().jPanelDicomCube.repaint();
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void valueChanged(TreeSelectionEvent e) {
        String classname = "";
        Object nodeinfo = null;
        DefaultMutableTreeNode node = null;
        this.getDocument().slicetree.setSelectedSeries();
        this.getGui().htmlPane.setText("");
        TreePath[] paths = this.getGui().tree.getSelectionPaths();
        if (paths == null) {
            Graphics2D g = (Graphics2D)this.getGui().jPanelDicomCube.getGraphics();
            this.showDicomSlices(g);
            return;
        }
        int i = 0;
        while (i < paths.length) {
            try {
                node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                nodeinfo = node.getUserObject();
                classname = nodeinfo.getClass().getName();
            }
            catch (Exception ed) {
                // empty catch block
            }
            if (classname.compareTo("java.lang.String") == 0) {
                int childs = node.getChildCount();
                int chl = 0;
                while (chl < childs) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(chl);
                    this.showSerie_Info(child);
                    ++chl;
                }
            } else if (classname.indexOf("Series_Node") > 0) {
                this.showSerie_Info(node);
            } else {
                Slice_Leaf sl = (Slice_Leaf)nodeinfo;
                this.showLeaf_Info(sl);
            }
            ++i;
        }
        this.getGui().jPanelDicomCube.update = true;
        this.getGui().jPanelDicomCube.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.transX += -this.oldx + e.getX();
        this.transY += -this.oldy + e.getY();
        this.redraw = false;
        this.oldx = e.getX();
        this.oldy = e.getY();
        this.getGui().jPanelDicomCube.update = true;
        this.getGui().jPanelDicomCube.repaint();
    }

    public void showDicomSlices(Graphics2D g) {
        String temp;
        TreePath[] paths = this.getGui().tree.getSelectionPaths();
        Dimension dim = this.getGui().jPanelDicomCube.getSize();
        int h = dim.height;
        int w = dim.width;
        DefaultTreeModel model = (DefaultTreeModel)this.getGui().tree.getModel();
        DefaultMutableTreeNode top = (DefaultMutableTreeNode)model.getRoot();
        if (paths == null || paths.length == 0 || top.getChildCount() == 0) {
            g.setBackground(Color.darkGray);
            return;
        }
        g.setColor(Color.black);
        g.drawRect(1, 1, w - 3, h - 3);
        g.translate(this.transX, this.transY);
        int i = 0;
        while (i < paths.length) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
            Object nodeinfo = node.getUserObject();
            String classname = nodeinfo.getClass().getName();
            if (classname.compareTo("java.lang.String") == 0 && this.redraw) {
                int childs = node.getChildCount();
                int chl = 0;
                while (chl < childs) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(chl);
                    this.showSerie(child, g);
                    ++chl;
                }
            } else if (classname.indexOf("Series_Node") > 0 && this.redraw) {
                this.showSerie(node, g);
            } else if (this.redraw) {
                Slice_Leaf sl = (Slice_Leaf)nodeinfo;
                this.showLeaf(sl, g);
            }
            ++i;
        }
        if (this.BoundingBox || !this.redraw) {
            Update_control.BB.setColor(Global_Options.BoundingColor);
            Update_control.BB.setProjection(this.Projection_Type);
            Update_control.BB.drawCube(g, 200.0f, 200.0f, this.Zoom);
            if (this.redraw) {
                temp = this.getGui().htmlPane.getText();
                int end = temp.indexOf("Bounding");
                if (end > 0) {
                    temp = temp.substring(0, end);
                    this.getGui().htmlPane.setText(temp);
                }
                this.getGui().htmlPane.append("\nBounding Box Koordinaten \n");
                this.getGui().htmlPane.append(Update_control.BB.Coord_to_String());
            }
        }
        if (this.IntersectionBox) {
            Update_control.IB.setColor(Global_Options.IntersectionColor);
            Update_control.IB.setProjection(this.Projection_Type);
            Update_control.IB.drawCube(g, 200.0f, 200.0f, this.Zoom);
            temp = this.getGui().htmlPane.getText();
            int end = temp.indexOf("Intersection");
            if (end > 0) {
                temp = temp.substring(0, end);
                this.getGui().htmlPane.setText(temp);
            }
            this.getGui().htmlPane.append("\nIntersection Box Koordinaten \n");
            this.getGui().htmlPane.append(Update_control.IB.Coord_to_String());
        }
    }

    private void calcBorders() {
        TreePath[] select = new TreePath[]{null, null, null, null, null, null};
        float MinTrans = Float.POSITIVE_INFINITY;
        float MaxTrans = Float.NEGATIVE_INFINITY;
        float MinSag = Float.POSITIVE_INFINITY;
        float MaxSag = Float.NEGATIVE_INFINITY;
        float MinCor = Float.POSITIVE_INFINITY;
        float MaxCor = Float.NEGATIVE_INFINITY;
        Slice_Tree tree = this.getGui().tree;
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        DefaultMutableTreeNode top = (DefaultMutableTreeNode)model.getRoot();
        Enumeration<TreeNode> leafs = top.depthFirstEnumeration();
        while (leafs.hasMoreElements()) {
            DefaultMutableTreeNode leaf = (DefaultMutableTreeNode)leafs.nextElement();
            if (!leaf.isLeaf()) continue;
            try {
                Slice_Leaf Sleaf = (Slice_Leaf)leaf.getUserObject();
                Slice_Cube tmp = Sleaf.cube;
                TreePath path = new TreePath(leaf.getPath());
                if (tmp.View == 1 || tmp.View == 3 || tmp.View == 2) {
                    if (tmp.getMid().getZ() < MinTrans) {
                        MinTrans = tmp.getMid().getZ();
                        select[0] = path;
                    }
                    if (tmp.getMid().getZ() > MaxTrans) {
                        MaxTrans = tmp.getMid().getZ();
                        select[1] = path;
                    }
                }
                if (tmp.View == 4 || tmp.View == 6 || tmp.View == 5) {
                    if (tmp.getMid().getX() < MinSag) {
                        MinSag = tmp.getMid().getX();
                        select[2] = path;
                    }
                    if (tmp.getMid().getX() > MaxSag) {
                        MaxSag = tmp.getMid().getX();
                        select[3] = path;
                    }
                }
                if (tmp.View != 7 && tmp.View != 8 && tmp.View != 9) continue;
                if (tmp.getMid().getY() < MinCor) {
                    MinCor = tmp.getMid().getY();
                    select[4] = path;
                }
                if (!(tmp.getMid().getY() > MaxCor)) continue;
                MaxCor = tmp.getMid().getY();
                select[5] = path;
            }
            catch (Exception excep) {
                IJ.write((String)excep.getMessage());
            }
        }
        this.getGui().tree.clearSelection();
        this.getGui().tree.addSelectionPaths(select);
        this.getGui().tree.repaint();
    }

    public void showLeaf_Info(Slice_Leaf sl) {
        String name = sl.cube.ds.Filename;
        int ind = name.lastIndexOf(this.separator);
        name = name.substring(ind);
        this.getGui().htmlPane.append("\n..." + name);
        this.getGui().htmlPane.append("\n" + sl.cube.Angle + " " + sl.cube.View_to_String());
        this.getGui().htmlPane.append(sl.cube.Dimension);
        this.getGui().htmlPane.append(sl.cube.Coord_to_String());
    }

    public void showSerie_Info(DefaultMutableTreeNode node) {
        int childs = node.getChildCount();
        Series_Node Snode = (Series_Node)node.getUserObject();
        String dist = Float.toString(Snode.Slice_Distant);
        this.getGui().htmlPane.append("\nSchichtabstand : " + dist + " mm");
        int chl = 0;
        while (chl < childs) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(chl);
            Slice_Leaf sl = (Slice_Leaf)child.getUserObject();
            this.showLeaf_Info(sl);
            ++chl;
        }
    }

    public void showLeaf(Slice_Leaf sl, Graphics2D g) {
        sl.cube.setProjection(this.Projection_Type);
        sl.cube.drawCube(g, 200.0f, 200.0f, this.Zoom);
        if (sl.cube.ds.isTransversal()) {
            sl.cube.setColor(Global_Options.TransversalColor);
        }
        if (sl.cube.ds.isCoronar()) {
            sl.cube.setColor(Global_Options.CoronarColor);
        }
        if (sl.cube.ds.isSagittal()) {
            sl.cube.setColor(Global_Options.SagittalColor);
        }
    }

    public void showSerie(DefaultMutableTreeNode node, Graphics2D g) {
        int childs = node.getChildCount();
        int chl = 0;
        while (chl < childs) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(chl);
            Slice_Leaf sl = (Slice_Leaf)child.getUserObject();
            this.showLeaf(sl, g);
            ++chl;
        }
    }

    public void readSlices() {
        String path = System.getProperty("user.dir");
        path = path + System.getProperty("file.separator");
        path = path + "th_io_properties.txt";
        ImagePlus imp = (ImagePlus)IJ.runPlugIn((String)"DICOM_import", (String)("\t-p" + path));
        int number = imp.getStack().getSize();
        DcmDataObject[] ddol = (DcmDataObject[])imp.getProperty("1.2.3.4711.5.2");
        if (ddol == null) {
            IJ.write((String)"Keine Props");
            return;
        }
        Slice_Tree tree = this.getGui().tree;
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        DefaultMutableTreeNode top = (DefaultMutableTreeNode)model.getRoot();
        int numberofSer = model.getChildCount(model.getRoot());
        int sl = 0;
        while (sl < number) {
            imp.setSlice(sl + 1);
            FileInfo info = imp.getFileInfo();
            int indexExt = info.fileName.lastIndexOf(".");
            String Extension = "";
            if (indexExt >= 0) {
                Extension = info.fileName.substring(indexExt);
            }
            String Filename = info.directory + System.getProperty("file.separator");
            Filename = number > 1 ? Filename + imp.getStack().getSliceLabel(sl + 1) + Extension : Filename + info.fileName;
            DcmDataObject ddo = ddol[sl];
            Slice_Leaf leaf = new Slice_Leaf(ddo, Filename);
            leaf.cube.ds.Pixel = (short[])imp.getProcessor().getPixelsCopy();
            boolean done = false;
            Enumeration<TreeNode> series = top.children();
            while (series.hasMoreElements()) {
                DefaultMutableTreeNode serie = (DefaultMutableTreeNode)series.nextElement();
                DefaultMutableTreeNode firstimage = (DefaultMutableTreeNode)serie.getFirstChild();
                Slice_Leaf firstSlice = (Slice_Leaf)firstimage.getUserObject();
                int comp = firstSlice.compare(leaf);
                if (comp == 0) {
                    done = true;
                }
                if (comp != 0 && comp != -1) {
                    int Images = serie.getChildCount();
                    int x = 0;
                    while (x < Images) {
                        DefaultMutableTreeNode Image2 = (DefaultMutableTreeNode)serie.getChildAt(x);
                        Slice_Leaf templeaf = (Slice_Leaf)Image2.getUserObject();
                        if (templeaf.compare(leaf) == 1) {
                            model.insertNodeInto(new DefaultMutableTreeNode(leaf), serie, x);
                            done = true;
                            series = DefaultMutableTreeNode.EMPTY_ENUMERATION;
                            break;
                        }
                        ++x;
                    }
                    if (!done) {
                        model.insertNodeInto(new DefaultMutableTreeNode(leaf), serie, Images);
                        done = true;
                        series = DefaultMutableTreeNode.EMPTY_ENUMERATION;
                    }
                }
                int z = 12;
            }
            if (!done) {
                Series_Node snode = new Series_Node();
                String temp = leaf.cube.ds.BodyPart;
                String temp2 = leaf.cube.ds.SeriesDescription;
                if (temp.compareTo("<null>") == 0) {
                    temp = "unknown Body Part ";
                }
                temp = temp + temp2;
                snode.setName(temp);
                DefaultMutableTreeNode newSerie = new DefaultMutableTreeNode(snode);
                newSerie.add(new DefaultMutableTreeNode(leaf));
                model.insertNodeInto(newSerie, top, top.getChildCount());
            }
            ++sl;
        }
        Enumeration<TreeNode> series = top.children();
        while (series.hasMoreElements()) {
            DefaultMutableTreeNode serie = (DefaultMutableTreeNode)series.nextElement();
            DefaultMutableTreeNode firstimage = (DefaultMutableTreeNode)serie.getFirstChild();
            Slice_Leaf firstSlice = (Slice_Leaf)firstimage.getUserObject();
            Dicom_Slice ds1 = firstSlice.cube.ds;
            Series_Node node = (Series_Node)serie.getUserObject();
            if (serie.getChildCount() > 1) {
                float dist;
                DefaultMutableTreeNode secondimage = (DefaultMutableTreeNode)serie.getChildAt(1);
                Slice_Leaf secondSlice = (Slice_Leaf)secondimage.getUserObject();
                Dicom_Slice ds2 = secondSlice.cube.ds;
                node.Slice_Distant = dist = ds1.ImagePosition.VC_Min(ds2.ImagePosition).Length() - ds1.SliceThicknes;
                node.Sum = dist + ds1.SliceThicknes;
                continue;
            }
            node.Sum = ds1.SliceThicknes;
        }
        this.getDocument().slicetree.update();
        Point3D p1 = new Point3D(this.getGui().tree.MinX, this.getGui().tree.MinY, this.getGui().tree.MinZ);
        Point3D p2 = new Point3D(this.getGui().tree.MaxX, this.getGui().tree.MinY, this.getGui().tree.MinZ);
        Point3D p3 = new Point3D(this.getGui().tree.MinX, this.getGui().tree.MaxY, this.getGui().tree.MinZ);
        Point3D p4 = new Point3D(this.getGui().tree.MaxX, this.getGui().tree.MaxY, this.getGui().tree.MinZ);
        Point3D p5 = new Point3D(this.getGui().tree.MinX, this.getGui().tree.MinY, this.getGui().tree.MaxZ);
        Point3D p6 = new Point3D(this.getGui().tree.MaxX, this.getGui().tree.MinY, this.getGui().tree.MaxZ);
        Point3D p7 = new Point3D(this.getGui().tree.MinX, this.getGui().tree.MaxY, this.getGui().tree.MaxZ);
        Point3D p8 = new Point3D(this.getGui().tree.MaxX, this.getGui().tree.MaxY, this.getGui().tree.MaxZ);
        Update_control.BB = new Bounding_Cube(p1, p2, p3, p4, p5, p6, p7, p8, Global_Options.BP);
        p1 = new Point3D(this.getGui().tree.MinX2, this.getGui().tree.MinY2, this.getGui().tree.MinZ2);
        p2 = new Point3D(this.getGui().tree.MaxX2, this.getGui().tree.MinY2, this.getGui().tree.MinZ2);
        p3 = new Point3D(this.getGui().tree.MinX2, this.getGui().tree.MaxY2, this.getGui().tree.MinZ2);
        p4 = new Point3D(this.getGui().tree.MaxX2, this.getGui().tree.MaxY2, this.getGui().tree.MinZ2);
        p5 = new Point3D(this.getGui().tree.MinX2, this.getGui().tree.MinY2, this.getGui().tree.MaxZ2);
        p6 = new Point3D(this.getGui().tree.MaxX2, this.getGui().tree.MinY2, this.getGui().tree.MaxZ2);
        p7 = new Point3D(this.getGui().tree.MinX2, this.getGui().tree.MaxY2, this.getGui().tree.MaxZ2);
        p8 = new Point3D(this.getGui().tree.MaxX2, this.getGui().tree.MaxY2, this.getGui().tree.MaxZ2);
        Update_control.IB = new Bounding_Cube(p1, p2, p3, p4, p5, p6, p7, p8, Global_Options.BP);
        this.getGui().tree.model.reload();
        this.getGui().jPanelDicomCube.repaint();
        this.getGui().jSplitPane1.repaint();
        this.getGui().g.Composite.setSeriesStrings();
    }
}

