/*
 * Decompiled with CFR 0.152.
 */
package mrcp.dd;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import java.util.Properties;
import mrcp.tools.Global_Options;
import mrcp.tools.MathTools;
import mrcp.tools.Point3D;
import mrcp.tools.Vektor3DPoint;
import rad.dicom.dcm.DcmDataObject;
import rad.dicom.dcm.DcmValue;

public class Dicom_Slice {
    private String separator = System.getProperty("file.separator");
    public String Filename = "";
    public float angle;
    public short[] Pixel = null;
    public int Rows;
    public int Colums;
    public int Row_dec;
    public int Col_dec;
    public int Serie = -1;
    public float PixelSpacingColumn;
    public float PixelSpacingRow;
    public float SliceThicknes;
    public Point3D ImagePosition;
    public Point3D ImagePosition2;
    public Point3D RowVector;
    public Point3D ColVector;
    public Point3D SliceVector;
    public Point3D FirstPixelCorner;
    public Vektor3DPoint Edges;
    public float Voxelvolume;
    public float MinX = Float.POSITIVE_INFINITY;
    public float MaxX = Float.NEGATIVE_INFINITY;
    public float MinZ = Float.POSITIVE_INFINITY;
    public float MaxZ = Float.NEGATIVE_INFINITY;
    public float MinY = Float.POSITIVE_INFINITY;
    public float MaxY = Float.NEGATIVE_INFINITY;
    public boolean valid = true;
    public String PatientPosition;
    public String SeriesTime;
    public String Imagenumber;
    public String SeriesDate;
    public String BodyPart;
    public String SeriesDescription;
    public float Width_scale = 0.0f;
    public float Height_scale = 0.0f;
    public float Row_scale = 0.0f;
    public float Col_scale = 0.0f;
    private byte Orientation = 0;
    final byte unknown = 0;
    static final byte Tra = 1;
    private final byte Tra_Cor = (byte)2;
    private final byte Tra_Sag = (byte)3;
    private final byte Sag = (byte)4;
    private final byte Sag_Tra = (byte)5;
    private final byte Sag_Cor = (byte)6;
    private final byte Cor = (byte)7;
    private final byte Cor_Tra = (byte)8;
    private final byte Cor_Sag = (byte)9;

    public void init(DcmDataObject ddo) {
        this.Edges = new Vektor3DPoint();
        DcmValue dv = ddo.getDcmValue(486);
        String[] tmp = DcmValue.str2StringArray((String)dv.toString(false, 0, false, 256, false), (String)"\\");
        this.PixelSpacingColumn = new Float(tmp[1]).floatValue();
        this.PixelSpacingRow = new Float(tmp[0]).floatValue();
        this.SliceThicknes = new Float(ddo.getDcmValue(162).toString(false, 0, false, 256, false)).floatValue();
        dv = ddo.getDcmValue(483);
        this.Colums = DcmValue.bufToUS((byte[])dv.getData(), (int)0);
        dv = ddo.getDcmValue(482);
        this.Rows = DcmValue.bufToUS((byte[])dv.getData(), (int)0);
        this.Row_dec = this.Rows - 1;
        this.Col_dec = this.Colums - 1;
        dv = ddo.getDcmValue(444);
        this.Imagenumber = dv.toString(false, 0, false, 256, false);
        dv = ddo.getDcmValue(455);
        tmp = DcmValue.str2StringArray((String)dv.toString(false, 0, false, 256, false), (String)"\\");
        float[] ImgPos = new float[3];
        int i = 0;
        while (i < 3) {
            ImgPos[i] = new Float(tmp[i]).floatValue();
            ++i;
        }
        this.ImagePosition = new Point3D(ImgPos[0], ImgPos[1], ImgPos[2]);
        dv = ddo.getDcmValue(456);
        tmp = DcmValue.str2StringArray((String)dv.toString(false, 0, false, 256, false), (String)"\\");
        float[] ImgOrient = new float[6];
        int i2 = 0;
        while (i2 < 6) {
            ImgOrient[i2] = new Float(tmp[i2]).floatValue();
            ++i2;
        }
        this.RowVector = new Point3D(ImgOrient[0], ImgOrient[1], ImgOrient[2]);
        this.ColVector = new Point3D(ImgOrient[3], ImgOrient[4], ImgOrient[5]);
        this.SliceVector = this.RowVector.VC_Mult(this.ColVector);
        dv = ddo.getDcmValue(356);
        this.PatientPosition = dv.toString(false, 0, false, 256, false);
        dv = ddo.getDcmValue(9);
        this.SeriesDate = dv.toString(false, 0, false, 256, false);
        dv = ddo.getDcmValue(15);
        this.SeriesTime = dv.toString(false, 0, false, 256, false);
        dv = ddo.getDcmValue(139);
        this.BodyPart = dv.toString(false, 0, false, 256, false);
        dv = ddo.getDcmValue(51);
        this.SeriesDescription = dv != null ? dv.toString(false, 0, false, 256, false) : " ";
        dv = ddo.getDcmValue(442);
        String temp = dv.toString(false, 0, false, 256, false);
        char ch = temp.charAt(0);
        while (Character.getNumericValue(ch) == -1) {
            temp = temp.substring(1);
            ch = temp.charAt(0);
        }
        try {
            this.Serie = new Integer(temp);
        }
        catch (NumberFormatException nfe) {
            IJ.write((String)("Fehler bei Erkennung der Seriennummer ! " + nfe.toString()));
        }
        this.Voxelvolume = this.SliceThicknes * this.getPixelSpacingColumn() * this.getPixelSpacingRow();
        this.Orientation = (double)Math.abs(this.getXRowVector()) == 1.0 && (double)Math.abs(this.getYRowVector()) == 0.0 && (double)Math.abs(this.getZRowVector()) == 0.0 && (double)Math.abs(this.getXColVector()) == 0.0 && (double)Math.abs(this.getYColVector()) == 1.0 ? (byte)1 : ((double)Math.abs(this.getXRowVector()) == 1.0 && (double)Math.abs(this.getYRowVector()) == 0.0 && (double)Math.abs(this.getZRowVector()) == 0.0 && (double)Math.abs(this.getXColVector()) == 0.0 && Math.abs(this.getYColVector()) >= Math.abs(this.getZColVector()) ? (byte)2 : ((double)Math.abs(this.getYRowVector()) == 0.0 && (double)Math.abs(this.getXColVector()) == 0.0 && (double)Math.abs(this.getYColVector()) == 1.0 && (double)Math.abs(this.getZColVector()) == 0.0 && Math.abs(this.getXRowVector()) >= Math.abs(this.getZRowVector()) ? (byte)3 : ((double)Math.abs(this.getXRowVector()) == 1.0 && (double)Math.abs(this.getYRowVector()) == 0.0 && (double)Math.abs(this.getZRowVector()) == 0.0 && (double)Math.abs(this.getXColVector()) == 0.0 && (double)Math.abs(this.getZColVector()) == 1.0 ? (byte)7 : ((double)Math.abs(this.getXRowVector()) == 1.0 && (double)Math.abs(this.getYRowVector()) == 0.0 && (double)Math.abs(this.getZRowVector()) == 0.0 && (double)Math.abs(this.getXColVector()) == 0.0 && Math.abs(this.getYColVector()) < Math.abs(this.getZColVector()) ? (byte)8 : ((double)Math.abs(this.getZRowVector()) == 0.0 && (double)Math.abs(this.getXColVector()) == 0.0 && (double)Math.abs(this.getYColVector()) == 0.0 && (double)Math.abs(this.getZColVector()) == 1.0 && Math.abs(this.getXRowVector()) >= Math.abs(this.getYRowVector()) ? (byte)9 : ((double)Math.abs(this.getXRowVector()) == 0.0 && (double)Math.abs(this.getYRowVector()) == 1.0 && (double)Math.abs(this.getZRowVector()) == 0.0 && (double)Math.abs(this.getXColVector()) == 0.0 && (double)Math.abs(this.getYColVector()) == 0.0 && (double)Math.abs(this.getZColVector()) == 1.0 ? (byte)4 : ((double)Math.abs(this.getXRowVector()) == 0.0 && (double)Math.abs(this.getYRowVector()) == 1.0 && (double)Math.abs(this.getZRowVector()) == 0.0 && (double)Math.abs(this.getYColVector()) == 0.0 && Math.abs(this.getXColVector()) < Math.abs(this.getZColVector()) ? (byte)5 : ((double)Math.abs(this.getZRowVector()) == 0.0 && (double)Math.abs(this.getXColVector()) == 0.0 && (double)Math.abs(this.getYColVector()) == 0.0 && (double)Math.abs(this.getZColVector()) == 1.0 && Math.abs(this.getXRowVector()) < Math.abs(this.getYRowVector()) ? (byte)6 : (byte)0))))))));
        if (this.isTransversal()) {
            if (this.SliceVector.getZ() < 0.0f) {
                this.SliceVector = this.SliceVector.Sk_Mult(-1.0f);
            }
            this.valid = true;
            this.Edges.setPoint(1, this.ImagePosition);
            this.Edges.setPoint(2, this.Edges.getPoint(1).VC_Add(this.RowVector.Sk_Mult((float)this.Colums * this.PixelSpacingColumn)));
            this.Edges.setPoint(3, this.Edges.getPoint(1).VC_Add(this.ColVector.Sk_Mult((float)this.Rows * this.PixelSpacingRow)));
            this.Edges.setPoint(4, this.Edges.getPoint(3).VC_Add(this.RowVector.Sk_Mult((float)this.Colums * this.PixelSpacingColumn)));
            this.Edges.setPoint(5, this.Edges.getPoint(1).VC_Add(this.SliceVector.Sk_Mult(this.SliceThicknes)));
            this.Edges.setPoint(6, this.Edges.getPoint(2).VC_Add(this.SliceVector.Sk_Mult(this.SliceThicknes)));
            this.Edges.setPoint(7, this.Edges.getPoint(3).VC_Add(this.SliceVector.Sk_Mult(this.SliceThicknes)));
            this.Edges.setPoint(8, this.Edges.getPoint(4).VC_Add(this.SliceVector.Sk_Mult(this.SliceThicknes)));
            this.FirstPixelCorner = this.Edges.getPoint(1);
            this.calcMinMax();
            this.Width_scale = (float)this.Col_dec / (this.MaxX - this.MinX);
            this.Height_scale = (float)this.Row_dec / (this.MaxY - this.MinY);
            this.Row_scale = (float)this.Row_dec / ((float)this.Rows * this.PixelSpacingRow);
            this.Col_scale = (float)this.Col_dec / ((float)this.Colums * this.PixelSpacingColumn);
            if (this.isStrictTransversal()) {
                this.angle = 0.0f;
            } else if (this.isTra_Cor()) {
                this.angle = (float)Math.atan(this.SliceVector.getY() / this.SliceVector.getZ()) / 0.01745333f;
            } else if (this.isTra_Sag()) {
                this.angle = (float)Math.atan(this.SliceVector.getX() / this.SliceVector.getZ()) / 0.01745333f;
            }
        } else if (this.isSagittal()) {
            this.valid = true;
            if ((double)this.SliceVector.getX() > 0.0) {
                this.SliceVector = this.SliceVector.Sk_Mult(-1.0f);
            }
            this.Edges.setPoint(6, this.ImagePosition);
            this.Edges.setPoint(5, this.ImagePosition.VC_Add(this.SliceVector.Sk_Mult(this.SliceThicknes)));
            this.Edges.setPoint(7, this.Edges.getPoint(5).VC_Add(this.RowVector.Sk_Mult((float)this.Colums * this.PixelSpacingColumn)));
            this.Edges.setPoint(8, this.Edges.getPoint(6).VC_Add(this.RowVector.Sk_Mult((float)this.Colums * this.PixelSpacingColumn)));
            this.Edges.setPoint(1, this.Edges.getPoint(5).VC_Add(this.ColVector.Sk_Mult((float)this.Rows * this.PixelSpacingRow)));
            this.Edges.setPoint(2, this.Edges.getPoint(6).VC_Add(this.ColVector.Sk_Mult((float)this.Rows * this.PixelSpacingRow)));
            this.Edges.setPoint(3, this.Edges.getPoint(7).VC_Add(this.ColVector.Sk_Mult((float)this.Rows * this.PixelSpacingRow)));
            this.Edges.setPoint(4, this.Edges.getPoint(8).VC_Add(this.ColVector.Sk_Mult((float)this.Rows * this.PixelSpacingRow)));
            this.FirstPixelCorner = this.Edges.getPoint(6);
            this.calcMinMax();
            this.Width_scale = (float)this.Col_dec / (this.MaxY - this.MinY);
            this.Height_scale = (float)this.Row_dec / (this.MaxZ - this.MinZ);
            this.Row_scale = (float)this.Row_dec / ((float)this.Rows * this.PixelSpacingRow);
            this.Col_scale = (float)this.Col_dec / ((float)this.Colums * this.PixelSpacingColumn);
            if (this.isStrictSagittal()) {
                this.angle = 0.0f;
            } else if (this.isSag_Tra()) {
                this.angle = (float)Math.atan(this.SliceVector.getZ() / this.SliceVector.getX()) / 0.01745333f;
            } else if (this.isSag_Cor()) {
                this.angle = (float)Math.atan(this.SliceVector.getY() / this.SliceVector.getX()) / 0.01745333f;
            }
        } else if (this.isCoronar()) {
            this.valid = true;
            if (this.SliceVector.getY() < 0.0f) {
                this.SliceVector = this.SliceVector.Sk_Mult(-1.0f);
            }
            this.Edges.setPoint(5, this.ImagePosition);
            this.Edges.setPoint(7, this.ImagePosition.VC_Add(this.SliceVector.Sk_Mult(this.SliceThicknes)));
            this.Edges.setPoint(6, this.Edges.getPoint(5).VC_Add(this.RowVector.Sk_Mult((float)this.Colums * this.PixelSpacingColumn)));
            this.Edges.setPoint(8, this.Edges.getPoint(6).VC_Add(this.SliceVector.Sk_Mult(this.SliceThicknes)));
            this.Edges.setPoint(1, this.Edges.getPoint(5).VC_Add(this.ColVector.Sk_Mult((float)this.Rows * this.PixelSpacingRow)));
            this.Edges.setPoint(2, this.Edges.getPoint(6).VC_Add(this.ColVector.Sk_Mult((float)this.Rows * this.PixelSpacingRow)));
            this.Edges.setPoint(3, this.Edges.getPoint(7).VC_Add(this.ColVector.Sk_Mult((float)this.Rows * this.PixelSpacingRow)));
            this.Edges.setPoint(4, this.Edges.getPoint(8).VC_Add(this.ColVector.Sk_Mult((float)this.Rows * this.PixelSpacingRow)));
            this.FirstPixelCorner = this.Edges.getPoint(5);
            this.calcMinMax();
            this.Width_scale = (float)this.Col_dec / (this.MaxX - this.MinX);
            this.Height_scale = (float)this.Row_dec / (this.MaxZ - this.MinZ);
            this.Row_scale = (float)this.Row_dec / ((float)this.Rows * this.PixelSpacingRow);
            this.Col_scale = (float)this.Col_dec / ((float)this.Colums * this.PixelSpacingColumn);
            if (this.isStrictCoronar()) {
                this.angle = 0.0f;
            } else if (this.isCor_Tra()) {
                this.angle = (float)Math.atan(this.SliceVector.getZ() / this.SliceVector.getY()) / 0.01745333f;
            } else if (this.isCor_Sag()) {
                this.angle = (float)Math.atan(this.SliceVector.getX() / this.SliceVector.getY()) / 0.01745333f;
            }
        } else {
            this.valid = false;
            IJ.write((String)"Schichtorientierung konnte nicht bestimmt werden !");
            return;
        }
        this.ImagePosition2 = this.ImagePosition.VC_Add(this.SliceVector.Sk_Mult(this.SliceThicknes));
        ddo = null;
    }

    public Dicom_Slice(String Filename, boolean onlyHeader) {
        ImagePlus imp = (ImagePlus)IJ.runPlugIn((String)"DICOM_import", (String)("\t-p.\\th_io_properties.txt\t" + Filename));
        if (imp == null) {
            return;
        }
        this.Filename = Filename;
        if (!onlyHeader) {
            this.Pixel = (short[])imp.getProcessor().getPixelsCopy();
        } else {
            imp.killProcessor();
        }
        Properties prop = imp.getProperties();
        if (prop != null) {
            if (!prop.containsKey("1.2.3.4711.5.2")) {
                IJ.write((String)"Keine Props");
                return;
            }
        } else {
            IJ.write((String)"Keine Props");
            return;
        }
        DcmDataObject[] ddol = (DcmDataObject[])prop.get("1.2.3.4711.5.2");
        DcmDataObject ddo = ddol[0];
        this.init(ddo);
    }

    public Dicom_Slice(String Filename, DcmDataObject ddo) {
        this.Filename = Filename;
        this.init(ddo);
    }

    public Dicom_Slice(ImagePlus imp, boolean onlyHeader) {
        Properties prop;
        if (imp == null) {
            return;
        }
        FileInfo info = imp.getFileInfo();
        this.Filename = info.directory + System.getProperty("file.separator") + info.fileName;
        if (!onlyHeader) {
            this.Pixel = (short[])imp.getProcessor().getPixelsCopy();
        }
        if ((prop = imp.getProperties()) != null) {
            if (!prop.containsKey("1.2.3.4711.5.2")) {
                IJ.write((String)"Keine Props");
                return;
            }
        } else {
            IJ.write((String)"Keine Props");
            return;
        }
        DcmDataObject[] ddol = (DcmDataObject[])prop.get("1.2.3.4711.5.2");
        DcmDataObject ddo = ddol[0];
        this.init(ddo);
    }

    public float getXRowVector() {
        return this.RowVector.getX();
    }

    public float getYRowVector() {
        return this.RowVector.getY();
    }

    public float getZRowVector() {
        return this.RowVector.getZ();
    }

    public float getXColVector() {
        return this.ColVector.getX();
    }

    public float getYColVector() {
        return this.ColVector.getY();
    }

    public float getZColVector() {
        return this.ColVector.getZ();
    }

    public float getXPos() {
        return this.ImagePosition.getX();
    }

    public float getYPos() {
        return this.ImagePosition.getY();
    }

    public float getZPos() {
        return this.ImagePosition.getZ();
    }

    public int getColums() {
        return this.Colums;
    }

    public int getRows() {
        return this.Rows;
    }

    public float getPixelSpacingColumn() {
        return this.PixelSpacingColumn;
    }

    public float getPixelSpacingRow() {
        return this.PixelSpacingRow;
    }

    public float getSliceThicknes() {
        return this.SliceThicknes;
    }

    public float getMinZ() {
        return this.MinZ;
    }

    public float getMaxZ() {
        return this.MaxZ;
    }

    public float getMinX() {
        return this.MinX;
    }

    public float getMaxX() {
        return this.MaxX;
    }

    public float getMinY() {
        return this.MinY;
    }

    public float getMaxY() {
        return this.MaxY;
    }

    public int getSerie() {
        return this.Serie;
    }

    public boolean isTransversal() {
        return this.Orientation > 0 && this.Orientation < 4;
    }

    public boolean isCoronar() {
        return this.Orientation > 6 && this.Orientation < 10;
    }

    public boolean isSagittal() {
        return this.Orientation > 3 && this.Orientation < 7;
    }

    public boolean isStrictTransversal() {
        return this.Orientation == 1;
    }

    public boolean isStrictCoronar() {
        return this.Orientation == 7;
    }

    public boolean isStrictSagittal() {
        return this.Orientation == 4;
    }

    public boolean isTra_Cor() {
        return this.Orientation == 2;
    }

    public boolean isTra_Sag() {
        return this.Orientation == 3;
    }

    public boolean isCor_Sag() {
        return this.Orientation == 9;
    }

    public boolean isCor_Tra() {
        return this.Orientation == 8;
    }

    public boolean isSag_Tra() {
        return this.Orientation == 5;
    }

    public boolean isSag_Cor() {
        return this.Orientation == 6;
    }

    public boolean isStrict() {
        return this.isStrictCoronar() || this.isStrictSagittal() || this.isStrictTransversal();
    }

    public byte getOrientation() {
        return this.Orientation;
    }

    public boolean isValid() {
        return this.valid;
    }

    public int getValue(float x, float y) {
        return this.getPixel(MathTools.floor(x), MathTools.floor(y));
    }

    public void calcMinMax() {
        this.MinX = Float.POSITIVE_INFINITY;
        this.MaxX = Float.NEGATIVE_INFINITY;
        this.MinZ = Float.POSITIVE_INFINITY;
        this.MaxZ = Float.NEGATIVE_INFINITY;
        this.MinY = Float.POSITIVE_INFINITY;
        this.MaxY = Float.NEGATIVE_INFINITY;
        int i = 1;
        while (i <= 8) {
            float xval = this.Edges.getPoint(i).getX();
            float yval = this.Edges.getPoint(i).getY();
            float zval = this.Edges.getPoint(i).getZ();
            if (xval < this.MinX) {
                this.MinX = xval;
            }
            if (xval > this.MaxX) {
                this.MaxX = xval;
            }
            if (yval < this.MinY) {
                this.MinY = yval;
            }
            if (yval > this.MaxY) {
                this.MaxY = yval;
            }
            if (zval < this.MinZ) {
                this.MinZ = zval;
            }
            if (zval > this.MaxZ) {
                this.MaxZ = zval;
            }
            ++i;
        }
    }

    public int getPixel(int x, int y) {
        return this.Pixel[y * this.Colums + x];
    }

    public int getPixel2(int x, int y) {
        if (x > this.Col_dec) {
            x = this.Col_dec;
        }
        if (y > this.Row_dec) {
            y = this.Row_dec;
        }
        return this.Pixel[y * this.Colums + x];
    }

    public boolean compare(Dicom_Slice ds) {
        boolean result = this.ColVector.equal(ds.ColVector);
        boolean result1 = this.RowVector.equal(ds.RowVector);
        boolean result2 = this.SliceThicknes == ds.SliceThicknes;
        boolean result3 = this.SeriesDate.compareTo(ds.SeriesDate) == 0;
        boolean result4 = this.SeriesDescription.compareTo(ds.SeriesDescription) == 0;
        boolean result5 = this.SeriesTime.compareTo(ds.SeriesTime) == 0;
        boolean result6 = true;
        if (Global_Options.Directorytest) {
            String name2;
            String dir2;
            String name1 = this.Filename;
            int ind = name1.lastIndexOf(this.separator);
            String dir = name1.substring(0, ind);
            if (dir.compareTo(dir2 = (name2 = ds.Filename).substring(0, ind = name2.lastIndexOf(this.separator))) != 0) {
                result6 = false;
            }
        }
        return result && result1 && result2 && result3 && result4 && result5 && result6;
    }

    public int[][] getMatrix(float newx, float newy, int NumberOfPoints, int add) {
        int[][] Matrix = new int[NumberOfPoints][NumberOfPoints];
        int y = 0;
        while (y < NumberOfPoints) {
            int x = 0;
            while (x < NumberOfPoints) {
                Matrix[x][y] = this.getValue_comp(newx - (float)add + (float)x, newy - (float)add + (float)y);
                ++x;
            }
            ++y;
        }
        return Matrix;
    }

    public int getValue_comp(float x, float y) {
        if (x < 0.0f) {
            x = 0.0f;
        } else if (x > (float)(this.Rows - 1)) {
            x = this.Rows - 1;
        }
        if (y < 0.0f) {
            y = 0.0f;
        } else if (y > (float)(this.Colums - 1)) {
            y = this.Colums - 1;
        }
        return this.getValue(x, y);
    }

    public float getAngle() {
        return this.angle;
    }

    public Vektor3DPoint getEdges() {
        return this.Edges;
    }

    public void setValues() {
        if (this.isTransversal()) {
            if (this.SliceVector.getZ() < 0.0f) {
                this.SliceVector = this.SliceVector.Sk_Mult(-1.0f);
            }
            this.valid = true;
            this.Edges.setPoint(1, this.ImagePosition);
            this.Edges.setPoint(2, this.Edges.getPoint(1).VC_Add(this.RowVector.Sk_Mult((float)this.Colums * this.PixelSpacingColumn)));
            this.Edges.setPoint(3, this.Edges.getPoint(1).VC_Add(this.ColVector.Sk_Mult((float)this.Rows * this.PixelSpacingRow)));
            this.Edges.setPoint(4, this.Edges.getPoint(3).VC_Add(this.RowVector.Sk_Mult((float)this.Colums * this.PixelSpacingColumn)));
            this.Edges.setPoint(5, this.Edges.getPoint(1).VC_Add(this.SliceVector.Sk_Mult(this.SliceThicknes)));
            this.Edges.setPoint(6, this.Edges.getPoint(2).VC_Add(this.SliceVector.Sk_Mult(this.SliceThicknes)));
            this.Edges.setPoint(7, this.Edges.getPoint(3).VC_Add(this.SliceVector.Sk_Mult(this.SliceThicknes)));
            this.Edges.setPoint(8, this.Edges.getPoint(4).VC_Add(this.SliceVector.Sk_Mult(this.SliceThicknes)));
            this.FirstPixelCorner = this.Edges.getPoint(1);
            this.calcMinMax();
            this.Width_scale = (float)this.Col_dec / (this.MaxX - this.MinX);
            this.Height_scale = (float)this.Row_dec / (this.MaxY - this.MinY);
            this.Row_scale = (float)this.Row_dec / ((float)this.Rows * this.PixelSpacingRow);
            this.Col_scale = (float)this.Col_dec / ((float)this.Colums * this.PixelSpacingColumn);
            if (this.isStrictTransversal()) {
                this.angle = 0.0f;
            } else if (this.isTra_Cor()) {
                this.angle = (float)Math.atan(this.SliceVector.getY() / this.SliceVector.getZ()) / 0.01745333f;
            } else if (this.isTra_Sag()) {
                this.angle = (float)Math.atan(this.SliceVector.getX() / this.SliceVector.getZ()) / 0.01745333f;
            }
        } else if (this.isSagittal()) {
            this.valid = true;
            if ((double)this.SliceVector.getX() > 0.0) {
                this.SliceVector = this.SliceVector.Sk_Mult(-1.0f);
            }
            this.Edges.setPoint(6, this.ImagePosition);
            this.Edges.setPoint(5, this.ImagePosition.VC_Add(this.SliceVector.Sk_Mult(this.SliceThicknes)));
            this.Edges.setPoint(7, this.Edges.getPoint(5).VC_Add(this.RowVector.Sk_Mult((float)this.Colums * this.PixelSpacingColumn)));
            this.Edges.setPoint(8, this.Edges.getPoint(6).VC_Add(this.RowVector.Sk_Mult((float)this.Colums * this.PixelSpacingColumn)));
            this.Edges.setPoint(1, this.Edges.getPoint(5).VC_Add(this.ColVector.Sk_Mult((float)this.Rows * this.PixelSpacingRow)));
            this.Edges.setPoint(2, this.Edges.getPoint(6).VC_Add(this.ColVector.Sk_Mult((float)this.Rows * this.PixelSpacingRow)));
            this.Edges.setPoint(3, this.Edges.getPoint(7).VC_Add(this.ColVector.Sk_Mult((float)this.Rows * this.PixelSpacingRow)));
            this.Edges.setPoint(4, this.Edges.getPoint(8).VC_Add(this.ColVector.Sk_Mult((float)this.Rows * this.PixelSpacingRow)));
            this.FirstPixelCorner = this.Edges.getPoint(6);
            this.calcMinMax();
            this.Width_scale = (float)this.Col_dec / (this.MaxY - this.MinY);
            this.Height_scale = (float)this.Row_dec / (this.MaxZ - this.MinZ);
            this.Row_scale = (float)this.Row_dec / ((float)this.Rows * this.PixelSpacingRow);
            this.Col_scale = (float)this.Col_dec / ((float)this.Colums * this.PixelSpacingColumn);
            if (this.isStrictSagittal()) {
                this.angle = 0.0f;
            } else if (this.isSag_Tra()) {
                this.angle = (float)Math.atan(this.SliceVector.getZ() / this.SliceVector.getX()) / 0.01745333f;
            } else if (this.isSag_Cor()) {
                this.angle = (float)Math.atan(this.SliceVector.getY() / this.SliceVector.getX()) / 0.01745333f;
            }
        } else if (this.isCoronar()) {
            this.valid = true;
            if (this.SliceVector.getY() < 0.0f) {
                this.SliceVector = this.SliceVector.Sk_Mult(-1.0f);
            }
            this.Edges.setPoint(5, this.ImagePosition);
            this.Edges.setPoint(7, this.ImagePosition.VC_Add(this.SliceVector.Sk_Mult(this.SliceThicknes)));
            this.Edges.setPoint(6, this.Edges.getPoint(5).VC_Add(this.RowVector.Sk_Mult((float)this.Colums * this.PixelSpacingColumn)));
            this.Edges.setPoint(8, this.Edges.getPoint(6).VC_Add(this.SliceVector.Sk_Mult(this.SliceThicknes)));
            this.Edges.setPoint(1, this.Edges.getPoint(5).VC_Add(this.ColVector.Sk_Mult((float)this.Rows * this.PixelSpacingRow)));
            this.Edges.setPoint(2, this.Edges.getPoint(6).VC_Add(this.ColVector.Sk_Mult((float)this.Rows * this.PixelSpacingRow)));
            this.Edges.setPoint(3, this.Edges.getPoint(7).VC_Add(this.ColVector.Sk_Mult((float)this.Rows * this.PixelSpacingRow)));
            this.Edges.setPoint(4, this.Edges.getPoint(8).VC_Add(this.ColVector.Sk_Mult((float)this.Rows * this.PixelSpacingRow)));
            this.FirstPixelCorner = this.Edges.getPoint(5);
            this.calcMinMax();
            this.Width_scale = (float)this.Col_dec / (this.MaxX - this.MinX);
            this.Height_scale = (float)this.Row_dec / (this.MaxZ - this.MinZ);
            this.Row_scale = (float)this.Row_dec / ((float)this.Rows * this.PixelSpacingRow);
            this.Col_scale = (float)this.Col_dec / ((float)this.Colums * this.PixelSpacingColumn);
            if (this.isStrictCoronar()) {
                this.angle = 0.0f;
            } else if (this.isCor_Tra()) {
                this.angle = (float)Math.atan(this.SliceVector.getZ() / this.SliceVector.getY()) / 0.01745333f;
            } else if (this.isCor_Sag()) {
                this.angle = (float)Math.atan(this.SliceVector.getX() / this.SliceVector.getY()) / 0.01745333f;
            }
        } else {
            this.valid = false;
            IJ.write((String)"Schichtorientierung konnte nicht bestimmt werden !");
            return;
        }
        this.ImagePosition2 = this.ImagePosition.VC_Add(this.SliceVector.Sk_Mult(this.SliceThicknes));
    }

    static {
        Tra = 1;
    }
}

