/*
 * Decompiled with CFR 0.152.
 */
package mrcp.ddd;

import ij.IJ;
import java.util.Enumeration;
import javax.swing.JProgressBar;
import javax.swing.JTree;
import javax.swing.ProgressMonitor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import mrcp.dd.Dicom_Slice;
import mrcp.ddd.Series_Node;
import mrcp.ddd.Slice_Leaf;
import mrcp.graphics.Bounding_Cube;
import mrcp.graphics.Update_control;
import mrcp.tools.Global_Options;
import mrcp.tools.MathTools;
import mrcp.tools.MyRenderer;
import mrcp.tools.Point2D;
import mrcp.tools.Point3D;

public class Slice_Tree
extends JTree {
    public DefaultMutableTreeNode root;
    public DefaultTreeModel model;
    public int NumberOfSeries;
    public int[] SelectedSlices = new int[Global_Options.MaxNumberOfSeries];
    public int NumberOfSelectesSeries;
    public int[] NumberOfSlices;
    public int[] SeriesOffsets;
    private Dicom_Slice[] Slices;
    private Series_Node[] Series;
    public float newx = -1.0f;
    public float newy = -1.0f;
    public float newz = -1.0f;
    public float factor = 0.0f;
    public int akt_index = 0;
    private float Slice_Position = 0.0f;
    private int index2 = 0;
    private int index3 = 0;
    public int index4 = 0;
    public Point3D RowCount = new Point3D(0.0f, 0.0f, 0.0f);
    public Point3D ColCount = new Point3D(0.0f, 0.0f, 0.0f);
    public float MinZ = Float.POSITIVE_INFINITY;
    public float MinX = Float.POSITIVE_INFINITY;
    public float MinY = Float.POSITIVE_INFINITY;
    public float MaxX = Float.NEGATIVE_INFINITY;
    public float MaxY = Float.NEGATIVE_INFINITY;
    public float MaxZ = Float.NEGATIVE_INFINITY;
    public float MinZ2 = Float.NEGATIVE_INFINITY;
    public float MinX2 = Float.NEGATIVE_INFINITY;
    public float MinY2 = Float.NEGATIVE_INFINITY;
    public float MaxX2 = Float.POSITIVE_INFINITY;
    public float MaxY2 = Float.POSITIVE_INFINITY;
    public float MaxZ2 = Float.POSITIVE_INFINITY;
    private final int Error = -1;
    private float[] Functionvalues = new float[Global_Options.MaxNumberOfSeries];
    private int[] SeriesPosition = new int[Global_Options.MaxNumberOfSeries];
    private float[] Slice_Positions = new float[Global_Options.MaxNumberOfSeries];
    public int[] Series_sel = new int[Global_Options.MaxNumberOfSeries];

    public Slice_Tree(DefaultTreeModel model) {
        super(model);
        this.model = model;
    }

    public void initTree(DefaultMutableTreeNode top, DefaultTreeModel model) {
        this.model = model;
        this.root = top;
        this.setEditable(true);
        this.getSelectionModel().setSelectionMode(4);
        this.setShowsRootHandles(true);
        this.setCellRenderer(new MyRenderer());
        this.putClientProperty("JTree.lineStyle", "Angled");
    }

    public void update() {
        this.NumberOfSeries = this.root.getChildCount();
        this.NumberOfSlices = new int[this.NumberOfSeries];
        this.SeriesOffsets = new int[this.NumberOfSeries];
        this.Series = new Series_Node[this.NumberOfSeries];
        int SliceCount = 0;
        int SliceOffset = 0;
        int i = 0;
        while (i < this.NumberOfSeries) {
            Series_Node sn;
            DefaultMutableTreeNode Serie = (DefaultMutableTreeNode)this.root.getChildAt(i);
            DefaultMutableTreeNode FirstChild = (DefaultMutableTreeNode)Serie.getFirstChild();
            Slice_Leaf leaf = (Slice_Leaf)FirstChild.getUserObject();
            Dicom_Slice FirstSlice = leaf.cube.ds;
            this.Series[i] = sn = (Series_Node)Serie.getUserObject();
            this.NumberOfSlices[i] = Serie.getChildCount();
            this.SeriesOffsets[i] = SliceOffset;
            if (FirstSlice.isTransversal()) {
                sn.FirstImagePosZY = new Point2D(FirstSlice.FirstPixelCorner.getZ(), FirstSlice.FirstPixelCorner.getY());
                sn.FirstImagePosZX = new Point2D(FirstSlice.FirstPixelCorner.getZ(), FirstSlice.FirstPixelCorner.getX());
                sn.SliceVectorZY = new Point2D(FirstSlice.SliceVector.getZ(), FirstSlice.SliceVector.getY());
                sn.SliceVectorZX = new Point2D(FirstSlice.SliceVector.getZ(), FirstSlice.SliceVector.getX());
            }
            if (FirstSlice.isCoronar()) {
                sn.FirstImagePosYX = new Point2D(FirstSlice.FirstPixelCorner.getY(), FirstSlice.FirstPixelCorner.getX());
                sn.FirstImagePosYZ = new Point2D(FirstSlice.FirstPixelCorner.getY(), FirstSlice.FirstPixelCorner.getZ());
                sn.SliceVectorYX = new Point2D(FirstSlice.SliceVector.getY(), FirstSlice.SliceVector.getX());
                sn.SliceVectorYZ = new Point2D(FirstSlice.SliceVector.getY(), FirstSlice.SliceVector.getZ());
            }
            if (FirstSlice.isSagittal()) {
                sn.FirstImagePosXY = new Point2D(FirstSlice.FirstPixelCorner.getX(), FirstSlice.FirstPixelCorner.getY());
                sn.FirstImagePosXZ = new Point2D(FirstSlice.FirstPixelCorner.getX(), FirstSlice.FirstPixelCorner.getZ());
                sn.SliceVectorXY = new Point2D(FirstSlice.SliceVector.getX(), FirstSlice.SliceVector.getY());
                sn.SliceVectorXZ = new Point2D(FirstSlice.SliceVector.getX(), FirstSlice.SliceVector.getZ());
            }
            sn.MinZ = Float.POSITIVE_INFINITY;
            sn.MinX = Float.POSITIVE_INFINITY;
            sn.MinY = Float.POSITIVE_INFINITY;
            sn.MaxX = Float.NEGATIVE_INFINITY;
            sn.MaxY = Float.NEGATIVE_INFINITY;
            sn.MaxZ = Float.NEGATIVE_INFINITY;
            Enumeration<TreeNode> leafs = Serie.children();
            while (leafs.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)leafs.nextElement();
                Slice_Leaf sl = (Slice_Leaf)child.getUserObject();
                float xmin = sl.cube.ds.getMinX();
                float ymin = sl.cube.ds.getMinY();
                float zmin = sl.cube.ds.getMinZ();
                float xmax = sl.cube.ds.getMaxX();
                float ymax = sl.cube.ds.getMaxY();
                float zmax = sl.cube.ds.getMaxZ();
                if (xmin < sn.MinX) {
                    sn.MinX = xmin;
                }
                if (xmax > sn.MaxX) {
                    sn.MaxX = xmax;
                }
                if (ymin < sn.MinY) {
                    sn.MinY = ymin;
                }
                if (ymax > sn.MaxY) {
                    sn.MaxY = ymax;
                }
                if (zmin < sn.MinZ) {
                    sn.MinZ = zmin;
                }
                if (!(zmax > sn.MaxZ)) continue;
                sn.MaxZ = zmax;
            }
            SliceOffset += Serie.getChildCount();
            SliceCount += Serie.getChildCount();
            if (sn.MinX < this.MinX) {
                this.MinX = sn.MinX;
            }
            if (sn.MinY < this.MinY) {
                this.MinY = sn.MinY;
            }
            if (sn.MinZ < this.MinZ) {
                this.MinZ = sn.MinZ;
            }
            if (sn.MaxX > this.MaxX) {
                this.MaxX = sn.MaxX;
            }
            if (sn.MaxY > this.MaxY) {
                this.MaxY = sn.MaxY;
            }
            if (sn.MaxZ > this.MaxZ) {
                this.MaxZ = sn.MaxZ;
            }
            if (sn.MinX > this.MinX2) {
                this.MinX2 = sn.MinX;
            }
            if (sn.MinY > this.MinY2) {
                this.MinY2 = sn.MinY;
            }
            if (sn.MinZ > this.MinZ2) {
                this.MinZ2 = sn.MinZ;
            }
            if (sn.MaxX < this.MaxX2) {
                this.MaxX2 = sn.MaxX;
            }
            if (sn.MaxY < this.MaxY2) {
                this.MaxY2 = sn.MaxY;
            }
            if (sn.MaxZ < this.MaxZ2) {
                this.MaxZ2 = sn.MaxZ;
            }
            ++i;
        }
        Point3D p1 = new Point3D(this.MinX, this.MinY, this.MinZ);
        Point3D p2 = new Point3D(this.MaxX, this.MinY, this.MinZ);
        Point3D p3 = new Point3D(this.MinX, this.MaxY, this.MinZ);
        Point3D p4 = new Point3D(this.MaxX, this.MaxY, this.MinZ);
        Point3D p5 = new Point3D(this.MinX, this.MinY, this.MaxZ);
        Point3D p6 = new Point3D(this.MaxX, this.MinY, this.MaxZ);
        Point3D p7 = new Point3D(this.MinX, this.MaxY, this.MaxZ);
        Point3D p8 = new Point3D(this.MaxX, this.MaxY, this.MaxZ);
        Update_control.BB = new Bounding_Cube(p1, p2, p3, p4, p5, p6, p7, p8, Global_Options.BP);
        p1 = new Point3D(this.MinX2, this.MinY2, this.MinZ2);
        p2 = new Point3D(this.MaxX2, this.MinY2, this.MinZ2);
        p3 = new Point3D(this.MinX2, this.MaxY2, this.MinZ2);
        p4 = new Point3D(this.MaxX2, this.MaxY2, this.MinZ2);
        p5 = new Point3D(this.MinX2, this.MinY2, this.MaxZ2);
        p6 = new Point3D(this.MaxX2, this.MinY2, this.MaxZ2);
        p7 = new Point3D(this.MinX2, this.MaxY2, this.MaxZ2);
        p8 = new Point3D(this.MaxX2, this.MaxY2, this.MaxZ2);
        Update_control.IB = new Bounding_Cube(p1, p2, p3, p4, p5, p6, p7, p8, Global_Options.BP);
        this.Slices = new Dicom_Slice[SliceCount];
        int counter = 0;
        int i2 = 0;
        while (i2 < this.NumberOfSeries) {
            int x = 0;
            while (x < this.NumberOfSlices[i2]) {
                DefaultMutableTreeNode Serie = (DefaultMutableTreeNode)this.root.getChildAt(i2);
                Slice_Leaf sl = (Slice_Leaf)((DefaultMutableTreeNode)Serie.getChildAt(x)).getUserObject();
                this.Slices[counter] = sl.cube.ds;
                ++counter;
                ++x;
            }
            ++i2;
        }
        Update_control.Trans_Z = (this.MaxZ + this.MinZ) / 2.0f;
        Update_control.Sag_X = (this.MaxX + this.MinX) / 2.0f;
        Update_control.Cor_Y = (this.MaxY + this.MinY) / 2.0f;
        int i3 = 0;
        while (i3 < this.NumberOfSeries) {
            DefaultMutableTreeNode Serie = (DefaultMutableTreeNode)this.root.getChildAt(i3);
            Series_Node sn = (Series_Node)Serie.getUserObject();
            float sum = sn.Sum;
            Slice_Leaf fl = (Slice_Leaf)((DefaultMutableTreeNode)Serie.getFirstChild()).getUserObject();
            Dicom_Slice fds = fl.cube.ds;
            Point3D SLVector = fds.SliceVector;
            Point3D Start = fds.ImagePosition;
            float count = 0.0f;
            int s = 0;
            while (s < this.NumberOfSlices[i3]) {
                Slice_Leaf sl = (Slice_Leaf)((DefaultMutableTreeNode)Serie.getChildAt(s)).getUserObject();
                Dicom_Slice ds = sl.cube.ds;
                Point3D np = Start.VC_Add(SLVector.Sk_Mult((float)s * sum));
                if (!np.equal(ds.ImagePosition)) {
                    IJ.error((String)("Serie " + sn.name + "\n unvollst\u00e4ndig bzw. redundant, ab Bild " + ds.Filename));
                    IJ.error((String)("Es wird dringend empfohlen, die Bilder in der Serie " + sn.name + "\n ab dem Bild " + ds.Filename + " zu l\u00f6schen"));
                }
                ++s;
            }
            ++i3;
        }
    }

    public Dicom_Slice getFirstSlice(int Serie) {
        return this.Slices[this.SeriesOffsets[Serie]];
    }

    public float getSliceDist(int Serie) {
        return this.Series[Serie].Slice_Distant;
    }

    public Series_Node getSerie(int Serie) {
        return this.Series[Serie];
    }

    public int calc_SliceNumber(float x, float y, float z, int Serie) {
        Dicom_Slice ds = this.getFirstSlice(Serie);
        Series_Node sn = this.getSerie(Serie);
        float sum = sn.Sum;
        if (ds.isStrictTransversal()) {
            float dist = z - sn.FirstImagePosZY.getX();
            if (dist > sn.MaxZ - sn.MinZ || (double)dist < 0.0) {
                return -1;
            }
            this.newx = ds.Width_scale * (x - ds.MinX);
            this.newy = ds.Height_scale * (y - ds.MinY);
            this.newz = dist;
            if (this.newx < 0.0f || this.newy < 0.0f || this.newx > (float)ds.Col_dec || this.newy > (float)ds.Row_dec) {
                return -1;
            }
            int ind = MathTools.floor(dist / sum);
            if (ind < 0 || ind > this.NumberOfSlices[Serie] - 1) {
                return -1;
            }
            return ind;
        }
        if (ds.isTra_Cor()) {
            Point2D P = new Point2D(z, y);
            P = P.VC_Min(sn.FirstImagePosZY);
            Point2D PV = new Point2D(P.getX(), P.getY());
            Point2D CV = new Point2D(ds.ColVector.getZ(), ds.ColVector.getY());
            PV.norm();
            float t1 = PV.VC_SK_Mult(sn.SliceVectorZY);
            float t2 = CV.VC_SK_Mult(PV);
            if (t1 < 0.0f || t2 < 0.0f) {
                return -1;
            }
            float dist = P.VC_SK_Mult(sn.SliceVectorZY);
            if (dist < 0.0f || dist > sum * (float)this.NumberOfSlices[Serie] - sn.Slice_Distant) {
                return -1;
            }
            this.newy = (float)Math.sqrt(P.square() - dist * dist);
            this.newx = ds.Width_scale * (x - ds.MinX);
            this.newy = ds.Row_scale * this.newy;
            this.newz = dist;
            if (this.newx < 0.0f || this.newy < 0.0f || this.newx > (float)ds.Col_dec || this.newy > (float)ds.Row_dec) {
                return -1;
            }
            int ind = MathTools.floor(dist / sum);
            if (ind < 0 || ind > this.NumberOfSlices[Serie] - 1) {
                return -1;
            }
            return ind;
        }
        if (ds.isTra_Sag()) {
            Point2D P = new Point2D(z, x);
            P = P.VC_Min(sn.FirstImagePosZX);
            Point2D PV = new Point2D(P.getX(), P.getY());
            Point2D CV = new Point2D(ds.RowVector.getZ(), ds.RowVector.getX());
            PV.norm();
            float t1 = PV.VC_SK_Mult(sn.SliceVectorZX);
            float t2 = CV.VC_SK_Mult(PV);
            if (t1 < 0.0f || t2 < 0.0f) {
                return -1;
            }
            float dist = P.VC_SK_Mult(sn.SliceVectorZX);
            if ((double)dist < 0.0 || dist > sum * (float)this.NumberOfSlices[Serie] - sn.Slice_Distant) {
                return -1;
            }
            this.newx = (float)Math.sqrt(P.square() - dist * dist);
            this.newy = ds.Height_scale * (y - ds.MinY);
            this.newx = ds.Col_scale * this.newx;
            this.newz = dist;
            if (this.newx < 0.0f || this.newy < 0.0f || this.newx > (float)ds.Col_dec || this.newy > (float)ds.Row_dec) {
                return -1;
            }
            int ind = MathTools.floor(dist / sum);
            if (ind < 0 || ind > this.NumberOfSlices[Serie] - 1) {
                return -1;
            }
            return ind;
        }
        if (ds.isStrictCoronar()) {
            float dist = y - sn.FirstImagePosYZ.getX();
            if (dist > sn.MaxY - sn.MinY || (double)dist < 0.0) {
                return -1;
            }
            this.newx = ds.Width_scale * (x - ds.MinX);
            this.newy = ds.Row_scale * (ds.MaxZ - z);
            this.newz = dist;
            if (this.newx < 0.0f || this.newy < 0.0f || this.newx > (float)ds.Col_dec || this.newy > (float)ds.Row_dec) {
                return -1;
            }
            int ind = MathTools.floor(dist / sum);
            if (ind < 0 || ind > this.NumberOfSlices[Serie] - 1) {
                return -1;
            }
            return ind;
        }
        if (ds.isCor_Sag()) {
            Point2D P = new Point2D(y, x);
            P = P.VC_Min(sn.FirstImagePosYX);
            Point2D PV = new Point2D(P.getX(), P.getY());
            Point2D CV = new Point2D(ds.RowVector.getY(), ds.RowVector.getX());
            PV.norm();
            float t1 = PV.VC_SK_Mult(sn.SliceVectorYX);
            float t2 = CV.VC_SK_Mult(PV);
            if (t1 < 0.0f || t2 < 0.0f) {
                return -1;
            }
            float dist = P.VC_SK_Mult(sn.SliceVectorYX);
            if ((double)dist < 0.0 || dist > sum * (float)this.NumberOfSlices[Serie] - sn.Slice_Distant) {
                return -1;
            }
            this.newx = (float)Math.sqrt(P.square() - dist * dist);
            this.newy = ds.Height_scale * (ds.MaxZ - z);
            this.newx = ds.Col_scale * this.newx;
            this.newz = dist;
            if (this.newx < 0.0f || this.newy < 0.0f || this.newx > (float)ds.Col_dec || this.newy > (float)ds.Row_dec) {
                return -1;
            }
            int ind = MathTools.floor(dist / sum);
            if (ind < 0 || ind > this.NumberOfSlices[Serie] - 1) {
                return -1;
            }
            return ind;
        }
        if (ds.isCor_Tra()) {
            Point2D P = new Point2D(y, z);
            P = P.VC_Min(sn.FirstImagePosYZ);
            Point2D PV = new Point2D(P.getX(), P.getY());
            Point2D CV = new Point2D(ds.ColVector.getY(), ds.ColVector.getZ());
            PV.norm();
            float t1 = PV.VC_SK_Mult(sn.SliceVectorYZ);
            float t2 = CV.VC_SK_Mult(PV);
            if (t1 < 0.0f || t2 < 0.0f) {
                return -1;
            }
            float dist = P.VC_SK_Mult(sn.SliceVectorYZ);
            if ((double)dist < 0.0 || dist > sum * (float)this.NumberOfSlices[Serie] - sn.Slice_Distant) {
                return -1;
            }
            this.newy = (float)Math.sqrt(P.square() - dist * dist);
            this.newx = ds.Width_scale * (x - ds.MinX);
            this.newy = ds.Row_scale * this.newy;
            this.newz = dist;
            if (this.newx < 0.0f || this.newy < 0.0f || this.newx > (float)ds.Col_dec || this.newy > (float)ds.Row_dec) {
                return -1;
            }
            int ind = MathTools.floor(dist / sum);
            if (ind < 0 || ind > this.NumberOfSlices[Serie] - 1) {
                return -1;
            }
            return ind;
        }
        if (ds.isStrictSagittal()) {
            float dist = sn.FirstImagePosXY.getX() - x;
            if (dist > sn.MaxX - sn.MinX || (double)dist < 0.0) {
                return -1;
            }
            this.newx = ds.Width_scale * (y - ds.MinY);
            this.newy = ds.Height_scale * (ds.MaxZ - z);
            this.newz = dist;
            if (this.newx < 0.0f || this.newy < 0.0f || this.newx > (float)ds.Col_dec || this.newy > (float)ds.Row_dec) {
                return -1;
            }
            int ind = MathTools.floor(dist / sum);
            if (ind < 0 || ind > this.NumberOfSlices[Serie] - 1) {
                return -1;
            }
            return ind;
        }
        if (ds.isSag_Tra()) {
            Point2D P = new Point2D(x, z);
            P = P.VC_Min(sn.FirstImagePosXZ);
            Point2D PV = new Point2D(P.getX(), P.getY());
            Point2D CV = new Point2D(ds.ColVector.getX(), ds.ColVector.getZ());
            PV.norm();
            float t1 = PV.VC_SK_Mult(sn.SliceVectorXZ);
            float t2 = CV.VC_SK_Mult(PV);
            if (t1 < 0.0f || t2 < 0.0f) {
                return -1;
            }
            float dist = P.VC_SK_Mult(sn.SliceVectorXZ);
            if ((double)dist < 0.0 || dist > sum * (float)this.NumberOfSlices[Serie] - sn.Slice_Distant) {
                return -1;
            }
            this.newy = (float)Math.sqrt(P.square() - dist * dist);
            this.newx = ds.Width_scale * (y - ds.MinY);
            this.newy = ds.Row_scale * this.newy;
            this.newz = dist;
            if (this.newx < 0.0f || this.newy < 0.0f || this.newx > (float)ds.Col_dec || this.newy > (float)ds.Row_dec) {
                return -1;
            }
            int ind = MathTools.floor(dist / sum);
            if (ind < 0 || ind > this.NumberOfSlices[Serie] - 1) {
                return -1;
            }
            return ind;
        }
        if (ds.isSag_Cor()) {
            Point2D P = new Point2D(x, y);
            P = P.VC_Min(sn.FirstImagePosXY);
            Point2D PV = new Point2D(P.getX(), P.getY());
            Point2D CV = new Point2D(ds.RowVector.getX(), ds.RowVector.getY());
            PV.norm();
            float t1 = PV.VC_SK_Mult(sn.SliceVectorXY);
            float t2 = CV.VC_SK_Mult(PV);
            if (t1 < 0.0f || t2 < 0.0f) {
                return -1;
            }
            float dist = P.VC_SK_Mult(sn.SliceVectorXY);
            if ((double)dist < 0.0 || dist > sum * (float)this.NumberOfSlices[Serie] - sn.Slice_Distant) {
                return -1;
            }
            this.newx = (float)Math.sqrt(P.square() - dist * dist);
            this.newy = ds.Height_scale * (ds.MaxZ - z);
            this.newx = ds.Col_scale * this.newx;
            this.newz = dist;
            if (this.newx < 0.0f || this.newy < 0.0f || this.newx > (float)ds.Col_dec || this.newy > (float)ds.Row_dec) {
                return -1;
            }
            int ind = MathTools.floor(dist / sum);
            if (ind < 0 || ind > this.NumberOfSlices[Serie] - 1) {
                return -1;
            }
            return ind;
        }
        IJ.write((String)"Fehler bei Zuordnung der Orientierung");
        return -1;
    }

    private float getFunktionValue(float x, float y, float z, int Serie) throws IllegalArgumentException {
        int index = this.calc_SliceNumber(x, y, z, Serie);
        if (index == -1) {
            throw new IllegalArgumentException("Fehler bei Funktionsauswertung");
        }
        this.akt_index = this.SeriesOffsets[Serie] + index;
        Dicom_Slice ds = this.Slices[this.akt_index];
        Series_Node sn = this.getSerie(Serie);
        float sum = sn.Sum;
        this.Slice_Position = this.newz - (float)MathTools.floor(this.newz / sum) * sum;
        if (this.Slice_Position > ds.SliceThicknes) {
            this.Slice_Position = -1.0f;
        }
        if (Global_Options.Interpolationmodel == 2) {
            float dt = (float)index * sum + ds.SliceThicknes / 2.0f;
            if (this.newz - dt > 0.0f) {
                this.factor = (this.newz - dt) / sum;
                this.index2 = index + 1;
                if (this.index2 > this.NumberOfSlices[Serie] - 1) {
                    this.index2 = index;
                    this.factor = 0.0f;
                }
            } else {
                this.factor = (dt - this.newz) / sum;
                this.index2 = index - 1;
                if (this.index2 < 0) {
                    this.index2 = index;
                    this.factor = 0.0f;
                }
            }
        } else if (Global_Options.Interpolationmodel == 4 || Global_Options.Interpolationmodel >= 6) {
            this.index2 = index - 1;
            this.index3 = index + 1;
            this.index4 = index + 2;
            if (this.index2 < 0) {
                this.index2 = index;
            }
            if (this.index3 > this.NumberOfSlices[Serie] - 1) {
                this.index3 = index;
            }
            if (this.index4 > this.NumberOfSlices[Serie] - 1) {
                this.index4 = this.index3;
            }
            this.factor = (this.newz - (float)(index - 1) * sum - ds.SliceThicknes / 2.0f) / (sum + sum) * 2.0f;
        }
        switch (Global_Options.Interpolationmodel) {
            case 0: {
                int tmp = ds.getPixel2(Math.round(this.newx), Math.round(this.newy));
                return (float)tmp / ds.Voxelvolume;
            }
            case 1: {
                int xval1 = (int)this.newx;
                int yval1 = (int)this.newy;
                int xval2 = xval1 + 1;
                int yval2 = yval1 + 1;
                int val1 = ds.getPixel2(xval1, yval1);
                int val2 = ds.getPixel2(xval2, yval1);
                int val3 = ds.getPixel2(xval1, yval2);
                int val4 = ds.getPixel2(xval2, yval2);
                float intfacx = this.newx - (float)xval1;
                float intfacy = this.newy - (float)yval1;
                float val12 = MathTools.LI2(val1, val2, intfacx);
                float val34 = MathTools.LI2(val3, val4, intfacx);
                float val = MathTools.LI2(val12, val34, intfacy);
                return val / ds.Voxelvolume;
            }
            case 2: {
                if (this.NumberOfSlices[Serie] < 2) {
                    this.index2 = index;
                }
                int xval1 = (int)this.newx;
                int yval1 = (int)this.newy;
                int xval2 = xval1 + 1;
                int yval2 = yval1 + 1;
                int val1 = ds.getPixel2(xval1, yval1);
                int val2 = ds.getPixel2(xval2, yval1);
                int val3 = ds.getPixel2(xval1, yval2);
                int val4 = ds.getPixel2(xval2, yval2);
                float intfacx = this.newx - (float)xval1;
                float intfacy = this.newy - (float)yval1;
                float val12 = MathTools.LI2(val1, val2, intfacx);
                float val34 = MathTools.LI2(val3, val4, intfacx);
                float val1234 = MathTools.LI2(val12, val34, intfacy);
                ds = this.Slices[this.SeriesOffsets[Serie] + this.index2];
                val1 = ds.getPixel2(xval1, yval1);
                val2 = ds.getPixel2(xval2, yval1);
                val3 = ds.getPixel2(xval1, yval2);
                val4 = ds.getPixel2(xval2, yval2);
                val12 = MathTools.LI2(val1, val2, intfacx);
                val34 = MathTools.LI2(val3, val4, intfacx);
                float val5678 = MathTools.LI2(val12, val34, intfacy);
                float val = MathTools.LI2(val1234, val5678, this.factor);
                return val / ds.Voxelvolume;
            }
            case 3: {
                int n = MathTools.floor((Global_Options.NumberOfPoints - 1) / 2);
                float[] values = new float[Global_Options.NumberOfPoints];
                int[][] Matrix = ds.getMatrix(this.newx, this.newy, Global_Options.NumberOfPoints, n);
                float facy = this.newy - (float)MathTools.floor(this.newy) + (float)n;
                float facx = this.newx - (float)MathTools.floor(this.newx) + (float)n;
                int i = 0;
                while (i < Global_Options.NumberOfPoints) {
                    values[i] = MathTools.Lagrange(Matrix[i], facy);
                    ++i;
                }
                float val1234 = MathTools.Lagrange(values, facx);
                return val1234 / ds.Voxelvolume;
            }
            case 4: {
                int n = MathTools.floor((Global_Options.NumberOfPoints - 1) / 2);
                float[] values = new float[Global_Options.NumberOfPoints];
                float facy = this.newy - (float)MathTools.floor(this.newy) + (float)n;
                float facx = this.newx - (float)MathTools.floor(this.newx) + (float)n;
                ds = this.Slices[this.SeriesOffsets[Serie] + this.index2];
                int[][] Matrix = ds.getMatrix(this.newx, this.newy, Global_Options.NumberOfPoints, n);
                int i = 0;
                while (i < Global_Options.NumberOfPoints) {
                    values[i] = MathTools.Lagrange(Matrix[i], facy);
                    ++i;
                }
                float val1234 = MathTools.Lagrange(values, facx);
                ds = this.Slices[this.SeriesOffsets[Serie] + index];
                Matrix = ds.getMatrix(this.newx, this.newy, Global_Options.NumberOfPoints, n);
                int i2 = 0;
                while (i2 < Global_Options.NumberOfPoints) {
                    values[i2] = MathTools.Lagrange(Matrix[i2], facy);
                    ++i2;
                }
                float val5678 = MathTools.Lagrange(values, facx);
                ds = this.Slices[this.SeriesOffsets[Serie] + this.index3];
                Matrix = ds.getMatrix(this.newx, this.newy, Global_Options.NumberOfPoints, n);
                int i3 = 0;
                while (i3 < Global_Options.NumberOfPoints) {
                    values[i3] = MathTools.Lagrange(Matrix[i3], facy);
                    ++i3;
                }
                float val9012 = MathTools.Lagrange(values, facx);
                float[] values_global = new float[]{val1234, val5678, val9012};
                float val = MathTools.Lagrange(values_global, this.factor);
                return val / ds.Voxelvolume;
            }
            case 5: {
                float[] values = new float[4];
                int[][] Matrix = ds.getMatrix(this.newx, this.newy, 4, 1);
                float facy = this.newy - (float)MathTools.floor(this.newy);
                float facx = this.newx - (float)MathTools.floor(this.newx);
                float h1 = ds.PixelSpacingColumn;
                int i = 0;
                while (i < 4) {
                    values[i] = MathTools.KubicSpline(Matrix[i], h1, facy);
                    ++i;
                }
                float val = MathTools.KubicSpline(values, ds.PixelSpacingRow, facx);
                return val / ds.Voxelvolume;
            }
            case 6: {
                float[] values = new float[4];
                ds = this.Slices[this.SeriesOffsets[Serie] + this.index2];
                int[][] Matrix = ds.getMatrix(this.newx, this.newy, 4, 1);
                float facy = this.newy - (float)MathTools.floor(this.newy);
                float facx = this.newx - (float)MathTools.floor(this.newx);
                float h1 = ds.PixelSpacingColumn;
                int i = 0;
                while (i < 4) {
                    values[i] = MathTools.KubicSpline(Matrix[i], h1, facy);
                    ++i;
                }
                float val1234 = MathTools.KubicSpline(values, ds.PixelSpacingRow, facx);
                ds = this.Slices[this.SeriesOffsets[Serie] + index];
                Matrix = ds.getMatrix(this.newx, this.newy, 4, 1);
                int i4 = 0;
                while (i4 < 4) {
                    values[i4] = MathTools.KubicSpline(Matrix[i4], h1, facy);
                    ++i4;
                }
                float val5678 = MathTools.KubicSpline(values, ds.PixelSpacingRow, facx);
                ds = this.Slices[this.SeriesOffsets[Serie] + this.index3];
                Matrix = ds.getMatrix(this.newx, this.newy, 4, 1);
                int i5 = 0;
                while (i5 < 4) {
                    values[i5] = MathTools.KubicSpline(Matrix[i5], h1, facy);
                    ++i5;
                }
                float val9012 = MathTools.KubicSpline(values, ds.PixelSpacingRow, facx);
                ds = this.Slices[this.SeriesOffsets[Serie] + this.index4];
                Matrix = ds.getMatrix(this.newx, this.newy, 4, 1);
                int i6 = 0;
                while (i6 < 4) {
                    values[i6] = MathTools.KubicSpline(Matrix[i6], h1, facy);
                    ++i6;
                }
                float val3456 = MathTools.KubicSpline(values, ds.PixelSpacingRow, facx);
                float[] values_global2 = new float[]{val1234, val5678, val9012, val3456};
                float val = MathTools.KubicSpline(values_global2, ds.PixelSpacingRow, this.factor);
                return val / ds.Voxelvolume;
            }
            case 7: {
                int n = MathTools.floor((Global_Options.NumberOfPoints_Kubic - 1) / 2);
                float[] values = new float[Global_Options.NumberOfPoints_Kubic];
                ds = this.Slices[this.SeriesOffsets[Serie] + this.index2];
                int[][] Matrix = ds.getMatrix(this.newx, this.newy, Global_Options.NumberOfPoints_Kubic, n);
                float facy = this.newy - (float)MathTools.floor(this.newy) + (float)n;
                float facx = this.newx - (float)MathTools.floor(this.newx) + (float)n;
                float h1 = ds.PixelSpacingColumn;
                int i = 0;
                while (i < Global_Options.NumberOfPoints_Kubic) {
                    values[i] = MathTools.KubicSpline2(Global_Options.NumberOfPoints_Kubic, h1, Matrix[i], facy);
                    ++i;
                }
                float val1234 = MathTools.KubicSpline2(Global_Options.NumberOfPoints_Kubic, ds.PixelSpacingRow, values, facx);
                ds = this.Slices[this.SeriesOffsets[Serie] + index];
                Matrix = ds.getMatrix(this.newx, this.newy, Global_Options.NumberOfPoints_Kubic, n);
                int i7 = 0;
                while (i7 < Global_Options.NumberOfPoints_Kubic) {
                    values[i7] = MathTools.KubicSpline2(Global_Options.NumberOfPoints_Kubic, h1, Matrix[i7], facy);
                    ++i7;
                }
                float val5678 = MathTools.KubicSpline2(Global_Options.NumberOfPoints_Kubic, ds.PixelSpacingRow, values, facx);
                ds = this.Slices[this.SeriesOffsets[Serie] + this.index3];
                Matrix = ds.getMatrix(this.newx, this.newy, Global_Options.NumberOfPoints_Kubic, n);
                int i8 = 0;
                while (i8 < Global_Options.NumberOfPoints_Kubic) {
                    values[i8] = MathTools.KubicSpline2(Global_Options.NumberOfPoints_Kubic, h1, Matrix[i8], facy);
                    ++i8;
                }
                float val9012 = MathTools.KubicSpline2(Global_Options.NumberOfPoints_Kubic, ds.PixelSpacingRow, values, facx);
                ds = this.Slices[this.SeriesOffsets[Serie] + this.index4];
                Matrix = ds.getMatrix(this.newx, this.newy, Global_Options.NumberOfPoints_Kubic, n);
                int i9 = 0;
                while (i9 < Global_Options.NumberOfPoints_Kubic) {
                    values[i9] = MathTools.KubicSpline2(Global_Options.NumberOfPoints_Kubic, h1, Matrix[i9], facy);
                    ++i9;
                }
                float val3456 = MathTools.KubicSpline2(Global_Options.NumberOfPoints_Kubic, ds.PixelSpacingRow, values, facx);
                float[] values_global3 = new float[]{val1234, val5678, val9012, val3456};
                float val = MathTools.KubicSpline2(Global_Options.NumberOfPoints_Kubic, ds.PixelSpacingRow, values_global3, this.factor + 1.0f);
                return val / ds.Voxelvolume;
            }
        }
        return 0.0f;
    }

    private float getFunktionValue(Point3D p, int Serie) {
        return this.getFunktionValue(p.getX(), p.getY(), p.getZ(), Serie);
    }

    public float getFunktionValue(Point3D p) {
        return this.getFunktionValue(p.getX(), p.getY(), p.getZ());
    }

    /*
     * Unable to fully structure code
     */
    public float getFunktionValue(float x, float y, float z) {
        val = 0.0f;
        count = 0;
        i = 0;
        while (i < this.NumberOfSelectesSeries) {
            try {
                this.Functionvalues[count] = this.getFunktionValue(x, y, z, this.SelectedSlices[i]);
                val += this.Functionvalues[count];
                this.SeriesPosition[count] = this.akt_index;
                this.Slice_Positions[count] = this.Slice_Position;
                this.Series_sel[count] = this.SelectedSlices[i];
                ++count;
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        if (count == 0) {
            return 0.0f;
        }
        switch (Global_Options.ApproxMethod) {
            case 0: {
                return val;
            }
            case 1: {
                return val / (float)count;
            }
            case 2: {
                if (count < 2) {
                    return val / (float)count;
                }
                Matrix_values = new float[Global_Options.NumberOfPairs];
                Matrix_counter = 0;
                angle = 0.0f;
                x1 = 0;
                while (x1 < count) {
                    x2 = 0;
                    while (x2 < count) {
                        if (x1 == x2) ** GOTO lbl192
                        ds1 = this.Slices[this.SeriesPosition[x1]];
                        ds2 = this.Slices[this.SeriesPosition[x2]];
                        fac = Global_Options.getMatrixFactors(ds1, ds2);
                        Origin = new Point3D(x, y, z);
                        Vector_2 = p0 = MathTools.Nullvector;
                        Vector_1 = p0;
                        Res_2 = 0.0f;
                        Res_1 = 0.0f;
                        thickness_2 = 0.0f;
                        thickness_1 = 0.0f;
                        Integral_2 = new float[Global_Options.Matrix_Resolution];
                        Integral_1 = new float[Global_Options.Matrix_Resolution];
                        sum_x = 0.0f;
                        sum_z = 0.0f;
                        trans_2 = 0.0f;
                        trans_1 = 0.0f;
                        fl = 0.0f;
                        if (!ds1.isTransversal() || !ds2.isSagittal()) ** GOTO lbl96
                        if (this.Slice_Positions[x1] < 0.0f || this.Slice_Positions[x2] < 0.0f) {
                            return val / (float)count;
                        }
                        o = Origin;
                        p = ds1.SliceVector.VC_Mult(ds2.SliceVector);
                        g1o = new Point3D(0.0f, 0.0f, 0.0f);
                        g1m = new Point3D(0.0f, 0.0f, 0.0f);
                        MathTools.calcIntersection_PP(ds1.ImagePosition, ds1.SliceVector, ds2.ImagePosition, ds2.ColVector, ds2.RowVector, g1o, g1m);
                        g2o = new Point3D(0.0f, 0.0f, 0.0f);
                        g2m = new Point3D(0.0f, 0.0f, 0.0f);
                        MathTools.calcIntersection_PP(ds1.ImagePosition2, ds1.SliceVector, ds2.ImagePosition, ds2.ColVector, ds2.RowVector, g2o, g2m);
                        g3o = new Point3D(0.0f, 0.0f, 0.0f);
                        g3m = new Point3D(0.0f, 0.0f, 0.0f);
                        MathTools.calcIntersection_PP(ds1.ImagePosition, ds1.SliceVector, ds2.ImagePosition2, ds2.ColVector, ds2.RowVector, g3o, g3m);
                        p0 = MathTools.calcIntersection_GP(g1o, g1m, Origin, p);
                        ps1 = MathTools.calcIntersection_GP(g2o, g2m, Origin, p);
                        ps2 = MathTools.calcIntersection_GP(g3o, g3m, Origin, p);
                        Vector_1 = ps1.VC_Min(p0);
                        Vector_2 = ps2.VC_Min(p0);
                        thickness_1 = Vector_1.Length();
                        thickness_2 = Vector_2.Length();
                        Res_2 = thickness_2 / (float)Global_Options.Matrix_Resolution;
                        Res_1 = thickness_1 / (float)Global_Options.Matrix_Resolution;
                        Vector_1.norm();
                        Vector_2.norm();
                        trans_1 = this.Slice_Positions[x1] / ds1.SliceThicknes * thickness_1;
                        trans_2 = this.Slice_Positions[x2] / ds2.SliceThicknes * thickness_2;
                        cs = Vector_1.Sk_Mult(Res_1).VC_Mult(Vector_2.Sk_Mult(Res_2));
                        fl = cs.Length();
                        mr = 0;
                        while (mr < Global_Options.Matrix_Resolution) {
                            p1 = p0.VC_Add(Vector_2.Sk_Mult((float)mr * Res_2));
                            p2 = p0.VC_Add(Vector_1.Sk_Mult((float)mr * Res_1));
                            try {
                                Integral_1[mr] = this.getIntegral(p1, Res_2, 1.0f, thickness_1, Vector_2, MathTools.Nullvector, Vector_1, this.Series_sel[x1]);
                                Integral_2[mr] = this.getIntegral(p2, thickness_2, 1.0f, Res_1, Vector_2, MathTools.Nullvector, Vector_1, this.Series_sel[x2]);
                                sum_z += Integral_1[mr];
                                sum_x += Integral_2[mr];
                            }
                            catch (Exception excep) {
                                return val / (float)count;
                            }
                            ++mr;
                        }
                        ** GOTO lbl184
lbl96:
                        // 1 sources

                        if (!ds1.isTransversal() || !ds2.isCoronar()) ** GOTO lbl140
                        if (this.Slice_Positions[x1] < 0.0f || this.Slice_Positions[x2] < 0.0f) {
                            return val / (float)count;
                        }
                        o = Origin;
                        p = ds1.SliceVector.VC_Mult(ds2.SliceVector);
                        g1o = new Point3D(0.0f, 0.0f, 0.0f);
                        g1m = new Point3D(0.0f, 0.0f, 0.0f);
                        MathTools.calcIntersection_PP(ds1.ImagePosition, ds1.SliceVector, ds2.ImagePosition, ds2.ColVector, ds2.RowVector, g1o, g1m);
                        g2o = new Point3D(0.0f, 0.0f, 0.0f);
                        g2m = new Point3D(0.0f, 0.0f, 0.0f);
                        MathTools.calcIntersection_PP(ds1.ImagePosition, ds1.SliceVector, ds2.ImagePosition2, ds2.ColVector, ds2.RowVector, g2o, g2m);
                        g3o = new Point3D(0.0f, 0.0f, 0.0f);
                        g3m = new Point3D(0.0f, 0.0f, 0.0f);
                        MathTools.calcIntersection_PP(ds1.ImagePosition2, ds1.SliceVector, ds2.ImagePosition, ds2.ColVector, ds2.RowVector, g3o, g3m);
                        p0 = MathTools.calcIntersection_GP(g1o, g1m, Origin, p);
                        ps1 = MathTools.calcIntersection_GP(g2o, g2m, Origin, p);
                        ps2 = MathTools.calcIntersection_GP(g3o, g3m, Origin, p);
                        Vector_1 = ps1.VC_Min(p0);
                        Vector_2 = ps2.VC_Min(p0);
                        thickness_1 = Vector_1.Length();
                        thickness_2 = Vector_2.Length();
                        Res_2 = thickness_2 / (float)Global_Options.Matrix_Resolution;
                        Res_1 = thickness_1 / (float)Global_Options.Matrix_Resolution;
                        Vector_1.norm();
                        Vector_2.norm();
                        trans_1 = this.Slice_Positions[x2] / ds2.SliceThicknes * thickness_1;
                        trans_2 = this.Slice_Positions[x1] / ds1.SliceThicknes * thickness_2;
                        cs = Vector_1.Sk_Mult(Res_1).VC_Mult(Vector_2.Sk_Mult(Res_2));
                        fl = cs.Length();
                        mr = 0;
                        while (mr < Global_Options.Matrix_Resolution) {
                            p1 = p0.VC_Add(Vector_2.Sk_Mult((float)mr * Res_2));
                            p2 = p0.VC_Add(Vector_1.Sk_Mult((float)mr * Res_1));
                            try {
                                Integral_1[mr] = this.getIntegral(p1, 1.0f, thickness_1, Res_2, MathTools.Nullvector, Vector_1, Vector_2, this.Series_sel[x1]);
                                Integral_2[mr] = this.getIntegral(p2, 1.0f, Res_1, thickness_2, MathTools.Nullvector, Vector_1, Vector_2, this.Series_sel[x2]);
                                sum_x += Integral_1[mr];
                                sum_z += Integral_2[mr];
                            }
                            catch (Exception excep) {
                                return val / (float)count;
                            }
                            ++mr;
                        }
                        ** GOTO lbl184
lbl140:
                        // 1 sources

                        if (ds1.isCoronar() && ds2.isSagittal()) {
                            if (this.Slice_Positions[x1] < 0.0f || this.Slice_Positions[x2] < 0.0f) {
                                return val / (float)count;
                            }
                            o = Origin;
                            p = ds1.SliceVector.VC_Mult(ds2.SliceVector);
                            g1o = new Point3D(0.0f, 0.0f, 0.0f);
                            g1m = new Point3D(0.0f, 0.0f, 0.0f);
                            MathTools.calcIntersection_PP(ds1.ImagePosition, ds1.SliceVector, ds2.ImagePosition, ds2.ColVector, ds2.RowVector, g1o, g1m);
                            g2o = new Point3D(0.0f, 0.0f, 0.0f);
                            g2m = new Point3D(0.0f, 0.0f, 0.0f);
                            MathTools.calcIntersection_PP(ds1.ImagePosition2, ds1.SliceVector, ds2.ImagePosition, ds2.ColVector, ds2.RowVector, g2o, g2m);
                            g3o = new Point3D(0.0f, 0.0f, 0.0f);
                            g3m = new Point3D(0.0f, 0.0f, 0.0f);
                            MathTools.calcIntersection_PP(ds1.ImagePosition, ds1.SliceVector, ds2.ImagePosition2, ds2.ColVector, ds2.RowVector, g3o, g3m);
                            p0 = MathTools.calcIntersection_GP(g1o, g1m, Origin, p);
                            ps1 = MathTools.calcIntersection_GP(g2o, g2m, Origin, p);
                            ps2 = MathTools.calcIntersection_GP(g3o, g3m, Origin, p);
                            Vector_1 = ps1.VC_Min(p0);
                            Vector_2 = ps2.VC_Min(p0);
                            thickness_1 = Vector_1.Length();
                            thickness_2 = Vector_2.Length();
                            Res_2 = thickness_2 / (float)Global_Options.Matrix_Resolution;
                            Res_1 = thickness_1 / (float)Global_Options.Matrix_Resolution;
                            Vector_1.norm();
                            Vector_2.norm();
                            trans_1 = this.Slice_Positions[x1] / ds1.SliceThicknes * thickness_1;
                            trans_2 = this.Slice_Positions[x2] / ds2.SliceThicknes * thickness_2;
                            cs = Vector_1.Sk_Mult(Res_1).VC_Mult(Vector_2.Sk_Mult(Res_2));
                            fl = cs.Length();
                            mr = 0;
                            while (mr < Global_Options.Matrix_Resolution) {
                                p1 = p0.VC_Add(Vector_2.Sk_Mult((float)mr * Res_2));
                                p2 = p0.VC_Add(Vector_1.Sk_Mult((float)mr * Res_1));
                                try {
                                    Integral_1[mr] = this.getIntegral(p1, Res_2, thickness_1, 1.0f, Vector_2, Vector_1, MathTools.Nullvector, this.Series_sel[x1]);
                                    Integral_2[mr] = this.getIntegral(p2, thickness_2, Res_1, 1.0f, Vector_2, Vector_1, MathTools.Nullvector, this.Series_sel[x2]);
                                    sum_z += Integral_1[mr];
                                    sum_x += Integral_2[mr];
                                }
                                catch (Exception excep) {
                                    return val / (float)count;
                                }
                                ++mr;
                            }
                        }
                        ** GOTO lbl192
lbl184:
                        // 3 sources

                        split_2 = (int)(trans_2 * (float)Global_Options.Matrix_Resolution / thickness_2);
                        split_1 = (int)(trans_1 * (float)Global_Options.Matrix_Resolution / thickness_1);
                        sum_all = sum_x + sum_z;
                        vl1 = Integral_1[split_2] / (sum_x + 1.0f) * Integral_2[split_1];
                        vl2 = Integral_2[split_1] / (sum_z + 1.0f) * Integral_1[split_2];
                        Matrix_values[Matrix_counter] = fac * vl1 / fl + (1.0f - fac) * vl2 / fl;
                        v0 = Matrix_counter++;
                        Matrix_values[v0] = Matrix_values[v0] * Global_Options.getFactors(ds1, ds2);
lbl192:
                        // 3 sources

                        ++x2;
                    }
                    ++x1;
                }
                val = 0.0f;
                i = 0;
                while (i < Matrix_counter) {
                    val += Matrix_values[i];
                    ++i;
                }
                return val / (float)Matrix_counter;
            }
            case 3: {
                if (count != 3) {
                    return val / (float)count;
                }
                Matrix_values = new float[Global_Options.NumberOfPairs];
                Matrix_counter = 0;
                factor_eq = 0.0f;
                angle = 0.0f;
                x3 = 0;
                x1 = 0;
                while (x1 < count) {
                    x2 = 0;
                    while (x2 < count) {
                        if (x1 == x2) ** GOTO lbl439
                        x3 = 0;
                        while (x3 == x2 || x3 == x1) {
                            ++x3;
                        }
                        ds1 = this.Slices[this.SeriesPosition[x1]];
                        ds2 = this.Slices[this.SeriesPosition[x2]];
                        ds3 = this.Slices[this.SeriesPosition[x3]];
                        Origin = new Point3D(x, y, z);
                        Vector_2 = p0 = MathTools.Nullvector;
                        Vector_1 = p0;
                        Res_2 = 0.0f;
                        Res_1 = 0.0f;
                        thickness_2 = 0.0f;
                        thickness_1 = 0.0f;
                        Integral_2 = new float[Global_Options.Matrix_Resolution];
                        Integral_1 = new float[Global_Options.Matrix_Resolution];
                        sum_x = 0.0f;
                        sum_z = 0.0f;
                        trans_2 = 0.0f;
                        trans_1 = 0.0f;
                        fl = 0.0f;
                        cn = Global_Options.Matrix_Resolution * 2 + Global_Options.Matrix_Resolution * Global_Options.Matrix_Resolution;
                        b = new double[cn];
                        if (!ds1.isTransversal() || !ds2.isSagittal() || !Global_Options.TS_C) ** GOTO lbl295
                        if (this.Slice_Positions[x1] < 0.0f || this.Slice_Positions[x2] < 0.0f) {
                            return val / (float)count;
                        }
                        factor_eq = Global_Options.Factor_eq_TS;
                        o = Origin;
                        p = ds1.SliceVector.VC_Mult(ds2.SliceVector);
                        g1o = new Point3D(0.0f, 0.0f, 0.0f);
                        g1m = new Point3D(0.0f, 0.0f, 0.0f);
                        MathTools.calcIntersection_PP(ds1.ImagePosition, ds1.SliceVector, ds2.ImagePosition, ds2.ColVector, ds2.RowVector, g1o, g1m);
                        g2o = new Point3D(0.0f, 0.0f, 0.0f);
                        g2m = new Point3D(0.0f, 0.0f, 0.0f);
                        MathTools.calcIntersection_PP(ds1.ImagePosition2, ds1.SliceVector, ds2.ImagePosition, ds2.ColVector, ds2.RowVector, g2o, g2m);
                        g3o = new Point3D(0.0f, 0.0f, 0.0f);
                        g3m = new Point3D(0.0f, 0.0f, 0.0f);
                        MathTools.calcIntersection_PP(ds1.ImagePosition, ds1.SliceVector, ds2.ImagePosition2, ds2.ColVector, ds2.RowVector, g3o, g3m);
                        p0 = MathTools.calcIntersection_GP(g1o, g1m, Origin, p);
                        ps1 = MathTools.calcIntersection_GP(g2o, g2m, Origin, p);
                        ps2 = MathTools.calcIntersection_GP(g3o, g3m, Origin, p);
                        Vector_1 = ps1.VC_Min(p0);
                        Vector_2 = ps2.VC_Min(p0);
                        thickness_1 = Vector_1.Length();
                        thickness_2 = Vector_2.Length();
                        Res_2 = thickness_2 / (float)Global_Options.Matrix_Resolution;
                        Res_1 = thickness_1 / (float)Global_Options.Matrix_Resolution;
                        Vector_1.norm();
                        Vector_2.norm();
                        trans_1 = this.Slice_Positions[x1] / ds1.SliceThicknes * thickness_1;
                        trans_2 = this.Slice_Positions[x2] / ds2.SliceThicknes * thickness_2;
                        cs = Vector_1.Sk_Mult(Res_1).VC_Mult(Vector_2.Sk_Mult(Res_2));
                        fl = cs.Length();
                        mr = 0;
                        while (mr < Global_Options.Matrix_Resolution) {
                            p1 = p0.VC_Add(Vector_2.Sk_Mult((float)mr * Res_2));
                            p2 = p0.VC_Add(Vector_1.Sk_Mult((float)mr * Res_1));
                            try {
                                Integral_1[mr] = this.getIntegral(p1, Res_2, 1.0f, thickness_1, Vector_2, MathTools.Nullvector, Vector_1, this.Series_sel[x1]);
                                Integral_2[mr] = this.getIntegral(p2, thickness_2, 1.0f, Res_1, Vector_2, MathTools.Nullvector, Vector_1, this.Series_sel[x2]);
                                sum_z += Integral_1[mr];
                                sum_x += Integral_2[mr];
                            }
                            catch (Exception excep) {
                                return val / (float)count;
                            }
                            ++mr;
                        }
                        i1 = 0;
                        while (i1 < Global_Options.Matrix_Resolution) {
                            i2 = 0;
                            while (i2 < Global_Options.Matrix_Resolution) {
                                Org = p0.VC_Add(Vector_2.Sk_Mult((float)i2 * Res_2));
                                Org = Org.VC_Add(Vector_1.Sk_Mult((float)i1 * Res_1));
                                b[Global_Options.Matrix_Resolution * i1 + i2 + 2 * Global_Options.Matrix_Resolution] = this.getIntegral(Org, Res_2, 1.0f, Res_1, Vector_2, MathTools.Nullvector, Vector_1, this.Series_sel[x3]);
                                ++i2;
                            }
                            ++i1;
                        }
                        ** GOTO lbl407
lbl295:
                        // 1 sources

                        if (!ds1.isTransversal() || !ds2.isCoronar() || !Global_Options.TC_S) ** GOTO lbl351
                        if (this.Slice_Positions[x1] < 0.0f || this.Slice_Positions[x2] < 0.0f) {
                            return val / (float)count;
                        }
                        factor_eq = Global_Options.Factor_eq_TC;
                        o = Origin;
                        p = ds1.SliceVector.VC_Mult(ds2.SliceVector);
                        g1o = new Point3D(0.0f, 0.0f, 0.0f);
                        g1m = new Point3D(0.0f, 0.0f, 0.0f);
                        MathTools.calcIntersection_PP(ds1.ImagePosition, ds1.SliceVector, ds2.ImagePosition, ds2.ColVector, ds2.RowVector, g1o, g1m);
                        g2o = new Point3D(0.0f, 0.0f, 0.0f);
                        g2m = new Point3D(0.0f, 0.0f, 0.0f);
                        MathTools.calcIntersection_PP(ds1.ImagePosition, ds1.SliceVector, ds2.ImagePosition2, ds2.ColVector, ds2.RowVector, g2o, g2m);
                        g3o = new Point3D(0.0f, 0.0f, 0.0f);
                        g3m = new Point3D(0.0f, 0.0f, 0.0f);
                        MathTools.calcIntersection_PP(ds1.ImagePosition2, ds1.SliceVector, ds2.ImagePosition, ds2.ColVector, ds2.RowVector, g3o, g3m);
                        p0 = MathTools.calcIntersection_GP(g1o, g1m, Origin, p);
                        ps1 = MathTools.calcIntersection_GP(g2o, g2m, Origin, p);
                        ps2 = MathTools.calcIntersection_GP(g3o, g3m, Origin, p);
                        Vector_1 = ps1.VC_Min(p0);
                        Vector_2 = ps2.VC_Min(p0);
                        thickness_1 = Vector_1.Length();
                        thickness_2 = Vector_2.Length();
                        Res_2 = thickness_2 / (float)Global_Options.Matrix_Resolution;
                        Res_1 = thickness_1 / (float)Global_Options.Matrix_Resolution;
                        Vector_1.norm();
                        Vector_2.norm();
                        trans_1 = this.Slice_Positions[x2] / ds2.SliceThicknes * thickness_1;
                        trans_2 = this.Slice_Positions[x1] / ds1.SliceThicknes * thickness_2;
                        cs = Vector_1.Sk_Mult(Res_1).VC_Mult(Vector_2.Sk_Mult(Res_2));
                        fl = cs.Length();
                        mr = 0;
                        while (mr < Global_Options.Matrix_Resolution) {
                            p1 = p0.VC_Add(Vector_2.Sk_Mult((float)mr * Res_2));
                            p2 = p0.VC_Add(Vector_1.Sk_Mult((float)mr * Res_1));
                            try {
                                Integral_1[mr] = this.getIntegral(p1, 1.0f, thickness_1, Res_2, MathTools.Nullvector, Vector_1, Vector_2, this.Series_sel[x1]);
                                Integral_2[mr] = this.getIntegral(p2, 1.0f, Res_1, thickness_2, MathTools.Nullvector, Vector_1, Vector_2, this.Series_sel[x2]);
                                sum_z += Integral_1[mr];
                                sum_x += Integral_2[mr];
                            }
                            catch (Exception excep) {
                                return val / (float)count;
                            }
                            ++mr;
                        }
                        i1 = 0;
                        while (i1 < Global_Options.Matrix_Resolution) {
                            i2 = 0;
                            while (i2 < Global_Options.Matrix_Resolution) {
                                Org = p0.VC_Add(Vector_2.Sk_Mult((float)i2 * Res_2));
                                Org = Org.VC_Add(Vector_1.Sk_Mult((float)i1 * Res_1));
                                b[Global_Options.Matrix_Resolution * i1 + i2 + 2 * Global_Options.Matrix_Resolution] = this.getIntegral(Org, 1.0f, Res_1, Res_2, MathTools.Nullvector, Vector_1, Vector_2, this.Series_sel[x3]);
                                ++i2;
                            }
                            ++i1;
                        }
                        ** GOTO lbl407
lbl351:
                        // 1 sources

                        if (ds1.isCoronar() && ds2.isSagittal() && Global_Options.SC_T) {
                            if (this.Slice_Positions[x1] < 0.0f || this.Slice_Positions[x2] < 0.0f) {
                                return val / (float)count;
                            }
                            factor_eq = Global_Options.Factor_eq_CS;
                            o = Origin;
                            p = ds1.SliceVector.VC_Mult(ds2.SliceVector);
                            g1o = new Point3D(0.0f, 0.0f, 0.0f);
                            g1m = new Point3D(0.0f, 0.0f, 0.0f);
                            MathTools.calcIntersection_PP(ds1.ImagePosition, ds1.SliceVector, ds2.ImagePosition, ds2.ColVector, ds2.RowVector, g1o, g1m);
                            g2o = new Point3D(0.0f, 0.0f, 0.0f);
                            g2m = new Point3D(0.0f, 0.0f, 0.0f);
                            MathTools.calcIntersection_PP(ds1.ImagePosition2, ds1.SliceVector, ds2.ImagePosition, ds2.ColVector, ds2.RowVector, g2o, g2m);
                            g3o = new Point3D(0.0f, 0.0f, 0.0f);
                            g3m = new Point3D(0.0f, 0.0f, 0.0f);
                            MathTools.calcIntersection_PP(ds1.ImagePosition, ds1.SliceVector, ds2.ImagePosition2, ds2.ColVector, ds2.RowVector, g3o, g3m);
                            p0 = MathTools.calcIntersection_GP(g1o, g1m, Origin, p);
                            ps1 = MathTools.calcIntersection_GP(g2o, g2m, Origin, p);
                            ps2 = MathTools.calcIntersection_GP(g3o, g3m, Origin, p);
                            Vector_1 = ps1.VC_Min(p0);
                            Vector_2 = ps2.VC_Min(p0);
                            thickness_1 = Vector_1.Length();
                            thickness_2 = Vector_2.Length();
                            Res_2 = thickness_2 / (float)Global_Options.Matrix_Resolution;
                            Res_1 = thickness_1 / (float)Global_Options.Matrix_Resolution;
                            Vector_1.norm();
                            Vector_2.norm();
                            trans_1 = this.Slice_Positions[x1] / ds1.SliceThicknes * thickness_1;
                            trans_2 = this.Slice_Positions[x2] / ds2.SliceThicknes * thickness_2;
                            cs = Vector_1.Sk_Mult(Res_1).VC_Mult(Vector_2.Sk_Mult(Res_2));
                            fl = cs.Length();
                            mr = 0;
                            while (mr < Global_Options.Matrix_Resolution) {
                                p1 = p0.VC_Add(Vector_2.Sk_Mult((float)mr * Res_2));
                                p2 = p0.VC_Add(Vector_1.Sk_Mult((float)mr * Res_1));
                                try {
                                    Integral_1[mr] = this.getIntegral(p1, Res_2, thickness_1, 1.0f, Vector_2, Vector_1, MathTools.Nullvector, this.Series_sel[x1]);
                                    Integral_2[mr] = this.getIntegral(p2, thickness_2, Res_1, 1.0f, Vector_2, Vector_1, MathTools.Nullvector, this.Series_sel[x2]);
                                    sum_z += Integral_1[mr];
                                    sum_x += Integral_2[mr];
                                }
                                catch (Exception excep) {
                                    return val / (float)count;
                                }
                                ++mr;
                            }
                            i1 = 0;
                            while (i1 < Global_Options.Matrix_Resolution) {
                                i2 = 0;
                                while (i2 < Global_Options.Matrix_Resolution) {
                                    Org = p0.VC_Add(Vector_2.Sk_Mult((float)i2 * Res_2));
                                    Org = Org.VC_Add(Vector_1.Sk_Mult((float)i1 * Res_1));
                                    b[Global_Options.Matrix_Resolution * i1 + i2 + 2 * Global_Options.Matrix_Resolution] = this.getIntegral(Org, Res_2, Res_1, 1.0f, Vector_2, Vector_1, MathTools.Nullvector, this.Series_sel[x3]);
                                    ++i2;
                                }
                                ++i1;
                            }
                        }
                        ** GOTO lbl439
lbl407:
                        // 3 sources

                        split_2 = (int)(trans_2 * (float)Global_Options.Matrix_Resolution / thickness_2);
                        split_1 = (int)(trans_1 * (float)Global_Options.Matrix_Resolution / thickness_1);
                        i = 0;
                        while (i < Global_Options.Matrix_Resolution) {
                            b[i] = Integral_2[i];
                            b[i + Global_Options.Matrix_Resolution] = Integral_1[i];
                            ++i;
                        }
                        fac_imp = Global_Options.Factor_impRows;
                        quad = Global_Options.Matrix_Resolution * Global_Options.Matrix_Resolution;
                        Matrix = new double[quad + 2 * Global_Options.Matrix_Resolution][quad];
                        if (Global_Options.Matrix_Resolution == 3) {
                            MathTools.copyMatrix(MathTools.Matrix3_3, Matrix);
                        } else {
                            MathTools.copyMatrix(MathTools.Matrix2_2, Matrix);
                        }
                        ip = 0;
                        while (ip < 2 * Global_Options.Matrix_Resolution) {
                            v1 = ip;
                            b[v1] = b[v1] * (double)fac_imp;
                            col = 0;
                            while (col < quad) {
                                v2 = Matrix[ip];
                                v3 = col++;
                                v2[v3] = v2[v3] * (double)fac_imp;
                            }
                            ++ip;
                        }
                        b = Global_Options.Matrix_Resolution == 3 ? MathTools.solveLinEqu(Matrix, b, 15, 9) : MathTools.solveLinEqu(Matrix, b, 8, 4);
                        if (b != null) {
                            Matrix_values[Matrix_counter] = (float)b[split_1 * Global_Options.Matrix_Resolution + split_2];
                            v4 = Matrix_counter++;
                            Matrix_values[v4] = Matrix_values[v4] * factor_eq;
                        }
lbl439:
                        // 5 sources

                        ++x2;
                    }
                    ++x1;
                }
                val = 0.0f;
                i = 0;
                while (i < Matrix_counter) {
                    val += Matrix_values[i];
                    ++i;
                }
                return val;
            }
        }
        return 0.0f;
    }

    private float getIntegral_Midpoint_Sum(Point3D Origin, float xval, float yval, float zval, Point3D xvec, Point3D yvec, Point3D zvec) {
        float val = 0.0f;
        int n = Global_Options.Integration_Number;
        if (n == 1) {
            return this.getFunktionValue(Origin.getX() + 0.5f * xval * xvec.getX(), Origin.getY() + 0.5f * yval * yvec.getY(), Origin.getZ() + 0.5f * zval * zvec.getZ()) * xval * yval * zval;
        }
        int x = 0;
        while (x < n) {
            int y = 0;
            while (y < n) {
                int z = 0;
                while (z < n) {
                    val += this.getFunktionValue(Origin.getX() + ((float)x + 0.5f) * xval / (float)n * xvec.getX(), Origin.getY() + ((float)y + 0.5f) * yval / (float)n * yvec.getY(), Origin.getZ() + ((float)z + 0.5f) * zval / (float)n * zvec.getZ());
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return val * xval * yval * zval / (float)(n * n * n);
    }

    private float getIntegral_Riemann_Sum(Point3D Origin, float xval, float yval, float zval, Point3D xvec, Point3D yvec, Point3D zvec) {
        float val = 0.0f;
        int n = Global_Options.Integration_Number;
        int x = 1;
        while (x <= n) {
            int y = 1;
            while (y <= n) {
                int z = 1;
                while (z <= n) {
                    val += this.getFunktionValue(Origin.getX() + (float)x * xval / (float)n * xvec.getX(), Origin.getY() + (float)y * yval / (float)n * yvec.getY(), Origin.getZ() + (float)z * zval / (float)n * zvec.getZ());
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return val * xval * yval * zval / (float)(n * n * n);
    }

    private float getIntegral_Riemann_Sum_2D(Point3D Origin, float xval, float yval, float zval, Point3D xvec, Point3D yvec, Point3D zvec, int Serie) throws IllegalArgumentException {
        float val = 0.0f;
        int n = Global_Options.Integration_Number;
        try {
            int x = 1;
            while (x <= n) {
                int y = 1;
                while (y <= n) {
                    int z = 1;
                    while (z <= n) {
                        val += this.getFunktionValue(Origin.getX() + (float)x * xval / (float)n * xvec.getX(), Origin.getY() + (float)y * yval / (float)n * yvec.getY(), Origin.getZ() + (float)z * zval / (float)n * zvec.getZ(), Serie);
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            return val * xval * yval * zval / (float)(n * n * n);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    private float getIntegral_Trapezoidal_Sum_2D(Point3D Origin, float xval, float yval, float zval, Point3D xvec, Point3D yvec, Point3D zvec, int Serie) throws IllegalArgumentException {
        int n = Global_Options.Integration_Number;
        float xfac = xval / (float)n;
        float yfac = yval / (float)n;
        float zfac = zval / (float)n;
        float val = 0.0f;
        int x = 0;
        while (x <= n) {
            int y = 0;
            while (y <= n) {
                int z = 0;
                while (z <= n) {
                    float factor = 1.0f;
                    if (x == 0 || x == n) {
                        factor *= 0.5f;
                    }
                    if (y == 0 || y == n) {
                        factor *= 0.5f;
                    }
                    if (z == 0 || z == n) {
                        factor *= 0.5f;
                    }
                    val += factor * this.getFunktionValue(Origin.getX() + (float)x * xfac * xvec.getX(), Origin.getY() + (float)y * yfac * yvec.getY(), Origin.getZ() + (float)z * zfac * zvec.getZ(), Serie);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return val * xfac * yfac * zfac;
    }

    private float getIntegral_Simpson_Sum(Point3D Origin, float xval, float yval, float zval, Point3D xvec, Point3D yvec, Point3D zvec) {
        int n = Global_Options.Integration_Number;
        int two_n = n << 1;
        float xfac = xval / (float)two_n;
        float yfac = yval / (float)two_n;
        float zfac = zval / (float)two_n;
        float val = 0.0f;
        int x = 0;
        while (x <= two_n) {
            int y = 0;
            while (y <= two_n) {
                int z = 0;
                while (z <= two_n) {
                    float factor = MathTools.getWeigth(x, n) * MathTools.getWeigth(y, n) * MathTools.getWeigth(z, n);
                    val += factor * this.getFunktionValue(Origin.getX() + (float)x * xfac * xvec.getX(), Origin.getY() + (float)y * yfac * yvec.getY(), Origin.getZ() + (float)z * zfac * zvec.getZ());
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return val * xfac * yfac * zfac / 27.0f;
    }

    private float getIntegral_Simpson_Sum_2D(Point3D Origin, float xval, float yval, float zval, Point3D xvec, Point3D yvec, Point3D zvec, int Serie) throws IllegalArgumentException {
        int n = Global_Options.Integration_Number;
        int two_n = n << 1;
        float xfac = xval / (float)two_n;
        float yfac = yval / (float)two_n;
        float zfac = zval / (float)two_n;
        float val = 0.0f;
        try {
            int x = 0;
            while (x <= two_n) {
                int y = 0;
                while (y <= two_n) {
                    int z = 0;
                    while (z <= two_n) {
                        float factor = MathTools.getWeigth(x, n) * MathTools.getWeigth(y, n) * MathTools.getWeigth(z, n);
                        val += factor * this.getFunktionValue(Origin.getX() + (float)x * xfac * xvec.getX(), Origin.getY() + (float)y * yfac * yvec.getY(), Origin.getZ() + (float)z * zfac * zvec.getZ(), Serie);
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            return val * xfac * yfac * zfac / 27.0f;
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public short[][] getSlices(Point3D Origin, Point3D xvec, Point3D yvec, Point3D zvec, float xval, float yval, float zval, int rows, int cols, ProgressMonitor mon, int NumberSlices, float SliceDistant) {
        if (mon != null) {
            mon.setProgress(0);
        }
        if (Global_Options.ApproxMethod == 2 && this.NumberOfSelectesSeries < 2) {
            IJ.error((String)"F\u00fcr die Methode Gewichtete Summen werden mindestens zwei selektierte Serien gebraucht");
            return null;
        }
        if (Global_Options.ApproxMethod == 3 && this.NumberOfSelectesSeries < 3) {
            IJ.error((String)"F\u00fcr die Methode Lineare Gleichungen werden mindestens drei selektierte Serien gebraucht");
            return null;
        }
        short[][] Slices = new short[NumberSlices][cols * rows];
        Point3D Slice_Increment = zvec.Sk_Mult(SliceDistant + zval);
        int sl = 0;
        while (sl < NumberSlices) {
            short[] Pixels = new short[cols * rows];
            Point3D Col_Increment = yvec.Sk_Mult(yval);
            Point3D Row_Increment = xvec.Sk_Mult(xval);
            this.ColCount.set(Origin);
            int y = 0;
            while (y < rows) {
                this.RowCount.set(this.ColCount);
                int x = 0;
                while (x < cols) {
                    float val = 0.0f;
                    val = this.getIntegral(this.RowCount, xval, yval, zval, xvec, yvec, zvec);
                    if (val < 0.0f) {
                        val = 0.0f;
                    }
                    Pixels[x + y * cols] = (short)val;
                    this.RowCount.VC_Add2(Row_Increment);
                    ++x;
                }
                this.ColCount.VC_Add2(Col_Increment);
                if (mon != null) {
                    mon.setProgress(y + sl * rows);
                }
                ++y;
            }
            Slices[sl] = Pixels;
            if (mon != null && mon.isCanceled()) {
                return null;
            }
            Origin.VC_Add2(Slice_Increment);
            ++sl;
        }
        if (mon != null) {
            mon.close();
        }
        return Slices;
    }

    public void resetBB() {
        this.MinZ = Float.POSITIVE_INFINITY;
        this.MinX = Float.POSITIVE_INFINITY;
        this.MinY = Float.POSITIVE_INFINITY;
        this.MaxX = Float.NEGATIVE_INFINITY;
        this.MaxY = Float.NEGATIVE_INFINITY;
        this.MaxZ = Float.NEGATIVE_INFINITY;
        this.MinZ2 = Float.NEGATIVE_INFINITY;
        this.MinX2 = Float.NEGATIVE_INFINITY;
        this.MinY2 = Float.NEGATIVE_INFINITY;
        this.MaxX2 = Float.POSITIVE_INFINITY;
        this.MaxY2 = Float.POSITIVE_INFINITY;
        this.MaxZ2 = Float.POSITIVE_INFINITY;
    }

    public void setSelectedSeries(int[] Series) {
        this.NumberOfSelectesSeries = Series.length;
        int i = 0;
        while (i < this.NumberOfSelectesSeries) {
            this.SelectedSlices[i] = Series[i];
            ++i;
        }
    }

    public void setSelectedSeries() {
        this.NumberOfSelectesSeries = 0;
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return;
        }
        int i = 0;
        while (i < paths.length) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
            Object nodeinfo = node.getUserObject();
            String classname = nodeinfo.getClass().getName();
            if (classname.compareTo("java.lang.String") == 0) {
                this.NumberOfSelectesSeries = this.root.getChildCount();
                int s = 0;
                while (s < this.NumberOfSelectesSeries) {
                    this.SelectedSlices[s] = s;
                    ++s;
                }
                return;
            }
            if (classname.indexOf("Series_Node") > 0) {
                ++this.NumberOfSelectesSeries;
                this.SelectedSlices[i] = this.root.getIndex(node);
            }
            ++i;
        }
    }

    public void clearSelection2() {
        this.NumberOfSelectesSeries = 0;
        TreeSelectionModel tm = this.getSelectionModel();
        tm.clearSelection();
        this.model.reload();
        this.update();
    }

    private float getIntegral_Midpoint_Sum_2D(Point3D Origin, float xval, float yval, float zval, Point3D xvec, Point3D yvec, Point3D zvec, int serie) throws IllegalArgumentException {
        float val = 0.0f;
        int n = Global_Options.Integration_Number;
        try {
            if (n == 1) {
                return this.getFunktionValue(Origin.getX() + 0.5f * xval * xvec.getX(), Origin.getY() + 0.5f * yval * yvec.getY(), Origin.getZ() + 0.5f * zval * zvec.getZ(), serie) * xval * yval * zval;
            }
            int x = 0;
            while (x < n) {
                int y = 0;
                while (y < n) {
                    int z = 0;
                    while (z < n) {
                        val += this.getFunktionValue(Origin.getX() + ((float)x + 0.5f) * xval / (float)n * xvec.getX(), Origin.getY() + ((float)y + 0.5f) * yval / (float)n * yvec.getY(), Origin.getZ() + ((float)z + 0.5f) * zval / (float)n * zvec.getZ(), serie);
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            return val * xval * yval * zval / (float)(n * n * n);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public float getIntegral(Point3D Origin, float xval, float yval, float zval, Point3D xvec, Point3D yvec, Point3D zvec) {
        switch (Global_Options.IntegrationMethod) {
            case 0: {
                return this.getIntegral_Midpoint_Sum(Origin, xval, yval, zval, xvec, yvec, zvec);
            }
            case 1: {
                return this.getIntegral_Riemann_Sum(Origin, xval, yval, zval, xvec, yvec, zvec);
            }
            case 2: {
                return this.getIntegral_Simpson_Sum(Origin, xval, yval, zval, xvec, yvec, zvec);
            }
            case 3: {
                return this.getIntegral_Trapezoidal_Sum(Origin, xval, yval, zval, xvec, yvec, zvec);
            }
        }
        return 0.0f;
    }

    public float getIntegral(Point3D Origin, float xval, float yval, float zval, Point3D xvec, Point3D yvec, Point3D zvec, int Serie) {
        switch (Global_Options.IntegrationMethod) {
            case 0: {
                return this.getIntegral_Midpoint_Sum_2D(Origin, xval, yval, zval, xvec, yvec, zvec, Serie);
            }
            case 1: {
                return this.getIntegral_Riemann_Sum_2D(Origin, xval, yval, zval, xvec, yvec, zvec, Serie);
            }
            case 2: {
                return this.getIntegral_Simpson_Sum_2D(Origin, xval, yval, zval, xvec, yvec, zvec, Serie);
            }
            case 3: {
                return this.getIntegral_Trapezoidal_Sum_2D(Origin, xval, yval, zval, xvec, yvec, zvec, Serie);
            }
        }
        return 0.0f;
    }

    public short[][] getSlices_2(Point3D Origin, Point3D xvec, Point3D yvec, Point3D zvec, float xval, float yval, float zval, int rows, int cols, JProgressBar mon, int NumberSlices, float SliceDistant) {
        if (mon != null) {
            mon.setValue(0);
        }
        if (Global_Options.ApproxMethod == 2 && this.NumberOfSelectesSeries < 2) {
            IJ.error((String)"F\u00fcr die Methode Gewichtete Summen werden mindestens zwei selektierte Serien gebraucht");
            return null;
        }
        if (Global_Options.ApproxMethod == 3 && this.NumberOfSelectesSeries < 3) {
            IJ.error((String)"F\u00fcr die Methode Lineare Gleichungen werden mindestens drei selektierte Serien gebraucht");
            return null;
        }
        short[][] Slices = new short[NumberSlices][cols * rows];
        Point3D Slice_Increment = zvec.Sk_Mult(SliceDistant + zval);
        int sl = 0;
        while (sl < NumberSlices) {
            short[] Pixels = new short[cols * rows];
            Point3D Col_Increment = yvec.Sk_Mult(yval);
            Point3D Row_Increment = xvec.Sk_Mult(xval);
            this.ColCount.set(Origin);
            int y = 0;
            while (y < rows) {
                this.RowCount.set(this.ColCount);
                int x = 0;
                while (x < cols) {
                    float val = 0.0f;
                    val = this.getIntegral(this.RowCount, xval, yval, zval, xvec, yvec, zvec);
                    if (val < 0.0f) {
                        val = 0.0f;
                    }
                    Pixels[x + y * cols] = (short)val;
                    this.RowCount.VC_Add2(Row_Increment);
                    ++x;
                }
                this.ColCount.VC_Add2(Col_Increment);
                if (mon != null) {
                    mon.setValue(y + y * sl);
                }
                ++y;
            }
            Slices[sl] = Pixels;
            Origin.VC_Add2(Slice_Increment);
            ++sl;
        }
        return Slices;
    }

    private float getIntegral_Trapezoidal_Sum(Point3D Origin, float xval, float yval, float zval, Point3D xvec, Point3D yvec, Point3D zvec) {
        int n = Global_Options.Integration_Number;
        float xfac = xval / (float)n;
        float yfac = yval / (float)n;
        float zfac = zval / (float)n;
        float val = 0.0f;
        int x = 0;
        while (x <= n) {
            int y = 0;
            while (y <= n) {
                int z = 0;
                while (z <= n) {
                    float factor = 1.0f;
                    if (x == 0 || x == n) {
                        factor *= 0.5f;
                    }
                    if (y == 0 || y == n) {
                        factor *= 0.5f;
                    }
                    if (z == 0 || z == n) {
                        factor *= 0.5f;
                    }
                    val += factor * this.getFunktionValue(Origin.getX() + (float)x * xfac * xvec.getX(), Origin.getY() + (float)y * yfac * yvec.getY(), Origin.getZ() + (float)z * zfac * zvec.getZ());
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return val * xfac * yfac * zfac;
    }
}

