/*
 * Decompiled with CFR 0.152.
 */
package mrcp.graphics;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Polygon;
import mrcp.graphics.Cube;
import mrcp.tools.Global_Options;
import mrcp.tools.Point3D;

public class Selection_Cube
extends Cube {
    int Orientation = 0;

    public Selection_Cube(Point3D p) {
        super(p);
    }

    public Selection_Cube(Point3D p1, Point3D p2, Point3D p3, Point3D p4, Point3D p5, Point3D p6, Point3D p7, Point3D p8, Point3D BP) {
        super(p1, p2, p3, p4, p5, p6, p7, p8, BP);
    }

    public float getAverageX() {
        float sum = 0.0f;
        int i = 1;
        while (i <= 8) {
            sum += this.getPoint(i).getX();
            i = (byte)(i + 1);
        }
        return sum / 8.0f;
    }

    public float getAverageY() {
        float sum = 0.0f;
        int i = 1;
        while (i <= 8) {
            sum += this.getPoint(i).getY();
            i = (byte)(i + 1);
        }
        return sum / 8.0f;
    }

    public float getAverageZ() {
        float sum = 0.0f;
        int i = 1;
        while (i <= 8) {
            sum += this.getPoint(i).getZ();
            i = (byte)(i + 1);
        }
        return sum / 8.0f;
    }

    public void translate(float x, float y, float z) {
        int i = 1;
        while (i <= 8) {
            this.getPoint(i).translate(x, y, z);
            i = (byte)(i + 1);
        }
    }

    public void rotateY(float Grad) {
        float AvgX = this.getAverageX();
        float AvgZ = this.getAverageZ();
        this.translate(-AvgX, 0.0f, -AvgZ);
        int i = 1;
        while (i <= 8) {
            this.getPoint(i).rotateY(Grad);
            i = (byte)(i + 1);
        }
        this.translate(AvgX, 0.0f, AvgZ);
    }

    public void rotateX(float Grad) {
        float AvgY = this.getAverageY();
        float AvgZ = this.getAverageZ();
        this.translate(0.0f, -AvgY, -AvgZ);
        int i = 1;
        while (i <= 8) {
            this.getPoint(i).rotateX(Grad);
            i = (byte)(i + 1);
        }
        this.translate(0.0f, AvgY, AvgZ);
    }

    public void rotateZ(float Grad) {
        float AvgX = this.getAverageX();
        float AvgY = this.getAverageY();
        this.translate(-AvgX, -AvgY, 0.0f);
        int i = 1;
        while (i <= 8) {
            this.getPoint(i).rotateZ(Grad);
            i = (byte)(i + 1);
        }
        this.translate(AvgX, AvgY, 0.0f);
    }

    public void translateWidth(float trans) {
        float val = trans / 2.0f;
        Point3D vec = this.getPoint(2).VC_Min(this.getPoint(1));
        vec.norm();
        Point3D vec1 = vec.Sk_Mult(val);
        Point3D vec2 = vec.Sk_Mult(-val);
        this.getPoint(2).translate(vec1);
        this.getPoint(4).translate(vec1);
        this.getPoint(6).translate(vec1);
        this.getPoint(8).translate(vec1);
        this.getPoint(1).translate(vec2);
        this.getPoint(3).translate(vec2);
        this.getPoint(5).translate(vec2);
        this.getPoint(7).translate(vec2);
    }

    public void translateHeigth(float trans) {
        float val = trans / 2.0f;
        Point3D vec = this.getPoint(3).VC_Min(this.getPoint(1));
        vec.norm();
        Point3D vec1 = vec.Sk_Mult(val);
        Point3D vec2 = vec.Sk_Mult(-val);
        this.getPoint(3).translate(vec1);
        this.getPoint(4).translate(vec1);
        this.getPoint(7).translate(vec1);
        this.getPoint(8).translate(vec1);
        this.getPoint(1).translate(vec2);
        this.getPoint(2).translate(vec2);
        this.getPoint(5).translate(vec2);
        this.getPoint(6).translate(vec2);
    }

    public void translateDepth(float trans) {
        float val = trans / 2.0f;
        Point3D vec = this.getPoint(5).VC_Min(this.getPoint(1));
        vec.norm();
        Point3D vec1 = vec.Sk_Mult(val);
        Point3D vec2 = vec.Sk_Mult(-val);
        this.getPoint(5).translate(vec1);
        this.getPoint(6).translate(vec1);
        this.getPoint(7).translate(vec1);
        this.getPoint(8).translate(vec1);
        this.getPoint(1).translate(vec2);
        this.getPoint(2).translate(vec2);
        this.getPoint(3).translate(vec2);
        this.getPoint(4).translate(vec2);
    }

    public void drawCube(Graphics2D g, float YConstant, float XConstant, float scale) {
        if (this.Projection_Type == 0) {
            this.HiddenPoint = this.calculateHidden();
        }
        this.calculate2DPoints(YConstant, XConstant, scale);
        g.setColor(this.color);
        if (this.Projection_Type == 4 || this.Projection_Type == 5 || this.Projection_Type == 6) {
            Polygon p1 = new Polygon();
            p1.addPoint(this.get2dPointX(1), this.get2dPointY(1));
            p1.addPoint(this.get2dPointX(2), this.get2dPointY(2));
            p1.addPoint(this.get2dPointX(6), this.get2dPointY(6));
            p1.addPoint(this.get2dPointX(5), this.get2dPointY(5));
            Polygon p2 = new Polygon();
            p2.addPoint(this.get2dPointX(2), this.get2dPointY(2));
            p2.addPoint(this.get2dPointX(6), this.get2dPointY(6));
            p2.addPoint(this.get2dPointX(8), this.get2dPointY(8));
            p2.addPoint(this.get2dPointX(4), this.get2dPointY(4));
            Polygon p3 = new Polygon();
            p3.addPoint(this.get2dPointX(1), this.get2dPointY(1));
            p3.addPoint(this.get2dPointX(2), this.get2dPointY(2));
            p3.addPoint(this.get2dPointX(4), this.get2dPointY(4));
            p3.addPoint(this.get2dPointX(3), this.get2dPointY(3));
            Polygon p4 = new Polygon();
            p4.addPoint(this.get2dPointX(5), this.get2dPointY(5));
            p4.addPoint(this.get2dPointX(6), this.get2dPointY(6));
            p4.addPoint(this.get2dPointX(8), this.get2dPointY(8));
            p4.addPoint(this.get2dPointX(7), this.get2dPointY(7));
            Polygon p5 = new Polygon();
            p5.addPoint(this.get2dPointX(1), this.get2dPointY(1));
            p5.addPoint(this.get2dPointX(5), this.get2dPointY(5));
            p5.addPoint(this.get2dPointX(7), this.get2dPointY(7));
            p5.addPoint(this.get2dPointX(3), this.get2dPointY(3));
            Polygon p6 = new Polygon();
            p6.addPoint(this.get2dPointX(3), this.get2dPointY(3));
            p6.addPoint(this.get2dPointX(4), this.get2dPointY(4));
            p6.addPoint(this.get2dPointX(8), this.get2dPointY(8));
            p6.addPoint(this.get2dPointX(7), this.get2dPointY(7));
            g.drawPolygon(p1);
            g.drawPolygon(p2);
            g.drawPolygon(p3);
            g.drawPolygon(p4);
            g.drawPolygon(p5);
            g.drawPolygon(p6);
            return;
        }
        float[] dash1 = new float[]{5.0f};
        BasicStroke bs2 = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
        BasicStroke bs1 = new BasicStroke(1.0f);
        g.setStroke(bs1);
        if (this.HiddenPoint != 1 && this.HiddenPoint != 2) {
            g.drawLine(this.get2dPointX(1), this.get2dPointY(1), this.get2dPointX(2), this.get2dPointY(2));
        } else if (Global_Options.showHiddenLines) {
            g.setStroke(bs2);
            g.drawLine(this.get2dPointX(1), this.get2dPointY(1), this.get2dPointX(2), this.get2dPointY(2));
            g.setStroke(bs1);
        }
        if (this.HiddenPoint != 1 && this.HiddenPoint != 3) {
            g.drawLine(this.get2dPointX(1), this.get2dPointY(1), this.get2dPointX(3), this.get2dPointY(3));
        } else if (Global_Options.showHiddenLines) {
            g.setStroke(bs2);
            g.drawLine(this.get2dPointX(1), this.get2dPointY(1), this.get2dPointX(3), this.get2dPointY(3));
            g.setStroke(bs1);
        }
        if (this.HiddenPoint != 4 && this.HiddenPoint != 2) {
            g.drawLine(this.get2dPointX(2), this.get2dPointY(2), this.get2dPointX(4), this.get2dPointY(4));
        } else if (Global_Options.showHiddenLines) {
            g.setStroke(bs2);
            g.drawLine(this.get2dPointX(2), this.get2dPointY(2), this.get2dPointX(4), this.get2dPointY(4));
            g.setStroke(bs1);
        }
        if (this.HiddenPoint != 4 && this.HiddenPoint != 3) {
            g.drawLine(this.get2dPointX(4), this.get2dPointY(4), this.get2dPointX(3), this.get2dPointY(3));
        } else if (Global_Options.showHiddenLines) {
            g.setStroke(bs2);
            g.drawLine(this.get2dPointX(4), this.get2dPointY(4), this.get2dPointX(3), this.get2dPointY(3));
            g.setStroke(bs1);
        }
        if (this.HiddenPoint != 1 && this.HiddenPoint != 5) {
            g.drawLine(this.get2dPointX(1), this.get2dPointY(1), this.get2dPointX(5), this.get2dPointY(5));
        } else if (Global_Options.showHiddenLines) {
            g.setStroke(bs2);
            g.drawLine(this.get2dPointX(1), this.get2dPointY(1), this.get2dPointX(5), this.get2dPointY(5));
            g.setStroke(bs1);
        }
        if (this.HiddenPoint != 2 && this.HiddenPoint != 6) {
            g.drawLine(this.get2dPointX(2), this.get2dPointY(2), this.get2dPointX(6), this.get2dPointY(6));
        } else if (Global_Options.showHiddenLines) {
            g.setStroke(bs2);
            g.drawLine(this.get2dPointX(2), this.get2dPointY(2), this.get2dPointX(6), this.get2dPointY(6));
            g.setStroke(bs1);
        }
        if (this.HiddenPoint != 5 && this.HiddenPoint != 6) {
            g.drawLine(this.get2dPointX(5), this.get2dPointY(5), this.get2dPointX(6), this.get2dPointY(6));
        } else if (Global_Options.showHiddenLines) {
            g.setStroke(bs2);
            g.drawLine(this.get2dPointX(5), this.get2dPointY(5), this.get2dPointX(6), this.get2dPointY(6));
            g.setStroke(bs1);
        }
        if (this.HiddenPoint != 4 && this.HiddenPoint != 8) {
            g.drawLine(this.get2dPointX(4), this.get2dPointY(4), this.get2dPointX(8), this.get2dPointY(8));
        } else if (Global_Options.showHiddenLines) {
            g.setStroke(bs2);
            g.drawLine(this.get2dPointX(4), this.get2dPointY(4), this.get2dPointX(8), this.get2dPointY(8));
            g.setStroke(bs1);
        }
        if (this.HiddenPoint != 6 && this.HiddenPoint != 8) {
            g.drawLine(this.get2dPointX(6), this.get2dPointY(6), this.get2dPointX(8), this.get2dPointY(8));
        } else if (Global_Options.showHiddenLines) {
            g.setStroke(bs2);
            g.drawLine(this.get2dPointX(6), this.get2dPointY(6), this.get2dPointX(8), this.get2dPointY(8));
            g.setStroke(bs1);
        }
        if (this.HiddenPoint != 3 && this.HiddenPoint != 7) {
            g.drawLine(this.get2dPointX(3), this.get2dPointY(3), this.get2dPointX(7), this.get2dPointY(7));
        } else if (Global_Options.showHiddenLines) {
            g.setStroke(bs2);
            g.drawLine(this.get2dPointX(3), this.get2dPointY(3), this.get2dPointX(7), this.get2dPointY(7));
            g.setStroke(bs1);
        }
        if (this.HiddenPoint != 7 && this.HiddenPoint != 8) {
            g.drawLine(this.get2dPointX(7), this.get2dPointY(7), this.get2dPointX(8), this.get2dPointY(8));
        } else if (Global_Options.showHiddenLines) {
            g.setStroke(bs2);
            g.drawLine(this.get2dPointX(7), this.get2dPointY(7), this.get2dPointX(8), this.get2dPointY(8));
            g.setStroke(bs1);
        }
        if (this.HiddenPoint != 5 && this.HiddenPoint != 7) {
            g.drawLine(this.get2dPointX(5), this.get2dPointY(5), this.get2dPointX(7), this.get2dPointY(7));
        } else if (Global_Options.showHiddenLines) {
            g.setStroke(bs2);
            g.drawLine(this.get2dPointX(5), this.get2dPointY(5), this.get2dPointX(7), this.get2dPointY(7));
            g.setStroke(bs1);
        }
    }
}

