/*
 * Decompiled with CFR 0.152.
 */
package mrcp.graphics;

import java.awt.Graphics2D;
import mrcp.dd.Dicom_Slice;
import mrcp.graphics.Selection_Cube;
import mrcp.tools.Global_Options;
import mrcp.tools.Point3D;
import rad.dicom.dcm.DcmDataObject;

public class Slice_Cube
extends Selection_Cube {
    public byte View = 0;
    public String Angle = "";
    public String Dimension = "";
    public Dicom_Slice ds;
    public float width;
    public float height;
    public float depth;
    public float Volume;
    public float DbAngle;
    private final byte unknown = 0;
    private final byte Tra = 1;
    private final byte Tra_Cor = (byte)2;
    private final byte Tra_Sag = (byte)3;
    private final byte Sag = (byte)4;
    private final byte Sag_Tra = (byte)5;
    private final byte Sag_Cor = (byte)6;
    private final byte Cor = (byte)7;
    private final byte Cor_Tra = (byte)8;
    private final byte Cor_Sag = (byte)9;

    public Slice_Cube(Point3D p) {
        super(p);
    }

    public Slice_Cube(Point3D p1, Point3D p2, Point3D p3, Point3D p4, Point3D p5, Point3D p6, Point3D p7, Point3D p8, Point3D BP) {
        super(p1, p2, p3, p4, p5, p6, p7, p8, BP);
    }

    public void Update(DcmDataObject ddo, String Filename) {
        Dicom_Slice tmp;
        this.ds = tmp = new Dicom_Slice(Filename, ddo);
        if (tmp == null) {
            return;
        }
        if (tmp.isTransversal()) {
            int i = 1;
            while (i <= 8) {
                this.setPoint(i, tmp.getEdges().getPoint(i));
                ++i;
            }
            this.setColor(Global_Options.TransversalColor);
            this.View = tmp.getOrientation();
            this.Angle = Double.toString(tmp.getAngle());
        } else if (tmp.isCoronar()) {
            int i = 1;
            while (i <= 8) {
                this.setPoint(i, tmp.getEdges().getPoint(i));
                ++i;
            }
            this.setColor(Global_Options.CoronarColor);
            this.View = tmp.getOrientation();
            this.Angle = Double.toString(tmp.getAngle());
        } else if (tmp.isSagittal()) {
            int i = 1;
            while (i <= 8) {
                this.setPoint(i, tmp.getEdges().getPoint(i));
                ++i;
            }
            this.setColor(Global_Options.SagittalColor);
            this.View = tmp.getOrientation();
            this.Angle = Double.toString(tmp.getAngle());
        }
        this.DbAngle = tmp.getAngle();
        if (this.Angle.length() > 8) {
            this.Angle = this.Angle.substring(0, 7);
        }
        this.Angle = this.Angle + " Grad";
        this.Angle = "Winkel : " + this.Angle;
        this.width = this.getDistance(this.getPoint(1), this.getPoint(2));
        this.height = this.getDistance(this.getPoint(1), this.getPoint(3));
        this.depth = this.getDistance(this.getPoint(1), this.getPoint(5));
        this.Volume = this.width * this.height * this.depth / 1000.0f;
        this.Dimension = "\nBreite : " + Math.abs(this.width) + "mm  \nH\u00f6he : " + Math.abs(this.height) + "mm  \nTiefe : " + Math.abs(Math.abs(this.depth)) + "mm   \nVolumen : " + Math.abs(this.Volume) + "cm3\n";
    }

    public String View_to_String() {
        switch (this.View) {
            case 1: {
                return "Transversal";
            }
            case 2: {
                return "Transversal nach Coronar gekippt";
            }
            case 3: {
                return "Transversal nach Sagittal gekippt";
            }
            case 4: {
                return "Sagittal";
            }
            case 5: {
                return "Sagittal nach Transversal gekippt";
            }
            case 6: {
                return "Sagittal nach Coronar gekippt";
            }
            case 7: {
                return "Coronar";
            }
            case 8: {
                return "Coronar nach Transversal gekippt ";
            }
            case 9: {
                return "Coronar nach Sagittal gekippt ";
            }
        }
        return "unbekannt";
    }

    public String Coord_to_String() {
        String tmp = "";
        int i = 1;
        while (i <= 8) {
            tmp = tmp + "Punkt : " + Integer.toString(i) + "  ";
            tmp = tmp + "(";
            tmp = Double.toString(this.getPoint(i).getX()).length() > 7 ? tmp + Double.toString(this.getPoint(i).getX()).substring(0, 6) : tmp + Double.toString(this.getPoint(i).getX());
            tmp = Double.toString(this.getPoint(i).getY()).length() > 7 ? tmp + "," + Double.toString(this.getPoint(i).getY()).substring(0, 6) : tmp + "," + Double.toString(this.getPoint(i).getY());
            tmp = Double.toString(this.getPoint(i).getZ()).length() > 7 ? tmp + "," + Double.toString(this.getPoint(i).getZ()).substring(0, 6) : tmp + "," + Double.toString(this.getPoint(i).getZ());
            tmp = tmp + ")\n";
            ++i;
        }
        return tmp;
    }

    public void drawCube(Graphics2D g, float YConstant, float XConstant, float scale) {
        super.drawCube(g, YConstant, XConstant, scale);
    }
}

