/*
 * Decompiled with CFR 0.152.
 */
package mrcp.graphics;

import java.util.Vector;
import mrcp.graphics.Bounding_Cube;
import mrcp.graphics.Cube;
import mrcp.graphics.Selection_Cube;
import mrcp.tools.Global_Options;
import mrcp.tools.Point3D;

public class Update_control {
    public static int Rows = 256;
    public static int Cols = 256;
    public static float Origin_x = -100.0f;
    public static float Origin_y = -100.0f;
    public static float Origin_z = 0.0f;
    public static float Row_x = 1.0f;
    public static float Row_y = 0.0f;
    public static float Row_z = 0.0f;
    public static float Col_x = 0.0f;
    public static float Col_y = 1.0f;
    public static float Col_z = 0.0f;
    public static Point3D Origin = new Point3D(Origin_x, Origin_y, Origin_z);
    public static Point3D RowVec = new Point3D(Row_x, Row_y, Row_z);
    public static Point3D ColVec = new Point3D(Col_x, Col_y, Col_z);
    public static Point3D SliceVec = RowVec.VC_Mult(ColVec);
    public static float width = 200.0f;
    public static float heigth = 200.0f;
    public static float depth = 4.0f;
    public static float RowSpacing = 1.5f;
    public static float ColSpacing = 1.5f;
    public static float SliceThickness = 5.0f;
    public static float slicedist = 0.0f;
    public static int numslices = 1;
    public static int currentSlice = 0;
    public static Vector CubeArray = new Vector();
    public static String Orientation = "";
    public static boolean NewPreView = true;
    public static boolean showAll = false;
    public static int SelectioncubeX = 100;
    public static int SelectioncubeY = 100;
    public static float scale = 0.2f;
    public static float Trans_Z = 0.0f;
    public static float Sag_X = 0.0f;
    public static float Cor_Y = 0.0f;
    public static Bounding_Cube BB = null;
    public static Bounding_Cube IB = null;
    public static int View3D_transX = 0;
    public static int View3D_transY = 0;
    public static Cube DicomQuader = new Cube(new Point3D(Global_Options.MRT_Min_X, Global_Options.MRT_Min_Y, Global_Options.MRT_Min_Z), new Point3D(Global_Options.MRT_Max_X, Global_Options.MRT_Min_Y, Global_Options.MRT_Min_Z), new Point3D(Global_Options.MRT_Min_X, Global_Options.MRT_Max_Y, Global_Options.MRT_Min_Z), new Point3D(Global_Options.MRT_Max_X, Global_Options.MRT_Max_Y, Global_Options.MRT_Min_Z), new Point3D(Global_Options.MRT_Min_X, Global_Options.MRT_Min_Y, Global_Options.MRT_Max_Z), new Point3D(Global_Options.MRT_Max_X, Global_Options.MRT_Min_Y, Global_Options.MRT_Max_Z), new Point3D(Global_Options.MRT_Min_X, Global_Options.MRT_Max_Y, Global_Options.MRT_Max_Z), new Point3D(Global_Options.MRT_Max_X, Global_Options.MRT_Max_Y, Global_Options.MRT_Max_Z), Global_Options.BP);

    public Update_control() {
        DicomQuader.setColor(Global_Options.GlobalCubeColor);
    }

    public static void setSlices() {
        CubeArray.clear();
        CubeArray = new Vector(numslices);
        if (Orientation.compareTo("Transversal") == 0) {
            ColVec = new Point3D(0.0f, 1.0f, 0.0f);
            RowVec = new Point3D(1.0f, 0.0f, 0.0f);
            SliceVec = new Point3D(0.0f, 0.0f, 1.0f);
        }
        if (Orientation.compareTo("Sagittal") == 0) {
            ColVec = new Point3D(0.0f, 0.0f, -1.0f);
            RowVec = new Point3D(0.0f, 1.0f, 0.0f);
            SliceVec = new Point3D(-1.0f, 0.0f, 0.0f);
        }
        if (Orientation.compareTo("Coronar") == 0) {
            ColVec = new Point3D(0.0f, 0.0f, -1.0f);
            RowVec = new Point3D(1.0f, 0.0f, 0.0f);
            SliceVec = new Point3D(0.0f, 1.0f, 0.0f);
        }
        int i = 0;
        while (i < numslices) {
            Selection_Cube sc = new Selection_Cube(new Point3D(Origin.getX(), Origin.getY(), Origin.getZ()), Origin.VC_Add(RowVec.Sk_Mult(width)), Origin.VC_Add(ColVec.Sk_Mult(heigth)), Origin.VC_Add(ColVec.Sk_Mult(heigth)).VC_Add(RowVec.Sk_Mult(width)), Origin.VC_Add(SliceVec.Sk_Mult(depth)), Origin.VC_Add(SliceVec.Sk_Mult(depth)).VC_Add(RowVec.Sk_Mult(width)), Origin.VC_Add(SliceVec.Sk_Mult(depth)).VC_Add(ColVec.Sk_Mult(heigth)), Origin.VC_Add(SliceVec.Sk_Mult(depth)).VC_Add(ColVec.Sk_Mult(heigth)).VC_Add(RowVec.Sk_Mult(width)), Global_Options.BP);
            sc.setColor(Global_Options.SelectionColor);
            Point3D TV = SliceVec.Sk_Mult((float)i * (depth + slicedist));
            sc.translate(TV.getX(), TV.getY(), TV.getZ());
            CubeArray.add(sc);
            ++i;
        }
        Update_control.reset();
    }

    public static Point3D getOrigin() {
        if (CubeArray.size() > currentSlice) {
            float x = ((Selection_Cube)CubeArray.elementAt(currentSlice)).getPoint(1).getX();
            float y = ((Selection_Cube)CubeArray.elementAt(currentSlice)).getPoint(1).getY();
            float z = ((Selection_Cube)CubeArray.elementAt(currentSlice)).getPoint(1).getZ();
            return new Point3D(x, y, z);
        }
        return null;
    }

    public static Selection_Cube getSlice() {
        if (CubeArray.size() > currentSlice) {
            return (Selection_Cube)CubeArray.elementAt(currentSlice);
        }
        return null;
    }

    public static void increment() {
        if (CubeArray.size() > currentSlice + 1 || currentSlice < 0) {
            ++currentSlice;
        }
    }

    public static void decrement() {
        if (currentSlice > 0) {
            --currentSlice;
        }
    }

    public static void translate(float x, float y, float z) {
        int i = 0;
        while (i < CubeArray.size()) {
            ((Selection_Cube)CubeArray.elementAt(i)).translate(x, y, z);
            ++i;
        }
    }

    public static void rotateY(float step) {
        float AvgX = 0.0f;
        float AvgZ = 0.0f;
        int i = 0;
        while (i < CubeArray.size()) {
            Selection_Cube sc = (Selection_Cube)CubeArray.elementAt(i);
            AvgX += sc.getAverageX();
            AvgZ += sc.getAverageZ();
            ++i;
        }
        Update_control.translate(-(AvgX /= (float)CubeArray.size()), 0.0f, -(AvgZ /= (float)CubeArray.size()));
        int q = 0;
        while (q < CubeArray.size()) {
            Selection_Cube sc = (Selection_Cube)CubeArray.elementAt(q);
            int i2 = 1;
            while (i2 <= 8) {
                sc.getPoint(i2).rotateY(step);
                i2 = (byte)(i2 + 1);
            }
            ++q;
        }
        Update_control.translate(AvgX, 0.0f, AvgZ);
        Update_control.reset();
    }

    public static void rotateX(float step) {
        float AvgY = 0.0f;
        float AvgZ = 0.0f;
        int i = 0;
        while (i < CubeArray.size()) {
            Selection_Cube sc = (Selection_Cube)CubeArray.elementAt(i);
            AvgY += sc.getAverageY();
            AvgZ += sc.getAverageZ();
            ++i;
        }
        Update_control.translate(0.0f, -(AvgY /= (float)CubeArray.size()), -(AvgZ /= (float)CubeArray.size()));
        int q = 0;
        while (q < CubeArray.size()) {
            Selection_Cube sc = (Selection_Cube)CubeArray.elementAt(q);
            int i2 = 1;
            while (i2 <= 8) {
                sc.getPoint(i2).rotateX(step);
                i2 = (byte)(i2 + 1);
            }
            Update_control.reset();
            ++q;
        }
        Update_control.translate(0.0f, AvgY, AvgZ);
    }

    public static void rotateZ(float step) {
        float AvgX = 0.0f;
        float AvgY = 0.0f;
        int i = 0;
        while (i < CubeArray.size()) {
            Selection_Cube sc = (Selection_Cube)CubeArray.elementAt(i);
            AvgX += sc.getAverageX();
            AvgY += sc.getAverageY();
            ++i;
        }
        Update_control.translate(-(AvgX /= (float)CubeArray.size()), -(AvgY /= (float)CubeArray.size()), 0.0f);
        int q = 0;
        while (q < CubeArray.size()) {
            Selection_Cube sc = (Selection_Cube)CubeArray.elementAt(q);
            int i2 = 1;
            while (i2 <= 8) {
                sc.getPoint(i2).rotateZ(step);
                i2 = (byte)(i2 + 1);
            }
            ++q;
        }
        Update_control.translate(AvgX, AvgY, 0.0f);
        Update_control.reset();
    }

    public static void translateWidth(float step) {
        int i = 0;
        while (i < CubeArray.size()) {
            ((Selection_Cube)CubeArray.elementAt(i)).translateWidth(step);
            ++i;
        }
        Update_control.reset();
    }

    public static void translateHeigth(float step) {
        int i = 0;
        while (i < CubeArray.size()) {
            ((Selection_Cube)CubeArray.elementAt(i)).translateHeigth(step);
            ++i;
        }
        Update_control.reset();
    }

    public static void translateDepth(float step) {
        int i = 0;
        while (i < CubeArray.size()) {
            ((Selection_Cube)CubeArray.elementAt(i)).translateDepth(step);
            ++i;
        }
        slicedist -= step;
        Update_control.reset();
    }

    public static boolean isLast() {
        return currentSlice == CubeArray.size() - 1;
    }

    public static void reset() {
        if (CubeArray == null || CubeArray.size() <= 0) {
            return;
        }
        Selection_Cube sc = (Selection_Cube)CubeArray.elementAt(0);
        RowVec = sc.getPoint(2).VC_Min(sc.getPoint(1));
        width = RowVec.Length();
        RowVec.norm();
        ColVec = sc.getPoint(3).VC_Min(sc.getPoint(1));
        heigth = ColVec.Length();
        ColVec.norm();
        SliceVec = sc.getPoint(5).VC_Min(sc.getPoint(1));
        depth = SliceVec.Length();
        SliceVec.norm();
        Point3D og = sc.getPoint(1);
        Origin = new Point3D(og.getX(), og.getY(), og.getZ());
        Cols = (int)(width / ColSpacing);
        Rows = (int)(heigth / RowSpacing);
    }
}

