/*
 * Decompiled with CFR 0.152.
 */
package mrcp.gui;

import ij.ImagePlus;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JProgressBar;
import mrcp.graphics.Update_control;
import mrcp.gui.JPanel_Ortho_All;
import mrcp.gui.gui;
import mrcp.tools.Global_Options;
import mrcp.tools.Point3D;

public class JPanel_Ortho_C
extends JPanel_Ortho_All {
    final Point3D SliceVector = new Point3D(0.0f, 1.0f, 0.0f);
    final Point3D RowVector = new Point3D(1.0f, 0.0f, 0.0f);
    final Point3D ColVector = new Point3D(0.0f, 0.0f, -1.0f);
    Point3D Origin = null;

    public JPanel_Ortho_C(gui Document2) {
        super(Document2);
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle rc = g2.getClipBounds();
        g2.clearRect(rc.x, rc.y, rc.width, rc.height);
        if (this.im == null && this.getDocument().slicetree.NumberOfSelectesSeries > 0) {
            this.setImage();
        } else if (this.getDocument().slicetree.NumberOfSelectesSeries == 0) {
            this.im = null;
            return;
        }
        g2.drawImage(this.im, this.Imagex, this.Imagey, this);
        int old = Update_control.currentSlice;
        if (!Update_control.showAll) {
            if (Update_control.getSlice() == null) {
                return;
            }
            Update_control.getSlice().setProjection((byte)6);
            Update_control.getSlice().setCorrectionFactor((float)(-this.im.getHeight(this)) / (this.getDocument().slicetree.MaxZ - this.getDocument().slicetree.MinZ));
            Update_control.getSlice().drawCube(g2, (float)this.Imagey + this.getDocument().slicetree.MaxZ * (float)this.im.getHeight(this) / (this.getDocument().slicetree.MaxZ - this.getDocument().slicetree.MinZ), (float)this.Imagex - this.Origin.getX() * (float)this.im.getWidth(this) / (this.getDocument().slicetree.MaxX - this.getDocument().slicetree.MinX), (float)this.im.getWidth(this) / (this.getDocument().slicetree.MaxX - this.getDocument().slicetree.MinX));
        } else {
            Update_control.currentSlice = -1;
            do {
                Update_control.increment();
                if (Update_control.getSlice() == null) {
                    return;
                }
                if (Update_control.currentSlice == old) {
                    Update_control.getSlice().setColor(Global_Options.CurrentSliceColor);
                }
                Update_control.getSlice().setProjection((byte)6);
                Update_control.getSlice().setCorrectionFactor((float)(-this.im.getHeight(this)) / (this.getDocument().slicetree.MaxZ - this.getDocument().slicetree.MinZ));
                Update_control.getSlice().drawCube(g2, (float)this.Imagey + this.getDocument().slicetree.MaxZ * (float)this.im.getHeight(this) / (this.getDocument().slicetree.MaxZ - this.getDocument().slicetree.MinZ), (float)this.Imagex - this.Origin.getX() * (float)this.im.getWidth(this) / (this.getDocument().slicetree.MaxX - this.getDocument().slicetree.MinX), (float)this.im.getWidth(this) / (this.getDocument().slicetree.MaxX - this.getDocument().slicetree.MinX));
                Update_control.getSlice().setColor(Global_Options.SelectionColor);
            } while (!Update_control.isLast());
            Update_control.currentSlice = old;
        }
    }

    public void setImage() {
        this.Origin = new Point3D(this.getDocument().slicetree.MinX, Update_control.Cor_Y, this.getDocument().slicetree.MaxZ);
        float Imagewidth = this.getDocument().slicetree.MaxX - this.getDocument().slicetree.MinX;
        float Imageheigth = this.getDocument().slicetree.MaxZ - this.getDocument().slicetree.MinZ;
        if (Imagewidth > 192.0f) {
            this.factor = 192.0f / Imagewidth;
            Imagewidth *= this.factor;
            Imageheigth *= this.factor;
        }
        if (Imageheigth > 192.0f) {
            this.factor = 192.0f / Imageheigth;
            Imagewidth *= this.factor;
            Imageheigth *= this.factor;
        }
        this.RowSpacing = (this.getDocument().slicetree.MaxX - this.getDocument().slicetree.MinX) / Imagewidth;
        this.ColSpacing = (this.getDocument().slicetree.MaxZ - this.getDocument().slicetree.MinZ) / Imageheigth;
        this.factor = 1.0f / this.RowSpacing;
        this.Imagex = (int)(192.0f - Imagewidth) / 2;
        this.Imagey = (int)(192.0f - Imageheigth) / 2;
        this.getDocument().slicetree.setSelectedSeries();
        JProgressBar bar = this.Document.jProgressBar_Adjustment;
        bar.setMinimum(0);
        bar.setMaximum((int)Imageheigth);
        short[][] Pixels = this.getDocument().slicetree.getSlices_2(this.Origin, this.RowVector, this.ColVector, this.SliceVector, this.RowSpacing, this.ColSpacing, 5.0f, (int)Imageheigth, (int)Imagewidth, bar, 1, Update_control.slicedist);
        ShortProcessor proc = new ShortProcessor((int)Imagewidth, (int)Imageheigth, Pixels[0], this.cModel, false);
        ImagePlus imp = new ImagePlus("", (ImageProcessor)proc);
        this.autoAdjust(imp, (ImageProcessor)proc);
        this.im = proc.createImage();
    }
}

