/*
 * Decompiled with CFR 0.152.
 */
package mrcp.tools;

import ij.IJ;
import mrcp.LineareAlgebra.Blas_j;
import mrcp.LineareAlgebra.Cholesky;
import mrcp.LineareAlgebra.LU_j;
import mrcp.tools.Point3D;

public final class MathTools {
    public static Point3D Nullvector = new Point3D(0.0f, 0.0f, 0.0f);
    public static double[][] Matrix3_3 = new double[][]{{1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, {1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0}, {1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
    public static double[][] Matrix2_2 = new double[][]{{1.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 1.0}, {1.0, 0.0, 1.0, 0.0}, {0.0, 1.0, 0.0, 1.0}, {1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};

    public static float round_db(float x) {
        return Math.round(x);
    }

    public static int floor(float x) {
        return (int)Math.floor(x);
    }

    public static int ceil(float x) {
        return (int)Math.ceil(x);
    }

    public static int round(float x) {
        return Math.round(x);
    }

    public static boolean equal(float x, float y, float eps) {
        return Math.abs(x - y) < eps;
    }

    public static float LI2(float val1, float val2, float XFactor) {
        return val1 + (val2 - val1) * XFactor;
    }

    public static float Lagrange(int[] values, float XVal) {
        int n = values.length;
        float val = 0.0f;
        int j = 0;
        while (j < n) {
            float Beta = 1.0f;
            int i = 0;
            while (i < n) {
                if (i != j) {
                    Beta *= (XVal - (float)i) / (float)(j - i);
                }
                ++i;
            }
            val += Beta * (float)values[j];
            ++j;
        }
        return val;
    }

    public static float Lagrange(float[] values, float XVal) {
        int n = values.length;
        float val = 0.0f;
        int j = 0;
        while (j < n) {
            float Beta = 1.0f;
            int i = 0;
            while (i < n) {
                if (i != j) {
                    Beta *= (XVal - (float)i) / (float)(j - i);
                }
                ++i;
            }
            val += Beta * values[j];
            ++j;
        }
        return val;
    }

    public static float KubicSpline(int[] values, float dist, float XVal) {
        float y1 = 3.0f / dist * (float)(values[2] - 2 * values[1] + values[0]);
        float y2 = 3.0f / dist * (float)(values[3] - 2 * values[2] + values[1]);
        float c2 = (y2 - 0.25f * y1) / (3.75f * dist);
        float c1 = (y1 - dist * c2) / (4.0f * dist);
        float d1 = 1.0f / (3.0f * dist) * (c2 - c1);
        float b1 = 1.0f / dist * (float)(values[2] - values[1]) - dist / 3.0f * (c2 + 2.0f * c1);
        return (float)values[1] + b1 * XVal + c1 * (XVal * XVal) + d1 * (XVal * XVal * XVal);
    }

    public static float KubicSpline(float[] values, float dist, float XVal) {
        float y1 = 3.0f / dist * (values[2] - 2.0f * values[1] + values[0]);
        float y2 = 3.0f / dist * (values[3] - 2.0f * values[2] + values[1]);
        float c2 = (y2 - 0.25f * y1) / (3.75f * dist);
        float c1 = (y1 - dist * c2) / (4.0f * dist);
        float d1 = 1.0f / (3.0f * dist) * (c2 - c1);
        float b1 = 1.0f / dist * (values[2] - values[1]) - dist / 3.0f * (c2 + 2.0f * c1);
        return values[1] + b1 * XVal + c1 * (XVal * XVal) + d1 * (XVal * XVal * XVal);
    }

    public static float KubicSpline2(int n, float dist, float[] y, float x0) {
        float[] a = new float[--n + 1];
        float[] b = new float[n + 1];
        float[] c = new float[n + 1];
        float[] d = new float[n + 1];
        float[] h = new float[n + 1];
        int i = 0;
        while (i <= n - 1) {
            h[i] = dist;
            ++i;
        }
        int i2 = 0;
        while (i2 <= n - 2) {
            a[i2] = 3.0f * ((y[i2 + 2] - y[i2 + 1]) / h[i2 + 1] - (y[i2 + 1] - y[i2]) / h[i2]);
            b[i2] = h[i2];
            c[i2] = h[i2 + 1];
            d[i2] = 2.0f * (h[i2] + h[i2 + 1]);
            ++i2;
        }
        MathTools.trdiag(n - 1, b, d, c, a, 0);
        int i3 = 0;
        while (i3 <= n - 2) {
            c[i3 + 1] = a[i3];
            ++i3;
        }
        c[0] = 0.0f;
        c[n] = 0.0f;
        int i4 = 0;
        while (i4 <= n - 1) {
            b[i4] = (y[i4 + 1] - y[i4]) / h[i4] - h[i4] * (c[i4 + 1] + 2.0f * c[i4]) / 3.0f;
            d[i4] = (c[i4 + 1] - c[i4]) / (3.0f * h[i4]);
            ++i4;
        }
        int i5 = (int)x0;
        return ((d[i5] * (x0 -= (float)i5) + c[i5]) * x0 + b[i5]) * x0 + y[i5];
    }

    public static float KubicSpline2(int n, float dist, int[] y, float x0) {
        float[] a = new float[--n + 1];
        float[] b = new float[n + 1];
        float[] c = new float[n + 1];
        float[] d = new float[n + 1];
        float[] h = new float[n + 1];
        int i = 0;
        while (i <= n - 1) {
            h[i] = dist;
            ++i;
        }
        int i2 = 0;
        while (i2 <= n - 2) {
            a[i2] = 3.0f * ((float)(y[i2 + 2] - y[i2 + 1]) / h[i2 + 1] - (float)(y[i2 + 1] - y[i2]) / h[i2]);
            b[i2] = h[i2];
            c[i2] = h[i2 + 1];
            d[i2] = 2.0f * (h[i2] + h[i2 + 1]);
            ++i2;
        }
        MathTools.trdiag(n - 1, b, d, c, a, 0);
        int i3 = 0;
        while (i3 <= n - 2) {
            c[i3 + 1] = a[i3];
            ++i3;
        }
        c[0] = 0.0f;
        c[n] = 0.0f;
        int i4 = 0;
        while (i4 <= n - 1) {
            b[i4] = (float)(y[i4 + 1] - y[i4]) / h[i4] - h[i4] * (c[i4 + 1] + 2.0f * c[i4]) / 3.0f;
            d[i4] = (c[i4 + 1] - c[i4]) / (3.0f * h[i4]);
            ++i4;
        }
        int i5 = (int)x0;
        return ((d[i5] * (x0 -= (float)i5) + c[i5]) * x0 + b[i5]) * x0 + (float)y[i5];
    }

    public static void trdiag(int n, float[] lower, float[] diag, float[] upper, float[] b, int rep) {
        int i = 1;
        while (i < n) {
            int n2 = i;
            lower[n2] = lower[n2] / diag[i - 1];
            int n3 = i;
            diag[n3] = diag[n3] - lower[i] * upper[i - 1];
            ++i;
        }
        int i2 = 1;
        while (i2 < n) {
            int n4 = i2;
            b[n4] = b[n4] - lower[i2] * b[i2 - 1];
            ++i2;
        }
        int n5 = n - 1;
        b[n5] = b[n5] / diag[n - 1];
        int i3 = n - 2;
        while (i3 >= 0) {
            b[i3] = (b[i3] - upper[i3] * b[i3 + 1]) / diag[i3];
            --i3;
        }
    }

    public static int getWeigth(int n, int global_n) {
        if (n == 0 || n == 2 * global_n) {
            return 1;
        }
        if (n % 2 == 0) {
            return 2;
        }
        return 4;
    }

    public static double[] solveLinEqu(double[][] a, double[] b, int n, int p) {
        double[][] at = new double[p][n];
        Blas_j.mattran_j(a, at, n, p);
        double[][] c = new double[p][p];
        Blas_j.matmat_j(at, a, c, p, n, p);
        double[] d = new double[p];
        Blas_j.matvec_j(at, b, d, p, n);
        Cholesky chol = new Cholesky();
        try {
            chol.solvePosDef(c, d, new double[p], p, false);
        }
        catch (Exception e) {
            IJ.write((String)" Not pos definet error ");
            int[] ipvt = new int[p];
            try {
                LU_j.dgefa_j(c, p, ipvt);
                LU_j.dgesl_j(c, p, ipvt, b, 0);
            }
            catch (Exception ep) {
                IJ.write((String)" Not Gausl\u00f6sbar ");
                return null;
            }
            return b;
        }
        return d;
    }

    public static float Exp(float Basis, int Exponent) {
        if (Exponent == 0) {
            return 1.0f;
        }
        float val = Basis;
        int i = 0;
        while (i < Exponent - 1) {
            val *= val;
            ++i;
        }
        return val;
    }

    public static Point3D calcIntersection_GP(Point3D go, Point3D gm, Point3D eo, Point3D em) {
        if (gm.VC_SK_Mult(em) == 0.0f) {
            return null;
        }
        Point3D tmp = go.VC_Min(eo);
        float r0 = gm.VC_SK_Mult(em);
        float r1 = tmp.VC_SK_Mult(em);
        float r = -r1 / r0;
        return go.VC_Add(gm.Sk_Mult(r));
    }

    public static void calcIntersection_PP(Point3D eo, Point3D em, Point3D o, Point3D v1, Point3D v2, Point3D go, Point3D gm) {
        if (em.VC_SK_Mult(v1) == 0.0f && em.VC_SK_Mult(v2) == 0.0f) {
            gm = null;
            go = null;
            return;
        }
        Point3D tmp = o.VC_Min(eo);
        float a = tmp.VC_SK_Mult(em);
        float r = v1.VC_SK_Mult(em);
        float s = v2.VC_SK_Mult(em);
        if (s != 0.0f) {
            go.set(o.VC_Add(v2.Sk_Mult(-(a /= s))));
            gm.set(v1.VC_Add(v2.Sk_Mult(-(r /= s))));
        } else {
            go.set(o.VC_Add(v1.Sk_Mult(-(a /= r))));
            gm.set(v2.VC_Add(v1.Sk_Mult(-(s /= r))));
        }
    }

    public static void copyMatrix(double[][] a, double[][] b) {
        int rows = a.length;
        int cols = a[0].length;
        int i = 0;
        while (i < rows) {
            int n = 0;
            while (n < cols) {
                b[i][n] = a[i][n];
                ++n;
            }
            ++i;
        }
    }
}

