/*
 * Decompiled with CFR 0.152.
 */
package mrcp.tools;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import mrcp.dd.Dicom_Slice;
import mrcp.ddd.Slice_Leaf;

public class MyRenderer
extends DefaultTreeCellRenderer {
    ImageIcon Tra_Icon;
    ImageIcon Tra_Ser_Icon;
    ImageIcon DDD_Icon;
    ImageIcon Sag_Icon;
    ImageIcon Sagital_Ser_Icon;
    ImageIcon Cor_Icon;
    ImageIcon Cor_Ser_Icon;

    public MyRenderer() {
        String path = System.getProperty("user.dir");
        path = path + System.getProperty("file.separator");
        this.DDD_Icon = new ImageIcon(path + "Resource/ddd.gif");
        this.Tra_Icon = new ImageIcon(path + "Resource/Transversal_Icon.gif");
        this.Tra_Ser_Icon = new ImageIcon(path + "Resource/Transversal_Ser_Icon.gif");
        this.Sag_Icon = new ImageIcon(path + "Resource/Sagital.gif");
        this.Sagital_Ser_Icon = new ImageIcon(path + "Resource/Sagital_Ser.gif");
        this.Cor_Icon = new ImageIcon(path + "Resource/Coronar_Icon.gif");
        this.Cor_Ser_Icon = new ImageIcon(path + "Resource/Coronar_Ser_Icon.gif");
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object object = node.getUserObject();
        String classname = object.getClass().getName();
        if (classname.compareTo("java.lang.String") == 0) {
            this.setIcon(this.DDD_Icon);
            return this;
        }
        if (classname.indexOf("Series_Node") > 0) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getFirstChild();
            Slice_Leaf sl = (Slice_Leaf)child.getUserObject();
            Dicom_Slice ds = sl.cube.ds;
            if (ds.isSagittal()) {
                this.setIcon(this.Sagital_Ser_Icon);
            } else if (ds.isCoronar()) {
                this.setIcon(this.Cor_Ser_Icon);
            } else if (ds.isTransversal()) {
                this.setIcon(this.Tra_Ser_Icon);
            }
            return this;
        }
        if (leaf) {
            Slice_Leaf Sleaf = (Slice_Leaf)object;
            if (Sleaf.cube.ds.isSagittal()) {
                this.setIcon(this.Sag_Icon);
            } else if (Sleaf.cube.ds.isCoronar()) {
                this.setIcon(this.Cor_Icon);
            } else if (Sleaf.cube.ds.isTransversal()) {
                this.setIcon(this.Tra_Icon);
            }
            return this;
        }
        return this;
    }
}

