/*
 * Decompiled with CFR 0.152.
 */
package mrcp.tools;

import mrcp.tools.Global_Options;
import mrcp.tools.MathTools;

public class Point3D {
    float x;
    float y;
    float z;

    public Point3D(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void translate(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(Point3D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public void translate(Point3D p) {
        this.x += p.x;
        this.y += p.y;
        this.z += p.z;
    }

    public Point3D translate_copy(Point3D p) {
        return new Point3D(this.x + p.x, this.y + p.y, this.z + p.z);
    }

    public void rotateY(float Grad) {
        float xnew = (float)((double)this.z * Math.sin(Grad * 0.01745333f) + (double)this.x * Math.cos(Grad * 0.01745333f));
        float znew = (float)((double)this.z * Math.cos(Grad * 0.01745333f) - (double)this.x * Math.sin(Grad * 0.01745333f));
        this.x = xnew;
        this.z = znew;
    }

    public void rotateX(float Grad) {
        float ynew = (float)((double)this.y * Math.cos(Grad * 0.01745333f) - (double)this.z * Math.sin(Grad * 0.01745333f));
        float znew = (float)((double)this.y * Math.sin(Grad * 0.01745333f) + (double)this.z * Math.cos(Grad * 0.01745333f));
        this.y = ynew;
        this.z = znew;
    }

    public void rotateZ(float Grad) {
        float xnew = (float)((double)this.x * Math.cos(Grad * 0.01745333f) - (double)this.y * Math.sin(Grad * 0.01745333f));
        float ynew = (float)((double)this.x * Math.sin(Grad * 0.01745333f) + (double)this.y * Math.cos(Grad * 0.01745333f));
        this.x = xnew;
        this.y = ynew;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public Point3D Sk_Mult(float fac) {
        return new Point3D(this.getX() * fac, this.getY() * fac, this.getZ() * fac);
    }

    public float VC_SK_Mult(Point3D p2) {
        return this.getX() * p2.getX() + this.getY() * p2.getY() + this.getZ() * p2.getZ();
    }

    public Point3D VC_Add(Point3D Vec) {
        return new Point3D(this.getX() + Vec.getX(), this.getY() + Vec.getY(), this.getZ() + Vec.getZ());
    }

    public void VC_Add2(Point3D Vec) {
        this.x += Vec.getX();
        this.y += Vec.getY();
        this.z += Vec.getZ();
    }

    public Point3D VC_Min(Point3D Vec) {
        return new Point3D(this.getX() - Vec.getX(), this.getY() - Vec.getY(), this.getZ() - Vec.getZ());
    }

    public Point3D VC_Mult(Point3D Vec) {
        return new Point3D(this.getY() * Vec.getZ() - this.getZ() * Vec.getY(), this.getZ() * Vec.getX() - this.getX() * Vec.getZ(), this.getX() * Vec.getY() - this.getY() * Vec.getX());
    }

    public void norm() {
        float fac = this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ();
        fac = (float)Math.sqrt(1.0f / fac);
        this.x = this.getX() * fac;
        this.y = this.getY() * fac;
        this.z = this.getZ() * fac;
    }

    public float square() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ();
    }

    public float Length() {
        return (float)Math.sqrt(this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ());
    }

    public boolean equal(Point3D p) {
        float eps = Global_Options.eps;
        boolean result = MathTools.equal(Math.abs(this.getX()), Math.abs(p.getX()), eps) && MathTools.equal(Math.abs(this.getY()), Math.abs(p.getY()), eps) && MathTools.equal(Math.abs(this.getZ()), Math.abs(p.getZ()), eps);
        return result;
    }

    public String toString() {
        String temp = "";
        temp = temp + Double.toString(this.x);
        temp = temp + "; ";
        temp = temp + Double.toString(this.y);
        temp = temp + "; ";
        temp = temp + Double.toString(this.z);
        return temp;
    }
}

