/*
 * Decompiled with CFR 0.152.
 */
package mrcp.tools;

import ij.IJ;
import mrcp.tools.Point3D;

public class Vektor3DPoint {
    public Point3D[] Quader = new Point3D[8];

    public Vektor3DPoint(Point3D p1, Point3D p2, Point3D p3, Point3D p4, Point3D p5, Point3D p6, Point3D p7, Point3D p8) {
        this.setPoint(1, p1);
        this.setPoint(2, p2);
        this.setPoint(3, p3);
        this.setPoint(4, p4);
        this.setPoint(5, p5);
        this.setPoint(6, p6);
        this.setPoint(7, p7);
        this.setPoint(8, p8);
    }

    public Vektor3DPoint() {
        this.setPoint(1, new Point3D(0.0f, 0.0f, 0.0f));
        this.setPoint(2, new Point3D(0.0f, 0.0f, 0.0f));
        this.setPoint(3, new Point3D(0.0f, 0.0f, 0.0f));
        this.setPoint(4, new Point3D(0.0f, 0.0f, 0.0f));
        this.setPoint(5, new Point3D(0.0f, 0.0f, 0.0f));
        this.setPoint(6, new Point3D(0.0f, 0.0f, 0.0f));
        this.setPoint(7, new Point3D(0.0f, 0.0f, 0.0f));
        this.setPoint(8, new Point3D(0.0f, 0.0f, 0.0f));
    }

    public Point3D getPoint(int number) {
        try {
            return this.Quader[number - 1];
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public void setPoint(int number, Point3D p) {
        try {
            this.Quader[number - 1] = p;
        }
        catch (Exception e) {
            IJ.error((String)"IndexOutOfBoundsException in getPoint");
            return;
        }
    }

    public Point3D add(Point3D p1, Point3D p2, Point3D p3, Point3D p4) {
        return p1.VC_Add(p2).VC_Add(p3).VC_Add(p4);
    }

    public Point3D sub(Point3D p1, Point3D p2) {
        return p1.VC_Add(p2.Sk_Mult(-1.0f));
    }

    public float getDistance(Point3D p1, Point3D p2) {
        return (float)Math.sqrt((p1.getX() - p2.getX()) * (p1.getX() - p2.getX()) + (p1.getY() - p2.getY()) * (p1.getY() - p2.getY()) + (p1.getZ() - p2.getZ()) * (p1.getZ() - p2.getZ()));
    }

    public void translate(float x, float y, float z) {
        int i = 0;
        while (i < 8) {
            this.Quader[i].translate(x, y, z);
            ++i;
        }
    }

    public Point3D getMid() {
        float z = 0.0f;
        float y = 0.0f;
        float x = 0.0f;
        int i = 0;
        while (i < 8) {
            x += this.Quader[i].getX();
            y += this.Quader[i].getY();
            z += this.Quader[i].getZ();
            ++i;
        }
        Point3D mid = new Point3D(x / 8.0f, y / 8.0f, z / 8.0f);
        return mid;
    }
}

