/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * Copyright (C) 2000 Thomas Hacklaender, e-mail: reply@thomas-hacklaender.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.gnu.org/copyleft/copyleft.html
 */
package rad.ijplugin.dcm;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import rad.dicom.dcm.*;
import rad.ijplugin.util.*;


/**
 * Dieses Panel dient zum Dumpen eines <code>DcmDataObjects</code>. Die einzelnen
 * DICOM Elemente werden in einer String-Darstellung in einem Textfeld
 * Dargestellt. Der Anwender kann zwischen zwei Darstellungen waehlen:
 * Einer Uebersicht, in der nur die im Dictionary <code>DcmDDE</code> definierten
 * Elemente angezeigt werden und einer Ansicht, bei der alle Elemente
 * gezeigt werden. In der Overview-Darstellung erscheint nur der
 * Elementname und der Inhalt des Elementes. In der Detail-Darstellung
 * wird auch die Gruppennummer, Elementnummer, VT und Laenge des Elementes
 * dargestellt.
 * <DL><DT><B>Modifications: </B><DD>
 * Thomas Hacklaender 2000.11.13:
 * "Details" listet jetzt auch den Inhalt des File Meta Information Blocks.<br>
 * Thomas Hacklaender 2000.8.22:
 * Copyright Mitteilung geloescht.<br>
 * </DD></DL>
 * @author   Thomas Hacklaender
 * @version  2000.08.22
 */
public class DumpPanel extends JPanel {

	/*
	 * Dieses Directory wird als Voreinstellung des JFileChoosers der
	 * Methode save verwendet.
	 */
	private File	outputDir;

	/* Allgemeine Felder fuer die grafische Darstellung */
	JTabbedPane		tabbedPane = new JTabbedPane();
	JScrollPane		overviewJScrollPane = new JScrollPane();
	JScrollPane		detailsJScrollPane = new JScrollPane();
	JTextArea			overviewText = new JTextArea();
	JButton				saveBtn = new JButton();
	JTextArea			detailsText = new JTextArea();
	GridBagLayout gridBagLayout1 = new GridBagLayout();


	/**
	 * Es wird eine neue Instanz des Panels generiert.
	 * @param outD  Voreinstellung fuer ein Directory, in das die Methode
	 * <code>save</code> eine Textdarstellung abspeichern kann.
	 */
	public DumpPanel(File outD) {

		outputDir = outD;

		try {
			jbInit();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}


	/**
	 * Durch Aufruf dieser Methode wird das Panel generiert. Der Anwender
	 * hat dann interaktiv die Moeglichkeit, zwischen den zwei
	 * Darstellungsformen zu waehlen.
	 * @param orgDDO  Das DcmDataObject, das analysiert werden soll.
	 */
	public void processDcmDataObject(DcmDataObject orgDDO) throws Exception {
    processDcmDataObject(null, orgDDO);
  }


	/**
	 * Durch Aufruf dieser Methode wird das Panel generiert. Der Anwender
	 * hat dann interaktiv die Moeglichkeit, zwischen den zwei
	 * Darstellungsformen zu waehlen.
	 * @param metaDDO Das File Meta Information DcmDataObject
	 * @param orgDDO  Das DcmDataObject, das analysiert werden soll
	 */
	public void processDcmDataObject(DcmDataObject metaDDO, DcmDataObject orgDDO) throws Exception {
		String				ovStr = "";
		String				trStr = "";
		String				deStr = "";
		int						dd_type;
		int						typeCode;
		String				typeCodeName;
		String				description;
		DcmDataObject ddo = new DcmDataObject();
		DcmValue			vr;

		if (orgDDO == null) {
			throw new Exception("processDICOMDataObject: Not a DICOM Data Object");
		} else {
			ddo = orgDDO.getCopyOfMe();
		}

		while ((vr = ddo.pop()) != null) {
			dd_type = vr.getType();
			if (dd_type != DcmDDE.VRCODE_UNDEFINED) {
				ovStr += vr.toString(true, 28, false, 256, true) + "\n";
			}
		}

		if (orgDDO.getEncoding() == DcmDataObject.LITTLE_ENDIAN) {
			trStr += "LITTLE_ENDIAN\n";
		} else {
			trStr += "BIG_ENDIAN\n";
		}
		if (orgDDO.getStructure() == DcmDataObject.EXPLICITE_VR) {
			trStr += "EXPLICITE_VR\n";
		} else {
			trStr += "IMPLICITE_VR\n";
		}
		if (orgDDO.getStorage() == DcmDataObject.META_STORAGE) {
			trStr += "META_STORAGE\n";
		  if (metaDDO != null) {
        trStr += "\nFile Meta Information:\n" + metaDDO.getCopyOfMe().toString() + "\nDICM\n";
		  }
		} else {
			trStr += "PLAIN_STORAGE\n";
		}
		trStr += "\n";

		overviewText.setText(ovStr);
		detailsText.setText(trStr + orgDDO.toString());
	}


	/**
	 * Gibt den Text der Overview-Darstellung zurueck.
	 * @return  Der Overview-Text.
	 */
	public String getOverviewText() {
		return overviewText.getText();
	}


	/**
	 * Gibt den Text der Detail-Darstellung zurueck.
	 * @return  Der Detail-Text.
	 */
	public String getDetailsText() {
		return detailsText.getText();
	}


	/**
	 * Erlaubt die Speicherung des aktuell auf dem Panel ausgewaehlten
	 * Textes in einer Datei. Dazu wird dem Anwender ein Swing
	 * <code>JFileChooser</code>.
	 * praesentiert.
	 * @exception   I/O Exception.
	 */
	public void save() throws Exception {
		File							f;
		DataOutputStream	out;
		String						theText;
		String						fName;

		Component					c = tabbedPane.getSelectedComponent();

		if (c == overviewJScrollPane) {
			theText = getOverviewText();
			fName = "DICOM_Dump_Overview.txt";
		} else {
			theText = getDetailsText();
			fName = "DICOM_Dump_Details.txt";
		}

		JFileChooser	chooser = new JFileChooser();

		chooser.setDialogTitle("Save Dump...");
		if (outputDir != null) {
			chooser.setCurrentDirectory(outputDir);
		}
		chooser.setSelectedFile(new File(fName));
		chooser.showSaveDialog(this);
		f = chooser.getSelectedFile();
		if (f == null) {
			return;

		}
		try {
			out = new DataOutputStream(new FileOutputStream(f));
			out.writeBytes(theText);
			out.close();
		} catch (IOException ex) {
			ex.printStackTrace();
			throw new Exception("DumpPanel.save: Can't write output-file");
		}
	}


	/**
	 * Von JBuilder automatisch generierte Action-Mmethode fuer den
	 * saveBtn. Wird der Button gedrueck, wird die save Methode aufgerufen.
	 * @param   e   Das Action Event.
	 */
	void saveBtn_actionPerformed(ActionEvent e) {
		try {
			save();
		} catch (Exception err) {
			Util.showErrorDialog(err.getMessage());
			;
		}
	}


	/**
	 * Von JBuilder automatisch generierte Initialisierungsmethode fuer die
	 * grafischen Elemente.
	 */
	void jbInit() throws Exception {
		this.setMinimumSize(new Dimension(620, 450));
		this.setPreferredSize(new Dimension(620, 450));
		saveBtn.setText("Save as Text");
		saveBtn.addActionListener(new java.awt.event.ActionListener() {
			/**
			 */
			public void actionPerformed(ActionEvent e) {
				saveBtn_actionPerformed(e);
			}

		});
		this.setLayout(gridBagLayout1);
		overviewJScrollPane.getViewport();
		overviewText.setFont(new java.awt.Font("Monospaced", 0, 12));
		detailsText.setFont(new java.awt.Font("Monospaced", 0, 12));
		overviewJScrollPane.getViewport().add(overviewText, null);
		detailsJScrollPane.getViewport().add(detailsText, null);
		tabbedPane.addTab("Overview", overviewJScrollPane);
		tabbedPane.addTab("Details", detailsJScrollPane);
		this.add(tabbedPane, new GridBagConstraints2(0, 0, 2, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 391, 221));
		this.add(saveBtn, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 0, 0, 0), 0, 0));
	}


}











/*--- formatting done in "My Own Convention" style on 04-30-2000 ---*/

