/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * Copyright (C) 2000 Thomas Hacklaender, e-mail: reply@thomas-hacklaender.de
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * http://www.gnu.org/copyleft/copyleft.html
 */
package rad.ijplugin.dcm;


import java.io.*;
import java.util.*;

import rad.dicom.dcm.*;
import rad.dicom.ima.*;


/**
 * Diese Klasse ist der Datenblock des Export-Plugins zum
 * Austausch der Daten zwischen dem eigentlichen Export-Plugin
 * und der Dialogbox <code>ExportPanel</code>, sowie dessen Unter-Panels.
 * Die Felder werden zunaechst mit den Werten der Klassendefinition vorbesetzt.
 * Anschliessend wir nach der Properties-Datei <code>Util.PROPERTY_FILE_NAME</code>
 * gesucht.Wird diese gefunden, dann werden die Felder:
 * <ul>
 * <li> inputDir </li>
 * <li> outputDir </li>
 * <li> encoding </li>
 * <li> structure </li>
 * <li> storage </li>
 * <li> fileNameToSave </li>
 * <li> fileNameSuffix </li></ul>
 * mit den Eintraegen in der Datei ueberschrieben.
 * <DL><DT><B>Modifications: </B><DD>
 * Keine
 * </DD></DL>
 * @author   Thomas Hacklaender
 * @version  2000.05.04
 */
public class ExportData {


	/**
	 * Property: input.dir = String <br>
	 * Directory fuer alle Input-Operationen. Voreinstellung "user.dir"
	 */
	public File									inputDir = new File(System.getProperty("user.dir"));


	/**
	 * Property: output.dir = String <br>
	 * Directory fuer alle Output-Operationen. Voreinstellung "user.dir"
	 */
	public File									outputDir = new File(System.getProperty("user.dir"));


	/**
	 * Property: transfer.encoding = Erstes Zeichen 'l' fuer little Endian,
	 * sonst big Endian <br>
	 * Das Encoding des SC Files. Voreinstellung 'l'
	 */
	public int									encoding = DcmDataObject.LITTLE_ENDIAN;


	/**
	 * Property: transfer.structure = Erstes Zeichen 'i' fuer implicite VR,
	 * sonst explicite VR <br>
	 * Die Structure des SC Files. Voreinstellung 'e'
	 */
	public int									structure = DcmDataObject.EXPLICITE_VR;


	/**
	 * Property: transfer.storage = Erstes Zeichen 'm' fuer Meta File Information,
	 * sonst Plain File <br>
	 * Das Storage Format des SC Files. Voreinstellung 'm'
	 */
	public int									storage = DcmDataObject.META_STORAGE;


	/**
	 * Property: filesave.name = String <br>
	 * Filename, unter dem das SC Bild in outputDir gespeichert werden soll.
	 * Voreinstellung "SC_file"
	 */
	public String								fileNameToSave = "SC_file";


	/**
	 * Property: filesave.suffix = String <br>
	 * Suffix, der an jeden Filenamen angehaengt werden soll.
	 * Voreinstellung ".dcm"
	 */
	public String								fileNameSuffix = ".dcm";


	/**
	 * Die aktuelle SecondaryCaptureIOD
	 */
	public SecondaryCaptureIOD	theSC = null;


	/**
	 * Felder der Klasseninstanz werden mit den Werten des Property Files
	 * ueberschrieben.
	 * <ul>
	 * <li> input.dir -> inputDir </li>
	 * <li> output.dir -> outputDir </li>
	 * <li> transfer.encoding -> encoding </li>
	 * <li> transfer.structure -> structure </li>
	 * <li> transfer.storage -> storage </li>
	 * <li> filesave.name -> fileNameToSave </li>
	 * <li> filesave.suffix -> fileNameSuffix </li></ul>
	 */
	public void getProperties(InputStream in) {
		Properties	prop = new Properties();
		String			s;
		File				f;

		try {
			prop.load(in);

			s = prop.getProperty("input.dir");
			if (s != null) {
				f = new File(s);
				if (f != null) {
					inputDir = f;
				} 
			} 

			s = prop.getProperty("output.dir");
			if (s != null) {
				f = new File(s);
				if (f != null) {
					outputDir = f;
				} 
			} 

			s = prop.getProperty("transfer.encoding");
			if (s != null) {
				if (s.charAt(0) == 'l') {
					encoding = DcmDataObject.LITTLE_ENDIAN;
				} else {
					encoding = DcmDataObject.BIG_ENDIAN;
				} 
			} 

			s = prop.getProperty("transfer.structure");
			if (s != null) {
				if (s.charAt(0) == 'i') {
					structure = DcmDataObject.IMPLICITE_VR;
				} else {
					structure = DcmDataObject.EXPLICITE_VR;
				} 
			} 

			s = prop.getProperty("transfer.storage");
			if (s != null) {
				if (s.charAt(0) == 'm') {
					storage = DcmDataObject.META_STORAGE;
				} else {
					storage = DcmDataObject.META_STORAGE;
				} 
			} 

			s = prop.getProperty("filesave.name");
			if (s != null) {
				fileNameToSave = s;
			} 

			s = prop.getProperty("filesave.suffix");
			if (s != null) {
				fileNameToSave = s;
			} 

			in.close();

		} catch (Exception e) {}
	} 

}


/*--- formatting done in "My Own Convention" style on 04-30-2000 ---*/

