/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * Copyright (C) 2000 Thomas Hacklaender, e-mail: reply@thomas-hacklaender.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.gnu.org/copyleft/copyleft.html
 */
package rad.ijplugin.dcm;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import rad.dicom.dcm.*;
import rad.dicom.ima.*;
import rad.ijplugin.util.*;


/**
 * Diese Klasse definiert ein Panel, ueber das Elemente eines
 * <code>SecondaryCaptureIOD</code> modifiziert werden koennen.
 * Das <b>DICOM_Export</b> Plugin verwendet dieses Panel als inhaltliche Basis
 * der Dialogbox.
 * Letztere wird ueber die Hilfsklasse <code>Util.PanelDialog</code> erzeugt.
 * <DL><DT><B>Modifications: </B><DD>
 * Thomas Hacklaender 2000.08.22:
 * Copyright Mitteilung von der Dialogbox in dieses Panel verlagert.<br>
 * Thomas Hacklaender 2000.08.22:
 * Methode onShow geloescht.<br>
 * Thomas Hacklaender 2000.08.22:
 * Klassen PDPanel und PanelDialog aus dem Projekt entferntKlasse von JPanel
 * abgeleitet.<br>
 * </DD></DL>
 * @author   Thomas Hacklaender
 * @version  2000.08.22
 */
public class ExportPanel extends JPanel {

	/**
	 * Mit diesem Datenblock werden Daten zwischen dem Plugin und der Dialgobox
	 * sowie deren Panels ausgetauscht.
	 */
	private ExportData	exda;


	/* Allgemeine Felder fuer das Layout */
	JPanel							contentP = new JPanel();
	GridBagLayout				gridBagLayout1 = new GridBagLayout();
	JLabel							patientOrientationL = new JLabel();
	JLabel							lrOrientationL = new JLabel();
	JTextField					lrOrientationT = new JTextField();
	JTextField					tbOrientationT = new JTextField();
	JLabel							tbOrientationL = new JLabel();
	JLabel							patientNameL = new JLabel();
	JLabel							patientBirthDateL = new JLabel();
	JTextField					patientNameT = new JTextField();
	JTextField					patientBirthDateT = new JTextField();
	JLabel							seriesNumberL = new JLabel();
	JTextField					seriesNumberT = new JTextField();
	JLabel							orgRootUIDL = new JLabel();
	JTextField					accessionNumberT = new JTextField();
	JLabel							accessionNumberL = new JLabel();
	JTextField					orgRootUIDT = new JTextField();
	JButton							browseB = new JButton();
	JLabel							patientSexL = new JLabel();
	JTextField					patientSexT = new JTextField();
	JLabel							referringPhysicianNameL = new JLabel();
	JTextField					referringPhysicianNameT = new JTextField();
	JLabel							patientIDL = new JLabel();
	JTextField					patientIDT = new JTextField();
	JLabel							imageNumberL = new JLabel();
	JLabel							studyIDL = new JLabel();
	JTextField					imageNumberT = new JTextField();
	JTextField					fileNameT = new JTextField();
	JTextField					studyIDT = new JTextField();
	GridBagLayout				gridBagLayout2 = new GridBagLayout();
	JPanel							fileP = new JPanel();
	JLabel							fileParentL = new JLabel();
	GridBagLayout				gridBagLayout3 = new GridBagLayout();
	GridLayout					gridLayout1 = new GridLayout();
	JLabel							jLabel1 = new JLabel();
	JRadioButton				liEndB = new JRadioButton();
	JRadioButton				biEndB = new JRadioButton();
	JRadioButton				exVRB = new JRadioButton();
	JRadioButton				imVRB = new JRadioButton();
	JRadioButton				metaB = new JRadioButton();
	JRadioButton				plainB = new JRadioButton();

	/**
	 * Hier kann eine Copyright Mitteilung eingesetz werden.
	 */
  public JLabel       copyrightL = new JLabel();


	/**
	 * Initialisiert das Grafiklayout.
	 */
	public ExportPanel() {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			jbInit();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}


	/**
	 * Die Instanz wird mit dem Datenblock des Plug-Ins initialisiert.
	 * In dieser Methode werden auch alle anderen Initialisierungsvorgaenge
	 * gestartet. <br>
	 * Fuer den Zugriff durch alle Methoden der Instanz wird eine
	 * Referenz auf den Datenblock des Plugins als globales Instanz-Feld
	 * definiert.
	 * @param d		Datenblock des Plugins.
	 */
	public void initWithDataBlock(ExportData ed) {
		exda = ed;

		patientNameT.setText(exda.theSC.patientName);
		patientIDT.setText(exda.theSC.patientID);
		patientBirthDateT.setText(exda.theSC.patientBirthDate);
		patientSexT.setText(exda.theSC.patientSex);
		referringPhysicianNameT.setText(exda.theSC.referringPhysicianName);
		studyIDT.setText(exda.theSC.studyID);
		accessionNumberT.setText(exda.theSC.accessionNumber);
		seriesNumberT.setText(exda.theSC.seriesNumber);
		imageNumberT.setText(exda.theSC.imageNumber);
		lrOrientationT.setText(exda.theSC.lrPatientOrientation);
		tbOrientationT.setText(exda.theSC.tbPatientOrientation);
		orgRootUIDT.setText(exda.theSC.orgRootUID);

		if (exda.encoding == DcmDataObject.LITTLE_ENDIAN) {
			liEndB.setSelected(true);
			biEndB.setSelected(false);
		} else {
			liEndB.setSelected(false);
			biEndB.setSelected(true);
		}
		if (exda.structure == DcmDataObject.EXPLICITE_VR) {
			exVRB.setSelected(true);
			imVRB.setSelected(false);
		} else {
			exVRB.setSelected(false);
			imVRB.setSelected(true);
		}
		if (exda.storage == DcmDataObject.META_STORAGE) {
			metaB.setSelected(true);
			plainB.setSelected(false);
		} else {
			metaB.setSelected(false);
			plainB.setSelected(true);
		}

		// Das Label mit dem Pfad: Der Path bezieht sich auf das Directory
		fileParentL.setText(exda.outputDir.getPath());

		// Das Textfeld mit dem Filename
		fileNameT.setText(exda.fileNameToSave);
	}


	/**
	 * Durch den Aufruf der Methode werden alle Felder des Datenblocks
	 * des Plugins auf den aktuellen Wert gesetzt werden.
	 */
	public void updateDataBlock() {
		exda.theSC.patientName = patientNameT.getText();
		exda.theSC.patientID = patientIDT.getText();
		exda.theSC.patientBirthDate = patientBirthDateT.getText();
		exda.theSC.patientSex = patientSexT.getText();
		exda.theSC.referringPhysicianName = referringPhysicianNameT.getText();
		exda.theSC.studyID = studyIDT.getText();
		exda.theSC.accessionNumber = accessionNumberT.getText();
		exda.theSC.seriesNumber = seriesNumberT.getText();
		exda.theSC.imageNumber = imageNumberT.getText();
		exda.theSC.lrPatientOrientation = lrOrientationT.getText();
		exda.theSC.tbPatientOrientation = tbOrientationT.getText();
		exda.theSC.orgRootUID = orgRootUIDT.getText();

		if (liEndB.isSelected()) {
			exda.encoding = DcmDataObject.LITTLE_ENDIAN;
		} else {
			exda.encoding = DcmDataObject.BIG_ENDIAN;
		}
		if (exVRB.isSelected()) {
			exda.structure = DcmDataObject.EXPLICITE_VR;
		} else {
			exda.structure = DcmDataObject.IMPLICITE_VR;
		}
		if (metaB.isSelected()) {
			exda.storage = DcmDataObject.META_STORAGE;
		} else {
			exda.storage = DcmDataObject.PLAIN_STORAGE;
		}

		exda.outputDir = new File(fileParentL.getText());
		exda.fileNameToSave = fileNameT.getText();
	}


	/**
	 * Von JBuilder automatisch generierte Action-Methode fuer den
	 * saveBtn. Wird der Button gedrueck, wird ein JFileChooser zur
	 * Auswahl des Ausgabeverzeichnisses praesentiert.
	 * @param   e   Das Action Event.
	 */
	void browseB_actionPerformed(ActionEvent e) {
		File					f;

		JFileChooser	chooser = new JFileChooser();

		chooser.setDialogTitle("Filename to save");
		chooser.setCurrentDirectory(new File(fileParentL.getText()));
		chooser.setSelectedFile(new File(fileNameT.getText()));
		chooser.showSaveDialog(this);
		f = chooser.getSelectedFile();
		if (f == null) {
			return;

		}
		fileParentL.setText(f.getParent());
		fileNameT.setText(f.getName());
	}


	/**
	 * Von JBuilder automatisch generierte Action-Methode fuer den
	 * liEndB. Wird der Button gedrueck, werden die Radio-Buttons
	 * liEndB und biEndB getoggelt.
	 * @param   e   Das Action Event.
	 */
	void liEndB_actionPerformed(ActionEvent e) {
		biEndB.setSelected(!liEndB.isSelected());
		exVRB.setEnabled(true);
		imVRB.setEnabled(true);
	}


	/**
	 * Von JBuilder automatisch generierte Action-Methode fuer den
	 * biEndB. Wird der Button gedrueck, werden die Radio-Buttons
	 * liEndB und biEndB getoggelt. Wenn big Endian ausgewaehlt ist, ist
	 * nach der Norm nur die expplizite Transfer Syntax erlaubt
	 * @param   e   Das Action Event.
	 */
	void biEndB_actionPerformed(ActionEvent e) {
		if (biEndB.isSelected()) {
			exVRB.setEnabled(false);
			imVRB.setEnabled(false);
			exVRB.setSelected(true);
			imVRB.setSelected(false);
		} else {
			exVRB.setEnabled(true);
			imVRB.setEnabled(true);
		}
		liEndB.setSelected(!biEndB.isSelected());
	}


	/**
	 * Von JBuilder automatisch generierte Action-Methode fuer den
	 * exVRB. Wird der Button gedrueck, werden die Radio-Buttons
	 * imVRB und exVRB getoggelt.
	 */
	void exVRB_actionPerformed(ActionEvent e) {
		imVRB.setSelected(!exVRB.isSelected());
	}


	/**
	 * Von JBuilder automatisch generierte Action-Methode fuer den
	 * imVRB. Wird der Button gedrueck, werden die Radio-Buttons
	 * imVRB und exVRB getoggelt.
	 */
	void imVRB_actionPerformed(ActionEvent e) {
		exVRB.setSelected(!imVRB.isSelected());
	}


	/**
	 * Von JBuilder automatisch generierte Action-Methode fuer den
	 * metaB. Wird der Button gedrueck, werden die Radio-Buttons
	 * plainB und metaB getoggelt.
	 */
	void metaB_actionPerformed(ActionEvent e) {
		plainB.setSelected(!metaB.isSelected());
	}


	/**
	 * Von JBuilder automatisch generierte Action-Methode fuer den
	 * plainB. Wird der Button gedrueck, werden die Radio-Buttons
	 * plainB und metaB getoggelt.
	 */
	void plainB_actionPerformed(ActionEvent e) {
		metaB.setSelected(!plainB.isSelected());
	}


	/**
	 * Von JBuilder automatisch generierte Initialisierungsmethode fuer die
	 * grafischen Elemente.
	 */
	private void jbInit() throws Exception {
		this.setPreferredSize(new Dimension(620, 420));
		this.setBackground(SystemColor.control);
		this.setMinimumSize(new Dimension(620, 420));
		contentP.setLayout(gridBagLayout1);
		lrOrientationL.setFont(new Font("Dialog", 0, 12));
		lrOrientationT.setPreferredSize(new Dimension(80, 19));
		lrOrientationT.setFont(new Font("Dialog", 0, 12));
		lrOrientationT.setMinimumSize(new Dimension(40, 19));
		patientNameL.setText("Patient Name");
		patientNameL.setFont(new Font("Dialog", 0, 12));
		patientBirthDateL.setText("Patient Birth Date");
		patientBirthDateL.setFont(new Font("Dialog", 0, 12));
		patientNameT.setPreferredSize(new Dimension(200, 19));
		patientNameT.setMinimumSize(new Dimension(200, 19));
		patientNameT.setFont(new Font("Dialog", 0, 12));
		patientBirthDateT.setPreferredSize(new Dimension(80, 19));
		patientBirthDateT.setFont(new Font("Dialog", 0, 12));
		patientBirthDateT.setMinimumSize(new Dimension(80, 19));
		seriesNumberL.setText("Series Number");
		seriesNumberL.setFont(new Font("Dialog", 0, 12));
		seriesNumberT.setPreferredSize(new Dimension(60, 19));
		seriesNumberT.setFont(new Font("Dialog", 0, 12));
		seriesNumberT.setMinimumSize(new Dimension(40, 19));
		orgRootUIDL.setText("Root UID");
		orgRootUIDL.setFont(new Font("Dialog", 0, 12));
		accessionNumberT.setPreferredSize(new Dimension(60, 19));
		accessionNumberT.setFont(new Font("Dialog", 0, 12));
		accessionNumberT.setMinimumSize(new Dimension(150, 19));
		accessionNumberL.setFont(new Font("Dialog", 0, 12));
		orgRootUIDT.setPreferredSize(new Dimension(150, 19));
		orgRootUIDT.setMinimumSize(new Dimension(150, 19));
		orgRootUIDT.setFont(new Font("Dialog", 0, 12));
		browseB.setText("Browse");
		browseB.setPreferredSize(new Dimension(80, 25));
		patientSexL.setText("Patient Sex (M, F, O)");
		patientSexL.setFont(new Font("Dialog", 0, 12));
		patientSexT.setPreferredSize(new Dimension(80, 19));
		patientSexT.setFont(new Font("Dialog", 0, 12));
		patientSexT.setMinimumSize(new Dimension(40, 19));
		referringPhysicianNameL.setFont(new Font("Dialog", 0, 12));
		patientIDL.setText("Patient ID");
		patientIDL.setFont(new Font("Dialog", 0, 12));
		referringPhysicianNameT.setPreferredSize(new Dimension(150, 19));
		referringPhysicianNameT.setMinimumSize(new Dimension(150, 19));
		referringPhysicianNameT.setFont(new Font("Dialog", 0, 12));
		patientIDT.setPreferredSize(new Dimension(200, 19));
    patientIDT.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        patientIDT_actionPerformed(e);
      }
    });
		patientIDT.setFont(new Font("Dialog", 0, 12));
		patientIDT.setMinimumSize(new Dimension(40, 19));
		imageNumberL.setFont(new Font("Dialog", 0, 12));
		studyIDL.setText("Study ID");
		studyIDL.setFont(new Font("Dialog", 0, 12));
		imageNumberT.setPreferredSize(new Dimension(60, 19));
		imageNumberT.setFont(new Font("Dialog", 0, 12));
		imageNumberT.setMinimumSize(new Dimension(40, 19));
		fileNameT.setPreferredSize(new Dimension(150, 19));
		fileNameT.setMinimumSize(new Dimension(100, 19));
		fileNameT.setFont(new Font("Dialog", 0, 12));
		fileParentL.setPreferredSize(new Dimension(150, 19));
		tbOrientationT.setMinimumSize(new Dimension(40, 19));
		tbOrientationT.setPreferredSize(new Dimension(80, 19));
		tbOrientationL.setText("top - bottom");
		tbOrientationL.setFont(new Font("Dialog", 0, 12));
		patientOrientationL.setFont(new Font("Dialog", 0, 12));
		patientOrientationL.setText("Patient Orientation (A, P, R, L, H, F)");
		studyIDT.setPreferredSize(new Dimension(6 - 0, 19));
		studyIDT.setFont(new Font("Dialog", 0, 12));
		fileP.setLayout(gridBagLayout3);
		imageNumberL.setText("Image Number");
		referringPhysicianNameL.setText("Referring Physician Name");
		browseB.addActionListener(new java.awt.event.ActionListener() {
			/**
			 */
			public void actionPerformed(ActionEvent e) {
				browseB_actionPerformed(e);
			}

		});
		accessionNumberL.setText("Accession Number");
		lrOrientationL.setText("left - right");
		this.setSize(400, 300);
		this.setLayout(gridLayout1);
		jLabel1.setText("Path:");
		liEndB.setText("Little Endian");
		liEndB.addActionListener(new java.awt.event.ActionListener() {
			/**
			 */
			public void actionPerformed(ActionEvent e) {
				liEndB_actionPerformed(e);
			}

		});
		biEndB.setText("Big Endian");
		biEndB.addActionListener(new java.awt.event.ActionListener() {
			/**
			 */
			public void actionPerformed(ActionEvent e) {
				biEndB_actionPerformed(e);
			}

		});
		exVRB.setText("Explicite VR");
		exVRB.addActionListener(new java.awt.event.ActionListener() {
			/**
			 */
			public void actionPerformed(ActionEvent e) {
				exVRB_actionPerformed(e);
			}

		});
		imVRB.setText("Implicite VR");
		imVRB.addActionListener(new java.awt.event.ActionListener() {
			/**
			 */
			public void actionPerformed(ActionEvent e) {
				imVRB_actionPerformed(e);
			}

		});
		metaB.setText("Meta Info Block");
		metaB.addActionListener(new java.awt.event.ActionListener() {
			/**
			 */
			public void actionPerformed(ActionEvent e) {
				metaB_actionPerformed(e);
			}

		});
		plainB.setText("Plain");
		plainB.addActionListener(new java.awt.event.ActionListener() {
			/**
			 */
			public void actionPerformed(ActionEvent e) {
				plainB_actionPerformed(e);
			}

		});
		copyrightL.setText("(c) 2000 Thomas Hacklaender, see GPL Lizense");
    this.add(contentP, null);
		contentP.add(patientOrientationL, new GridBagConstraints2(1, 3, GridBagConstraints.REMAINDER, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(6, 8, 3, 0), 0, 0));
		contentP.add(lrOrientationL, new GridBagConstraints2(1, 4, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 8, 0, 0), 0, 0));
		contentP.add(lrOrientationT, new GridBagConstraints2(2, 4, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 3, 0), 0, 0));
		contentP.add(patientNameL, new GridBagConstraints2(1, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 8, 0, 0), 0, 0));
		contentP.add(patientBirthDateL, new GridBagConstraints2(1, 2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 8, 0, 0), 0, 0));
		contentP.add(patientNameT, new GridBagConstraints(2, 0, GridBagConstraints.REMAINDER, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(3, 0, 3, 8), 0, 0));
		contentP.add(patientBirthDateT, new GridBagConstraints2(2, 2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 3, 0), 0, 0));
		contentP.add(seriesNumberL, new GridBagConstraints2(1, 6, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 8, 0, 0), 0, 0));
		contentP.add(seriesNumberT, new GridBagConstraints2(2, 6, 2, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 3, 0), 0, 0));
		contentP.add(orgRootUIDL, new GridBagConstraints2(1, 10, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(6, 8, 0, 0), 0, 0));
		contentP.add(accessionNumberT, new GridBagConstraints2(2, 9, GridBagConstraints.REMAINDER, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 3, 8), 0, 0));
		contentP.add(accessionNumberL, new GridBagConstraints2(1, 9, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 8, 0, 0), 0, 0));
		contentP.add(orgRootUIDT, new GridBagConstraints2(2, 10, GridBagConstraints.REMAINDER, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 3, 8), 0, 0));
		contentP.add(referringPhysicianNameL, new GridBagConstraints2(1, 8, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 8, 0, 3), 0, 0));
		contentP.add(patientIDL, new GridBagConstraints2(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.BOTH, new Insets(0, 8, 0, 0), 0, 0));
		contentP.add(referringPhysicianNameT, new GridBagConstraints2(2, 8, GridBagConstraints.REMAINDER, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(6, 0, 3, 8), 0, 0));
		contentP.add(patientIDT, new GridBagConstraints2(2, 1, 3, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 3, 8), 0, 0));
		contentP.add(imageNumberL, new GridBagConstraints2(1, 7, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 8, 0, 0), 0, 0));
		contentP.add(studyIDL, new GridBagConstraints2(1, 5, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 8, 0, 0), 0, 0));
		contentP.add(imageNumberT, new GridBagConstraints2(2, 7, 2, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 3, 0), 0, 0));
		contentP.add(studyIDT, new GridBagConstraints2(2, 5, GridBagConstraints.REMAINDER, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(6, 0, 3, 8), 0, 0));
		contentP.add(tbOrientationT, new GridBagConstraints2(4, 4, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 3, 0), 0, 0));
		contentP.add(fileP, new GridBagConstraints2(1, 11, 4, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(12, 0, 0, 0), 0, 0));
		fileP.add(browseB, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, GridBagConstraints.SOUTH, GridBagConstraints.HORIZONTAL, new Insets(0, 8, 3, 10), 0, 0));
		fileP.add(fileNameT, new GridBagConstraints2(1, 2, 3, 1, 1.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 3, 8), 0, 0));
		fileP.add(fileParentL, new GridBagConstraints2(1, 3, 3, 1, 1.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(4, 0, 0, 8), 0, 0));
		fileP.add(jLabel1, new GridBagConstraints2(0, 3, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(4, 0, 0, 8), 0, 0));
		fileP.add(liEndB, new GridBagConstraints2(1, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		fileP.add(plainB, new GridBagConstraints2(3, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		fileP.add(biEndB, new GridBagConstraints2(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		fileP.add(exVRB, new GridBagConstraints2(2, 0, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		fileP.add(metaB, new GridBagConstraints2(3, 0, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		fileP.add(imVRB, new GridBagConstraints2(2, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

		contentP.add(tbOrientationL, new GridBagConstraints2(3, 4, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.BOTH, new Insets(0, 20, 3, 3), 0, 0));
		contentP.add(patientSexT, new GridBagConstraints2(4, 2, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 3, 0), 0, 0));
		contentP.add(patientSexL, new GridBagConstraints2(3, 2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 8, 0, 4), 0, 0));
    contentP.add(copyrightL, new GridBagConstraints2(1, 12, 4, 1, 1.0, 1.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(3, 8, 0, 8), 0, 0));

	}

  void patientIDT_actionPerformed(ActionEvent e) {

  }

}


/*--- formatting done in "My Own Convention" style on 04-30-2000 ---*/

