/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * Copyright (C) 2000 Thomas Hacklaender, e-mail: reply@thomas-hacklaender.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.gnu.org/copyleft/copyleft.html
 */
package rad.ijplugin.dcm;

import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import rad.dicom.dcm.*;
import rad.dicom.ima.*;
import rad.ijplugin.util.*;


/**
 * Ueber dieses Panel werdenInformationen ueber die zu ladenden Bilder abgefragt.
 * So wird festgelegt, ob ein oder mehrere Bilder geladen werden sollen.
 * Wenn es mehrere sind, kann eine Liste der Bildnummern der zu ladenden
 * Bilder angegeben werden. Ferner kann festgelegt werden ob die DICOM Header
 * Informationen (alle Daten Elemente ausser den Pixel Daten der Gruppe 0x7fe0)
 * in einer String-Darstellung und/der als <code>DcmDataObject</code>
 * zusaetzlich gespeichert werden sollen.
 * <DL><DT><B>Modifications: </B><DD>
 * Thomas Hacklaender 2000.08.22:
 * Methode onShow geloescht.<br>
 * Thomas Hacklaender 2000.08.22:
 * Klassen PDPanel und PanelDialog aus dem Projekt entferntKlasse von JPanel
 * abgeleitet.<br>
 * Thomas Hacklaender 2000.05.01:
 * "Load multiple images" als Property eingefgt.<br>
 * </DD></DL>
 * @author   Thomas Hacklaender
 * @version  2000.08.22
 */
public class FileListPanel extends JPanel {


	/**
	 * Mit diesem Datenblock werden Daten zwischen dem Plugin und der Dialgobox
	 * sowie deren Panels ausgetauscht.
	 */
	private ImportData	imda;

	/* Allgemeine Felder fuer das Layout */
	GridBagLayout				gridBagLayout2 = new GridBagLayout();
	JLabel							imageListL = new JLabel();
	JTextField					imageListT = new JTextField();
	JCheckBox						multiChecBox = new JCheckBox();
	JCheckBox						inclStrChecBox = new JCheckBox();
	JCheckBox						inclDDOChecBox = new JCheckBox();
	JCheckBox						onlyFirstChecBox = new JCheckBox();
	JLabel							headerL = new JLabel();


	/**
	 * Initialisiert das Grafiklayout.
	 */
	public FileListPanel() {
		try {
			jbInit();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}


	/**
	 * Die Instanz wird mit dem Datenblock des Plugins initialisiert.
	 * In dieser Methode werden auch alle anderen Initialisierungs
	 * vorgaenge gestartet.
	 * Fuer den Zugriff durch aller Methoden der Instanz wird eine
	 * Referenz auf den Datenblock des Plugins als globales Instanz-
	 * feld definiert.
	 * @param d		Datenblock des Plugins.
	 */
	public void intWithDataBlock(ImportData id) {
		imda = id;

		inclStrChecBox.setSelected(imda.isIncludeStringHeader);
		inclDDOChecBox.setSelected(imda.isIncludeBinHeader);
		onlyFirstChecBox.setSelected(imda.isIncludeOnlyFirstHeader);
		multiChecBox.setSelected(imda.isMultiImage);
		if (imda.isMultiImage) {
			imageListT.setText(imda.multiImageIDList);
		}
	}


	/**
	 * Durch den Aufruf der Methode werden alle Felder des Datenblocks
	 * des Plugins auf den aktuellen Wert gesetzt werden.
	 */
	public void updateDataBlock() {
		imda.isMultiImage = multiChecBox.isSelected();
		if (imda.isMultiImage) {
			getImageRange();
		}
		imda.isIncludeStringHeader = inclStrChecBox.isSelected();
		imda.isIncludeBinHeader = inclDDOChecBox.isSelected();
		imda.isIncludeOnlyFirstHeader = onlyFirstChecBox.isSelected();
	}


	/**
	 * Generiert aus dem Textfeld imageListT eine Liste (Vector) von
	 * Bidnummern. Die Nummern muessen in einem plausiblen Bereich von 1..999
	 * liegen.
	 */
	private void getImageRange() {
		int							i;
		StringTokenizer itemst;
		String					item;
		StringTokenizer imast;
		int							imin, imax;
		String					list;

		imda.multiImageList = new Vector();

		list = imageListT.getText();
		if (list.startsWith("-")) list = "1" + list;
		if (list.endsWith("-")  ) list = list + "999";

		itemst = new StringTokenizer(list, ",");
		do {
			try {
				item = itemst.nextToken().trim();
				if (item.indexOf('-') == -1) {

					// image number
					i = (int) DcmValue.str2Long(item, 0);
					if ((i > 0) & (i < 1000)) imda.multiImageList.addElement(new Integer(i));
				} else {

					// image range
					imast = new StringTokenizer(item, "-");
					imin = imax = 0;
					try {
						imin = (int) DcmValue.str2Long(imast.nextToken(), 0);
						imax = (int) DcmValue.str2Long(imast.nextToken(), 0);
					} catch (NoSuchElementException e) {}
					if ((imin > 0) & (imin < 1000) & (imax > 0) & (imax < 1000)) {
						if (imin > imax) {
							i = imin;
							imin = imax;
							imax = i;
						}
						for (i = imin; i <= imax; i++) {
							imda.multiImageList.addElement(new Integer(i));
						}
					} else {
						if (imin > 0) {
							if (imin < 1000) imda.multiImageList.addElement(new Integer(imin));
						}
						if (imax > 0) {
							if (imax < 1000) imda.multiImageList.addElement(new Integer(imax));
						}
					}
				}
			} catch (NoSuchElementException e) {
				break;
			}
		} while (true);
	}


	/**
	 * Eventhandler fuer itemStateChanged Events von multiChecBtn
	 * (Name von JBuielder generiert).
	 * @param	e		Das Item-Event.
	 */
	void multiChecBox_itemStateChanged(ItemEvent e) {
		setMultiChecBox();
	}


	/**
	 * Falls multiChecBtn selektiert ist, muss auch das Textfeld
	 * imageListT aktiviert werden, so dass die Bildliste eingegeben
	 * werden kann.
	 */
	private void setMultiChecBox() {
		if (multiChecBox.isSelected()) {
			imageListT.setEnabled(true);
			imageListT.setBackground(Color.white);
		} else {
			imageListT.setEnabled(false);
			imageListT.setBackground(Color.lightGray);
		}
		this.repaint();
	}


	/**
	 * Eventhandler fuer itemStateChanged Events von inclStrChecBox
	 * (Name von JBuielder generiert).
	 * @param	e		Das Item-Event.
	 */
	void inclStrChecBox_itemStateChanged(ItemEvent e) {
		setInclChecBox();
	}


	/**
	 * Eventhandler fuer itemStateChanged Events von inclDDOChecBox
	 * (Name von JBuielder generiert).
	 * @param	e		Das Item-Event.
	 */
	void inclDDOChecBox_itemStateChanged(ItemEvent e) {
		setInclChecBox();
	}


	/**
	 * onlyFirstChecBox darf nur dann aktiv sein, falls Header
	 * gespeichert werden sollen.Informationen
	 */
	private void setInclChecBox() {
		if (inclStrChecBox.isSelected() | inclDDOChecBox.isSelected()) {
			onlyFirstChecBox.setEnabled(true);
		} else {
			onlyFirstChecBox.setEnabled(false);
		}
		this.repaint();
	}


	/**
	 * Von JBuilder automatisch generierte Initialisierungsmethode fuer die
	 * grafischen Elemente.
	 */
	private void jbInit() throws Exception {

		onlyFirstChecBox.setActionCommand("Only for first image");
		onlyFirstChecBox.setText("only for first image");
		inclStrChecBox.addItemListener(new java.awt.event.ItemListener() {
			/**
			 */
			public void itemStateChanged(ItemEvent e) {
				inclStrChecBox_itemStateChanged(e);
			}

		});
		inclStrChecBox.setText("as String");
		inclStrChecBox.setSelected(false);
		multiChecBox.addItemListener(new java.awt.event.ItemListener() {
			/**
			 */
			public void itemStateChanged(ItemEvent e) {
				multiChecBox_itemStateChanged(e);
			}

		});
		multiChecBox.setForeground(Color.black);
		multiChecBox.setText("Load multiple images");
		multiChecBox.setSelected(false);
		imageListT.setBackground(Color.lightGray);
		imageListT.setEnabled(false);
		imageListT.setMinimumSize(new Dimension(60, 20));
		imageListT.setPreferredSize(new Dimension(60, 20));
		imageListL.setPreferredSize(new Dimension(110, 15));
		imageListL.setText("Image list e.g. [3,5-7,9] or [-4,9] or [1,4-] or [-]:");
		setMultiChecBox();
		setInclChecBox();


		this.setLayout(gridBagLayout2);
		headerL.setText("Include DICOM header:");

		inclDDOChecBox.setText("as DataObject");
		inclDDOChecBox.addItemListener(new java.awt.event.ItemListener() {
			/**
			 */
			public void itemStateChanged(ItemEvent e) {
				inclDDOChecBox_itemStateChanged(e);
			}

		});
		this.add(imageListT, new GridBagConstraints2(2, 3, 2, 1, 1.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 5), 0, 0));
		this.add(headerL, new GridBagConstraints2(0, 0, 2, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 5, 0, 0), 0, 0));
		this.add(multiChecBox, new GridBagConstraints2(0, 3, 2, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 5, 0, 0), 0, 0));
		this.add(imageListL, new GridBagConstraints2(0, 2, 4, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 5, 0, 0), 0, 0));
		this.add(onlyFirstChecBox, new GridBagConstraints2(3, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.add(inclStrChecBox, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 5, 0, 0), 0, 0));
		this.add(inclDDOChecBox, new GridBagConstraints2(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
	}

}



/*--- formatting done in "My Own Convention" style on 04-30-2000 ---*/

