/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * Copyright (C) 2000 Thomas Hacklaender, e-mail: reply@thomas-hacklaender.de
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * http://www.gnu.org/copyleft/copyleft.html
 */
package rad.ijplugin.util;

import javax.swing.*;


/**
 * Die Klasse stellt ein Swing <code>ProgressMonitor</code>-Fenster auf dem
 * Bildschirm dar.
 * <DL><DT><B>Modifications: </B><DD>
 * Keine
 * </DD></DL>
 * @author   Thomas Hacklaender
 * @version  2000.05.04
 */
public class ProgressWindow extends JPanel {

	/* Das ProgressMonitor Fenster */
	private ProgressMonitor pm;

	/* Der aktuelle Wert des Progressbalkens */
	private int							aktValue;


	/**
	 * Erzeugt das Fenster und stellt es dar.
	 * @param message 	Ein konstant auf dem Fenster dargestellter Text (1. Zeile).
	 * @param note    	Ein variabler Text (2. Zeile).
	 * @param min     	Minimaler Zahlenwert fuer den Progressbalken.
	 * @param max     	Minimaler Zahlenwert fuer den Progressbalken.
	 */
	public ProgressWindow(String message, String note, int min, int max) {
		super(true);
		pm = new ProgressMonitor(this, message, note, min, max);
	}


	/**
	 * Neuer Wert fuer den Progress-Balken.
	 * @param value  Der Wert muss im Intervall min <= value <= max liegen.
	 */
	public void setValue(int value) {
		aktValue = value;

		// Mit diesem Methodenaufruf wird die Klasse Update in die
		// System Event Queue gelegt und der aktuelle Task solange angehalten,
		// bis dieser Event abgearbeitet worden ist. Die System Event Queue
		// ruft dabei die Methode run der uebergebenen Klasse Update auf.
		SwingUtilities.invokeLater(new Update());
	} 


	/**
	 * Ueberprueft, ob der Benutzer den "Cancel" Button gedrueckt hat.
	 * @return  true, wenn der Benutzer den "Cancel" Button gedrueckt hat.
	 */
	public boolean isCanceled() {
		return pm.isCanceled();
	} 


	/**
	 * Schliesst das ProgressMonitor Fenster auf dem Bildschirm.
	 */
	public void close() {
		pm.close();
	} 


	/**
	 * Eine "inner class", die nur die Methode run implementiert.
	 * Mit dieser Methode wird der Progressbalken auf den neuen Wert gesetzt.
	 */
	class Update implements Runnable {

		/**
		 */
		public void run() {
			pm.setProgress(aktValue);
		} 

	}

}



/*--- formatting done in "My Own Convention" style on 04-30-2000 ---*/

