/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * Copyright (C) 2000 Thomas Hacklaender, e-mail: reply@thomas-hacklaender.de
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * http://www.gnu.org/copyleft/copyleft.html
 */
package rad.ijplugin.util;

import java.io.*;
import java.util.*;
import java.awt.*;
import javax.swing.*;


/**
 * Diese Klasse definiert einige statische Methoden, die an verschiedenen
 * Stellen im Package <code>rad.ijplugin</code> benoetigt werden.
 * <DL><DT><B>Modifications: </B><DD>
 * Keine
 * </DD></DL>
 * @version   2000.05.04
 */
public class Util {


	/**
	 * Name des Property Files fuer die ImageJ Plug-Ins DICOM_import und
	 * DICOM_export
	 */
	static public final String	PROPERTY_FILE_NAME = "dicom_io_properties.txt";


	/**
	 * Bubble sort eines Arrays von Strings.
	 * Eine Implementation in Anlehnung an das Buch <br>
	 * Vanderburg G: Tricks of the Java Programming Gurus <br>
	 * Part 3, The Core Classes: AWT Tricks, pp 162 <br>
	 * Sams.net Publishing 1996
	 * @param strings  Das String-Array, das sortiert werden soll
	 */
	static public void bubbleSortStrings(String[] strings) {
		for (int i = 0; i < strings.length - 1; i++) {
			boolean swaps = false;

			for (int j = strings.length - 2; j >= i; j--) {
				if (strings[j].compareTo(strings[j + 1]) > 0) {
					String	temp = strings[j];

					strings[j] = strings[j + 1];
					strings[j + 1] = temp;
					swaps = true;
				} 
			} 
			if (swaps == false) {
				break;
			} 
		} 
	} 


	/**
	 * Die Methode sucht nach einer Property-Datei.
	 * Ueberprueft zunaechst, ob im Parameter arg eine Property-Datei
	 * angegeben wurde. Dieser String kann aus Unterargumenten bestehen, die
	 * durch '\t voneinander getrennt sind.
	 * Das Unterargument fuer eine Property-Datei muss mit "-p" beginnen. <br>
	 * Beispiele fuer WinXX: -pname, -p.\dir\name oder -pC:\dir\name <br>
	 * <b>Achtung</b>: arg muss die Pfadangaben mit den korrekten
	 * Trennzeichen fuer Files und Pfade enthalten. <br>
	 * Folgt auf "-p" ein '.', dann handelt es sich um einen relativen Pfad
	 * bezogen auf "user.dir", sonst um einen vollstaendigen Pfad. Wurde kein
	 * Dateiname angegeben wird erst im Verzeichnis "user.dir" und dann im
	 * Verzeichnis "user.home" nach der Datei <code>Util.PROPERTY_FILE_NAME</code>
	 * gesucht.
	 * @param arg   Ein String, der durchsucht werden soll.
	 * @return      Der InputStream auf den gefundenen Property-File. Falls
	 * keiner gefunden wurde = null
	 */
	static public InputStream getPropertyFileStream(String arg) {
		StringTokenizer st;
		String					s;

		st = new StringTokenizer(arg, "\t");
		while (st.hasMoreTokens()) {
			s = st.nextToken();
			if (s.substring(0, 2).compareTo("-p") == 0) {
				s = s.substring(2, s.length());
				if (s.charAt(0) == '.') {

					// Realtiver Dateiname bezogen auf das user.dir
					try {
						return new FileInputStream(System.getProperty("user.dir") + s.substring(1, s.length()));
					} catch (Exception e) {}
				} else {

					// Vollstaendiger Dateiname einschliesslich Verzeichnisname
					try {
						return new FileInputStream(s);
					} catch (Exception e) {}
				} 
			} 
		} 

		// Suche Property File in user.dir, dann in user.home
		try {
			s = System.getProperty("user.dir") + System.getProperty("file.separator") + PROPERTY_FILE_NAME;
			return new FileInputStream(s);
		} catch (Exception e) {}
		try {
			s = System.getProperty("user.home") + System.getProperty("file.separator") + PROPERTY_FILE_NAME;
			return new FileInputStream(s);
		} catch (Exception e) {}

		// Kein Property File gefunden
		return null;
	} 


	/**
	 * Die Methode sucht nach einem Dateinamen. Der Parameter arg kann aus
	 * Unterargumenten bestehen, die durch '\t voneinander getrennt sind.
	 * Das Unterargument des Dateinamens darf <b>nicht</b> mit "-" beginnen. <br>
	 * Beispiele fuer WinXX: name, .\dir\name oder C:\dir\name <br>
	 * <b>Achtung</b>: Der arg String muss die Pfadangaben mit den korrekten
	 * Trennzeichen fuer Files und Pfade enthalten. <br>
	 * Beginn der Name mit '.', dann handelt es sich um einen relativen Pfad
	 * bezogen auf theDir.
	 * @param arg   Ein String, der durchsucht werden soll.
	 * @param theDir Ein Directory-Name, der als Basis fuer relative Pfadangaben
	 * verwendet werden soll.
	 * @return       Der Name der Datei. Falls keiner gefunden wurde = null
	 */
	static public String getFileNameToProcess(String arg, String theDir) {
		StringTokenizer st;
		String					s;

		st = new StringTokenizer(arg, "\t");
		while (st.hasMoreTokens()) {
			s = st.nextToken();
			if (s.charAt(0) != '-') {
				if (s.charAt(0) == '.') {

					// Realtiver Dateiname bezogen auf das user.dir
					return theDir + s.substring(1, s.length());
				} else {

					// Vollstaendiger Dateiname einschliesslich Verzeichnisname
					return s;
				} 
			} 
		} 

		// Kein File gefunden
		return null;
	} 


	/**
	 * Darstellung einer Swing Error-Dialogbox.
	 * @param text  Der Error-Text.
	 */
	static public void showErrorDialog(String text) {
		Frame f = new Frame();

		Toolkit.getDefaultToolkit().beep();
		JOptionPane.showMessageDialog(f, text, "Error", JOptionPane.ERROR_MESSAGE, null);

		f.dispose();
	} 


	/**
	 * Darstellung einer Swing Warning-Dialogbox.
	 * @param text  Der Warning-Text.
	 */
	static public void showWarningDialog(String text) {
		Frame f = new Frame();

		Toolkit.getDefaultToolkit().beep();
		JOptionPane.showMessageDialog(f, text, "Warning", JOptionPane.WARNING_MESSAGE, null);

		f.dispose();
	} 


	/**
	 * Darstellung einer Swing Info-Dialogbox.
	 * @param text  Der Info-Text.
	 */
	static public void showInfoDialog(String text) {
		Frame f = new Frame();

		Toolkit.getDefaultToolkit().beep();
		JOptionPane.showMessageDialog(f, text, "Information", JOptionPane.INFORMATION_MESSAGE, null);

		f.dispose();
	} 

}


/*--- formatting done in "My Own Convention" style on 04-30-2000 ---*/

