/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * ImageJ plug-in to import DICOM files.
 * 
 * Copyright (C) 2000 Thomas Demuth, e-mail: th1811@t-online.de
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * http://www.gnu.org/copyleft/copyleft.html
 * 
 * The ImageJ project:
 * http://rsb.info.nih.gov/ij/default.html
 * Author: Wayne Rasband, wayne@codon.nih.gov
 * Research Services Branch, National Institute of Mental Health, Bethesda, Maryland, USA.
 * Download: ftp://codon.nih.gov/pub/image-j/
 */


// package ij.plugin;
import ij.plugin.*;
import java.awt.Color;
import javax.swing.tree.*;
import mrcp.gui.*;
import mrcp.ddd.*;
import mrcp.graphics.*;
import mrcp.tools.*;


/**
 * Plugin zur Entwicklung eines 3D-Datensatzes auf der Grundlage
 * von DICOM Files. Mit Hilfe des neu entwickelten Datensatzes knnen
 * Tomographien beliebiger Orientierung und Auflsung als DICOM oder
 * oder ImagePlus exportiert werden. Als zustzliches Mglichkeit bietet
 * sich die Konstruktion zweier 3D-Datenstze, um eine Bildberlagerung
 * gewhlter Schicchten zu verwirklichen. Dem Benutzer steht dazu ein umfangreiches
 * Optionenmen zur Verfgung mit dem er Einflu auf die Genauigkeit der Berechnung
 * nehmen kann. Ein Argumentstring wird nicht untersttzt.
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class DICOM_3D_MRCP implements PlugIn {


	/**
	 * Die graphische Oberflche des Startbildschirms und der Karteikarte Quellenselektion.
	 */

 	public gui	my_gui;

	/**
	 * Standard Konstruktor
	 * 
	 * 
	 */
	public DICOM_3D_MRCP() {}


	/**
	 * Die Method "run" wird beim Start des Plugin ausgefhrt
	 * und erzeugt die neue graphische Oberflche "gui". Der Schichtbaum
	 * der 2D-Datenstze und die Standardoptonen werden initialisert.
	 * 
	 * 
	 * @param arg Optionale Argumentzeichenkette
	 * 
	 */
	public void run(String arg) {


 		my_gui = new gui();

	} 

}





/*--- formatting done in "My Own Convention" style on 08-12-2000 ---*/

