/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/


package mrcp.control;
import java.awt.event.*;
import javax.swing.*;
import ij.*;
import ij.gui.*;
import java.awt.*;
import javax.swing.event.*;
import ij.process.*;
import java.awt.image.ColorModel;
import java.awt.image.*;

import mrcp.gui.*;
import mrcp.graphics.*;
import mrcp.tools.*;
import mrcp.dd.*;
import mrcp.ddd.*;
import mrcp.control.*;


/**
 * Die Klasse Adjustmentcontrol bernimmt das Event-Handling von
 * der Karteikarte Schichtselektion. Alle Events werden hier abgefangen
 * und bearbeitet. Dazu werden Methoden der untergeordneten Klassen
 * aufgerufen.
 * 
 * @author Thomas Demuth
 * @version 2000.08.10
 */
public class Adjustment_control implements ActionListener, MouseMotionListener, MouseListener, ChangeListener, ItemListener {

	// Member


	/**
	 * Verweis auf die grafische Oberflche
	 */
	private gui		my_gui;


	/**
	 * Translationskomponente X fr die schiefe Projektion
	 */
	private int		transX = 0;


	/**
	 * Translationskomponente Y fr die schiefe Projektion
	 */

	private int		transY = 0;


	/**
	 * Komponente x der letzte Mausposition
	 */
	private int		oldx = 0;


	/**
	 * Komponente y der letzte Mausposition
	 */
	private int		oldy = 0;


	/**
	 * Translationskomponenten fr die Orthogonal-Projektionen
	 */
	private float trans_sel_X = 0, trans_sel_Y = 0, trans_sel_Z = 0;


	/**
	 * Diskrete Translationskomponenten fr die Orthogonal-Projektion
	 */
	private int		old_sel_X = 0, old_sel_Y = 0, old_sel_Z = 0;


	/**
	 * Der Konstruktor erzeugt einen neuen Event-Handling Adapter
	 * Als Parameter wird ein Verweis auf die auslsende grafische
	 * Oberflche bentigt.
	 * 
	 * @param my_gui zugehrige grafische Oberflche
	 * 
	 */
	public Adjustment_control(gui my_gui) {
		this.my_gui = my_gui;
	}


	/**
	 * Die Methode liefert die zugehrige grafische Oberflche zurck.
	 * 
	 * 
	 * @return Ereignis auslsende grafische Oberflche
	 * 
	 * 
	 */
	private gui getGui() {
		return this.my_gui;
	} 


	// Button Steuerung


	/**
	 * Die Methode steuert das Event-Handling fr alle Schaltflchen.
	 * Nach Klrung der Quelle werden die entsprechenden Methoden aufgerufen.
	 * Die bentigten Transformationen, Translationen und Rotationen werden in
	 * mrcp.graphics.Update_control verarbeitet. Mit der Schaltflche "neu" wird
	 * der Schichtparameter-Dialog aufgerufen.
	 * @param e Das Aktionsereignis
	 * 
	 * mrcp.graphics.Update_control
	 */
	public void actionPerformed(ActionEvent e) {

		// Optionen
		if ("Optionen einstellen".equals(e.getActionCommand())) {

			// JColorChooser cc = new JColorChooser () ;
			// cc.showDialog (getGui (),"choose color",Color.black) ;

			Optionen_Dialog d = new Optionen_Dialog(getGui(), "Optionen", true);

			// d.setVisible(true);
			d.show();
			d.dispose();
			getGui().Sourceselection.source_control.redraw = true;
			getGui().Sourceselection.jPanelDicomCube.update = true;

		} 

		// Datei schlieen
		if ("Schlieen".equals(e.getActionCommand())) {

			System.exit(0);
		} 

		// Rotate Y Left
		if ("Rotate Y Left".equals(e.getActionCommand())) {
			Update_control.NewPreView = true;
			Update_control.rotateY(Global_Options.RotateStep);
			getGui().Adjustments3D.repaint();
		} else if ("Rotate Y Right".equals(e.getActionCommand())) {
			Update_control.NewPreView = true;
			Update_control.rotateY(-Global_Options.RotateStep);
			getGui().Adjustments3D.repaint();
		} else if ("Rotate Z Right".equals(e.getActionCommand())) {
			Update_control.NewPreView = true;
			Update_control.rotateZ(-Global_Options.RotateStep);
			getGui().Adjustments3D.repaint();
		} else if ("Rotate Z Left".equals(e.getActionCommand())) {
			Update_control.NewPreView = true;
			Update_control.rotateZ(Global_Options.RotateStep);
			getGui().Adjustments3D.repaint();
		} else if ("Rotate X Left".equals(e.getActionCommand())) {
			Update_control.NewPreView = true;
			Update_control.rotateX(-Global_Options.RotateStep);
			getGui().Adjustments3D.repaint();
		} else if ("Rotate X Right".equals(e.getActionCommand())) {
			Update_control.NewPreView = true;
			Update_control.rotateX(Global_Options.RotateStep);
			getGui().Adjustments3D.repaint();
		} 


		// BGs
		if ("BG -z".equals(e.getActionCommand())) {
			Update_control.Trans_Z -= 5;
			showTra();
		} else if ("BG +z".equals(e.getActionCommand())) {
			Update_control.Trans_Z += 5;
			showTra();
		} else if ("BG -x".equals(e.getActionCommand())) {
			Update_control.Sag_X -= 5;
			showSag();
		} else if ("BG +x".equals(e.getActionCommand())) {
			Update_control.Sag_X += 5;
			showSag();
		} else if ("BG -y".equals(e.getActionCommand())) {
			Update_control.Cor_Y -= 5;
			showCor();
		} else if ("BG +y".equals(e.getActionCommand())) {
			Update_control.Cor_Y += 5;
			showCor();
		} else if ("width-".equals(e.getActionCommand())) {
			Update_control.NewPreView = true;
			Update_control.translateWidth(-3.0f);
			getGui().Adjustments3D.repaint();
		} else if ("width+".equals(e.getActionCommand())) {
			Update_control.NewPreView = true;
			Update_control.translateWidth(+4.0f);
			getGui().Adjustments3D.repaint();

		} else if ("heigth-".equals(e.getActionCommand())) {
			Update_control.NewPreView = true;
			Update_control.translateHeigth(-4.0f);
			getGui().Adjustments3D.repaint();
		} else if ("heigth+".equals(e.getActionCommand())) {
			Update_control.NewPreView = true;
			Update_control.translateHeigth(+4.0f);
			getGui().Adjustments3D.repaint();
		} else if ("depth-".equals(e.getActionCommand())) {
			Update_control.NewPreView = true;
			Update_control.translateDepth(-1.0f);
			getGui().Adjustments3D.repaint();
		} else if ("depth+".equals(e.getActionCommand())) {
			Update_control.NewPreView = true;
			Update_control.translateDepth(+1.0f);
			getGui().Adjustments3D.repaint();
		} else if ("set".equals(e.getActionCommand())) {
			Slice_Dialog	sd = new Slice_Dialog(getGui(), "Bestimmen Sie die Schichtparameter", true);

			sd.show();
			if (sd.isCanceld) {
				return;
			} 
			getGui().slicetree.setSelectedSeries();
			showOrtho();

		} else if ("Update".equals(e.getActionCommand())) {
			showUpdate();
		} else if ("next".equals(e.getActionCommand())) {
			Update_control.NewPreView = true;
			Update_control.increment();
			showUpdate();
			getGui().Adjustments3D.repaint();

		} else if ("prev".equals(e.getActionCommand())) {
			Update_control.NewPreView = true;
			Update_control.decrement();
			showUpdate();
			getGui().Adjustments3D.repaint();

		} else if ("ImageJ".equals(e.getActionCommand())) {

			showImages();

		}		// ImageJ
 
		else if ("Export".equals(e.getActionCommand())) {
			exportDicom();
		}		// Export
 	 }		// action performed
 


	/**
	 * Die Methode wird nicht genutzt, mu aber verwendet werden,
	 * um das entsprechende Interface zu implementieren.
	 * 
	 * @param m Das Mausereignis
	 * 
	 * 
	 */
	public void mouseMoved(MouseEvent m) {}


	/**
	 * Die Methode steuert das Ziehen der Maus.
	 * Insbesondere wird die Translation der Schichten in den Orthogonalprojektionen
	 * und der SchiefProjektion durch das Ziehen der Maus verwirklicht.
	 * 
	 * @param e Das Mausereignis
	 * 
	 * 
	 */
	public void mouseDragged(MouseEvent e) {

		// IJ.write("Mouse dragged");
		if (getGui().slicetree.NumberOfSelectesSeries <= 0) {
			return;

		} 
		Object	ob = e.getSource();
		String	name = ob.getClass().getName();

		if (ob.getClass().getName().indexOf("JPanel_Cube") > 0) {
			transX += -oldx + e.getX();
			transY += -oldy + e.getY();
			oldx = e.getX();
			oldy = e.getY();
			Update_control.View3D_transX = transX;
			Update_control.View3D_transY = transY;
			getGui().jPanel_cube.repaint();
		} 
		JPanel	pan = (JPanel) ob;

		name = pan.getName();
                if (name == null) return ;

		if (name.compareTo("Tra") == 0) {
			Update_control.NewPreView = true;
			trans_sel_X = (-old_sel_X + e.getX());
			trans_sel_Y = (-old_sel_Y + e.getY());

			// translate all
			Update_control.translate(trans_sel_X, trans_sel_Y, 0);

			// getGui ().jPanel1_BG.repaint () ;
			getGui().Adjustments3D.repaint();
			old_sel_X = e.getX();
			old_sel_Y = e.getY();

		} 

		if (name.compareTo("Sag") == 0) {
			Update_control.NewPreView = true;
			trans_sel_Y = (-old_sel_Y + e.getX());
			trans_sel_Z = (-old_sel_Z + e.getY());

			// IJ.write(new Float(trans_sel_Z).toString());
			Update_control.translate(0, trans_sel_Y, -trans_sel_Z);

			// getGui ().jPanel1_BG.repaint () ;
			getGui().Adjustments3D.repaint();
			old_sel_Y = e.getX();
			old_sel_Z = e.getY();

		} 
		if (name.compareTo("Cor") == 0) {
			Update_control.NewPreView = true;
			trans_sel_X = (-old_sel_X + e.getX());
			trans_sel_Z = (-old_sel_Z + e.getY());

			// IJ.write(new Float(trans_sel_Z).toString());
			Update_control.translate(trans_sel_X, 0, -trans_sel_Z);

			// getGui ().jPanel1_BG.repaint () ;
			getGui().Adjustments3D.repaint();
			old_sel_X = e.getX();
			old_sel_Z = e.getY();

		} 




	} 


	/**
	 * Steuert das Event-Handling fr die gedrckte Maustaste.
	 * Hier werden die Mauspositionen gespeichert, um das Klicken & Ziehen
	 * zu verwirlichen.
	 * @param e Das Mausereignis
	 * 
	 * 
	 */
	public void mousePressed(MouseEvent e) {

		// IJ.write("Mouse pressed");
		Object	ob = e.getSource();
		String	name = ob.getClass().getName();

		if (name.indexOf("JPanel_Cube") > 0) {
			oldx = e.getX();
			oldy = e.getY();

			// IJ.write ("Mouse PRESSED JP cube");
		} 

		JPanel	pan = (JPanel) ob;

		name = pan.getName();
                if (name == null) return ;

		if (name.compareTo("Tra") == 0) {

			// IJ.write ("Mouse PRESSED TRA");
			old_sel_X = e.getX();
			old_sel_Y = e.getY();
		} else if (name.compareTo("Sag") == 0) {

			// IJ.write ("Mouse PRESSED Sag");
			old_sel_Y = e.getX();
			old_sel_Z = e.getY();
		} else if (name.compareTo("Cor") == 0) {

			// IJ.write ("Mouse PRESSED Cor");
			old_sel_X = e.getX();
			old_sel_Z = e.getY();
		} 
	} 


	/**
	 * Die Methode wird nicht genutzt, mu aber verwendet werden,
	 * um das entsprechende Interface zu implementieren.
	 * 
	 * @param m Das Mausereignis
	 * 
	 * 
	 */
	public void mouseReleased(MouseEvent m) {}


	/**
	 * Die Methode wird nur verwendet, um das entsprechende
	 * Interface zu implementieren.
	 * 
	 * @param m Das Mausereignis
	 * 
	 * 
	 */
	public void mouseClicked(MouseEvent m) {}


	/**
	 * Die Methode wird nur verwendet, um das entsprechende
	 * Interface zu implementieren.
	 * 
	 * @param m Das Mausereignis
	 * 
	 * 
	 */
	public void mouseEntered(MouseEvent m) {}


	/**
	 * Die Methode wird nur verwendet, um das entsprechende
	 * Interface zu implementieren.
	 * 
	 * 
	 * @param m Das Mausereignis
	 * 
	 * 
	 */
	public void mouseExited(MouseEvent m) {}


	/**
	 * Stuert das Event-Handling fr alle Schieberegler.
	 * Insbesondere wird hier die Zoom-Steuerung kontrolliert.
	 * 
	 * @param ce
	 * 
	 * 
	 */
	public void stateChanged(ChangeEvent ce) {
		JSlider source = (JSlider) (ce.getSource());

		boolean isadj = source.getValueIsAdjusting();

		if (isadj) {

			// IJ.write("adjusting");
		} else {

			// IJ.write("not adjusting");
		} 
		Update_control.scale = source.getValue() * 0.01f;
		getGui().jPanel_cube.repaint();
	} 


	/**
	 * Steuert das Event-Handling der Checkbox "Alle Schichten"
	 * 
	 * 
	 * @param ie Das ItemEvent
	 * 
	 * 
	 */
	public void itemStateChanged(ItemEvent ie) {
		Update_control.showAll = !Update_control.showAll;
		getGui().Adjustments3D.repaint();
	} 


	/**
	 * Ruft das ImageJ Plugin Dicom_export auf, welches die
	 * aktuellen ImagePlus Dateien als Secondary Capture exportiert.
	 * 
	 * 
	 */
	private void exportDicom() {
            
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp == null)
                IJ.write("Keine Bilder in ImageJ geffnet");

		// IJ.runPlugIn("ij.plugin.DICOM_export", "");
		IJ.runPlugIn("DICOM_export", "");
	} 


	/**
	 * Die Methode berechnet basierend auf den vorgenommenen Einstellungen
	 * einen neuen Schichtstapel und exportiert diesen als Imagestack in ImageJ.
	 * Der Proze wird in einem eigenen Thread gestartet und ber einen
	 * Fortschrittsbalken dokumentiert.
	 * 
	 * 
	 */
	private void showImages() {


		final SwingWorker worker = new SwingWorker() {


			/**
			 * Method declaration
			 * 
			 * 
			 * @return
			 * 
			 * 
			 */
			public Object construct() {


				Point3D RowVector = Update_control.RowVec;
				Point3D ColVector = Update_control.ColVec;
				Point3D SliceVector = Update_control.SliceVec;
				float		RowSpacing = Update_control.width / Update_control.Cols;
				float		ColSpacing = Update_control.heigth / Update_control.Rows;

				byte[]	cTab = new byte[256];

				for (int i = 0; i < 256; i++) {
					cTab[i] = (byte) i;
				} 
				ColorModel			cModel = new IndexColorModel(8, 256, cTab, cTab, cTab);

				ProgressMonitor mon = new ProgressMonitor(IJ.getInstance(), "Berechne Schicht(en)", "", 0, Update_control.Rows * Update_control.CubeArray.size());
				ImageStack			is = new ImageStack(Update_control.Cols, Update_control.Rows);

				int							old = Update_control.currentSlice;

				Update_control.currentSlice = 0;
				Point3D Origin = Update_control.getOrigin();

				Update_control.currentSlice = old;
				if (Origin == null) {
					return null;
				} 
				short[][] Pixels;

				Pixels = getGui().slicetree.getSlices(Origin, RowVector, ColVector, SliceVector, RowSpacing, ColSpacing, Update_control.depth, Update_control.Rows, Update_control.Cols, mon, Update_control.CubeArray.size(), Update_control.slicedist);

				for (int i = 0; i < Update_control.CubeArray.size(); i++) {
					ShortProcessor	proc = new ShortProcessor(Update_control.Cols, Update_control.Rows, Pixels[i], cModel, false);

					is.addSlice("test" + new Integer(i).toString(), proc);

				}		// i++
 
				String	name = "Interpol : ";

				name += new Integer(Global_Options.Interpolationmodel).toString();
				ImagePlus imp = new ImagePlus("Test Bild " + name, is);

				imp.show();
				return null;
			} 

		};
	}					// show
 

	/**
	 * Zeichnet alle Orthogonalprojektionen neu.
	 * Wird beim erstem Aufruf der Karteikarte aufgerufen.
	 * 
	 * 
	 */
	private void showOrtho() {
		if (getGui().slicetree.NumberOfSelectesSeries <= 0) {
			return;
		} 
		final SwingWorker worker = new SwingWorker() {


			/**
			 * Method declaration
			 *
			 *
			 * @return
			 *
			 */
			public Object construct() {
				Update_control.NewPreView = true;
				getGui().jPanel_cube.repaint();
				getGui().jPanel_Cor.setImage();
				getGui().jPanel_Tra.setImage();
				getGui().jPanel_Sag.setImage();
				getGui().jPanel_Cor.repaint();
				getGui().jPanel_Tra.repaint();
				getGui().jPanel_Sag.repaint();

				getGui().jPanel_Preview.setImage();
				getGui().jPanel_Preview.repaint();

				return null;

			} 

		};	// worker
	} 


	/**
	 * Zeichnet das Vorschaubild in der Karteikarte Schichtselektion neu.
	 * Die Methode wird in einem eigenen Thread gestartet und in einem
	 * Fortschrittsbalken dokumentiert.
	 * 
	 * 
	 */
	private void showUpdate() {

		final SwingWorker worker = new SwingWorker() {


			/**
			 * Method declaration
			 * 
			 * 
			 * @return
			 * 
			 * 
			 */
			public Object construct() {

				getGui().jPanel_Preview.setImage();
				getGui().jPanel_Preview.repaint();

				return null;

			} 

		};	// worker
	} 


	/**
	 * Zeichnet die Coronaransicht in der Karteikarte Schichtselektion neu.
	 * Die Methode wird in einem eigenen Thread gestartet und in einem
	 * Fortschrittsbalken dokumentiert.
	 * 
	 * 
	 */
	private void showCor() {

		final SwingWorker worker = new SwingWorker() {


			/**
			 * Method declaration
			 * 
			 * 
			 * @return
			 * 
			 * 
			 */
			public Object construct() {

				getGui().jPanel_Cor.setImage();
				getGui().jPanel_Cor.repaint();
				return null;

			} 

		};	// worker
	} 


	/**
	 * Zeichnet die Sagittalansicht in der Karteikarte Schichtselektion neu.
	 * Die Methode wird innerhalb eines neuen Threads gestartet um die
	 * Anzeige eines Fortschrittsbalken zu ermglichen.
	 * 
	 * 
	 * 
	 * 
	 */
	private void showSag() {

		final SwingWorker worker = new SwingWorker() {


			/**
			 * Method declaration
			 * 
			 * 
			 * @return
			 * 
			 * 
			 */
			public Object construct() {

				getGui().jPanel_Sag.setImage();
				getGui().jPanel_Sag.repaint();
				return null;

			} 

		};	// worker
	} 


	/**
	 * Zeichnet die Transversalansicht in der Karteikarte Schichtselektion neu.
	 * Die Methode wird innerhalb eines neuen Threads gestartet und in einem
	 * Fortschrittsbalken dokumentiert.
	 * 
	 * 
	 */
	private void showTra() {

		final SwingWorker worker = new SwingWorker() {


			/**
			 * Method declaration
			 * 
			 * 
			 * @return
			 * 
			 * 
			 */
			public Object construct() {

				getGui().jPanel_Tra.setImage();
				getGui().jPanel_Tra.repaint();
				return null;

			} 

		};	// worker
	} 


}






/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

