/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

package mrcp.control;
import java.awt.Image;
import ij.*;
import java.awt.event.*;
import javax.swing.JTree;
import javax.swing.tree.*;
import ij.process.*;
import java.awt.image.*;
import java.awt.image.ColorModel;
import java.awt.*;
import javax.swing.event.*;
import javax.swing.*;
import java.util.*;

import mrcp.gui.*;
import mrcp.graphics.*;
import mrcp.tools.*;
import mrcp.dd.*;
import mrcp.ddd.*;


/**
 * Die Klasse Composite_control bernimmt das Event-Handling von
 * der Karteikarte Bildberlagerung. Alle Events werden hier abgefangen
 * und bearbeitet. Dazu werden zwei zweidimensionales Pixelarrays verwaltet,
 * die berechneten Bildstapel beinhalten. Die aktuell zu zeichnenden Bilden
 * werden als Java-Image bereitgestellt und knnen direkt dargestellt werden.
 * Zustzlich sind Farbmodelle und Alpha-Werte der Bilder zu verwalten.
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class Composite_control implements ActionListener, ChangeListener {


	/**
	 * Verweis auf die gui der Pluginklasse
	 */
	public gui							Document;


	/**
	 * Verweis auf die zugehrige grafische Oberflche
	 */
	public JPanel_Composite source;


	/**
	 * Alphawert des ersten Kanals [0,1]
	 */
	public float						alpha_one = 0.5f;


	/**
	 * Alphawert des zweiten Kanals [0,1]
	 */
	public float						alpha_two = 0.5f;


	/**
	 * Kontrast-Einstellung des ersten Bildes
	 */
	public float						Contrast1 = 1.0f;


	/**
	 * Helligkeits-Einstellung des ersten Bildes
	 */
	public float						Bright1 = 0.0f;


	/**
	 * Kontrast-Einstellung des zweiten Bildes
	 */
	public float						Contrast2 = 1.0f;


	/**
	 * Helligkeits-Einstellung des zweiten Bildes
	 */
	public float						Bright2 = 0.0f;


	/**
	 * Pixeldaten der beiden zu berlagernden Schichtstapeln
	 * Der erste Index gibt die Schichtnummer an.
	 */
	public short[][]				pix1, pix2;


	/**
	 * Translationsvektor des zweiten Bildes zum Referenzbild (Bild 1)
	 */
	public Point2D					trans = new Point2D(0, 0);


	/**
	 * Aktuell zu zeichnende Bilder im Java-Format
	 */
	public Image						i1, i2;


	/**
	 * Farbmodelle der beiden Bildstapel
	 */
	public ColorModel				cModel1, cModel2;


	/**
	 * Aktuell zu zeichnende Bilder als 16 bit Bilder in einem Format von ImagePlus
	 */
	public ShortProcessor		sp, sp2;


	/**
	 * Boolesche Variable, die angibt, ob ein Neuzeichnen der Bilder ntig ist.
	 */
	public boolean					newPics = true;


	/**
	 * Rotationswert im Vergleich zum Referenzbild (BIld 1)
	 */
	public float						rotation = 0;



	/**
	 * Der Konstruktor erzeugt einen neuen Event-Handling Adapter
	 * Als Parameter wird ein Verweis auf die gui der Pluginklasse bentigt.
	 * 
	 * 
	 * 
	 * @param doc Plugin-Klasse
	 * 
	 */
	public Composite_control(gui doc) {
		this.Document = doc;
		setColorModel();
	}


	/**
	 * Berechnet in Abhngigkeit eines eingestellten RGB-Wertes ein neues Farbmodell.
	 * Dazu erfolgt eine Umrechnung des gewhlten Wertes in das HSB Format
	 * und eine Abstufung des Helligkeitswert auf 256 Intervalle.
	 * 
	 * 
	 */
	public void setColorModel() {

		// Stanbdardfarbmodelle
		byte[]	aTab = new byte[256];
		byte[]	rTab = new byte[256];
		byte[]	gTab = new byte[256];
		byte[]	bTab = new byte[256];

		int			r1 = Global_Options.Channel_one.getRed();
		int			g1 = Global_Options.Channel_one.getGreen();
		int			b1 = Global_Options.Channel_one.getBlue();
		float[] hsb = Color.RGBtoHSB(r1, g1, b1, null);
		float		b = hsb[2];

		float		fr1 = r1 / (b * 100) * 100 / 256;
		float		fg1 = g1 / (b * 100) * 100 / 256;
		float		fb1 = b1 / (b * 100) * 100 / 256;

		byte[]	aTab2 = new byte[256];
		byte[]	rTab2 = new byte[256];
		byte[]	gTab2 = new byte[256];
		byte[]	bTab2 = new byte[256];

		int			r2 = Global_Options.Channel_two.getRed();
		int			g2 = Global_Options.Channel_two.getGreen();
		int			b2 = Global_Options.Channel_two.getBlue();
		float[] hsb2 = Color.RGBtoHSB(r2, g2, b2, null);

		b = hsb[2];

		float fr2 = r2 / (b * 100) * 100 / 256;
		float fg2 = g2 / (b * 100) * 100 / 256;
		float fb2 = b2 / (b * 100) * 100 / 256;

		for (int i = 0; i < 256; i++) {
			int temp = (int) (i * fr1 * Contrast1 + Bright1);

			rTab[i] = (byte) temp;
			if (temp > 255) {
				rTab[i] = (byte) 255;

			} 
			temp = (int) (i * fg1 * Contrast1 + Bright1);
			gTab[i] = (byte) temp;
			if (temp > 255) {
				gTab[i] = (byte) 255;

			} 
			temp = (int) (i * fb1 * Contrast1 + Bright1);
			bTab[i] = (byte) temp;
			if (temp > 255) {
				bTab[i] = (byte) 255;

			} 
			temp = (int) (i * fr2 * Contrast2 + Bright2);
			rTab2[i] = (byte) temp;
			if (temp > 255) {
				rTab2[i] = (byte) 255;

			} 
			temp = (int) (i * fg2 * Contrast2 + Bright2);
			gTab2[i] = (byte) temp;
			if (temp > 255) {
				gTab2[i] = (byte) 255;

			} 
			temp = (int) (i * fb2 * Contrast2 + Bright2);
			bTab2[i] = (byte) temp;
			if (temp > 255) {
				bTab2[i] = (byte) 255;

				// aTab[i] = (byte)i ;

			} 
		} 

		cModel1 = new IndexColorModel(8, 256, rTab, gTab, bTab);			// , aTab);
		cModel2 = new IndexColorModel(8, 256, rTab2, gTab2, bTab2);		// , aTab);
	} 


	/**
	 * Standardkonstruktor
	 * 
	 * 
	 */
	public Composite_control() {}


	/**
	 * Die Methode steuert die Ereignisse der Schchieberegler Alpha, Helligkeit und
	 * Kontrast. Nachdem die Quelle des Ereignisses zugeordnet wurde, knnen die
	 * entsprechenden Werte verndert werden und eine Neuzeichnung veranlasst werden.
	 * 
	 * 
	 * @param ce Das nderungsereignis
	 * 
	 * 
	 */
	public void stateChanged(ChangeEvent ce) {

		JSlider sl = (JSlider) ce.getSource();

		// IJ.write("state changed");
		float		val = (float) sl.getValue() / 100.0f;

		if (sl.getName().compareTo("Source") == 0) {

			// IJ.write("Source");
			// IJ.write(new Float(val).toString());

			alpha_one = val;
			Document.Composite.Picture.repaint();
		} else if (sl.getName().compareTo("Dest") == 0) {

			// IJ.write("Dest");
			alpha_two = val;
			Document.Composite.Picture.repaint();
		} else if (sl.getName().compareTo("Bright1") == 0) {

			// Helligkeit
			// IJ.write("Helligkeit");
			Bright1 = val * 100;
			setColorModel();
			newPics = false;
			setPicture();
			Document.Composite.Picture.repaint();
		} else if (sl.getName().compareTo("Bright2") == 0) {

			// Helligkeit
			// IJ.write("Helligkeit2");
			Bright2 = val * 100;
			setColorModel();
			newPics = false;
			setPicture();
			Document.Composite.Picture.repaint();
		} else if (sl.getName().compareTo("Contrast2") == 0) {

			// Helligkeit
			// IJ.write("Kontrast2");
			Contrast2 = (float) val * 5.0f;
			setColorModel();
			newPics = false;
			setPicture();
			Document.Composite.Picture.repaint();
		} else {	// Kontrast

			// IJ.write("Contrast1");
			Contrast1 = (float) val * 5.0f;
			setColorModel();
			newPics = false;
			setPicture();
			Document.Composite.Picture.repaint();
		} 

	} 


	// Button Steuerung


	/**
	 * Die Methode regelt die Ereignisse der Schaltflchen.
	 * Dazu werden die entsprechenden Methoden aufgerufen und ein Neuzeichnen
	 * veranlat. Zeitaufwendige Berechnungen werden in einem eigenen Thread gestartet.
	 * 
	 * 
	 * @param e Das Aktionsereignis
	 * 
	 * @see mrcp.control.setPicture mrcp.control.setPicture2
	 */
	public void actionPerformed(ActionEvent e) {

		if ("Draw".equals(e.getActionCommand())) {
			newPics = true;
			setColorModel();
			final SwingWorker worker = new SwingWorker() {


				/**
				 * Method declaration
				 *
				 *
				 * @return
				 *
				 */
				public Object construct() {
					setPicture();
					Document.Composite.Picture.repaint();
					return null;

				} 

			};	// worker

		} 


		if ("up".equals(e.getActionCommand())) {

			// IJ.write("up");
			// trans.y -= 1;
			trans.translate(0, -1);
			Document.Composite.Picture.repaint();
			update_SliceTree(0, -1);
		} 
		if ("down".equals(e.getActionCommand())) {

			// IJ.write("down");
			// trans.y += 1;
			trans.translate(0, 1);
			Document.Composite.Picture.repaint();
			update_SliceTree(0, 1);
		} 



		if ("left".equals(e.getActionCommand())) {

			// IJ.write("left");
			// trans.x -= 1;
			trans.translate(-1, 0);
			Document.Composite.Picture.repaint();
			update_SliceTree(-1, 0);
		} 

		if ("rigth".equals(e.getActionCommand())) {

			// IJ.write("rigth");
			// trans.x += 1;
			trans.translate(1, 0);
			Document.Composite.Picture.repaint();
			update_SliceTree(1, 0);
		} 
		if ("rotl".equals(e.getActionCommand())) {

			// IJ.write("rot left");
			rotation += (-Math.PI / 128.0f);
			Document.Composite.Picture.repaint();
		} 

		if ("rotr".equals(e.getActionCommand())) {

			// IJ.write("rot rigth");
			rotation += (Math.PI / 128.0f);
			Document.Composite.Picture.repaint();
		} 

		if ("slr".equals(e.getActionCommand())) {

			// IJ.write("sl rigth");
			Update_control.increment();
			setPicture2();
			Document.Composite.Picture.repaint();
		} 

		if ("sll".equals(e.getActionCommand())) {

			// IJ.write("sl left");
			Update_control.decrement();
			setPicture2();
			Document.Composite.Picture.repaint();
		} 

	} 


	/**
	 * Die Methode berechnet mit den aktuellen Einstellungen, die
	 * zu berlagernden Bilder. Dazu werden jeweils die selektierten Quellen
	 * in einem 3D-Datensatz umgesetzt und entsprechend der Schichtwahl neue
	 * Bildstapel berechnet. Die Darstellung erfolgt mit einem optimalen
	 * Helligkeits-Kontrast-Wert.
	 * 
	 */
	public void setPicture() {
		if (newPics) {
			int[]					ser1, ser2;
			JProgressBar	bar = Document.Composite.jProgressBar1;

			bar.setMinimum(0);
			bar.setMaximum((int) Update_control.Rows * Update_control.CubeArray.size());

			ser1 = Document.Composite.jList1.getSelectedIndices();
			ser2 = Document.Composite.jList_ser2.getSelectedIndices();
			if (ser1.length <= 0 || ser2.length <= 0) {
				return;

				// Bild 1 Quellen limmitieren
			} 
			Document.slicetree.setSelectedSeries(ser1);
			Point3D RowVector = Update_control.RowVec;
			Point3D ColVector = Update_control.ColVec;
			Point3D SliceVector = Update_control.SliceVec;
			float		RowSpacing = Update_control.width / Update_control.Cols;
			float		ColSpacing = Update_control.heigth / Update_control.Rows;

			int			old = Update_control.currentSlice;

			Update_control.currentSlice = 0;
			Point3D Origin = Update_control.getOrigin();

			Update_control.currentSlice = old;
			if (Origin == null) {
				return;
			} 
			pix1 = Document.slicetree.getSlices_2(Origin, RowVector, ColVector, SliceVector, RowSpacing, ColSpacing, Update_control.depth, Update_control.Rows, Update_control.Cols, bar, Update_control.CubeArray.size(), Update_control.slicedist);


			// Bild 2 Quellen limmitieren
			Document.slicetree.setSelectedSeries(ser2);
			old = Update_control.currentSlice;
			Update_control.currentSlice = 0;
			Origin = Update_control.getOrigin();
			Update_control.currentSlice = old;
			if (Origin == null) {
				return;
			} 
			pix2 = Document.slicetree.getSlices_2(Origin, RowVector, ColVector, SliceVector, RowSpacing, ColSpacing, Update_control.depth, Update_control.Rows, Update_control.Cols, bar, Update_control.CubeArray.size(), Update_control.slicedist);
			newPics = false;
		} 

		sp2 = new ShortProcessor(Update_control.Cols, Update_control.Rows, pix2[Update_control.currentSlice], cModel2, false);
		sp = new ShortProcessor(Update_control.Cols, Update_control.Rows, pix1[Update_control.currentSlice], cModel1, false);

		if (newPics) {
			ImagePlus imp = new ImagePlus("", sp);

			autoAdjust(imp, sp);
			ImagePlus imp2 = new ImagePlus("", sp2);

			autoAdjust(imp2, sp2);
		} 

		i1 = sp.createImage();
		i2 = sp2.createImage();
	} 


	/**
	 * Die Methode berechnet automatisch einen optimalen Helligkeits-Kontrast-Wert.
	 * Dazu wird eine Methode aus ImageJ umgeschrieben.
	 * 
	 * @param imp Das ImagePlus Bild
	 * @param ip  Die zugehrigen Pixeldaten
	 * 
	 * 
	 */
	public void autoAdjust(ImagePlus imp, ImageProcessor ip) {

		ImageStatistics stats = imp.getStatistics();
		int[]						histogram = stats.histogram;
		int							threshold = stats.pixelCount / 5000;
		int							i = -1;
		boolean					found = false;

		do {
			i++;
			found = histogram[i] > threshold;
		} while (!found && i < 255);
		int hmin = i;

		i = 256;
		do {
			i--;
			found = histogram[i] > threshold;
		} while (!found && i > 0);
		int hmax = i;

		if (hmax > hmin) {
			imp.killRoi();
			double	min = stats.histMin + hmin * stats.binSize;
			double	max = stats.histMin + hmax * stats.binSize;

			ip.setMinAndMax(min, max);
		} 


	} 


	/**
	 * Die Methode berechnet mit den aktuellen Einstellungen, die
	 * zu berlagernden Bilder. Dazu wird an dieser Stelle nur im
	 * 2D Pixelarray pix1, pix2 der erste Index erhht bzw. erniedrigt.
	 * Dies entspricht dem Bettigen der Pfeiltasten, um im Datensatz zu blttern.
	 * Die aktuellen Bilder werden mit einem optimalen Helligkeits-Kontrast_wert dargestellt.
	 * 
	 */
	public void setPicture2() {
		if (pix1 == null || pix2 == null) {
			return;
		} 
		sp2 = new ShortProcessor(Update_control.Cols, Update_control.Rows, pix2[Update_control.currentSlice], cModel2, false);
		sp = new ShortProcessor(Update_control.Cols, Update_control.Rows, pix1[Update_control.currentSlice], cModel1, false);

		ImagePlus imp = new ImagePlus("", sp);

		autoAdjust(imp, sp);
		ImagePlus imp2 = new ImagePlus("", sp2);

		autoAdjust(imp2, sp2);

		i1 = sp.createImage();
		i2 = sp2.createImage();



	} 


	/**
	 * Die Methode verndert nach nderung der Position des 2.Bildes die DICOM-Attribute
	 * im Schichtbaum. Damit werden die nderung fr alle spteren Kalkulationen genutzt.
	 * @param x x-Komponente der Translation
	 * @param y y-Komponente der Translation
	 */

	public void update_SliceTree(float x, float y) {


		// Alle Quellserien extrahieren
		int[] ser;

		ser = Document.Composite.jList_ser2.getSelectedIndices();

		for (int i = 0; i < ser.length; i++) {
			DefaultMutableTreeNode	Serie = (DefaultMutableTreeNode) Document.slicetree.root.getChildAt(ser[i]);
			DefaultMutableTreeNode	FirstChild = (DefaultMutableTreeNode) Serie.getFirstChild();
			Slice_Leaf							leaf = (Slice_Leaf) FirstChild.getUserObject();
			Dicom_Slice							FirstSlice = leaf.cube.ds;
			Series_Node							sn = (Series_Node) Serie.getUserObject();

			Enumeration							leafs = Serie.children();

			while (leafs.hasMoreElements()) {
				DefaultMutableTreeNode	child = (DefaultMutableTreeNode) leafs.nextElement();
				Slice_Leaf							sl = (Slice_Leaf) child.getUserObject();

				// Umrechnung der Pixelverschiebung in mm
				float										wid = Document.Composite.Picture.wid;

				float										factor = wid / Update_control.width;

				// Ebene bestimmen
				Point3D									trans1 = Update_control.RowVec.Sk_Mult(factor * x);
				Point3D									trans2 = Update_control.ColVec.Sk_Mult(factor * y);

				sl.cube.translate(trans1.getX(), trans1.getY(), trans1.getZ());
				sl.cube.translate(trans2.getX(), trans2.getY(), trans2.getZ());

				// sl.cube.ds.ImagePosition.translate (trans1.Sk_Mult(-1)) ;
				// sl.cube.ds.ImagePosition.translate (trans2.Sk_Mult(-1)) ;

				sl.cube.ds.setValues();


			}		// while
 
		}			// i
		 Document.slicetree.resetBB();
		Document.slicetree.update();

		// Document.slicetree.
	}		// update ()
 
}






/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

