/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

package mrcp.control;
import java.awt.event.*;
import java.awt.*;
import javax.swing.*;

import mrcp.gui.*;
import mrcp.graphics.*;
import mrcp.tools.*;
import mrcp.dd.*;
import mrcp.ddd.*;


/**
 * Die Klasse Options_control bernimmt das Event-Handling von
 * der Karteikarte Farben im Optionenmen. Alle Events werden hier abgefangen
 * und bearbeitet. Dazu wird ein Exemplar von JColorChooser erzeugt und mit
 * dem Momentanfarbwert initialisiert. Der Rckgabewert wird in den globalen Optionen
 * gespeichert.
 * 
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class Options_control implements ActionListener {
	TabbedPages_Options comp;


	/**
	 * Der Konstruktor erzeugt einen neuen Event-Handling Adapter
	 * Als Parameter wird ein Verweis auf die zugehrige grafische
	 * Oberflche bentigt.
	 * 
	 * 
	 * @param comp Die zugehrige grafische Oberflche
	 * 
	 */
	public Options_control(TabbedPages_Options comp) {
		this.comp = comp;
	}


	/**
	 * Die Methode kontrolliert die Reaktion auf die Schaltfchen "whle".
	 * 
	 * 
	 * @param e Das Aktionsereignis
	 * 
	 * 
	 */
	public void actionPerformed(ActionEvent e) {

		if ("Color_TransversalColor".equals(e.getActionCommand())) {

			JColorChooser cs = new JColorChooser();

			Global_Options.TransversalColor = cs.showDialog(comp, "Transversalfarbe", Global_Options.TransversalColor);

			// comp.jButton1.setBackground(Global_Options.TransversalColor);
			comp.updateColor();

			// comp.jPanel_color.validate();
			// redraw (comp.jPanel_color) ;
		} else if ("Color_SagittalColor".equals(e.getActionCommand())) {

			JColorChooser cs = new JColorChooser();

			Global_Options.SagittalColor = cs.showDialog(comp, "Sagittalfarbe", Global_Options.SagittalColor);

			// comp.jButton1.setBackground(Global_Options.TransversalColor);
			comp.updateColor();

			// comp.jPanel_color.validate();
			// redraw (comp.jPanel_color) ;
		} else if ("Color_CoronarColor".equals(e.getActionCommand())) {

			JColorChooser cs = new JColorChooser();

			Global_Options.CoronarColor = cs.showDialog(comp, "Coronarfarbe", Global_Options.CoronarColor);

			// comp.jButton1.setBackground(Global_Options.TransversalColor);
			comp.updateColor();

			// comp.jPanel_color.validate();
			// redraw (comp.jPanel_color) ;
		} else if ("Color_Channel_one".equals(e.getActionCommand())) {

			JColorChooser cs = new JColorChooser();

			Global_Options.Channel_one = cs.showDialog(comp, "Kompositionsfarbe 01", Global_Options.Channel_one);

			// comp.jButton1.setBackground(Global_Options.TransversalColor);
			comp.updateColor();

			// comp.jPanel_color.validate();
			// redraw (comp.jPanel_color) ;
		} else if ("Color_Channel_two".equals(e.getActionCommand())) {
			JColorChooser cs = new JColorChooser();

			Global_Options.Channel_two = cs.showDialog(comp, "Kompositionsfarbe 02", Global_Options.Channel_two);
			comp.updateColor();
		} else if ("BoundingColor".equals(e.getActionCommand())) {
			JColorChooser cs = new JColorChooser();

			Global_Options.BoundingColor = cs.showDialog(comp, "Umgebungsquaderfarbe", Global_Options.BoundingColor);
			comp.updateColor();
		} else if ("IntersectionColor".equals(e.getActionCommand())) {
			JColorChooser cs = new JColorChooser();

			Global_Options.IntersectionColor = cs.showDialog(comp, "Schnittquaderfarbe", Global_Options.IntersectionColor);
			comp.updateColor();
		} else if ("CurrentSliceColor".equals(e.getActionCommand())) {
			JColorChooser cs = new JColorChooser();

			Global_Options.CurrentSliceColor = cs.showDialog(comp, "Aktuelle Schichtfarbe", Global_Options.CurrentSliceColor);
			comp.updateColor();
		} else if ("GlobalCubeColor".equals(e.getActionCommand())) {
			JColorChooser cs = new JColorChooser();

			Global_Options.GlobalCubeColor = cs.showDialog(comp, "MRT Quaderfarbe", Global_Options.GlobalCubeColor);
			comp.updateColor();
		} else if ("SelectionColor".equals(e.getActionCommand())) {
			JColorChooser cs = new JColorChooser();

			Global_Options.SelectionColor = cs.showDialog(comp, "Auswahlquaderfarbe", Global_Options.SelectionColor);
			comp.updateColor();
		} 


	}		// action performed
 

	/**
	 * Die Methode zeichnet die Karteikarte neu und frbt damit
	 * die Schaltflchen mit der ausgewhlten Farbe.
	 * 
	 * @param c Die zugehrige grafische Komponente
	 * 
	 * 
	 */
	public void redraw(Component c) {
		c.validate();
		c.repaint();
	} 

}






/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

