/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/


package mrcp.control;

import java.awt.event.*;
import java.awt.FontMetrics.*;
import javax.swing.*;
import ij.*;
import java.io.*;
import javax.swing.event.*;
import java.util.*;
import java.awt.*;
import ij.io.*;
import rad.dicom.dcm.*;
import javax.swing.tree.*;
import ij.process.*;
import java.awt.image.ColorModel;
import java.awt.image.*;
import ij.gui.*;

import mrcp.gui.*;
import mrcp.graphics.*;
import mrcp.tools.*;
import mrcp.dd.*;
import mrcp.ddd.*;


/**
 * Die Klasse Source_control bernimmt das Event-Handling von
 * Karteikarte Quellenselektion. Alle Events werden hier abgefangen
 * und bearbeitet. Dazu werden Methoden der untergeordneten Klassen
 * aufgerufen.
 *
 * @author Thomas Demuth
 * @version 2000.08.10
 *
 *
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class Source_control implements TreeSelectionListener, ActionListener, ChangeListener, MouseMotionListener, MouseListener {
    
    
    /**
     * Verweis auf die gui der Pluginklasse
     */
    gui										Document;
    
    
    /**
     * Verweis auf die zugehrige grafische Oberflche
     */
    JPanel_Source					gui;
    
    
    /**
     * Boolesche Variable, die angibt, ob ein Umgebungsquader zu zeichnen ist.
     */
    boolean								BoundingBox = false;
    
    
    /**
     * Boolesche Variable, die angibt, ob ein Schnittquader zu zeichnen ist.
     */
    boolean								IntersectionBox = false;
    
    
    /**
     * Aktueller Projektionstyp (Auf-, Seiten-, Grundri, Schiefprojektion)
     */
    byte									Projection_Type = 0;
    
    
    /**
     * Zoomfaktor
     */
    float									Zoom = 0.5f;
    
    
    /**
     * Boolesche Variable, die angibt, ob die Bildflche neu zu zeichnen ist
     */
    public boolean				redraw = true;
    
    
    
    private final byte		unknown = 0;
    private final byte		Tra = 1;
    private final byte		Tra_Cor = 2;
    private final byte		Tra_Sag = 3;
    
    private final byte		Sag = 4;
    private final byte		Sag_Tra = 5;
    private final byte		Sag_Cor = 6;
    
    private final byte		Cor = 7;
    private final byte		Cor_Tra = 8;
    private final byte		Cor_Sag = 9;
    
    private final int			bigger = 2;
    private final int			smaller = 1;
    private final int			equal = 0;
    private final int			NewSerie = -1;
    
    
    /**
     * Verwaltet den Translationsvektor der Schiefprojektion
     */
    int										transX, transY = 0;
    
    
    /**
     * Speichert die Mauskoordinaten zur Implementierung eines "Klicken & Ziehen"
     */
    int										oldx = 0, oldy = 0;
    
    
    final private String	separator = System.getProperty("file.separator");
    
    
    /**
     * Stringreprsentation der momentan ausgewhlten Serien
     */
    static String					SelectedSeries = "";
    
    // Konstruktor
    
    
    /**
     * Der Konstruktor erzeugt einen neuen Event-Handling Adapter
     * Als Parameter wird ein Verweis auf die auslsende grafische
     * Oberflche und die gui der Pluginklasse bentigt.
     *
     *
     * @param Document gui der Plugin-Klasse
     * @param gui grafische Oberflche
     *
     */
    public Source_control(gui Document, JPanel_Source gui) {
        this.Document = Document;
        this.gui = gui;
        
    }
    
    
    /**
     * Die Methode liefert die gui der Plugin-Klasse zurck.
     *
     *
     * @return gui der Plugin-Klasse
     *
     *
     */
    public gui getDocument() {
        return this.Document;
    }
    
    
    /**
     * Die Methode liefert die zugeehrige grafische Oberflche zurck.
     *
     *
     * @return zugehrige grafische Oberflche
     *
     *
     */
    public JPanel_Source getGui() {
        return this.gui;
    }
    
    // Button Steuerung
    
    
    /**
     * Die Methode kontrolliert die Reaktion auf das Drcken der Schaltflchen.
     * Je nach Art der gewhlten Projektion wird die Bildflche neu gezeichnet.
     * Fr den Knopf "Auswerten" wird ein neuer Dialog gestartet und der Proze
     * in einem eigenen Thread ausgefhrt. Gleiches gilt fr das Hinzufgen
     * neuer 2D-Datenstze.
     *
     * @param e Das Aktionsereignis
     *
     *
     */
    public void actionPerformed(ActionEvent e) {
        
        if ("Add Files".equals(e.getActionCommand())) {
            
            
            
            // BETTER CODE:
            final SwingWorker worker = new SwingWorker() {
                
                
                /**
                 * Method declaration
                 *
                 *
                 * @return
                 *
                 *
                 */
                public Object construct() {
                    
                    // ...code that might take a while to execute is here...
                    readSlices();
                    return null;
                }
                
            };	// worker
            
            
        }			// add files
        
        
        // delete from File List
        if ("Delete File".equals(e.getActionCommand())) {
            TreePath[]	paths = (getGui().tree).getSelectionPaths();
            
            if (paths == null) {
                return;
            }
            JTree							tree = getGui().tree;
            DefaultTreeModel	model = (DefaultTreeModel) tree.getModel();
            
            // nur die erste Markierung lschen !
            TreePath					currentSelection = paths[0];
            
            if (currentSelection != null) {
                
                // tree.removeSelectionPath(currentSelection);
                DefaultMutableTreeNode	currentNode = (DefaultMutableTreeNode) (currentSelection.getLastPathComponent());
                MutableTreeNode					parent = (MutableTreeNode) (currentNode.getParent());
                
                if (parent != null) {
                    try {
                        model.removeNodeFromParent(currentNode);
                    } catch (Exception trex) {}
                    
                    // parent.remove(currentNode);
                }
                
            }
            
            // tree.removeSelectionPath(currentSelection);
            
            (getGui().tree).resetBB();
            (getGui().tree).update();
            (getGui().g.Composite).setSeriesStrings();
            
            // BB berechen
            Point3D p1 = new Point3D((getGui().tree).MinX, (getGui().tree).MinY, (getGui().tree).MinZ);
            Point3D p2 = new Point3D((getGui().tree).MaxX, (getGui().tree).MinY, (getGui().tree).MinZ);
            Point3D p3 = new Point3D((getGui().tree).MinX, (getGui().tree).MaxY, (getGui().tree).MinZ);
            Point3D p4 = new Point3D((getGui().tree).MaxX, (getGui().tree).MaxY, (getGui().tree).MinZ);
            Point3D p5 = new Point3D((getGui().tree).MinX, (getGui().tree).MinY, (getGui().tree).MaxZ);
            Point3D p6 = new Point3D((getGui().tree).MaxX, (getGui().tree).MinY, (getGui().tree).MaxZ);
            Point3D p7 = new Point3D((getGui().tree).MinX, (getGui().tree).MaxY, (getGui().tree).MaxZ);
            Point3D p8 = new Point3D((getGui().tree).MaxX, (getGui().tree).MaxY, (getGui().tree).MaxZ);
            
            Update_control.BB = new Bounding_Cube(p1, p2, p3, p4, p5, p6, p7, p8, Global_Options.BP);
            
            p1 = new Point3D((getGui().tree).MinX2, (getGui().tree).MinY2, (getGui().tree).MinZ2);
            p2 = new Point3D((getGui().tree).MaxX2, (getGui().tree).MinY2, (getGui().tree).MinZ2);
            p3 = new Point3D((getGui().tree).MinX2, (getGui().tree).MaxY2, (getGui().tree).MinZ2);
            p4 = new Point3D((getGui().tree).MaxX2, (getGui().tree).MaxY2, (getGui().tree).MinZ2);
            p5 = new Point3D((getGui().tree).MinX2, (getGui().tree).MinY2, (getGui().tree).MaxZ2);
            p6 = new Point3D((getGui().tree).MaxX2, (getGui().tree).MinY2, (getGui().tree).MaxZ2);
            p7 = new Point3D((getGui().tree).MinX2, (getGui().tree).MaxY2, (getGui().tree).MaxZ2);
            p8 = new Point3D((getGui().tree).MaxX2, (getGui().tree).MaxY2, (getGui().tree).MaxZ2);
            Update_control.IB = new Bounding_Cube(p1, p2, p3, p4, p5, p6, p7, p8, Global_Options.BP);
            
            // tree.validate();
            // tree.repaint();
            
            return;
        }
        
        // clear Tree
        if ("Clear".equals(e.getActionCommand())) {
            (getGui().tree).clearSelection2();
            (getGui().jPanelDicomCube).repaint();
            
        }
        
        // SelectAll
        if ("SelectAll".equals(e.getActionCommand())) {
            DefaultTreeModel				model = (DefaultTreeModel) getGui().tree.getModel();
            DefaultMutableTreeNode	top = (DefaultMutableTreeNode) model.getRoot();
            
            getGui().tree.addSelectionInterval(0, 0);
            valueChanged(null);
            
            // getGui().tree.repaint();
        }
        
        // Borders berechnen
        if ("Borders".equals(e.getActionCommand())) {
            calcBorders();
        }
        
        // P_3D
        if ("P_3D".equals(e.getActionCommand())) {
            Projection_Type = Global_Options.P_Kabinett;
            
            getGui().jButton_P_Cor.setSelected(false);
            getGui().jButton_P_Tra.setSelected(false);
            getGui().jButton_P_Sag.setSelected(false);
            
            // showDicomSlices (g) ;
            redraw = true;
            (getGui().jPanelDicomCube).update = true;
            (getGui().jPanelDicomCube).repaint();
        }
        
        // Bounding Box
        if ("BB".equals(e.getActionCommand())) {
            Graphics	g = (getGui().jPanelDicomCube.getGraphics());
            
            BoundingBox = !BoundingBox;
            
            // (getGui().tree).resetBB () ;
            // (getGui().tree).update () ;
            (getGui().jPanelDicomCube).update = true;
            (getGui().jPanelDicomCube).repaint();
        }
        
        
        // Eval
        if ("Eval".equals(e.getActionCommand())) {
            
            (getGui().tree).setSelectedSeries();
            
            
            GenericDialog gd = new GenericDialog("Schicht Parameter", IJ.getInstance());
            
            gd.setBackground(Color.lightGray);
            String[]	Ansichten = {
                "Special", "Transversal", "Coronar", "Sagittal"
            };
            
            gd.addChoice("Orientierung", Ansichten, "Special");
            
            gd.addNumericField("Ankerpunkt X-Koord", Update_control.Origin_x, 2);
            gd.addNumericField("Ankerpunkt Y-Koord", Update_control.Origin_y, 2);
            gd.addNumericField("Ankerpunkt Z-Koord", Update_control.Origin_z, 2);
            
            gd.addNumericField("Zeilen Vektor X-Coord", Update_control.Row_x, 2);
            gd.addNumericField("Zeilen Vektor Y-Coord", Update_control.Row_y, 2);
            gd.addNumericField("Zeilen Vektor Z-Coord", Update_control.Row_z, 2);
            
            gd.addNumericField("Spalten Vektor X-Koord", Update_control.Col_x, 2);
            gd.addNumericField("Spalten Vektor Y-Koord", Update_control.Col_y, 2);
            gd.addNumericField("Spalten Vektor Z-Koord", Update_control.Col_z, 2);
            
            
            gd.addNumericField("Reihenauflsung", Update_control.RowSpacing, 2);
            gd.addNumericField("Spaltenauflsung", Update_control.ColSpacing, 2);
            gd.addNumericField("Schichtdicke", Update_control.SliceThickness, 2);
            
            gd.addNumericField("Anzahl der Reihen", Update_control.Rows, 0);
            gd.addNumericField("Anzahl der Spalten", Update_control.Cols, 0);
            
            gd.addNumericField("Anzahl der Schichten", Update_control.numslices, 0);
            gd.addNumericField("Schichtabstand", Update_control.slicedist, 2);
            
            getDocument().slicetree.setSelectedSeries();
            for (int q = 0; q < getDocument().slicetree.NumberOfSelectesSeries; q++) {
                SelectedSeries += getDocument().slicetree.SelectedSlices[q] + ",";
            }
            
            SelectedSeries = SelectedSeries.substring(0, SelectedSeries.length() - 1);
            
            gd.addStringField("Selektierte Serien", SelectedSeries);
            
            // gd.addNumericField("Number of Integration",Global_Options.);
            
            gd.showDialog();
            
            if (gd.wasCanceled()) {
                return;
                
                
            }
            Update_control.Origin_x = (float) gd.getNextNumber();
            Update_control.Origin_y = (float) gd.getNextNumber();
            Update_control.Origin_z = (float) gd.getNextNumber();
            
            final Point3D Origin = new Point3D(Update_control.Origin_x, Update_control.Origin_y, Update_control.Origin_z);
            
            Update_control.Row_x = (float) gd.getNextNumber();
            Update_control.Row_y = (float) gd.getNextNumber();
            Update_control.Row_z = (float) gd.getNextNumber();
            
            final Point3D RowVector = new Point3D(Update_control.Row_x, Update_control.Row_y, Update_control.Row_z);
            
            Update_control.Col_x = (float) gd.getNextNumber();
            Update_control.Col_y = (float) gd.getNextNumber();
            Update_control.Col_z = (float) gd.getNextNumber();
            
            final Point3D ColVector = new Point3D(Update_control.Col_x, Update_control.Col_y, Update_control.Col_z);
            
            final Point3D SliceVector = RowVector.VC_Mult(ColVector);
            
            Update_control.RowSpacing = (float) gd.getNextNumber();
            Update_control.ColSpacing = (float) gd.getNextNumber();
            Update_control.SliceThickness = (float) gd.getNextNumber();
            
            Update_control.Rows = (int) gd.getNextNumber();
            Update_control.Cols = (int) gd.getNextNumber();
            
            Update_control.numslices = (int) gd.getNextNumber();
            Update_control.slicedist = (float) gd.getNextNumber();
            
            getDocument().slicetree.update();
            
            // Serie 0 ; Image 01
            final Slice_Tree	tree = getDocument().slicetree;
            
            
            // BETTER CODE:
            final SwingWorker worker = new SwingWorker() {
                
                
                /**
                 * Method declaration
                 *
                 *
                 * @return
                 *
                 *
                 */
                public Object construct() {
                    
                    // ...code that might take a while to execute is here...
                    short[][]				Pixels;
                    ProgressMonitor mon = new ProgressMonitor(IJ.getInstance(), "Berechne Schicht(en)", "", 0, Update_control.Rows * Update_control.numslices);
                    
                    Pixels = tree.getSlices(Origin, RowVector, ColVector, SliceVector, Update_control.RowSpacing, Update_control.ColSpacing, Update_control.SliceThickness, Update_control.Rows, Update_control.Cols, mon, Update_control.numslices, Update_control.slicedist);
                    
                    byte[]	cTab = new byte[256];
                    
                    for (int i = 0; i < 256; i++) {
                        cTab[i] = (byte) i;
                    }
                    ColorModel	cModel = new IndexColorModel(8, 256, cTab, cTab, cTab);
                    ImageStack	is = new ImageStack(Update_control.Cols, Update_control.Rows);
                    
                    for (int i = 0; i < Update_control.numslices; i++) {
                        ShortProcessor	proc = new ShortProcessor(Update_control.Cols, Update_control.Rows, Pixels[i], cModel, false);
                        
                        is.addSlice("test" + new Integer(i).toString(), proc);
                    }
                    String	name = "Interpol : ";
                    
                    name += new Integer(Global_Options.Interpolationmodel).toString();
                    ImagePlus imp = new ImagePlus("Test Bild " + name, is);
                    
                    imp.show();
                    return null;
                    
                }
                
            };	// worker
            
        }			// Eval ;
        
        // P_Cor
        if ("P_Cor".equals(e.getActionCommand())) {
            
            getGui().jButton_P_3D.setSelected(false);
            getGui().jButton_P_Tra.setSelected(false);
            getGui().jButton_P_Sag.setSelected(false);
            Projection_Type = Global_Options.P_Parallel_Cor;
            
            // graphics g = (getGui ().jPanelDicomCube.getgraphics ()) ;
            // showDicomSlices (g) ;
            (getGui().jPanelDicomCube).update = true;
            (getGui().jPanelDicomCube).repaint();
        }
        
        // P_Tra
        if ("P_Tra".equals(e.getActionCommand())) {
            getGui().jButton_P_3D.setSelected(false);
            getGui().jButton_P_Cor.setSelected(false);
            getGui().jButton_P_Sag.setSelected(false);
            Projection_Type = Global_Options.P_Parallel_Tra;
            
            // graphics g = (getGui ().jPanelDicomCube.getgraphics ()) ;
            // showDicomSlices (g) ;
            (getGui().jPanelDicomCube).update = true;
            (getGui().jPanelDicomCube).repaint();
        }
        
        // P_Sag
        if ("P_Sag".equals(e.getActionCommand())) {
            Projection_Type = Global_Options.P_Parallel_Sag;
            getGui().jButton_P_3D.setSelected(false);
            getGui().jButton_P_Tra.setSelected(false);
            getGui().jButton_P_Cor.setSelected(false);
            
            // graphics g = (getGui ().jPanelDicomCube.getgraphics ()) ;
            // showDicomSlices (g) ;
            (getGui().jPanelDicomCube).update = true;
            (getGui().jPanelDicomCube).repaint();
        }
        
        // Schnitt Box
        if ("IB".equals(e.getActionCommand())) {
            Graphics	g = (getGui().jPanelDicomCube.getGraphics());
            
            IntersectionBox = !IntersectionBox;
            (getGui().tree).resetBB();
            (getGui().tree).update();
            (getGui().jPanelDicomCube).update = true;
            (getGui().jPanelDicomCube).repaint();
        }
        
        
        // Berechne 3D Modell
        if ("Calc".equals(e.getActionCommand())) {
            getDocument().slicetree.update();
            
            // float test1 = getDocument().slicetree.getIntegral_Rect_MP (
            // new Point3D (0,0,0),1.0,1.0,1.0,0);
            
            
            
        }
    }		// action performed
    
    
    // Zoom Slider Control
    
    
    /**
     * Die Methode steuert den Schiebebalken zur Vernderung der
     * Gre der dargestellten Volumina. Der Wert "Zoom"
     * wird angepat und dann entsprechend neu gezeichnet.
     *
     *
     * @param e Das nderungsereignis
     *
     *
     */
    public void stateChanged(ChangeEvent e) {
        
        
        JSlider source = (JSlider) (e.getSource());
        
        boolean isadj = source.getValueIsAdjusting();
        
        int			t = source.getModel().getValue();
        
        // IJ.write (Integer.toString (t)) ;
        // IJ.write (Integer.toString (source.getValue())) ;
        Zoom = source.getValue() * 0.04f;
        
        (getGui().jPanelDicomCube).update = true;
        redraw = false;
        (getGui().jPanelDicomCube).repaint();
        
                /*
                 *
                 * Probleme jdk 1.2.2.
                 * boolean isadj = source.getValueisAdjusting() ;
                 * if (isadj) IJ.write ("adjusting") ; else IJ.write ("not adjusting");
                 *
                 * if (!source.getValueisAdjusting())
                 * {
                 * IJ.write ("not adjusting");
                 * (getGui ().jPanelDicomCube).repaint () ;
                 * }
                 * else    IJ.write ("Adjusting ");
                 *
                 * // source.setValueisAdjusting(false);
                 *
                 *
                 */
        
    }
    
    
    /**
     * Die Methode steuert die Ereignisbehandlung bei einer Mausbewegung.
     * Dies wird bentigt, um die MRT-Koordinaten in Orthogonalprojektion
     * anzuzeigen.
     *
     * @param e Das Mausereignis
     *
     *
     */
    public void mouseMoved(MouseEvent e) {
        
        if (Projection_Type == Global_Options.P_Parallel_Tra) {
            Graphics	g = (getGui().jPanelDicomCube.getGraphics());
            int				h = (getGui().jPanelDicomCube).getHeight();
            int				w = (getGui().jPanelDicomCube).getWidth();
            
            g.clearRect(2, 2, 100, 10);
            g.drawString("X : " + Integer.toString(MathTools.round((e.getX() - transX - 200) / Zoom)), 2, 12);
            g.drawString("Y : " + Integer.toString(MathTools.round((e.getY() - transY - 200) / Zoom)), 52, 12);
        } else if (Projection_Type == Global_Options.P_Parallel_Sag) {
            Graphics	g = (getGui().jPanelDicomCube.getGraphics());
            int				h = (getGui().jPanelDicomCube).getHeight();
            int				w = (getGui().jPanelDicomCube).getWidth();
            
            g.clearRect(2, 2, 100, 10);
            g.drawString("Z : " + Integer.toString(MathTools.round((e.getX() - transX - 200) / Zoom)), 2, 12);
            g.drawString("Y : " + Integer.toString(MathTools.round((e.getY() - transY - 200) / Zoom)), 52, 12);
        } else if (Projection_Type == Global_Options.P_Parallel_Cor) {
            Graphics	g = (getGui().jPanelDicomCube.getGraphics());
            int				h = (getGui().jPanelDicomCube).getHeight();
            int				w = (getGui().jPanelDicomCube).getWidth();
            
            g.clearRect(2, 2, 100, 10);
            g.drawString("X : " + Integer.toString(MathTools.round((e.getX() - transX - 200) / Zoom)), 2, 12);
            g.drawString("Z : " + Integer.toString(MathTools.round((e.getY() - transY - 200) / Zoom)), 52, 12);
        }
        
    }
    
    
    /**
     * Die Methode steuert das Verhalten beim Drcken der Maus.
     * Dies wird genutzt um die aktuellen Mauskoordinaten zu speichern und
     * "Klicken & Ziehen" zu ermglichen.
     *
     * @param e Das Mausereignis
     *
     *
     */
    public void mousePressed(MouseEvent e) {
        oldx = e.getX();
        oldy = e.getY();
        
        
    }
    
    
    /**
     * Die Methode steuert das Verhalten nach dem Loslassen der Maus
     * und kann dazu genutzt werden die Bildfche neu zu zeichnen, falls
     * Volumina verschoben oder die Gre verndert wurde.
     * @param e Das Mausereignis
     *
     *
     */
    public void mouseReleased(MouseEvent e) {
        
        // IJ.write("Mouse released");
        redraw = true;
        (getGui().jPanelDicomCube).update = true;
        (getGui().jPanelDicomCube).repaint();
    }
    
    
    /**
     * Die Methode wird nicht bentigt und nur verwendet, um das entsprechende
     * Interface zu implementieren.
     *
     *
     * @param e Das Mausereignis
     *
     *
     */
    public void mouseExited(MouseEvent e) {}
    
    
    /**
     * Die Methode wird nicht bentigt und nur verwendet, um das entsprechende
     * Interface zu implementieren.
     *
     *
     * @param e Das Mausereignis
     *
     *
     */
    public void mouseClicked(MouseEvent e) {}
    
    
    /**
     * Die Methode wird nicht bentigt und nur verwendet, um das entsprechende
     * Interface zu implementieren.
     *
     *
     * @param e Das Mausereignis
     *
     *
     */
    public void mouseEntered(MouseEvent e) {}
    
    
    /**
     * Die Methode reagiert auf eine nderung der Selektion in der Baumansicht.
     * Dazu mssen die Markierung analysiert werden und die grafischen und textuellen
     * Informationen entsprechend angepat werden.
     *
     * @param e Das Baumselektionsereignis
     *
     * @see mrcp.control.showDicomSlices mrcp.control.showLeaf_Info
     */
    public void valueChanged(TreeSelectionEvent e) {
        
        // BoundingBox = false ;
        String									classname = "";
        Object									nodeinfo = null;
        DefaultMutableTreeNode	node = null;
        
        getDocument().slicetree.setSelectedSeries();
        getGui().htmlPane.setText("");
        TreePath[]	paths = (getGui().tree).getSelectionPaths();
        
        if (paths == null) {
            Graphics2D	g = (Graphics2D) (getGui().jPanelDicomCube.getGraphics());
            
            showDicomSlices(g);
            return;
        }
        
        for (int i = 0; i < paths.length; i++) {
            
            try {
                node = (DefaultMutableTreeNode) paths[i].getLastPathComponent();
                nodeinfo = node.getUserObject();
                classname = nodeinfo.getClass().getName();
            } catch (Exception ed) {}
            
            if (classname.compareTo("java.lang.String") == 0)
                
                // alles anzeigen
            {
                int childs = node.getChildCount();
                
                for (int chl = 0; chl < childs; chl++) {
                    DefaultMutableTreeNode	child = (DefaultMutableTreeNode) node.getChildAt(chl);
                    
                    showSerie_Info(child);
                }
            } else if (classname.indexOf("Series_Node") > 0) {
                
                // komplett Serie anzeigen
                showSerie_Info(node);
            } else {
                Slice_Leaf	sl = (Slice_Leaf) nodeinfo;
                
                showLeaf_Info(sl);
            }
            
            
        }
        
        // Gittermodelle zeichenen
        // Graphics2D g = (Graphics2D)(getGui ().jPanelDicomCube.getgraphics ()) ;
        // showDicomSlices (g) ;
        
        (getGui().jPanelDicomCube).update = true;
        (getGui().jPanelDicomCube).repaint();
        
    }
    
    
    /**
     * Die Methode steuert das Ziehen der Maus und damit die Bewegung der
     * Projektionen auf der Bildflche.
     * Die Kontrolle erfolgt ber den Translationsvektor "trans". Beim Ziehen
     * mit der Maus wird nur der Umgebungsquader neu gezeichnet (redraw = false).
     *
     * @param e
     *
     *
     */
    public void mouseDragged(MouseEvent e) {
        
        // IJ.write ("Mouse dragged") ;
        transX += -oldx + e.getX();
        transY += -oldy + e.getY();
        redraw = false;
        oldx = e.getX();
        oldy = e.getY();
        (getGui().jPanelDicomCube).update = true;
        ((getGui().jPanelDicomCube)).repaint();
    }
    
    
    
    /**
     * Die Methode zeichnet die selektierten Volumina in der gewhlten Projektion
     * auf die Bildflche. Falls der Umgebungsquader oder Schnittquader markiert sind,
     * werden diese ebenfalls gezeichnet. Zum Zeichnen mu die Hierarchie der Baumstruktur
     * erfat und ausgewertet werden. Falls eine Bewegung dargestellt wird, dann erfolgt
     * nur die Zeichnung der Begrenzungen (Umgebungsquader).
     *
     *
     * @param g Der grafische Kontext
     *
     *
     */
    public void showDicomSlices(Graphics2D g) {
        
        TreePath[]	paths = (getGui().tree).getSelectionPaths();
        Dimension		dim = (getGui().jPanelDicomCube).getSize();
        int					h = dim.height;
        int					w = dim.width;
        DefaultTreeModel			model = (DefaultTreeModel) getGui().tree.getModel();
        DefaultMutableTreeNode	top = (DefaultMutableTreeNode) model.getRoot();
        
        if (paths == null || paths.length == 0 ||  top.getChildCount() == 0) {
            
            
            g.setBackground(Color.darkGray);
            
            // g.setColor(Color.green);
            // g.drawString( "Whlen Sie eine Serie oder Blatt im linken Fenster",100,100) ;
            // g.drawString ( "Drcken Sie Hinzufgen, um den 3D-Datensattz zu fllen", 100,120);
            return;
        }
        
        // lschen
        // Rectangle rc = g.getClipBounds() ;
        // g.clearRect   (rc.x,rc.y,rc.width,rc.height) ;
        
        
        // IJ.write ("show DicomSlices") ;
        // IJ.write (Float.toString(Zoom)) ;
        
        // Pseudo Border
        g.setColor(Color.black);
        g.drawRect(1, 1, w - 3, h - 3);
        g.translate(transX, transY);
        
        
        for (int i = 0; i < paths.length; i++) {
            DefaultMutableTreeNode	node = (DefaultMutableTreeNode) paths[i].getLastPathComponent();
            Object									nodeinfo = node.getUserObject();
            String									classname = nodeinfo.getClass().getName();
            
            if (classname.compareTo("java.lang.String") == 0 && redraw)
                
                // alles anzeigen
            {
                
                int childs = node.getChildCount();
                
                for (int chl = 0; chl < childs; chl++) {
                    DefaultMutableTreeNode	child = (DefaultMutableTreeNode) node.getChildAt(chl);
                    
                    showSerie(child, g);
                }
            } else if (classname.indexOf("Series_Node") > 0 && redraw) {
                
                // komplett Serie anzeigen
                showSerie(node, g);
            } else if (redraw) {
                
                // einzelnes Blatt
                Slice_Leaf	sl = (Slice_Leaf) nodeinfo;
                
                
                showLeaf(sl, g);
            }
        }		// for
        
        if (BoundingBox ||!redraw) {
            
            // g.clearRect  (0,0,w,h) ;
            // g.translate(transX, transY);
            
            Update_control.BB.setColor(Global_Options.BoundingColor);
            Update_control.BB.setProjection(Projection_Type);
            Update_control.BB.drawCube(g, 200, 200, Zoom);
            
            if (redraw) {
                
                // alte Info lschen
                String	temp = getGui().htmlPane.getText();
                int			end = temp.indexOf("Bounding");
                
                if (end > 0) {
                    temp = temp.substring(0, end);
                    getGui().htmlPane.setText(temp);
                }
                
                getGui().htmlPane.append("\nBounding Box Koordinaten \n");
                getGui().htmlPane.append(Update_control.BB.Coord_to_String());
            }		// redraw
            
        }
        
        if (IntersectionBox) {
            
            // g.clearRect  (0,0,w,h) ;
            // g.translate(transX, transY);
            
            Update_control.IB.setColor(Global_Options.IntersectionColor);
            Update_control.IB.setProjection(Projection_Type);
            Update_control.IB.drawCube(g, 200, 200, Zoom);
            
            // alte Info lschen
            String	temp = getGui().htmlPane.getText();
            int			end = temp.indexOf("Intersection");
            
            if (end > 0) {
                temp = temp.substring(0, end);
                getGui().htmlPane.setText(temp);
            }
            
            getGui().htmlPane.append("\nIntersection Box Koordinaten \n");
            getGui().htmlPane.append(Update_control.IB.Coord_to_String());
            
            
        }
        
        
        // getGui ().jText_Details.setText (st_Details) ;
        
    }		// show
    
    
    /**
     * Die Methode berechnet die ueren Begrenzungsschichten in allen
     * Hauptachsenrichtungen und markiert diese in der Baumansicht.
     * Nach einem Aufruf von "showDicomSlices" werden diese gezeichnet.
     *
     *
     *
     */
    private void calcBorders() {
        TreePath[]							select = {
            null, null, null, null, null, null
        };
        float										MinTrans = Float.POSITIVE_INFINITY;		// Z-Richtung
        float										MaxTrans = Float.NEGATIVE_INFINITY;		// Z-Richtung
        
        float										MinSag = Float.POSITIVE_INFINITY;		// X-Richtung
        float										MaxSag = Float.NEGATIVE_INFINITY;		// X-Richtung
        
        float										MinCor = Float.POSITIVE_INFINITY;		// Y-Richtung
        float										MaxCor = Float.NEGATIVE_INFINITY;		// Y-Richtung
        
        JTree										tree = getGui().tree;
        DefaultTreeModel				model = (DefaultTreeModel) tree.getModel();
        DefaultMutableTreeNode	top = (DefaultMutableTreeNode) model.getRoot();
        Enumeration							leafs = top.depthFirstEnumeration();
        
        while (leafs.hasMoreElements()) {
            
            DefaultMutableTreeNode	leaf = (DefaultMutableTreeNode) leafs.nextElement();
            
            
            if (leaf.isLeaf()) {
                try {
                    
                    Slice_Leaf	Sleaf = (Slice_Leaf) leaf.getUserObject();
                    Slice_Cube	tmp = Sleaf.cube;
                    TreePath		path = new TreePath(leaf.getPath());
                    
                    if (tmp.View == Tra || tmp.View == Tra_Sag || tmp.View == Tra_Cor)	// Transversal
                        
                    {
                        if (tmp.getMid().getZ() < MinTrans) {
                            MinTrans = tmp.getMid().getZ();
                            select[0] = path;
                        }
                        if (tmp.getMid().getZ() > MaxTrans) {
                            MaxTrans = tmp.getMid().getZ();
                            select[1] = path;
                        }
                        
                    }
                    if (tmp.View == Sag || tmp.View == Sag_Cor || tmp.View == Sag_Tra)	// Sagittal
                        
                    {
                        if (tmp.getMid().getX() < MinSag) {
                            MinSag = tmp.getMid().getX();
                            select[2] = path;
                        }
                        if (tmp.getMid().getX() > MaxSag) {
                            MaxSag = tmp.getMid().getX();
                            select[3] = path;
                        }
                        
                    }
                    if (tmp.View == Cor || tmp.View == Cor_Tra || tmp.View == Cor_Sag)	// Coronar
                        
                    {
                        if (tmp.getMid().getY() < MinCor) {
                            MinCor = tmp.getMid().getY();
                            select[4] = path;
                        }
                        if (tmp.getMid().getY() > MaxCor) {
                            MaxCor = tmp.getMid().getY();
                            select[5] = path;
                        }
                        
                    }
                }		// try ;
                
                catch (Exception excep) {
                    IJ.write(excep.getMessage());
                }
                
            }
        }				// while ;
        
        getGui().tree.clearSelection();
        getGui().tree.addSelectionPaths(select);
        getGui().tree.repaint();
    }
    
    
    /**
     * Die Methode gibt die textuelle Information zu der Geometrie
     * der Schicht aus.
     *
     *
     * @param sl Ein Blatt des Schichtbaumes
     *
     *
     */
    public void showLeaf_Info(Slice_Leaf sl) {
        
        String	name = sl.cube.ds.Filename;
        int			ind = name.lastIndexOf(separator);
        
        name = name.substring(ind);
        
        getGui().htmlPane.append("\n" + "..." + name);
        getGui().htmlPane.append("\n" + sl.cube.Angle + " " + sl.cube.View_to_String());
        getGui().htmlPane.append(sl.cube.Dimension);
        getGui().htmlPane.append(sl.cube.Coord_to_String());
        
    }
    
    
    /**
     * Die Methode gibt die textuelle Information zu der Geometrie
     * der markierten Serie aus und ruft fr alle Shne "showLeaf_Info" auf.
     *
     *
     * @param node Ein Serien-Knoten des Schichtbaumes
     *
     * @see showLeaf_Info
     */
    public void showSerie_Info(DefaultMutableTreeNode node) {
        
        // komplett Serie anzeigen
        int					childs = node.getChildCount();
        Series_Node Snode = (Series_Node) node.getUserObject();
        String			dist = Float.toString(Snode.Slice_Distant);
        
        getGui().htmlPane.append("\nSchichtabstand : " + dist + " mm");
        for (int chl = 0; chl < childs; chl++) {
            
            
            DefaultMutableTreeNode	child = (DefaultMutableTreeNode) node.getChildAt(chl);
            Slice_Leaf							sl = (Slice_Leaf) child.getUserObject();
            
            showLeaf_Info(sl);
        }
        
    }
    
    
    /**
     * Die Methode zeichnet eine einzelne Schicht in der gewhlten
     * Projektion und Farbe und wird von "showSerie" aufgerufen.
     *
     *
     * @param sl Ein Blatt des Schichtbaumes
     * @param g Der grafische Kontext
     *
     *
     */
    public void showLeaf(Slice_Leaf sl, Graphics2D g) {
        
        sl.cube.setProjection(Projection_Type);
        sl.cube.drawCube(g, 200, 200, Zoom);
        if (sl.cube.ds.isTransversal()) {
            sl.cube.setColor(Global_Options.TransversalColor);
        }
        if (sl.cube.ds.isCoronar()) {
            sl.cube.setColor(Global_Options.CoronarColor);
        }
        if (sl.cube.ds.isSagittal()) {
            sl.cube.setColor(Global_Options.SagittalColor);
            
        }
    }
    
    
    /**
     * Die Methode zeichnet eine komplette Serie in der gewhlten
     * Projektion und Farbe und wird von "showDicomSlices" aufgerufen.
     *
     *
     *
     * @param node Ein Serienknoten des Schichtbaumes
     * @param g Der grafische Kontext
     *
     * @see mrcp.control.showDicomSlices
     */
    public void showSerie(DefaultMutableTreeNode node, Graphics2D g) {
        
        // komplett Serie anzeigen
        int childs = node.getChildCount();
        
        for (int chl = 0; chl < childs; chl++) {
            DefaultMutableTreeNode	child = (DefaultMutableTreeNode) node.getChildAt(chl);
            Slice_Leaf							sl = (Slice_Leaf) child.getUserObject();
            
            showLeaf(sl, g);
        }
        
    }
    
    
    /**
     * Die Methode liest durch Aufruf des Dicomplugins Dicomimport neue 2D-Datenstze ein.
     * Diese werden analysiert und in Abhngigkeit ihre Orientierung sortiert und Serien
     * zugeordnet. Dazu wird fr jede Schicht ein "Slice_Leaf" Ojekt erstellt, das alle
     * Informationen bezglich der Schicht kapselt. Nach Beendigung des Imports werden
     * Umgebungs- und Schnittquader neu berechnet.
     *
     *
     * @see mrcp.ddd.Slice_Leaf
     */
    public void readSlices() {
        String	path = System.getProperty("user.dir");
        
        path += System.getProperty("file.separator");
        path += "th_io_properties.txt";
        
        // ImagePlus imp = (ImagePlus)IJ.runPlugIn("ij.plugin.Dicom.DICOM_import", "\t-p.\\th_io_properties.txt") ;
        // ImagePlus imp = (ImagePlus) IJ.runPlugIn("ij.plugin.DICOM_import", "\t-p" + path);
        ImagePlus imp = (ImagePlus) IJ.runPlugIn("DICOM_import", "\t-p" + path);
        
        // Namen extrahieren
        // neue Serie ? Falls ja Serien Leaf erzeugen !
        // Slice_Leafes erzeugen und Jtree zuordnen
        
        //this.setProperty ("Dicom_Impot",proper);
        
        int					number = (imp.getStack()).getSize();
        
        /* tha 2002.5.1
        Properties				prop = (Properties) imp.getProperty("Dicom_Import");
        DcmDataObject[]				ddol;
        Slice_Tree				tree = getGui().tree;
        DefaultTreeModel			model = (DefaultTreeModel) tree.getModel();
        DefaultMutableTreeNode	top = (DefaultMutableTreeNode) model.getRoot();
        int			numberofSer = model.getChildCount(model.getRoot());
        
        if (prop != null) {
            if (prop.containsKey(DcmUID.DCM_BIN_HEADER_PROPERTY)) {
                ddol = (DcmDataObject[]) prop.get(DcmUID.DCM_BIN_HEADER_PROPERTY);
            } else {
                IJ.write("Keine Props");
                return;
            }
        } else {
            IJ.write("Keine Props");
            return;
        }
        */
        
        DcmDataObject[] ddol = (DcmDataObject[]) imp.getProperty(DcmUID.DCM_BIN_HEADER_PROPERTY);
        if (ddol == null) {
            IJ.write("Keine Props");
            return;
        }
        Slice_Tree tree = getGui().tree;
        DefaultTreeModel model = (DefaultTreeModel) tree.getModel();
        DefaultMutableTreeNode top = (DefaultMutableTreeNode) model.getRoot();
        int numberofSer = model.getChildCount(model.getRoot());
        
        // ber alle Schichtbilder
        boolean done;
        
        for (int sl = 0; sl < number; sl++) {
            
            imp.setSlice(sl + 1);		// Schicht auswhlen
            
            // Achtung get Fileinfo nicht richtig implementiert in ImageJ 112!
            // directory und Filename werden nicht zurckgeliefert !
            FileInfo	info = imp.getFileInfo();
            int			indexExt = (info.fileName).lastIndexOf(".");
            String		Extension = "";
            if (indexExt >= 0)
                Extension = (info.fileName).substring(indexExt);
            String		Filename = info.directory + System.getProperty("file.separator");
            
            if (number > 1) {
                Filename += (imp.getStack().getSliceLabel(sl+1)) + Extension;
            } else {
                Filename += info.fileName;
            }
            
            // Fehler falls Stacksize = 0 !!!
            
            DcmDataObject ddo = ddol[sl];
            Slice_Leaf		leaf = new Slice_Leaf(ddo, Filename);
            
            leaf.cube.ds.Pixel = (short[]) imp.getProcessor().getPixelsCopy();
            done = false;
            Enumeration series = top.children();
            
            while (series.hasMoreElements()) {
                DefaultMutableTreeNode	serie = (DefaultMutableTreeNode) series.nextElement();
                
                // lschen
                // serie.add(new DefaultMutableTreeNode (leaf));
                // lschen
                
                DefaultMutableTreeNode	firstimage = (DefaultMutableTreeNode) serie.getFirstChild();
                Slice_Leaf							firstSlice = (Slice_Leaf) firstimage.getUserObject();
                
                // firstSlice und leaf gleich, dann addiere zu Serie an richtiger Stelle !
                // Enumeration ber Serien Kinder und einfgen !
                
                int											comp = firstSlice.compare(leaf);
                
                if (comp == equal) {
                    done = true;
                    
                    
                }
                if (comp != equal && comp != NewSerie) {
                    int Images = serie.getChildCount();
                    
                    for (int x = 0; x < Images; x++) {
                        DefaultMutableTreeNode	Image = (DefaultMutableTreeNode) serie.getChildAt(x);
                        Slice_Leaf							templeaf = (Slice_Leaf) Image.getUserObject();
                        
                        if (templeaf.compare(leaf) == smaller) {
                            model.insertNodeInto(new DefaultMutableTreeNode(leaf), serie, x);
                            done = true;
                            
                            // stoppe Enumeration
                            series = DefaultMutableTreeNode.EMPTY_ENUMERATION;
                            break;
                        }
                        
                    }										// for x
                    
                    if (!done) {
                        model.insertNodeInto(new DefaultMutableTreeNode(leaf), serie, Images);	// hintenanfgen
                        done = true;
                        series = DefaultMutableTreeNode.EMPTY_ENUMERATION;
                    }
                    
                }											// der Serie zugehrig
                
                int z = 12;
            }												// alle series durchlaufen
            
            if (!done) {
                
                // neue Serie hinzufgen und adieren !
                Series_Node snode = new Series_Node();
                String			temp = leaf.cube.ds.BodyPart;
                String			temp2 = leaf.cube.ds.SeriesDescription;
                
                if (temp.compareTo("<null>") == 0) {
                    temp = "unknown Body Part ";
                }
                temp = temp + temp2;
                snode.setName(temp /* + leaf.cube.View_to_String() */);
                DefaultMutableTreeNode	newSerie = new DefaultMutableTreeNode(snode);
                
                newSerie.add(new DefaultMutableTreeNode(leaf));
                
                model.insertNodeInto(newSerie, top, top.getChildCount());
                
                // model.insertNodeInto (new DefaultMutableTreeNode (leaf),newSerie,1) ;
                
            }
            
            
        }													// for slices
        
        Enumeration series = top.children();
        
        while (series.hasMoreElements()) {
            DefaultMutableTreeNode	serie = (DefaultMutableTreeNode) series.nextElement();
            DefaultMutableTreeNode	firstimage = (DefaultMutableTreeNode) serie.getFirstChild();
            Slice_Leaf							firstSlice = (Slice_Leaf) firstimage.getUserObject();
            Dicom_Slice							ds1 = firstSlice.cube.ds;
            Series_Node							node = (Series_Node) serie.getUserObject();
            
            if (serie.getChildCount() > 1) {
                
                DefaultMutableTreeNode	secondimage = (DefaultMutableTreeNode) serie.getChildAt(1);
                Slice_Leaf							secondSlice = (Slice_Leaf) secondimage.getUserObject();
                Dicom_Slice							ds2 = secondSlice.cube.ds;
                float										dist = ((ds1.ImagePosition).VC_Min(ds2.ImagePosition)).Length() - ds1.SliceThicknes;
                
                node.Slice_Distant = dist;
                node.Sum = dist + ds1.SliceThicknes;
                
            }		// if
            else {
                node.Sum = ds1.SliceThicknes;
            }
            
        }			// while
        
        getDocument().slicetree.update();
        
        // BB berechen
        Point3D p1 = new Point3D((getGui().tree).MinX, (getGui().tree).MinY, (getGui().tree).MinZ);
        Point3D p2 = new Point3D((getGui().tree).MaxX, (getGui().tree).MinY, (getGui().tree).MinZ);
        Point3D p3 = new Point3D((getGui().tree).MinX, (getGui().tree).MaxY, (getGui().tree).MinZ);
        Point3D p4 = new Point3D((getGui().tree).MaxX, (getGui().tree).MaxY, (getGui().tree).MinZ);
        Point3D p5 = new Point3D((getGui().tree).MinX, (getGui().tree).MinY, (getGui().tree).MaxZ);
        Point3D p6 = new Point3D((getGui().tree).MaxX, (getGui().tree).MinY, (getGui().tree).MaxZ);
        Point3D p7 = new Point3D((getGui().tree).MinX, (getGui().tree).MaxY, (getGui().tree).MaxZ);
        Point3D p8 = new Point3D((getGui().tree).MaxX, (getGui().tree).MaxY, (getGui().tree).MaxZ);
        
        Update_control.BB = new Bounding_Cube(p1, p2, p3, p4, p5, p6, p7, p8, Global_Options.BP);
        
        p1 = new Point3D((getGui().tree).MinX2, (getGui().tree).MinY2, (getGui().tree).MinZ2);
        p2 = new Point3D((getGui().tree).MaxX2, (getGui().tree).MinY2, (getGui().tree).MinZ2);
        p3 = new Point3D((getGui().tree).MinX2, (getGui().tree).MaxY2, (getGui().tree).MinZ2);
        p4 = new Point3D((getGui().tree).MaxX2, (getGui().tree).MaxY2, (getGui().tree).MinZ2);
        p5 = new Point3D((getGui().tree).MinX2, (getGui().tree).MinY2, (getGui().tree).MaxZ2);
        p6 = new Point3D((getGui().tree).MaxX2, (getGui().tree).MinY2, (getGui().tree).MaxZ2);
        p7 = new Point3D((getGui().tree).MinX2, (getGui().tree).MaxY2, (getGui().tree).MaxZ2);
        p8 = new Point3D((getGui().tree).MaxX2, (getGui().tree).MaxY2, (getGui().tree).MaxZ2);
        Update_control.IB = new Bounding_Cube(p1, p2, p3, p4, p5, p6, p7, p8, Global_Options.BP);
        
        getGui().tree.model.reload();
        
        // getGui().tree.update();
        (getGui().jPanelDicomCube).repaint();
        (getGui().jSplitPane1).repaint();
        (getGui().g.Composite).setSeriesStrings();
        return;
        
        
    }
    
}












/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

