/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/



// Es werden bisher nur 16 bit Unsigned Dicom Files untersttzt




package mrcp.dd;
import ij.*;
import ij.io.*;
import java.util.*;
import java.io.*;
import java.awt.*;
import rad.dicom.dcm.*;

import mrcp.tools.*;


/**
 * Die Klasse stellt eine komprimierte Auflistung der wesentlichen Daten einer MRT-DICOM Datei dar.
 * Dazu gehren insbesondere alle Angaben die sich auf die dreidimensionale Lage
 * beziehen sowie Ausdehnung, Auflsung und medizinische Orientierung (Tra, Cor, Sag).
 * Es werden maximal 16 bit Unsigned Pixeldaten untersttzt.
 * 
 * @author Thomas Demuth
 * @version 2000.08.12
 */
public class Dicom_Slice {


	private String				separator = System.getProperty("file.separator");


	/**
	 * Dateiname der zugehrigen DICOM-Datei
	 */

	public String					Filename = "";


	/**
	 * Kippwinkel der maximal einfach angulierten Schichten
	 */
	public float					angle;


	/**
	 * Pixelarray mit den Bildinformationen
	 */
	public short[]				Pixel = null;


	/**
	 * Anzahl der Reihen in der Bildmatrix
	 */
	public int						Rows;


	/**
	 * Anzahl der Spalten in der Bildmatrix
	 */
	public int						Colums;


	/**
	 * Anzahl der Reihen -1
	 */
	public int						Row_dec;


	/**
	 * Anzahl der Spalten - 1
	 */
	public int						Col_dec;


	/**
	 * Seriennummer
	 */
	public int						Serie = -1;


	/**
	 * Auflsung der Spalten in mm / Pixel
	 */
	public float					PixelSpacingColumn;


	/**
	 * Auflsung der Reihen in mm / Pixel
	 */
	public float					PixelSpacingRow;


	/**
	 * Schichtbreite in mm
	 */
	public float					SliceThicknes;


	/**
	 * Bildpositionsvektor in MRT-Koordinaten (vordere, obere, linke Ecke)
	 */

	public Point3D				ImagePosition;


	/**
	 * Bildpositionsvektro in MRT-Koordinaten (hintere, obere, linke Ecke)
	 */
	public Point3D				ImagePosition2;


	/**
	 * Normalisierter Reihenvektor zur Positionierung der Bildebene
	 */
	public Point3D				RowVector;


	/**
	 * Normalisierter Spaltenvektor zur Positionierung der Bildebene
	 */
	public Point3D				ColVector;


	/**
	 * Normalisierter Schichtvektor zur Positionierung der Bildebene
	 */
	public Point3D				SliceVector;


	/**
	 * Obere, linke Ecke der Bildmatrix in MRT-Koordinaten
	 */
	public Point3D				FirstPixelCorner;


	/**
	 * Eckpunkte der Schicht in MRT-Koordinaten
	 */
	public Vektor3DPoint	Edges;


	/**
	 * Das Volumen einer Elementarzelle
	 */
	public float					Voxelvolume;


	/**
	 * Extremwerte bezglich der Hauptachsen in MRT-Koordinaten
	 */
	public float					MinX = Float.POSITIVE_INFINITY, MaxX = Float.NEGATIVE_INFINITY, MinZ = Float.POSITIVE_INFINITY, MaxZ = Float.NEGATIVE_INFINITY, MinY = Float.POSITIVE_INFINITY, MaxY = Float.NEGATIVE_INFINITY;


	/**
	 * Boolesche Variable, die angibt, ob es sich um eine gltige Schicht handelt.
	 * Insbesondere wird die Orientierung (Angulierung) und die Pixelinformation (16 bit) geprft.
	 */
	public boolean				valid = true;		// gltiges Schicht ? (einfach anguliert)


	/**
	 * Zeichenkette, die die Lage des Patienten in der MRT-Rhre beschreibt.
	 */
	public String					PatientPosition;	// Patienten Position


	/**
	 * Aufnahme Zeitpunkt der zugehrigen Serie
	 */
	public String					SeriesTime;


	/**
	 * Bildnummer
	 */
	public String					Imagenumber;


	/**
	 * Aufnahme Datum der zugehrigen Serie
	 */
	public String					SeriesDate;


	/**
	 * Bezeichnung des untersuchten Krperteils
	 */
	public String					BodyPart;


	/**
	 * Serienbeschreibung
	 */
	public String					SeriesDescription;


	/**
	 * weitere Auflsungparameter der Schicht
	 */
	public float					Width_scale = 0.0f;
	public float					Height_scale = 0.0f;
	public float					Row_scale = 0.0f;
	public float					Col_scale = 0.0f;


	/**
	 * medizinische Orientierung
	 * Tra = 1;  Tra_Cor = 2;   Tra_Sag = 3;
	 * Sag = 4;  Sag_Tra = 5;   Sag_Cor = 6;
	 * Cor = 7;  Cor_Tra = 8;   Cor_Sag = 9;
	 */

	private byte					Orientation = 0;


	final byte						unknown = 0;
	final static byte			Tra = 1;
	final private byte		Tra_Cor = 2;
	final private byte		Tra_Sag = 3;

	final private byte		Sag = 4;
	final private byte		Sag_Tra = 5;
	final private byte		Sag_Cor = 6;

	final private byte		Cor = 7;
	final private byte		Cor_Tra = 8;
	final private byte		Cor_Sag = 9;


	/**
	 * Die Methode extrahiert aus dem bergebenden Parameterobjekt
	 * die oben beschriebenden DICOM-Attribute und analysiert die Orientierung.
	 * Zustzlich wird eine Festkrpermodellierung ber die Eckpunkte einer Schicht
	 * verwirklicht. Als DICOM-Daten_Objekt wird nur ein binres Format untersttzt.
	 * 
	 * @param ddo DICOM-Daten-Objekt
	 */
	public void init(DcmDataObject ddo) {
		DcmValue	dv;

		Edges = new Vektor3DPoint();

		dv = (ddo.getDcmValue(DcmDDE.DD_PixelSpacing));
		String[]	tmp = dv.str2StringArray((dv.toString(false, 0, false, 256, false)), "\\");

		PixelSpacingColumn = new Float(tmp[1]).floatValue();
		PixelSpacingRow = new Float(tmp[0]).floatValue();

		SliceThicknes = new Float((ddo.getDcmValue(DcmDDE.DD_SliceThickness)).toString(false, 0, false, 256, false)).floatValue();

		dv = (ddo.getDcmValue(DcmDDE.DD_Columns));
		Colums = dv.bufToUS(dv.getData(), 0);

		dv = (ddo.getDcmValue(DcmDDE.DD_Rows));
		Rows = dv.bufToUS(dv.getData(), 0);

		Row_dec = Rows - 1;
		Col_dec = Colums - 1;

		dv = (ddo.getDcmValue(DcmDDE.DD_InstanceNumber));
		Imagenumber = dv.toString(false, 0, false, 256, false);

		dv = (ddo.getDcmValue(DcmDDE.DD_ImagePositionPatient));
		tmp = dv.str2StringArray((dv.toString(false, 0, false, 256, false)), "\\");
		float[] ImgPos = new float[3];

		for (int i = 0; i < 3; i++) {
			ImgPos[i] = new Float(tmp[i]).floatValue();
		} 
		ImagePosition = new Point3D(ImgPos[0], ImgPos[1], ImgPos[2]);

		dv = (ddo.getDcmValue(DcmDDE.DD_ImageOrientationPatient));
		tmp = dv.str2StringArray((dv.toString(false, 0, false, 256, false)), "\\");
		float[] ImgOrient = new float[6];

		for (int i = 0; i < 6; i++) {
			ImgOrient[i] = new Float(tmp[i]).floatValue();
		} 
		RowVector = new Point3D(ImgOrient[0], ImgOrient[1], ImgOrient[2]);
		ColVector = new Point3D(ImgOrient[3], ImgOrient[4], ImgOrient[5]);

		SliceVector = RowVector.VC_Mult(ColVector);		// Schichtrichtung durch Vektormult.



		dv = (ddo.getDcmValue(DcmDDE.DD_PatientPosition));
		PatientPosition = dv.toString(false, 0, false, 256, false);

		dv = (ddo.getDcmValue(DcmDDE.DD_StudyDate));
		SeriesDate = dv.toString(false, 0, false, 256, false);

		dv = (ddo.getDcmValue(DcmDDE.DD_StudyTime));
		SeriesTime = dv.toString(false, 0, false, 256, false);

		dv = (ddo.getDcmValue(DcmDDE.DD_BodyPartExamined));
		BodyPart = dv.toString(false, 0, false, 256, false);


		dv = (ddo.getDcmValue(DcmDDE.DD_SeriesDescription));
		if (dv != null) {
			SeriesDescription = dv.toString(false, 0, false, 256, false);
		} else {
			SeriesDescription = " ";
		} 

		dv = (ddo.getDcmValue(DcmDDE.DD_SeriesNumber));
		String	temp = dv.toString(false, 0, false, 256, false);


		char		ch = temp.charAt(0);

		while (Character.getNumericValue(ch) == -1) {
			temp = temp.substring(1);
			ch = temp.charAt(0);
		} 

		// Spezielles Format von Seriesnumber "    12"
		// Das sind keine whitespaces !

		try {
			Serie = (new Integer(temp)).intValue();
		} catch (NumberFormatException nfe) {
			IJ.write("Fehler bei Erkennung der Seriennummer ! " + nfe.toString());
		} 

		Voxelvolume = SliceThicknes * getPixelSpacingColumn() * getPixelSpacingRow();

		// Schichtfhrungen

		// Transversal
		if (((Math.abs(getXRowVector()) == 1.0) && (Math.abs(getYRowVector()) == 0.0) && (Math.abs(getZRowVector()) == 0.0) && (Math.abs(getXColVector()) == 0.0) && (Math.abs(getYColVector()) == 1.0))) {
			Orientation = Tra;

			// Transversal nach Coronar gekippt
		} else if (((Math.abs(getXRowVector()) == 1.0) && (Math.abs(getYRowVector()) == 0.0) && (Math.abs(getZRowVector()) == 0.0) && (Math.abs(getXColVector()) == 0.0) && (Math.abs(getYColVector()) >= Math.abs(getZColVector())))) {
			Orientation = Tra_Cor;

			// Transversal nach Sagittal gekippt
		} else if ((Math.abs(getYRowVector()) == 0.0) && (Math.abs(getXColVector()) == 0.0) && (Math.abs(getYColVector()) == 1.0) && (Math.abs(getZColVector()) == 0.0) && (Math.abs(getXRowVector()) >= Math.abs(getZRowVector()))) {
			Orientation = Tra_Sag;

			// Coronar
		} else if ((Math.abs(getXRowVector()) == 1.0) && (Math.abs(getYRowVector()) == 0.0) && (Math.abs(getZRowVector()) == 0.0) && (Math.abs(getXColVector()) == 0.0) && (Math.abs(getZColVector()) == 1.0)) {
			Orientation = Cor;

			// Coronar nach Transversal gekippt
		} else if ((Math.abs(getXRowVector()) == 1.0) && (Math.abs(getYRowVector()) == 0.0) && (Math.abs(getZRowVector()) == 0.0) && (Math.abs(getXColVector()) == 0.0) && (Math.abs(getYColVector()) < Math.abs(getZColVector()))) {
			Orientation = Cor_Tra;

			// Coronar nach Sagittal gekippt
		} else if ((Math.abs(getZRowVector()) == 0.0) && (Math.abs(getXColVector()) == 0.0) && (Math.abs(getYColVector()) == 0.0) && (Math.abs(getZColVector()) == 1.0) && (Math.abs(getXRowVector()) >= Math.abs(getYRowVector()))) {
			Orientation = Cor_Sag;

			// Sagittal
		} else if ((Math.abs(getXRowVector()) == 0.0) && (Math.abs(getYRowVector()) == 1.0) && (Math.abs(getZRowVector()) == 0.0) && (Math.abs(getXColVector()) == 0.0) && (Math.abs(getYColVector()) == 0.0) && (Math.abs(getZColVector()) == 1.0)) {
			Orientation = Sag;

			// Sagittal nach Transversal gekippt
		} else if ((Math.abs(getXRowVector()) == 0.0) && (Math.abs(getYRowVector()) == 1.0) && (Math.abs(getZRowVector()) == 0.0) && (Math.abs(getYColVector()) == 0.0) && (Math.abs(getXColVector()) < Math.abs(getZColVector()))) {
			Orientation = Sag_Tra;

			// Sagittal nach Coronar gekippt
		} else if ((Math.abs(getZRowVector()) == 0.0) && (Math.abs(getXColVector()) == 0.0) && (Math.abs(getYColVector()) == 0.0) && (Math.abs(getZColVector()) == 1.0) && (Math.abs(getXRowVector()) < Math.abs(getYRowVector()))) {
			Orientation = Sag_Cor;



		} else {
			Orientation = unknown;
		} 

		// Tra: 1/0/0 0/1/0
		// Cor : 1/0/0 0/0/1
		// Sag : 0/1/0 0/0/-1

		// nur bestimmte Schrgen zulassen ! Tra 100 / 0xy
		// Einfache Angulierung
		// valid definieren !
		// Extremwerte und Eckpunkte bestimmen



		if (isTransversal()) {

			// Slicevektor positiv in Z-Richtung !
			if (SliceVector.getZ() < 0) {
				SliceVector = SliceVector.Sk_Mult(-1);
			} 
			valid = true;
			Edges.setPoint(1, ImagePosition);
			Edges.setPoint(2, Edges.getPoint(1).VC_Add(RowVector.Sk_Mult((Colums) * PixelSpacingColumn)));
			Edges.setPoint(3, Edges.getPoint(1).VC_Add(ColVector.Sk_Mult((Rows) * PixelSpacingRow)));
			Edges.setPoint(4, Edges.getPoint(3).VC_Add(RowVector.Sk_Mult((Colums) * PixelSpacingColumn)));
			Edges.setPoint(5, Edges.getPoint(1).VC_Add(SliceVector.Sk_Mult(SliceThicknes)));
			Edges.setPoint(6, Edges.getPoint(2).VC_Add(SliceVector.Sk_Mult(SliceThicknes)));
			Edges.setPoint(7, Edges.getPoint(3).VC_Add(SliceVector.Sk_Mult(SliceThicknes)));
			Edges.setPoint(8, Edges.getPoint(4).VC_Add(SliceVector.Sk_Mult(SliceThicknes)));

			// Anpassung an ImagPos !!!

			// Point3D tran1 = RowVector.Sk_Mult(PixelSpacingColumn / 2.0f) ;
			// Point3D tran2 = ColVector.Sk_Mult(PixelSpacingRow / 2.0f) ;
			// Point3D trans = tran1.VC_Add(tran2) ;

			// kleiner Koorektirfaktor !
			// Edges.translate(0,0,-5);
			FirstPixelCorner = Edges.getPoint(1);


			calcMinMax();

			Width_scale = (Col_dec / (MaxX - MinX));
			Height_scale = (Row_dec / (MaxY - MinY));
			Row_scale = (Row_dec / (Rows * PixelSpacingRow));
			Col_scale = (Col_dec / (Colums * PixelSpacingColumn));

			// Kippwinkel berechnen (Tangens)
			if (isStrictTransversal()) {
				angle = 0.0f;

			} else if (isTra_Cor()) {
				angle = (float) Math.atan(SliceVector.getY() / SliceVector.getZ()) / Global_Options.RAD;

			} else if (isTra_Sag()) {
				angle = (float) Math.atan(SliceVector.getX() / SliceVector.getZ()) / Global_Options.RAD;
			} 
		} else if (isSagittal()) {
			valid = true;

			// test  mit negativen X
			if (SliceVector.getX() > 0.0) {
				SliceVector = SliceVector.Sk_Mult(-1);
			} 
			Edges.setPoint(6, ImagePosition);
			Edges.setPoint(5, ImagePosition.VC_Add(SliceVector.Sk_Mult(SliceThicknes)));
			Edges.setPoint(7, Edges.getPoint(5).VC_Add(RowVector.Sk_Mult((Colums) * PixelSpacingColumn)));
			Edges.setPoint(8, Edges.getPoint(6).VC_Add(RowVector.Sk_Mult((Colums) * PixelSpacingColumn)));
			Edges.setPoint(1, Edges.getPoint(5).VC_Add(ColVector.Sk_Mult((Rows) * PixelSpacingRow)));
			Edges.setPoint(2, Edges.getPoint(6).VC_Add(ColVector.Sk_Mult((Rows) * PixelSpacingRow)));
			Edges.setPoint(3, Edges.getPoint(7).VC_Add(ColVector.Sk_Mult((Rows) * PixelSpacingRow)));
			Edges.setPoint(4, Edges.getPoint(8).VC_Add(ColVector.Sk_Mult((Rows) * PixelSpacingRow)));


			// Edges.translate(-trans.getX(),-trans.getY(),-trans.getZ());
			FirstPixelCorner = Edges.getPoint(6);

			calcMinMax();

			Width_scale = (Col_dec / (MaxY - MinY));
			Height_scale = (Row_dec / (MaxZ - MinZ));
			Row_scale = (Row_dec / (Rows * PixelSpacingRow));
			Col_scale = (Col_dec / (Colums * PixelSpacingColumn));

			if (isStrictSagittal()) {
				angle = 0.0f;

			} else if (isSag_Tra()) {
				angle = (float) Math.atan(SliceVector.getZ() / SliceVector.getX()) / Global_Options.RAD;

			} else if (isSag_Cor()) {
				angle = (float) Math.atan(SliceVector.getY() / SliceVector.getX()) / Global_Options.RAD;

			} 
		} else if (isCoronar()) {
			valid = true;
			if (SliceVector.getY() < 0) {
				SliceVector = SliceVector.Sk_Mult(-1);
			} 
			Edges.setPoint(5, ImagePosition);
			Edges.setPoint(7, ImagePosition.VC_Add(SliceVector.Sk_Mult(SliceThicknes)));
			Edges.setPoint(6, Edges.getPoint(5).VC_Add(RowVector.Sk_Mult((Colums) * PixelSpacingColumn)));
			Edges.setPoint(8, Edges.getPoint(6).VC_Add(SliceVector.Sk_Mult(SliceThicknes)));
			Edges.setPoint(1, Edges.getPoint(5).VC_Add(ColVector.Sk_Mult((Rows) * PixelSpacingRow)));
			Edges.setPoint(2, Edges.getPoint(6).VC_Add(ColVector.Sk_Mult((Rows) * PixelSpacingRow)));
			Edges.setPoint(3, Edges.getPoint(7).VC_Add(ColVector.Sk_Mult((Rows) * PixelSpacingRow)));
			Edges.setPoint(4, Edges.getPoint(8).VC_Add(ColVector.Sk_Mult((Rows) * PixelSpacingRow)));

			// Anpassung an ImagPos !!!
			// Point3D tran1 = RowVector.Sk_Mult(PixelSpacingColumn / 2) ;
			// Point3D tran2 = ColVector.Sk_Mult(PixelSpacingRow / 2) ;
			// Point3D trans = tran1.VC_Add(tran2) ;
			// Edges.translate(-trans.getX(),-trans.getY(),-trans.getZ());
			FirstPixelCorner = Edges.getPoint(5);
			calcMinMax();

			Width_scale = (Col_dec / (MaxX - MinX));
			Height_scale = (Row_dec / (MaxZ - MinZ));
			Row_scale = (Row_dec / (Rows * PixelSpacingRow));
			Col_scale = (Col_dec / (Colums * PixelSpacingColumn));


			if (isStrictCoronar()) {
				angle = 0.0f;

			} else if (isCor_Tra()) {
				angle = (float) Math.atan(SliceVector.getZ() / SliceVector.getY()) / Global_Options.RAD;

			} else if (isCor_Sag()) {
				angle = (float) Math.atan(SliceVector.getX() / SliceVector.getY()) / Global_Options.RAD;

			} 
		} else {

			valid = false;
			IJ.write("Schichtorientierung konnte nicht bestimmt werden !");
			return;
		} 

		// IJ.write ("new Dicom Slice") ;

		// Zusatz Informationen
		ImagePosition2 = ImagePosition.VC_Add(SliceVector.Sk_Mult(SliceThicknes));


		ddo = null;
	} 


	// Konstruktor


	/**
	 * Erzeugt eine neues Exemplar von Dicom_Slice durch Angabe des Dateinamens.
	 * Dazu mu das entsprechende DICOM-Daten-Objekt erzeugt werden.
	 * Als DICOM-Daten_Objekt wird nur ein binres Format untersttzt.
	 * 
	 * @param Filename Dateiname
	 * @param onlyHeader Boolesche Vaiable, die angibt, ob nur die DICOM-Attributen oder
	 * auch Pixeldaten geladen werden sollen.
	 * 
	 */
	public Dicom_Slice(String Filename, boolean onlyHeader) {

		ImagePlus imp = (ImagePlus) IJ.runPlugIn("DICOM_import", "\t-p.\\th_io_properties.txt\t" + Filename);

		if (imp == null) {
			return;

		} 
		this.Filename = Filename;
		if (!onlyHeader) {
			Pixel = (short[]) imp.getProcessor().getPixelsCopy();
		} else {
			imp.killProcessor();
		} 

		Properties			prop = imp.getProperties();
		DcmDataObject[] ddol;

		if (prop != null) {
			if (prop.containsKey(DcmUID.DCM_BIN_HEADER_PROPERTY)) {
				ddol = (DcmDataObject[]) prop.get(DcmUID.DCM_BIN_HEADER_PROPERTY);
			} else {
				IJ.write("Keine Props");
				return;
			} 
		} else {
			IJ.write("Keine Props");
			return;
		} 

		DcmDataObject ddo = ddol[0];

		init(ddo);

	}


	/**
	 * Erzeugt ein neues Exemplar von Dicom_Slice durch Angabe des DICOM-Daten-Objektes.
	 * Da der Dateiname nicht im Objekt gespeichert ist, mu dieser als Argument bergeben werden.
	 * Als DICOM-Daten-Objekt wird nur ein binres Format untersttzt.
	 * 
	 * @param Filename Dateiname
	 * @param ddo DICOM-Daten-Objekt
	 * 
	 */
	public Dicom_Slice(String Filename, DcmDataObject ddo) {

		// Keine Pixelinformationen werden gebraucht !
		this.Filename = Filename;
		init(ddo);
	}


	/**
	 * Erzeugt eine neues Exemplar von Dicom_Slice durch Angabe des ImageJ Bildformats ImagePlus.
	 * 
	 * 
	 * @param imp ImagePlus Bild
	 * @param onlyHeader Boolesche Vaiable, die angibt, ob nur die DICOM-Attribute oder
	 * auch Pixeldaten geladen werden sollen.
	 * 
	 */
	public Dicom_Slice(ImagePlus imp, boolean onlyHeader) {

		if (imp == null) {
			return;

		} 
		FileInfo	info = imp.getFileInfo();

		this.Filename = info.directory + System.getProperty("file.separator") + info.fileName;
		if (!onlyHeader) {
			Pixel = (short[]) imp.getProcessor().getPixelsCopy();

		} 
		Properties			prop = imp.getProperties();
		DcmDataObject[] ddol;

		if (prop != null) {
			if (prop.containsKey(DcmUID.DCM_BIN_HEADER_PROPERTY)) {
				ddol = (DcmDataObject[]) prop.get(DcmUID.DCM_BIN_HEADER_PROPERTY);
			} else {
				IJ.write("Keine Props");
				return;
			} 
		} else {
			IJ.write("Keine Props");
			return;
		} 

		DcmDataObject ddo = ddol[0];

		init(ddo);

	}


	/**
	 * Die Methode liefert die x-Komponente des Reihenvektors zurck.
	 * 
	 * 
	 * @return x-Komponente Reihenvektor
	 */
	public float getXRowVector() {
		return RowVector.getX();
	} 

	;


	/**
	 * Die Methode liefert die y-Komponente des Reihenvektors zurck.
	 * 
	 * 
	 * @return y-Komponente Reihenvektor
	 * 
	 */
	public float getYRowVector() {
		return RowVector.getY();
	} 

	;


	/**
	 * Die Methode liefert die y-Komponente des Reihenvektors zurck.
	 * 
	 * 
	 * @return y-Komponente Reihenvektor
	 * 
	 * 
	 */
	public float getZRowVector() {
		return RowVector.getZ();
	} 

	;


	/**
	 * Die Methode liefert die x-Komponente des Spaltenvektors zurck.
	 * 
	 * 
	 * @return x-Komponente Spaltenvektor
	 */
	public float getXColVector() {
		return ColVector.getX();
	} 

	;


	/**
	 * Die Methode liefert die y-Komponente des Spaltenvektors zurck.
	 * 
	 * 
	 * @return y-Komponente Spaltenvektor
	 * 
	 * 
	 */
	public float getYColVector() {
		return ColVector.getY();
	} 

	;


	/**
	 * Die Methode liefert die z-Komponente des Spaltenvektors zurck.
	 * 
	 * 
	 * @return z-Komponente Spaltenvektor
	 * 
	 * 
	 */
	public float getZColVector() {
		return ColVector.getZ();
	} 

	;


	/**
	 * Die Methode liefert die x-Komponente des Bildpositionsvektors zurck.
	 * 
	 * 
	 * @return x-Komponente Bildpositionsvektor
	 * 
	 * 
	 */
	public float getXPos() {
		return ImagePosition.getX();
	} 

	;


	/**
	 * Die Methode liefert die y-Komponente des Bildpositionsvektors zurck.
	 * 
	 * 
	 * @return y-Komponente Bildpositionsvektor
	 * 
	 * 
	 */
	public float getYPos() {
		return ImagePosition.getY();
	} 

	;


	/**
	 * Die Methode liefert die z-Komponente des Bildpositionsvektors zurck.
	 * 
	 * 
	 * @return z-Komponente Bildpositionsvektor
	 * 
	 * 
	 */
	public float getZPos() {
		return ImagePosition.getZ();
		
	} 

	;


	/**
	 * Die Methode liefert die Anzahl der Spalten zurck.
	 * 
	 * 
	 * @return Anzahl der Spaltem
	 * 
	 * 
	 */
	public int getColums() {
		return Colums;
	} 

	;


	/**
	 * Die Methode liefert die Anzahl der Reihen zurck.
	 * 
	 * 
	 * @return Anzahl der Spaltem
	 * 
	 * 
	 */
	public int getRows() {
		return Rows;
	} 

	;


	/**
	 * Die Methode liefert die Auflsung der Spalten zurck.
	 * 
	 * 
	 * @return Spaltenauflsung mm / Pixel
	 * 
	 * 
	 */
	public float getPixelSpacingColumn() {
		return PixelSpacingColumn;
	} 

	;


	/**
	 * Die Methode liefert die Auflsung der Reihen zurck.
	 * 
	 * 
	 * @return Reihenauflsung in mm / Pixel
	 * 
	 * 
	 */
	public float getPixelSpacingRow() {
		return PixelSpacingRow;
	} 

	;


	/**
	 * Die Methode liefert die Schichtbreite zurck.
	 * 
	 * 
	 * @return Schichtbreite in mm
	 * 
	 * 
	 */
	public float getSliceThicknes() {
		return SliceThicknes;
	} 

	;




	/**
	 * Die Methode berechnet die minimale Z-Koordinate.
	 * 
	 * 
	 * @return Minimale Z-Koordinate
	 * 
	 * 
	 */
	public float getMinZ() {
		return MinZ;
	} 


	/**
	 * Die Methode berechnet die maximale Z-Koordinate.
	 * 
	 * 
	 * @return Maximale Z-Koordinate
	 * 
	 */
	public float getMaxZ() {
		return MaxZ;
	} 


	/**
	 * Die Methode berechnet die minimale X-Koordinate.
	 * 
	 * 
	 * @return Minimale X-Koordinate
	 * 
	 * 
	 */
	public float getMinX() {
		return MinX;
	} 


	/**
	 * Die Methode berechnet die maximale X-Koordinate.
	 * 
	 * 
	 * @return Maximale X-Koordinate
	 * 
	 * 
	 */
	public float getMaxX() {
		return MaxX;
	} 


	/**
	 * Die Methode berechnet die minimale Y-Koordinate.
	 * 
	 * 
	 * @return Minimale Y-Koordinate
	 * 
	 * 
	 */
	public float getMinY() {
		return MinY;
	} 


	/**
	 * Die Methode berechnet die maximale Y-Koordinate.
	 * 
	 * 
	 * @return Maximale Y-Koordinate
	 * 
	 * 
	 */
	public float getMaxY() {
		return MaxY;
	} 


	/**
	 * Die Methode liefert die Seriennummer zurck.
	 * 
	 * 
	 * @return Seriennummer
	 * 
	 * 
	 */
	public int getSerie() {
		return Serie;
	} 

	// Schichtrichtungen
	// Cor > Tra > Sag


	/**
	 * Test, ob die Schicht transversal (Tra, Tra_Cor, Tra-Sag) ist.
	 * 
	 * 
	 * @return wahr, falls Schicht transversal
	 * 
	 * 
	 */
	public boolean isTransversal() {
		return (Orientation > 0 && Orientation < 4);
	} 


	/**
	 * Test, ob die Schicht coronar (Cor, Cor-Sag, Cor-Tra) ist.
	 * 
	 * 
	 * @return wahr, falls Schicht coronar
	 * 
	 * 
	 */
	public boolean isCoronar() {
		return (Orientation > 6 && Orientation < 10);
	} 


	/**
	 * Test, ob die Schicht sagittal (Sag, Sag-Cor, Sag-Tra) ist.
	 * 
	 * 
	 * @return wahr, falls Schicht sagittal
	 * 
	 * 
	 */
	public boolean isSagittal() {
		return (Orientation > 3 && Orientation < 7);
	} 


	/**
	 * Test, ob die Schicht exakt transversal ist.
	 * 
	 * 
	 * @return wahr, falls Schicht exakt transversal
	 * 
	 * 
	 */
	public boolean isStrictTransversal() {
		return (Orientation == Tra);
	} 


	/**
	 * Test, ob die Schicht exakt coronar ist.
	 * 
	 * 
	 * @return wahr, falls Schicht exakt coronar
	 * 
	 * 
	 */
	public boolean isStrictCoronar() {
		return (Orientation == Cor);
	} 


	/**
	 * Test, ob die Schicht exakt sagittal ist.
	 * 
	 * 
	 * @return wahr, falls Schicht exakt sagittal
	 * 
	 * 
	 */
	public boolean isStrictSagittal() {
		return (Orientation == Sag);
	} 


	/**
	 * Test, ob die Schicht transversal nach coronar gekippt ist.
	 * 
	 * 
	 * @return wahr, falls Schicht transversal nach coronar gekippt
	 * 
	 * 
	 */
	public boolean isTra_Cor() {
		return (Orientation == Tra_Cor);
	} 


	/**
	 * Test, ob die Schicht transversal nach sagittal gekippt ist.
	 * 
	 * 
	 * @return wahr, falls Schicht transversal nach sagittal gekippt
	 * 
	 * 
	 */
	public boolean isTra_Sag() {
		return (Orientation == Tra_Sag);
	} 


	/**
	 * Test, ob die Schicht coronar nach sagittal gekippt ist.
	 * 
	 * 
	 * @return wahr, falls Schicht coronar nach sagittal gekippt
	 * 
	 * 
	 */
	public boolean isCor_Sag() {
		return (Orientation == Cor_Sag);
	} 


	/**
	 * Test, ob die Schicht coronar nach transversal gekippt ist.
	 * 
	 * 
	 * @return wahr, falls Schicht coronar nach transversal gekippt
	 * 
	 * 
	 */
	public boolean isCor_Tra() {
		return (Orientation == Cor_Tra);
	} 


	/**
	 * Test, ob die Schicht sagittal nach transversal gekippt ist.
	 * 
	 * 
	 * @return wahr, falls Schicht sagittal nach transversal gekippt
	 * 
	 * 
	 */
	public boolean isSag_Tra() {
		return (Orientation == Sag_Tra);
	} 


	/**
	 * Test, ob die Schicht sagittal nach coronar gekippt ist.
	 * 
	 * 
	 * @return wahr, falls Schicht sagittal nach coronar gekippt
	 * 
	 * 
	 */
	public boolean isSag_Cor() {
		return (Orientation == Sag_Cor);
	} 


	/**
	 * Test, ob es sich um eine medizinische Grundrichtung handelt.
	 * 
	 * 
	 * 
	 * @return wahr, falls exakt transversal, coronar oder sagittal
	 * 
	 * 
	 */
	public boolean isStrict() {
		return (isStrictCoronar() || isStrictSagittal() || isStrictTransversal());
	} 


	/**
	 * Die Methode liefert die Orientierung als Bytewert verschlsselt zurck.
	 * 
	 * 
	 * @return Zahlenwert der Orientierung
	 * 
	 * 
	 */
	public byte getOrientation() {
		return Orientation;
	} 

	// Nomem est Omen


	/**
	 * Die Methode prft, ob es sich um eine gltige Schicht handelt.
	 * 
	 * 
	 * @return wahr, falls Schicht ok
	 * 
	 * 
	 */
	public boolean isValid() {
		return valid;
	} 


	// Ausgabe des entsprechenden Signalwertes
	// an den bergebenden Matrixkoordinaten mit


	/**
	 * Die Methode berechnet den Grauwert an der Stelle (x, y)durch Auswertung
	 * der zugehrigen Bildmatrix. Dazu werden die Fliekommakoordinaten durch
	 * Rundung in diskrete umgewandelt.
	 * 
	 * 
	 * @param x Bildmatrix x-Koordinate
	 * @param y Bildmatrix y-Koordinate
	 * 
	 * @return Grauwert an der Stelle (x, y)
	 * 
	 * 
	 */
	public int getValue(float x, float y) {

		// Dreifachintegral, in das der Punkt hineinfllt !
		return getPixel(MathTools.floor(x), MathTools.floor(y));
	}		// getValue
 

	// berechne die Extremwerte der Schicht


	/**
	 * Die Methode berechnet die Extremwerte der Schicht bezglich der
	 * Hauptachsenrichtungen.
	 * 
	 * 
	 * 
	 */
	public void calcMinMax() {

		MinX = Float.POSITIVE_INFINITY;
		MaxX = Float.NEGATIVE_INFINITY;
		MinZ = Float.POSITIVE_INFINITY;
		MaxZ = Float.NEGATIVE_INFINITY;
		MinY = Float.POSITIVE_INFINITY;
		MaxY = Float.NEGATIVE_INFINITY;

		for (int i = 1; i <= 8; i++) {
			float xval = Edges.getPoint(i).getX();
			float yval = Edges.getPoint(i).getY();
			float zval = Edges.getPoint(i).getZ();

			if (xval < MinX) {
				MinX = xval;
			} 
			if (xval > MaxX) {
				MaxX = xval;
			} 
			if (yval < MinY) {
				MinY = yval;
			} 
			if (yval > MaxY) {
				MaxY = yval;
			} 
			if (zval < MinZ) {
				MinZ = zval;
			} 
			if (zval > MaxZ) {
				MaxZ = zval;

			} 
		} 

	} 

	// in Pixel Schritten
	// 2D Summeninformationen ber Schichtdicke


	/**
	 * Die Methode berechnet den Grauwert an der Stelle (x, y)durch Auswertung
	 * der zugehrigen Bildmatrix. Es erfolgt keine Gltigkeitsprfung. Daher mssen
	 * die Koordinaten vorher schon geprft sein.
	 * 
	 * 
	 * @param x Bildmatrix x-Koordinate
	 * @param y Bildmatrix y-Koordinate
	 * 
	 * @return Grauwert an der Stelle (x, y)
	 * 
	 * 
	 */
	public int getPixel(int x, int y) {
		return Pixel[y * Colums + x];
	} 


	/**
	 * Die Methode berechnet den Grauwert an der Stelle (x, y)durch Auswertung
	 * der zugehrigen Bildmatrix. Es erfolgt zunchst eine Gltigkeitsprfung.
	 * 
	 * 
	 * @param x Bildmatrix x-Koordinate
	 * @param y Bildmatrix y-Koordinate
	 * 
	 * @return Grauwert an der Stelle (x, y)
	 * 
	 * 
	 */
	public int getPixel2(int x, int y) {
		if (x > Col_dec) {
			x = Col_dec;
		} 
		if (y > Row_dec) {
			y = Row_dec;

		} 
		return Pixel[y * Colums + x];
	} 

	// true, falls gleiche Serie oder Fortsetzung der selben unter neuen Nummer


	/**
	 * Die Methode untersucht zwei "Dicom_Slice" Exemplare auf
	 * Gleichheit hinsichtlich ihere DICOM-Attribute. Falls "Directory-Test" wahr ist, dann
	 * mssen bei Gleichheit auch die Verzeichnispfade bereinstimmen.
	 * 
	 * 
	 * 
	 * @param ds Die zu vergleichende Schicht
	 * 
	 * @return wahr, falls beide Schichten gleich.
	 * 
	 * 
	 */
	public boolean compare(Dicom_Slice ds) {

		// Point3D tmp = (ds.ImagePosition.VC_Min(this.ImagePosition)) ;
		// tmp.norm();

		boolean result = this.ColVector.equal(ds.ColVector);
		boolean result1 = this.RowVector.equal(ds.RowVector);
		boolean result2 = this.SliceThicknes == ds.SliceThicknes;
		boolean result3 = ((this.SeriesDate).compareTo(ds.SeriesDate) == 0);

		boolean result4 = ((this.SeriesDescription).compareTo(ds.SeriesDescription) == 0);
		boolean result5 = ((this.SeriesTime).compareTo(ds.SeriesTime) == 0);

		// Test des Verzeichnisses
		boolean result6 = true;


		if (Global_Options.Directorytest) {
			String	name1 = this.Filename;
			int			ind = name1.lastIndexOf(separator);
			String	dir = name1.substring(0, ind);
			String	name2 = ds.Filename;

			ind = name2.lastIndexOf(separator);
			String	dir2 = name2.substring(0, ind);

			if (dir.compareTo(dir2) != 0) {
				result6 = false;


			} 
		} 


		return result && result1 && result2 && result3 && result4 && result5 && result6;

	}		// compare
 

	/**
	 * Die Methode berechnet eine quadratische Matrix von Grauwerten um eine feste Position.
	 * Dies wird bei komplexeren Interpolationen bentigt. Es wird kein Gltigkeitstest vorgenommen.
	 * 
	 * 
	 * @param newx x-Position in der Bildmatrix
	 * @param newy y-Position in der Bildmatrix
	 * @param NumberOfPoints Anzahl der Spalten- bzw Zeilenelemnte
	 * @param add Relative Positionsnderung zu (newx, newy)
	 * 
	 * @return Grauwertmatrix
	 * 
	 * 
	 */
	public int[][] getMatrix(float newx, float newy, int NumberOfPoints, int add) {

		// berechnet die Funktionsmatrix fr hhere Interpolationen

		int[][] Matrix = new int[NumberOfPoints][NumberOfPoints];

		for (int y = 0; y < NumberOfPoints; y++) {
			for (int x = 0; x < NumberOfPoints; x++) {
				Matrix[x][y] = getValue_comp(newx - add + x, newy - add + y);
			} 

		} 
		return Matrix;
	} 


	/**
	 * 
	 * Die Methode berechnet den Grauwert an der Stelle (x, y)durch Auswertung
	 * der zugehrigen Bildmatrix. Es erfolgt eine Gltigkeitsprfung. Falls
	 * das gltige Intervall unter- bzw- berschritten wird, dann wird automatisch
	 * die kleinste bzw. grte mglich Koordinate verwendet. Die Fliekomma
	 * Koordianaten werden gerundet.
	 * 
	 * 
	 * @param x Bildmatrix x-Koordinate
	 * @param y Bildmatrix y-Koordinate
	 * 
	 * @return Grauwert an der Stelle (x, y)
	 * 
	 */
	public int getValue_comp(float x, float y) {

		// Abfrage der Funktionswerte mit Ausgleich
		if (x < 0) {
			x = 0;
		} else if (x > Rows - 1) {
			x = Rows - 1;
		} 
		if (y < 0) {
			y = 0;
		} else if (y > Colums - 1) {
			y = Colums - 1;
		} 
		return getValue(x, y);
	} 




	/**
	 * Die Methode liefert den Kippwinkle der Schicht zurck.
	 * 
	 * 
	 * @return Kippwinkel in Grad
	 * 
	 */
	public float getAngle() {
		return angle;
	} 


	/**
	 * Die Methode liefert die Eckpunkte der Schicht in MRT-Koordinaten
	 * 
	 * 
	 * @return Eckpunkte der Schicht
	 * 
	 */
	public Vektor3DPoint getEdges() {
		return Edges;
	} 


	/**
	 * Die Methode berechnet einTeil der Initialisierung neu, falls eine nderung
	 * der "Image-Position" signalisiert wurde. Dies kann von "Composite_control" aus geschehen.
	 * 
	 * 
	 * 
	 */
	public void setValues() {
		if (isTransversal()) {

			// Slicevektor positiv in Z-Richtung !
			if (SliceVector.getZ() < 0) {
				SliceVector = SliceVector.Sk_Mult(-1);
			} 
			valid = true;
			Edges.setPoint(1, ImagePosition);
			Edges.setPoint(2, Edges.getPoint(1).VC_Add(RowVector.Sk_Mult((Colums) * PixelSpacingColumn)));
			Edges.setPoint(3, Edges.getPoint(1).VC_Add(ColVector.Sk_Mult((Rows) * PixelSpacingRow)));
			Edges.setPoint(4, Edges.getPoint(3).VC_Add(RowVector.Sk_Mult((Colums) * PixelSpacingColumn)));
			Edges.setPoint(5, Edges.getPoint(1).VC_Add(SliceVector.Sk_Mult(SliceThicknes)));
			Edges.setPoint(6, Edges.getPoint(2).VC_Add(SliceVector.Sk_Mult(SliceThicknes)));
			Edges.setPoint(7, Edges.getPoint(3).VC_Add(SliceVector.Sk_Mult(SliceThicknes)));
			Edges.setPoint(8, Edges.getPoint(4).VC_Add(SliceVector.Sk_Mult(SliceThicknes)));

			// Anpassung an ImagPos !!!

			// Point3D tran1 = RowVector.Sk_Mult(PixelSpacingColumn / 2.0f) ;
			// Point3D tran2 = ColVector.Sk_Mult(PixelSpacingRow / 2.0f) ;
			// Point3D trans = tran1.VC_Add(tran2) ;

			// kleiner Koorektirfaktor !
			// Edges.translate(0,0,-5);
			FirstPixelCorner = Edges.getPoint(1);


			calcMinMax();

			Width_scale = (Col_dec / (MaxX - MinX));
			Height_scale = (Row_dec / (MaxY - MinY));
			Row_scale = (Row_dec / (Rows * PixelSpacingRow));
			Col_scale = (Col_dec / (Colums * PixelSpacingColumn));

			// Kippwinkel berechnen (Tangens)
			if (isStrictTransversal()) {
				angle = 0.0f;

			} else if (isTra_Cor()) {
				angle = (float) Math.atan(SliceVector.getY() / SliceVector.getZ()) / Global_Options.RAD;

			} else if (isTra_Sag()) {
				angle = (float) Math.atan(SliceVector.getX() / SliceVector.getZ()) / Global_Options.RAD;
			} 
		} else if (isSagittal()) {
			valid = true;

			// test  mit negativen X
			if (SliceVector.getX() > 0.0) {
				SliceVector = SliceVector.Sk_Mult(-1);
			} 
			Edges.setPoint(6, ImagePosition);
			Edges.setPoint(5, ImagePosition.VC_Add(SliceVector.Sk_Mult(SliceThicknes)));
			Edges.setPoint(7, Edges.getPoint(5).VC_Add(RowVector.Sk_Mult((Colums) * PixelSpacingColumn)));
			Edges.setPoint(8, Edges.getPoint(6).VC_Add(RowVector.Sk_Mult((Colums) * PixelSpacingColumn)));
			Edges.setPoint(1, Edges.getPoint(5).VC_Add(ColVector.Sk_Mult((Rows) * PixelSpacingRow)));
			Edges.setPoint(2, Edges.getPoint(6).VC_Add(ColVector.Sk_Mult((Rows) * PixelSpacingRow)));
			Edges.setPoint(3, Edges.getPoint(7).VC_Add(ColVector.Sk_Mult((Rows) * PixelSpacingRow)));
			Edges.setPoint(4, Edges.getPoint(8).VC_Add(ColVector.Sk_Mult((Rows) * PixelSpacingRow)));


			// Edges.translate(-trans.getX(),-trans.getY(),-trans.getZ());
			FirstPixelCorner = Edges.getPoint(6);

			calcMinMax();

			Width_scale = (Col_dec / (MaxY - MinY));
			Height_scale = (Row_dec / (MaxZ - MinZ));
			Row_scale = (Row_dec / (Rows * PixelSpacingRow));
			Col_scale = (Col_dec / (Colums * PixelSpacingColumn));

			if (isStrictSagittal()) {
				angle = 0.0f;

			} else if (isSag_Tra()) {
				angle = (float) Math.atan(SliceVector.getZ() / SliceVector.getX()) / Global_Options.RAD;

			} else if (isSag_Cor()) {
				angle = (float) Math.atan(SliceVector.getY() / SliceVector.getX()) / Global_Options.RAD;

			} 
		} else if (isCoronar()) {
			valid = true;
			if (SliceVector.getY() < 0) {
				SliceVector = SliceVector.Sk_Mult(-1);
			} 
			Edges.setPoint(5, ImagePosition);
			Edges.setPoint(7, ImagePosition.VC_Add(SliceVector.Sk_Mult(SliceThicknes)));
			Edges.setPoint(6, Edges.getPoint(5).VC_Add(RowVector.Sk_Mult((Colums) * PixelSpacingColumn)));
			Edges.setPoint(8, Edges.getPoint(6).VC_Add(SliceVector.Sk_Mult(SliceThicknes)));
			Edges.setPoint(1, Edges.getPoint(5).VC_Add(ColVector.Sk_Mult((Rows) * PixelSpacingRow)));
			Edges.setPoint(2, Edges.getPoint(6).VC_Add(ColVector.Sk_Mult((Rows) * PixelSpacingRow)));
			Edges.setPoint(3, Edges.getPoint(7).VC_Add(ColVector.Sk_Mult((Rows) * PixelSpacingRow)));
			Edges.setPoint(4, Edges.getPoint(8).VC_Add(ColVector.Sk_Mult((Rows) * PixelSpacingRow)));

			// Anpassung an ImagPos !!!
			// Point3D tran1 = RowVector.Sk_Mult(PixelSpacingColumn / 2) ;
			// Point3D tran2 = ColVector.Sk_Mult(PixelSpacingRow / 2) ;
			// Point3D trans = tran1.VC_Add(tran2) ;
			// Edges.translate(-trans.getX(),-trans.getY(),-trans.getZ());
			FirstPixelCorner = Edges.getPoint(5);
			calcMinMax();

			Width_scale = (Col_dec / (MaxX - MinX));
			Height_scale = (Row_dec / (MaxZ - MinZ));
			Row_scale = (Row_dec / (Rows * PixelSpacingRow));
			Col_scale = (Col_dec / (Colums * PixelSpacingColumn));


			if (isStrictCoronar()) {
				angle = 0.0f;

			} else if (isCor_Tra()) {
				angle = (float) Math.atan(SliceVector.getZ() / SliceVector.getY()) / Global_Options.RAD;

			} else if (isCor_Sag()) {
				angle = (float) Math.atan(SliceVector.getX() / SliceVector.getY()) / Global_Options.RAD;

			} 
		} else {

			valid = false;
			IJ.write("Schichtorientierung konnte nicht bestimmt werden !");
			return;
		} 

		// IJ.write ("new Dicom Slice") ;

		// Zusatz Informationen
		ImagePosition2 = ImagePosition.VC_Add(SliceVector.Sk_Mult(SliceThicknes));

	} 

}














/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

