/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

package mrcp.ddd;
import javax.swing.tree.*;
import mrcp.tools.*;


/**
 * Die Klassel kapselt die Information eines Serien-Knoten im Schichtbaum
 * Dazu werden serienspezifische Daten gespeichert.
 * 
 * 
 * @author Thomas Demuth
 * @version 2000.08.12
 */
public class Series_Node	// extends DefaultMutableTreeNode
 {


	/**
	 * Name der Serie
	 */

	public String		name = "unknown";


	/**
	 * Schichtabstand
	 */
	public float		Slice_Distant = 0.0f;


	/**
	 * Minimale Z-Koordinate
	 */
	public float		MinZ = Float.POSITIVE_INFINITY;


	/**
	 * Minimale X-Koordinate
	 */
	public float		MinX = Float.POSITIVE_INFINITY;


	/**
	 * Minimale Y-Koordinate
	 */
	public float		MinY = Float.POSITIVE_INFINITY;


	/**
	 * Maximale X-Koordinate
	 */
	public float		MaxX = Float.NEGATIVE_INFINITY;


	/**
	 * Maximale Y-Koordinate
	 */
	public float		MaxY = Float.NEGATIVE_INFINITY;


	/**
	 * Maximale Z-Koordinate
	 */
	public float		MaxZ = Float.NEGATIVE_INFINITY;


	/**
	 * Bildpositionsvektor in der ZY-Ebene
	 */

	public Point2D	FirstImagePosZY;


	/**
	 * Bildpositionsvektor in der ZX-Ebene
	 */
	public Point2D	FirstImagePosZX;


	/**
	 * Bildpositionsvektor in der YX-Ebene
	 */
	public Point2D	FirstImagePosYX;


	/**
	 * Bildpositionsvektor in der YZ-Ebene
	 */
	public Point2D	FirstImagePosYZ;


	/**
	 * Bildpositionsvektor in der XY-Ebene
	 */
	public Point2D	FirstImagePosXY;


	/**
	 * Bildpositionsvektor in der XZ-Ebene
	 */
	public Point2D	FirstImagePosXZ;


	/**
	 * Schichtvektor in der ZY-Ebene
	 */

	public Point2D	SliceVectorZY;


	/**
	 * Schichtvektor in der ZY-Ebene
	 */
	public Point2D	SliceVectorZX;


	/**
	 * Schichtvektor in der YX-Ebene
	 */
	public Point2D	SliceVectorYX;


	/**
	 * Schichtvektor in der YZ-Ebene
	 */
	public Point2D	SliceVectorYZ;


	/**
	 * Schichtvektor in der XY-Ebene
	 */
	public Point2D	SliceVectorXY;


	/**
	 * Schichtvektor in der XZ-Ebene
	 */
	public Point2D	SliceVectorXZ;


	/**
	 * Schichtabstand + Schichtbreite
	 */
	public float		Sum = 0;


	// Konstrukt


	/**
	 * Standardkonstruktor
	 * 
	 * 
	 */
	public Series_Node() {
		super();
	}


	/**
	 * Die Methode liefert den Seriennamen zurck
	 * 
	 * 
	 * @return  Serienname
	 * 
	 * 
	 */
	public String toString() {

		return name;
	} 


	/**
	 * Die Methode stellt den Seriennamen ein.
	 * 
	 * 
	 * @param name Der Serienname
	 * 
	 * @
	 */
	public void setName(String name) {
		this.name = name;
	} 

}




/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

