/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

package mrcp.ddd;
import rad.dicom.dcm.DcmDataObject;
import mrcp.gui.*;
import mrcp.graphics.*;
import mrcp.tools.*;
import mrcp.dd.*;
import mrcp.ddd.*;


/**
 * Die Klasse kapselt die Information eines Blattes im Schichtbaum
 * Dazu werden die Festkrpermodelierung der Schicht und die DICOM-Attribute
 * mit den Pixeldaten gespeichert.
 * 
 * @see mrcp.graphics.cube mrcp.dd.Dicom_Slice
 * @author Thomas Demuth
 * @version 2000.08.12
 */
public class Slice_Leaf {


	/**
	 * Festkrpermodellierung der Schicht und DICOM-Attribute
	 */
	public Slice_Cube cube;


	/**
	 * Name der Schicht
	 */
	public String			info;


	/**
	 * Ein Exemplar von "Slice_Leaf" wird durch Angabe des DICOM-Daten-Objektes
	 * der zugehrigen Schicht erzeugt. Zustzlich wird der Dateiname der
	 * entsprechenden DICOM-Datei gebraucht.
	 * 
	 * 
	 * @param ddo DICOM-Daten-Objekt
	 * @param Filename Dateiname
	 * 
	 */
	public Slice_Leaf(DcmDataObject ddo, String Filename) {

		cube = new Slice_Cube(Global_Options.BP);
		cube.Update(ddo, Filename);

	}


	/**
	 * Die Methode liefert den Namen des Schichtobjektes
	 * 
	 * 
	 * @return Name
	 * 
	 * 
	 */
	public String toString() {
		return "Image" + cube.ds.Imagenumber;
	} 


	/**
	 * Die Methode untersucht zwei "Slice_Leaf-Objekte" hinsichtlich ihrer
	 * Serienzugehrigkeit und Gleichheit. Falls beide Objekte zu einer Serie gehren,
	 * dann wird eine Ordnung der beiden Schichten bezglich ihrer Orientierung definiert
	 * 
	 * 
	 * @param sl Das zu vergleichende Objekt
	 * 
	 * @return 0, falls gleiche Objekte;
	 * 1 falls das zu vergleichende Objekt kleiner ;
	 * 2 falls es grer ist;
	 * -1 falls unterschiedliche Serien zur Grunde liegen;
	 * 
	 * 
	 */
	public int compare(Slice_Leaf sl) {

		// vergelicht zwei Leaf Objekte
		final int bigger = 2;
		final int smaller = 1;
		final int equal = 0;
		final int newSerie = -1;

		boolean		sameSerie = (MathTools.equal(this.cube.DbAngle, sl.cube.DbAngle, 0.01f)) && (MathTools.equal(this.cube.depth, sl.cube.depth, 0.01f)) && (MathTools.equal(this.cube.height, sl.cube.height, 0.01f)) && (MathTools.equal(this.cube.width, sl.cube.width, 0.01f)) && (this.cube.ds).compare(sl.cube.ds);

		if (!sameSerie) {
			return newSerie;

		} 
		int comp = (this.cube.ds.Imagenumber).compareTo(sl.cube.ds.Imagenumber);

		if (comp == 0) {
			return equal;

		} 
		if (this.cube.ds.isTransversal()) 

		// Transversal vergleich Z-Werte
		{
			if (this.cube.ds.ImagePosition.getZ() <= sl.cube.ds.ImagePosition.getZ()) {
				return bigger;
			} else {
				return smaller;
			} 

		} else if (this.cube.ds.isCoronar()) 

		// Coronar vergleich Y-Werte
		{

			if (this.cube.ds.ImagePosition.getY() <= sl.cube.ds.ImagePosition.getY()) {
				return bigger;
			} else {
				return smaller;
			} 

		} else if (this.cube.ds.isSagittal()) 

		// Sagittal vergleich X-Werte
		{

			// Sagtest
			if (this.cube.ds.ImagePosition.getX() >= sl.cube.ds.ImagePosition.getX()) {
				return bigger;
			} else {
				return smaller;
			} 

		} else {
			return 0;
		} 

		// else if (comp > 0) return smaller ;
		// else return bigger ;


	} 

}





/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

