/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

package mrcp.graphics;
import java.awt.Graphics2D;
import java.awt.*;
import mrcp.tools.*;


/**
 * Die Klasse "Bounding_Cube" beschreibt eine Festkrpermodellierung der Umgebungs- und Schnittquader.
 * Dazu wird ein Drahtmodell verwaltet, das durch seine acht Eckpunkte definiert ist.
 * Als Funktionalitt wird die Berechnung von Projektionen und verdeckten Kanten angeboten.
 * Das Bezugssystem ist das MRT-Koordinatensystem.
 * Als zustzliche Funktionalitt knnen die Eckpunkte nummeriert werden, um eine
 * Zuordnung zu den textuellen Informationen in der Quellenwahl zu ermglichen.
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class Bounding_Cube extends Slice_Cube {



	/**
	 * Erzeugt ein neues Drahtmodell mit den angegebenen Punkten und Projektionszentrum.
	 * Die Projektionspunkte werden mit null initialisiert.
	 * 
	 * @param p1 Punkt1
	 * @param p2 Punkt2
	 * @param p3 Punkt3
	 * @param p4 Punkt4
	 * @param p5 Punkt5
	 * @param p6 Punkt6
	 * @param p7 Punkt7
	 * @param p8 Punkt8
	 * @param BP Projektionszentrum
	 * 
	 */
	public Bounding_Cube(Point3D p1, Point3D p2, Point3D p3, Point3D p4, Point3D p5, Point3D p6, Point3D p7, Point3D p8, Point3D BP) {
		super(p1, p2, p3, p4, p5, p6, p7, p8, BP);
	}


	/**
	 * Die Methode zeichnet die gewhlte Projektion in den angegebenen grafischen Kontext.
	 * Zustzlich kann ein Translationsvektor und ein Vergrerungsfaktor angegeben werden.
	 * Falls eine schiefe Projektion mit verdeckten Kanten gezeichnet werden soll, dann kann
	 * global ber "showHiddenLines" eingestellt werden, ob diese weggelassen oder durch
	 * ein Strichmuster angedeutet werden sollen.
	 * Auerdem kann ber den Ecken der Drahtmodelle die zugehrige Nummer angezeigt werden.
	 * Dies wird global ber "drawNumbers" gesteuert.
	 * @param g grafischer kontext
	 * @param YConstant y-Komponente des Translationsvektors
	 * @param XConstant x-Komponente des Translationsvektors
	 * @param scale Vergrerungsfaktor
	 */

	public void drawCube(Graphics2D g, float YConstant, float XConstant, float scale) {

		// g.drawString("Bounding Box",5,100);
		super.drawCube(g, YConstant, XConstant, scale);

		if (!Global_Options.drawNumbers) {
			return;

			// zeichnet die Eckennummern
		} 
		if (Projection_Type == Global_Options.P_Kabinett) {
			g.drawString("1", get2dPointX(1) - 10, get2dPointY(1));
			g.drawString("2", get2dPointX(2) + 10, get2dPointY(2));
			g.drawString("3", get2dPointX(3) - 10, get2dPointY(3) + 10);
			g.drawString("4", get2dPointX(4) + 10, get2dPointY(4) + 10);
			g.drawString("5", get2dPointX(5), get2dPointY(5) - 10);
			g.drawString("6", get2dPointX(6) + 10, get2dPointY(6));
			g.drawString("7", get2dPointX(7) + 10, get2dPointY(7) - 10);
			g.drawString("8", get2dPointX(8) + 10, get2dPointY(8));
		} else if (Projection_Type == Global_Options.P_Parallel_Tra) {
			g.drawString("1", get2dPointX(1) - 10, get2dPointY(1));
			g.drawString("2", get2dPointX(2) + 10, get2dPointY(2));
			g.drawString("3", get2dPointX(3) - 10, get2dPointY(3) + 10);
			g.drawString("4", get2dPointX(4) + 10, get2dPointY(4) + 10);
		} else if (Projection_Type == Global_Options.P_Parallel_Cor) {
			g.drawString("1", get2dPointX(1) - 10, get2dPointY(1));
			g.drawString("2", get2dPointX(2) + 10, get2dPointY(2));
			g.drawString("5", get2dPointX(5), get2dPointY(5) - 10);
			g.drawString("6", get2dPointX(6) + 10, get2dPointY(6));
		} else if (Projection_Type == Global_Options.P_Parallel_Sag) {
			g.drawString("4", get2dPointX(4) + 10, get2dPointY(4) + 10);
			g.drawString("2", get2dPointX(2) + 10, get2dPointY(2));
			g.drawString("8", get2dPointX(8) + 10, get2dPointY(8));
			g.drawString("6", get2dPointX(6) + 10, get2dPointY(6));
		} 
	} 

}






/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

