/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

package mrcp.graphics;
import java.awt.*;
import ij.*;
import mrcp.tools.*;


/**
 * Die Klasse "Selection Cube" beschreibt eine Festkrpermodellierung der Schichtgeometrie.
 * Dazu wird ein Drahtmodell verwaltet, das durch seine acht Eckpunkte definiert ist.
 * Neben der Funktionalitt, die von "Cube" geerbt wird, kann dieses Objekt zustzlich rotiert und verschoben werden.
 * Das Bezugssystem ist das MRT-Koordinatensystem.
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */

public class Selection_Cube extends Cube {


	/**
	 * Orientierung der zugehrigen Schicht
	 */

	int Orientation = 0;


	/**
	 * Der Konstruktur ezeugt eine leeres Drahtmodell mit Projektionszentrum "P".
	 * 
	 * 
	 * @param p Projektionszentrum
	 * 
	 */
	public Selection_Cube(Point3D p) {
		super(p);
	}


	/**
	 * Erzeugt ein neues Drahtmodell mit den angegebenen Punkten und Projektionszentrum.
	 * Die Projektionspunkte werden mit null initialisiert.
	 * 
	 * @param p1 Punkt1
	 * @param p2 Punkt2
	 * @param p3 Punkt3
	 * @param p4 Punkt4
	 * @param p5 Punkt5
	 * @param p6 Punkt6
	 * @param p7 Punkt7
	 * @param p8 Punkt8
	 * @param BP Projektionszentrum
	 * 
	 */
	public Selection_Cube(Point3D p1, Point3D p2, Point3D p3, Point3D p4, Point3D p5, Point3D p6, Point3D p7, Point3D p8, Point3D BP) {
		super(p1, p2, p3, p4, p5, p6, p7, p8, BP);
	}

	// brechnet den Durchschnitt der X-Koordinaten


	/**
	 * Die Methode berechnet den Durchschnitt der x-Koordinaten.
	 * 
	 * 
	 * @return berechneter Durchschnitt
	 * 
	 * 
	 */
	public float getAverageX() {
		float sum = 0.0f;

		for (byte i = 1; i <= 8; i++) {
			sum += getPoint(i).getX();
		} 
		return (sum / 8);

	} 

	// brechnet den Durchschnitt der Y-Koordinaten


	/**
	 * Die Methode berechnet den Durchschnitt der y-Koordinaten.
	 * 
	 * 
	 * @return berechneter Durchschnitt
	 * 
	 * 
	 */
	public float getAverageY() {
		float sum = 0.0f;

		for (byte i = 1; i <= 8; i++) {
			sum += getPoint(i).getY();
		} 
		return (sum / 8);
	} 




	/**
	 * Die Methode berechnet den Durchschnitt der z-Koordinaten.
	 * 
	 * 
	 * @return berechneter Durchschnitt
	 * 
	 * 
	 */
	public float getAverageZ() {
		float sum = 0.0f;

		for (byte i = 1; i <= 8; i++) {
			sum += getPoint(i).getZ();
		} 
		return (sum / 8);
	} 

	// Translation des Quaders um den Vektor (x,y,z)


	/**
	 * Die Methode verschiebt das Drahtmodell relativ zu dem angegebenen Vektor.
	 * 
	 * 
	 * @param x x-Komponente des Translationsvektor
	 * @param y y-Komponente des Translationsvektor
	 * @param z z-Komponente des Translationsvektor
	 * 
	 * 
	 */
	public void translate(float x, float y, float z) {
		for (byte i = 1; i <= 8; i++) {
			getPoint(i).translate(x, y, z);
		} 
	} 



	/**
	 * Die Methode verschiebt die Mittelachse des Drahtmodells auf die Koordinatenachse Y
	 * und rotiert das Modell um die Y-Achse mit dem angegebenen Winkel.
	 * Danach wird das Modell mit dem negativen Translationsvektor zur ursprnglichen Position verschoben.
	 * 
	 * @param Grad Drehwinkel
	 * 
	 * 
	 */
	public void rotateY(float Grad) {
		float AvgX = getAverageX();
		float AvgZ = getAverageZ();

		translate(-AvgX, 0, -AvgZ);

		for (byte i = 1; i <= 8; i++) {
			getPoint(i).rotateY(Grad);
		} 

		translate(AvgX, 0, AvgZ);

	} 



	/**
	 * Die Methode verschiebt die Mittelachse des Drahtmodells auf die Koordinatenachse X
	 * und rotiert das Modell um die X-Achse mit dem angegebenen Winkel.
	 * Danach wird das Modell mit dem negativen Translationsvektor zur ursprnglichen Position verschoben.
	 * 
	 * @param Grad Drehwinkel
	 * 
	 * 
	 */
	public void rotateX(float Grad) {
		float AvgY = getAverageY();
		float AvgZ = getAverageZ();

		translate(0, -AvgY, -AvgZ);

		for (byte i = 1; i <= 8; i++) {
			getPoint(i).rotateX(Grad);
		} 

		translate(0, AvgY, AvgZ);
	} 


	/**
	 * Die Methode verschiebt die Mittelachse des Drahtmodells auf die Koordinatenachse Z
	 * und rotiert das Modell um die Z-Achse mit dem angegebenen Winkel.
	 * Danach wird das Modell mit dem negativen Translationsvektor zur ursprnglichen Position verschoben.
	 * 
	 * @param Grad Drehwinkel
	 * 
	 * 
	 */
	public void rotateZ(float Grad) {
		float AvgX = getAverageX();
		float AvgY = getAverageY();

		translate(-AvgX, -AvgY, 0);

		for (byte i = 1; i <= 8; i++) {
			getPoint(i).rotateZ(Grad);
		} 

		translate(AvgX, AvgY, 0);
	} 


	/**
	 * Die Methode verndert die Breite des Drahtmodells.
	 * Dazu wird die linke und rechte Seite um den Wert trans/2 verrckt.
	 * 
	 * @param trans relativer Verkleinerung bzw Vergrerung in mm
	 * 
	 * 
	 */
	public void translateWidth(float trans) {

		float		val = trans / 2;
		Point3D vec = getPoint(2).VC_Min(getPoint(1));

		vec.norm();
		Point3D vec1 = vec.Sk_Mult(val);
		Point3D vec2 = vec.Sk_Mult(-val);

		getPoint(2).translate(vec1);
		getPoint(4).translate(vec1);
		getPoint(6).translate(vec1);
		getPoint(8).translate(vec1);

		getPoint(1).translate(vec2);
		getPoint(3).translate(vec2);
		getPoint(5).translate(vec2);
		getPoint(7).translate(vec2);
	} 


	/**
	 * Die Methode verndert die Hhe des Drahtmodells.
	 * Dazu wird die obere und untere Seite um den Wert trans/2 verrckt.
	 * 
	 * @param trans relativer Verkleinerung bzw Vergrerung in mm
	 * 
	 * 
	 * 
	 */
	public void translateHeigth(float trans) {

		float		val = trans / 2;
		Point3D vec = getPoint(3).VC_Min(getPoint(1));

		vec.norm();
		Point3D vec1 = vec.Sk_Mult(val);
		Point3D vec2 = vec.Sk_Mult(-val);

		getPoint(3).translate(vec1);
		getPoint(4).translate(vec1);
		getPoint(7).translate(vec1);
		getPoint(8).translate(vec1);

		getPoint(1).translate(vec2);
		getPoint(2).translate(vec2);
		getPoint(5).translate(vec2);
		getPoint(6).translate(vec2);
	} 


	/**
	 * Die Methode verndert die Tiefe des Drahtmodells.
	 * Dazu wird die vordere und hintere Seite um den Wert trans/2 verrckt.
	 * 
	 * @param trans relativer Verkleinerung bzw Vergrerung in mm
	 * 
	 * 
	 * 
	 */
	public void translateDepth(float trans) {

		float		val = trans / 2;
		Point3D vec = getPoint(5).VC_Min(getPoint(1));

		vec.norm();
		Point3D vec1 = vec.Sk_Mult(val);
		Point3D vec2 = vec.Sk_Mult(-val);

		getPoint(5).translate(vec1);
		getPoint(6).translate(vec1);
		getPoint(7).translate(vec1);
		getPoint(8).translate(vec1);

		getPoint(1).translate(vec2);
		getPoint(2).translate(vec2);
		getPoint(3).translate(vec2);
		getPoint(4).translate(vec2);
	} 


	/**
	 * Die Methode zeichnet die Projektion des Drahtmodell in den angegebenen grafischen Kontext.
	 * Zustzlich kann ein Translationsvektor und ein Vergrerungsfaktor angegeben werden.
	 * Falls eine schiefe Projektion mit verdeckten Kanten gezeichnet werden soll, dann kann
	 * global ber "showHiddenLines" eingestellt werden, ob diese weggelassen oder durch
	 * ein Strichmuster angedeutet werden sollen.
	 * 
	 * @param g grafischer Kontext
	 * @param YConstant y-Komponente des Translationsvektors
	 * @param XConstant x-Komponente des Translationsvektors
	 * @param scale Vergrerungsfaktor
	 * 
	 * 
	 */
	public void drawCube(Graphics2D g, float YConstant, float XConstant, float scale) {

		// Beochbachtungspunkt an die Translationskoordinaten anpassen !
		// this.BP = Global_Options.BP ;

		if (Projection_Type == Global_Options.P_Kabinett) {

			HiddenPoint = calculateHidden();	// verdeckte Kanten berechnen


			// Projektion berechnen
		} 
		calculate2DPoints(YConstant, XConstant, scale);

		// Farbe bestimmen
		g.setColor(color);

		if (Projection_Type == Global_Options.P_Parallel_Tra2 || Projection_Type == Global_Options.P_Parallel_Sag2 || Projection_Type == Global_Options.P_Parallel_Cor2) {

			Polygon p1 = new Polygon();

			p1.addPoint(get2dPointX(1), get2dPointY(1));
			p1.addPoint(get2dPointX(2), get2dPointY(2));
			p1.addPoint(get2dPointX(6), get2dPointY(6));
			p1.addPoint(get2dPointX(5), get2dPointY(5));
			Polygon p2 = new Polygon();

			p2.addPoint(get2dPointX(2), get2dPointY(2));
			p2.addPoint(get2dPointX(6), get2dPointY(6));
			p2.addPoint(get2dPointX(8), get2dPointY(8));
			p2.addPoint(get2dPointX(4), get2dPointY(4));
			Polygon p3 = new Polygon();

			p3.addPoint(get2dPointX(1), get2dPointY(1));
			p3.addPoint(get2dPointX(2), get2dPointY(2));
			p3.addPoint(get2dPointX(4), get2dPointY(4));
			p3.addPoint(get2dPointX(3), get2dPointY(3));
			Polygon p4 = new Polygon();

			p4.addPoint(get2dPointX(5), get2dPointY(5));
			p4.addPoint(get2dPointX(6), get2dPointY(6));
			p4.addPoint(get2dPointX(8), get2dPointY(8));
			p4.addPoint(get2dPointX(7), get2dPointY(7));
			Polygon p5 = new Polygon();

			p5.addPoint(get2dPointX(1), get2dPointY(1));
			p5.addPoint(get2dPointX(5), get2dPointY(5));
			p5.addPoint(get2dPointX(7), get2dPointY(7));
			p5.addPoint(get2dPointX(3), get2dPointY(3));
			Polygon p6 = new Polygon();

			p6.addPoint(get2dPointX(3), get2dPointY(3));
			p6.addPoint(get2dPointX(4), get2dPointY(4));
			p6.addPoint(get2dPointX(8), get2dPointY(8));
			p6.addPoint(get2dPointX(7), get2dPointY(7));

			g.drawPolygon(p1);
			g.drawPolygon(p2);
			g.drawPolygon(p3);
			g.drawPolygon(p4);
			g.drawPolygon(p5);
			g.drawPolygon(p6);

			return;

		}		// P_all
 



		// p1 - p2
		float				dash1[] = {
			5.0f
		};
		BasicStroke bs2 = new BasicStroke(1.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER, 10.0f, dash1, 0.0f);
		BasicStroke bs1 = new BasicStroke(1.0f);

		g.setStroke(bs1);


		if (HiddenPoint != 1 && HiddenPoint != 2) {
			g.drawLine(get2dPointX(1), get2dPointY(1), get2dPointX(2), get2dPointY(2));
		} else if (Global_Options.showHiddenLines) {
			g.setStroke(bs2);
			g.drawLine(get2dPointX(1), get2dPointY(1), get2dPointX(2), get2dPointY(2));
			g.setStroke(bs1);
		} 

		// p1 - p3
		if (HiddenPoint != 1 && HiddenPoint != 3) {
			g.drawLine(get2dPointX(1), get2dPointY(1), get2dPointX(3), get2dPointY(3));
		} else if (Global_Options.showHiddenLines) {
			g.setStroke(bs2);
			g.drawLine(get2dPointX(1), get2dPointY(1), get2dPointX(3), get2dPointY(3));
			g.setStroke(bs1);
		} 

		// p2 - p4
		if (HiddenPoint != 4 && HiddenPoint != 2) {
			g.drawLine(get2dPointX(2), get2dPointY(2), get2dPointX(4), get2dPointY(4));
		} else if (Global_Options.showHiddenLines) {
			g.setStroke(bs2);
			g.drawLine(get2dPointX(2), get2dPointY(2), get2dPointX(4), get2dPointY(4));
			g.setStroke(bs1);
		} 

		// p4 - p3
		if (HiddenPoint != 4 && HiddenPoint != 3) {
			g.drawLine(get2dPointX(4), get2dPointY(4), get2dPointX(3), get2dPointY(3));
		} else if (Global_Options.showHiddenLines) {
			g.setStroke(bs2);
			g.drawLine(get2dPointX(4), get2dPointY(4), get2dPointX(3), get2dPointY(3));
			g.setStroke(bs1);
		} 

		// p1 - p5
		if (HiddenPoint != 1 && HiddenPoint != 5) {
			g.drawLine(get2dPointX(1), get2dPointY(1), get2dPointX(5), get2dPointY(5));
		} else if (Global_Options.showHiddenLines) {
			g.setStroke(bs2);
			g.drawLine(get2dPointX(1), get2dPointY(1), get2dPointX(5), get2dPointY(5));
			g.setStroke(bs1);
		} 


		// p2 - p6
		if (HiddenPoint != 2 && HiddenPoint != 6) {
			g.drawLine(get2dPointX(2), get2dPointY(2), get2dPointX(6), get2dPointY(6));
		} else if (Global_Options.showHiddenLines) {
			g.setStroke(bs2);
			g.drawLine(get2dPointX(2), get2dPointY(2), get2dPointX(6), get2dPointY(6));
			g.setStroke(bs1);
		} 

		// p5 - p6
		if (HiddenPoint != 5 && HiddenPoint != 6) {
			g.drawLine(get2dPointX(5), get2dPointY(5), get2dPointX(6), get2dPointY(6));
		} else if (Global_Options.showHiddenLines) {
			g.setStroke(bs2);
			g.drawLine(get2dPointX(5), get2dPointY(5), get2dPointX(6), get2dPointY(6));
			g.setStroke(bs1);
		} 

		// p4 - p8
		if (HiddenPoint != 4 && HiddenPoint != 8) {
			g.drawLine(get2dPointX(4), get2dPointY(4), get2dPointX(8), get2dPointY(8));
		} else if (Global_Options.showHiddenLines) {
			g.setStroke(bs2);
			g.drawLine(get2dPointX(4), get2dPointY(4), get2dPointX(8), get2dPointY(8));
			g.setStroke(bs1);
		} 

		// p6 - p8
		if (HiddenPoint != 6 && HiddenPoint != 8) {
			g.drawLine(get2dPointX(6), get2dPointY(6), get2dPointX(8), get2dPointY(8));
		} else if (Global_Options.showHiddenLines) {
			g.setStroke(bs2);
			g.drawLine(get2dPointX(6), get2dPointY(6), get2dPointX(8), get2dPointY(8));
			g.setStroke(bs1);
		} 

		// p3 - p7
		if (HiddenPoint != 3 && HiddenPoint != 7) {
			g.drawLine(get2dPointX(3), get2dPointY(3), get2dPointX(7), get2dPointY(7));
		} else if (Global_Options.showHiddenLines) {
			g.setStroke(bs2);
			g.drawLine(get2dPointX(3), get2dPointY(3), get2dPointX(7), get2dPointY(7));
			g.setStroke(bs1);
		} 

		// p7 - p8
		if (HiddenPoint != 7 && HiddenPoint != 8) {
			g.drawLine(get2dPointX(7), get2dPointY(7), get2dPointX(8), get2dPointY(8));
		} else if (Global_Options.showHiddenLines) {
			g.setStroke(bs2);
			g.drawLine(get2dPointX(7), get2dPointY(7), get2dPointX(8), get2dPointY(8));
			g.setStroke(bs1);
		} 

		// p5 - p7
		if (HiddenPoint != 5 && HiddenPoint != 7) {
			g.drawLine(get2dPointX(5), get2dPointY(5), get2dPointX(7), get2dPointY(7));
		} else if (Global_Options.showHiddenLines) {
			g.setStroke(bs2);
			g.drawLine(get2dPointX(5), get2dPointY(5), get2dPointX(7), get2dPointY(7));
			g.setStroke(bs1);
		} 

	} 

}






/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

