/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/


package mrcp.graphics;
import ij.*;
import rad.dicom.dcm.DcmDataObject;
import java.awt.Color;
import java.awt.Graphics2D;

import mrcp.tools.*;
import mrcp.dd.*;


/**
 * Die Klasse "Slice_Cube" beschreibt eine Festkrpermodellierung der Schichtgeometrie.
 * Dazu wird ein Drahtmodell verwaltet, das durch seine acht Eckpunkte definiert ist.
 * Als Funktionalitt wird die Berechnung von Projektionen und verdeckten Kanten angeboten.
 * Das Bezugssystem ist das MRT-Koordinatensystem.
 * Die Klasse "Slice_Cube" beinhaltet neben geometrischen Daten auch
 * ein Verweis auf die zugehrige DICOM-Schicht, sowie textuelle Informationen.
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class Slice_Cube extends Selection_Cube {


	/**
	 * Orientierung der zugehrigen Schicht
	 */
	public byte					View = 0;			// Orientierung


	/**
	 * Kippwinkel der zugehrigen Schicht als zeichenkette
	 */
	public String				Angle = "";		// Winkel der Kippung


	/**
	 * Zeichenkette ber Ausdehnung der zugehrigen Schicht
	 */
	public String				Dimension = "";		// Breite, Hhe, Tiefe, Volumen als String !


	/**
	 * DICOM-Attribute der zugehrigen Schicht
	 */
	public Dicom_Slice	ds;						// alle Informationen (keine Pixel)


	/**
	 * Breite
	 */
	public float				width;


	/**
	 * Hhe
	 */
	public float				height;


	/**
	 * Tiefe
	 */
	public float				depth;


	/**
	 * Volumen
	 */
	public float				Volume;


	/**
	 * Kippwinkel
	 */
	public float				DbAngle;


	/**
	 * Name der zugehrigen Schicht
	 */


	/**
	 * Orientierungskonstanten
	 */

	final private byte	unknown = 0;


	/**
	 * Orientierungskonstanten
	 */
	final private byte	Tra = 1;


	/**
	 * Orientierungskonstanten
	 */
	final private byte	Tra_Cor = 2;


	/**
	 * Orientierungskonstanten
	 */
	final private byte	Tra_Sag = 3;


	/**
	 * Orientierungskonstanten
	 */
	final private byte	Sag = 4;


	/**
	 * Orientierungskonstanten
	 */
	final private byte	Sag_Tra = 5;


	/**
	 * Orientierungskonstanten
	 */
	final private byte	Sag_Cor = 6;


	/**
	 * Orientierungskonstanten
	 */
	final private byte	Cor = 7;


	/**
	 * Orientierungskonstanten
	 */
	final private byte	Cor_Tra = 8;


	/**
	 * Orientierungskonstanten
	 */
	final private byte	Cor_Sag = 9;


	/**
	 * Erzeugt ein leeres Drahtmodell mit angegebenen Projektionszentrum.
	 * All Punkte werden auf (0,0,0) gesetzt.
	 * 
	 * 
	 * @param p Projektionszentrum
	 * 
	 */
	public Slice_Cube(Point3D p) {
		super(p);
	}


	/**
	 * Erzeugt ein neues Drahtmodell mit den angegebenen Punkten und Projektionszentrum.
	 * Die Projektionspunkte werden mit null initialisiert.
	 * 
	 * @param p1 Punkt1
	 * @param p2 Punkt2
	 * @param p3 Punkt3
	 * @param p4 Punkt4
	 * @param p5 Punkt5
	 * @param p6 Punkt6
	 * @param p7 Punkt7
	 * @param p8 Punkt8
	 * @param BP Projektionszentrum
	 * 
	 */
	public Slice_Cube(Point3D p1, Point3D p2, Point3D p3, Point3D p4, Point3D p5, Point3D p6, Point3D p7, Point3D p8, Point3D BP) {
		super(p1, p2, p3, p4, p5, p6, p7, p8, BP);
	}


	/**
	 * Die Methode berechnet die Punkte des Wrfels anhand angegebene DICOM-Daten-Objekt neu.
	 * Auerdem werden geometrische Datem bernommen.
	 * 
	 * @param ddo DICOM-Daten-Objekt
	 * @param Filename Dateiname
	 * 
	 * 
	 */
	public void Update(DcmDataObject ddo, String Filename) {

		Dicom_Slice tmp = new Dicom_Slice(Filename, ddo);

		ds = tmp;
		if (tmp == null) {
			return;

			// ndern !
		} 
		if (tmp.isTransversal()) {
			for (int i = 1; i <= 8; i++) {
				setPoint(i, tmp.getEdges().getPoint(i));
			} 
			setColor(Global_Options.TransversalColor);
			View = tmp.getOrientation();
			Angle = Double.toString(tmp.getAngle());

		}		// Tra !
 
		else if (tmp.isCoronar()) {

			for (int i = 1; i <= 8; i++) {
				setPoint(i, tmp.getEdges().getPoint(i));
			} 
			setColor(Global_Options.CoronarColor);
			View = tmp.getOrientation();
			Angle = Double.toString(tmp.getAngle());

		}		// Cor
 
		else if (tmp.isSagittal()) {

			for (int i = 1; i <= 8; i++) {
				setPoint(i, tmp.getEdges().getPoint(i));
			} 
			setColor(Global_Options.SagittalColor);
			View = tmp.getOrientation();
			Angle = Double.toString(tmp.getAngle());
		}		// Sag
 

		DbAngle = tmp.getAngle();
		if (Angle.length() > 8) {
			Angle = Angle.substring(0, 7);
		} 
		Angle += " Grad";
		Angle = "Winkel : " + Angle;
		width = this.getDistance(this.getPoint(1), this.getPoint(2));
		height = this.getDistance(this.getPoint(1), this.getPoint(3));
		depth = this.getDistance(this.getPoint(1), this.getPoint(5));
		Volume = width * height * depth / 1000;
		Dimension = "\nBreite : " + Math.abs(width) + "mm  \nHhe : " + Math.abs(height) + "mm  \nTiefe : " + Math.abs(Math.abs(depth)) + "mm   \nVolumen : " + Math.abs(Volume) + "cm3\n";


	} 


	/**
	 * Die Methode liefert die Orientierung der zugehrigen Schicht als Zeichenkette.
	 * 
	 * 
	 * @return Schichtorientierung
	 * 
	 * 
	 */
	public String View_to_String() {
		switch (View) {

		case Tra:
			return "Transversal";
		case Tra_Cor:
			return "Transversal nach Coronar gekippt";
		case Tra_Sag:
			return "Transversal nach Sagittal gekippt";

		case Sag:
			return "Sagittal";
		case Sag_Tra:
			return "Sagittal nach Transversal gekippt";
		case Sag_Cor:
			return "Sagittal nach Coronar gekippt";

		case Cor:
			return "Coronar";
		case Cor_Tra:
			return "Coronar nach Transversal gekippt ";
		case Cor_Sag:
			return "Coronar nach Sagittal gekippt ";

		default:
			return "unbekannt";

		}
	} 


	/**
	 * Die Methode liefert die Koordinaten der zugehrigen Schichteckpunkten als Zeichenkette.
	 * 
	 * 
	 * @return Zeichenkette mit Eckpunkkoordinaten.
	 * 
	 * 
	 */
	public String Coord_to_String() {
		String	tmp = "";

		for (int i = 1; i <= 8; i++) {
			tmp += "Punkt : " + Integer.toString(i) + "  ";
			tmp += "(";
			if ((Double.toString(getPoint(i).getX())).length() > 7) {
				tmp = tmp + (Double.toString(getPoint(i).getX())).substring(0, 6);
			} else {
				tmp = tmp + (Double.toString(getPoint(i).getX()));
			} 

			if ((Double.toString(getPoint(i).getY())).length() > 7) {
				tmp = tmp + "," + (Double.toString(getPoint(i).getY())).substring(0, 6);
			} else {
				tmp = tmp + "," + (Double.toString(getPoint(i).getY()));
			} 

			if ((Double.toString(getPoint(i).getZ())).length() > 7) {
				tmp = tmp + "," + (Double.toString(getPoint(i).getZ())).substring(0, 6);
			} else {
				tmp = tmp + "," + (Double.toString(getPoint(i).getZ()));
			} 
			tmp += ")\n";

		} 



		return tmp;
	} 


	/**
	 * Die Methode ruft die bergeordnete Zeichenroutine auf.
	 * 
	 */
	public void drawCube(Graphics2D g, float YConstant, float XConstant, float scale) {

		super.drawCube(g, YConstant, XConstant, scale);
	} 

}






/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

