/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

package mrcp.graphics;
import java.util.Vector;
import mrcp.tools.*;


/**
 * Die Klasse "Update_control" verwaltet die Einstellungen der Schichtselektion und Spezialquader
 * hinsichtlich der Geometrie.
 * Als Funktionalitt werden Rotationen und Translationen untersttzt.
 * Dazu wird innerhalb der gewhlten Schichten eine aktuelle Schicht verwaltet, die ausgelsen werden kann.
 * Diese Daten werden zur Bilderzeugung genutzt.
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class Update_control {


	/**
	 * Anzahl der Reihen
	 */
	public static int						Rows = 256;


	/**
	 * Anzahl der Spalten
	 */
	public static int						Cols = 256;


	/**
	 * x-Komponente des Ankerpunktes (linke, obere, vordere Ecke des selektierten Volumen)
	 */
	public static float					Origin_x = -100;


	/**
	 * y-Komponente des Ankerpunktes (linke, obere, vordere Ecke des selektierten Volumen)
	 */
	public static float					Origin_y = -100;


	/**
	 * z-Komponente des Ankerpunktes (linke, obere, vordere Ecke des selektierten Volumen)
	 */
	public static float					Origin_z = 0;


	/**
	 * x-Komponente des Reihenvektors
	 */
	public static float					Row_x = 1;


	/**
	 * y-Komponente des Reihenvektors
	 */
	public static float					Row_y = 0;


	/**
	 * z-Komponente des Reihenvektors
	 */
	public static float					Row_z = 0;


	/**
	 * x-Komponente des Spaltenvektors
	 */
	public static float					Col_x = 0;


	/**
	 * y-Komponente des Spaltenvektors
	 */
	public static float					Col_y = 1;


	/**
	 * z-Komponente des Spaltenvektors
	 */
	public static float					Col_z = 0;


	/**
	 * Ankerpunkt
	 */
	public static Point3D				Origin = new Point3D(Origin_x, Origin_y, Origin_z);


	/**
	 * Reihenvektor
	 */
	public static Point3D				RowVec = new Point3D(Row_x, Row_y, Row_z);


	/**
	 * Spaltenvektor
	 */
	public static Point3D				ColVec = new Point3D(Col_x, Col_y, Col_z);


	/**
	 * Schichtvektor
	 */
	public static Point3D				SliceVec = RowVec.VC_Mult(ColVec);


	/**
	 * Breite der Schichten
	 */
	public static float					width = 200;


	/**
	 * Hhe der Schichten
	 */
	public static float					heigth = 200;


	/**
	 * Tiefe der Schichten
	 */
	public static float					depth = 4;


	/**
	 * Auflsung der Reihen
	 */

	public static float					RowSpacing = 1.5f;


	/**
	 * Auflsung der Spalten
	 */
	public static float					ColSpacing = 1.5f;


	/**
	 * Schichtbreite
	 */
	public static float					SliceThickness = 5.0f;


	/**
	 * Schichtabstand
	 */
	public static float					slicedist = 0.0f;


	/**
	 * Anzahl der Schichten im Volumen
	 */
	public static int						numslices = 1;


	/**
	 * Index der aktuellen Schchicht
	 */
	public static int						currentSlice = 0;


	/**
	 * Schichtstapel
	 */
	public static Vector				CubeArray = new Vector();


	/**
	 * Zeichenkette mit der Orientierung der Schichten
	 */
	public static String				Orientation = "";


	/**
	 * Boolesche Variable, die angibt, ob die aktuelle Schicht gewechselt hat.
	 */
	public static boolean				NewPreView = true;


	/**
	 * Boolesche Variable, die angibt, ob alle Schichten in der Schichtselektion gezeigt werden sollen.
	 */
	public static boolean				showAll = false;



	/**
	 * x-Komponente des Translationsvektor zur Darstellung der schiefen Projektion in der Schichtselektion
	 */
	public static int						SelectioncubeX = 100;


	/**
	 * y-Komponente des Translationsvektor zur Darstellung der schiefen Projektion in der Schichtselektion
	 */
	public static int						SelectioncubeY = 100;


	/**
	 * Vergrerungsfaktor zur Darstellung der schiefen Projektion in der Schichtselektion
	 */
	public static float					scale = 0.2f;



	/**
	 * Die Variable steuert die Tiefe des Hintergrundbildes in der Transversalansicht der Schichtselektion.
	 */
	public static float					Trans_Z = 0.0f;


	/**
	 * Die Variable steuert die Tiefe des Hintergrundbildes in der Sagittalansicht der Schichtselektion.
	 */
	public static float					Sag_X = 0.0f;


	/**
	 * Die Variable steuert die Tiefe des Hintergrundbildes in der Coronaransicht der Schichtselektion.
	 */
	public static float					Cor_Y = 0.0f;



	/**
	 * Umgebungsquader
	 */
	public static Bounding_Cube BB = null;


	/**
	 * Schnittquader
	 */
	public static Bounding_Cube IB = null;

	// Translationskoodinaten der Gitteransicht


	/**
	 * x-Komponente des Translationsvektor des grafischen Kontext von JPanel_Cube (steuert Klicken & Ziehen)
	 */
	public static int						View3D_transX = 0;


	/**
	 * y-Komponente des Translationsvektor des grafischen Kontext von JPanel_Cube (steuert Klicken & Ziehen)
	 */
	public static int						View3D_transY = 0;


	/**
	 * MRT-Quader zur Darstellung des Aufnahmebereichs
	 */
	public static Cube					DicomQuader = new Cube(new Point3D(Global_Options.MRT_Min_X, Global_Options.MRT_Min_Y, Global_Options.MRT_Min_Z), new Point3D(Global_Options.MRT_Max_X, Global_Options.MRT_Min_Y, Global_Options.MRT_Min_Z), new Point3D(Global_Options.MRT_Min_X, Global_Options.MRT_Max_Y, Global_Options.MRT_Min_Z), new Point3D(Global_Options.MRT_Max_X, Global_Options.MRT_Max_Y, Global_Options.MRT_Min_Z), new Point3D(Global_Options.MRT_Min_X, Global_Options.MRT_Min_Y, Global_Options.MRT_Max_Z), new Point3D(Global_Options.MRT_Max_X, Global_Options.MRT_Min_Y, Global_Options.MRT_Max_Z), new Point3D(Global_Options.MRT_Min_X, Global_Options.MRT_Max_Y, Global_Options.MRT_Max_Z), new Point3D(Global_Options.MRT_Max_X, Global_Options.MRT_Max_Y, Global_Options.MRT_Max_Z), Global_Options.BP);


	/**
	 * Standardkonstruktor
	 * Setzt die Farbe des MRT-Quaders zur Darstellung des Aufnahmebereichs
	 * 
	 */
	public Update_control() {

		DicomQuader.setColor(Global_Options.GlobalCubeColor);
	}


	/**
	 * Die Methode berechnet einen neuen Schichtstapel zur Darstellung in der Schichtselektion.
	 * Dazu werden die Einstellungen aus dem Schichtparameter Dialog bernommen und umgesetzt.
	 * Beim Wechsel der Orientierung werden zunchst die medizinischen Grundrichtungen genutzt (Tra, Cor, Sag).
	 * Der Schichtstapel ist in "CubeArray" gespeichert.
	 */
	public static void setSlices() {


		CubeArray.clear();
		CubeArray = new Vector(numslices);

		if (Orientation.compareTo("Transversal") == 0) {

			// Standard Initialisierungen
			ColVec = new Point3D(0, 1, 0);
			RowVec = new Point3D(1, 0, 0);
			SliceVec = new Point3D(0, 0, 1);

		} 

		if (Orientation.compareTo("Sagittal") == 0) {

			// Standard Initialisierungen
			ColVec = new Point3D(0, 0, -1);
			RowVec = new Point3D(0, 1, 0);
			SliceVec = new Point3D(-1, 0, 0);
		} 

		if (Orientation.compareTo("Coronar") == 0) {

			// Standard Initialisierungen
			ColVec = new Point3D(0, 0, -1);
			RowVec = new Point3D(1, 0, 0);
			SliceVec = new Point3D(0, 1, 0);
		} 


		for (int i = 0; i < numslices; i++) {

			Selection_Cube	sc = new Selection_Cube(new Point3D(Origin.getX(), Origin.getY(), Origin.getZ()),		// 1
			(Origin.VC_Add(RowVec.Sk_Mult(width))),			// 2
			(Origin.VC_Add(ColVec.Sk_Mult(heigth))),		// 3
			(Origin.VC_Add(ColVec.Sk_Mult(heigth)).VC_Add(RowVec.Sk_Mult(width))),	// 4
			(Origin.VC_Add(SliceVec.Sk_Mult(depth))),		// 5
			(Origin.VC_Add(SliceVec.Sk_Mult(depth)).VC_Add(RowVec.Sk_Mult(width))),		// 6
			(Origin.VC_Add(SliceVec.Sk_Mult(depth)).VC_Add(ColVec.Sk_Mult(heigth))),	// 7
			(Origin.VC_Add(SliceVec.Sk_Mult(depth)).VC_Add(ColVec.Sk_Mult(heigth)).VC_Add(RowVec.Sk_Mult(width))),	// 8
			Global_Options.BP);

			sc.setColor(Global_Options.SelectionColor);
			Point3D TV = SliceVec.Sk_Mult(i * (depth + slicedist));

			sc.translate(TV.getX(), TV.getY(), TV.getZ());
			CubeArray.add(sc);

		}																							// i
 
		reset();
	}		// set
 

	/**
	 * Die Methode liefert den Ankerpunkt der aktuellen Schicht zurck.
	 * 
	 * 
	 * @return Positionsvektor des Ankerpunktes
	 * 
	 * 
	 */
	public static Point3D getOrigin() {

		// Ursprung der aktuellen Schicht
		if (CubeArray.size() > currentSlice) {
			float x = ((Selection_Cube) CubeArray.elementAt(currentSlice)).getPoint(1).getX();
			float y = ((Selection_Cube) CubeArray.elementAt(currentSlice)).getPoint(1).getY();
			float z = ((Selection_Cube) CubeArray.elementAt(currentSlice)).getPoint(1).getZ();

			return new Point3D(x, y, z);
		} else {
			return null;
		} 
	} 


	/**
	 * Die Methode liefert die aktuelle Schicht zurck.
	 * 
	 * 
	 * @return Das Drahtmodell der aktuellen Schicht.
	 * 
	 * 
	 */
	public static Selection_Cube getSlice() {

		// aktuelle Schicht
		if (CubeArray.size() > currentSlice) {
			return ((Selection_Cube) CubeArray.elementAt(currentSlice));
		} else {
			return null;
		} 
	} 


	/**
	 * Die Methode erhht den internen Zhler der aktuellen Schicht
	 * und blttert damit im Bildstapel nach vorne.
	 * 
	 * 
	 * 
	 */
	public static void increment() {
		if (CubeArray.size() > currentSlice + 1 || currentSlice < 0) {
			currentSlice++;
		} 
	} 


	/**
	 * Die Methode erniedrigt den internen Zhler der aktuellen Schicht
	 * und blttert damit im Bildstapel nach hinten.
	 * 
	 * 
	 * 
	 */
	public static void decrement() {
		if (currentSlice > 0) {
			currentSlice--;
		} 
	} 


	/**
	 * Die Methode verschiebt die Schichtvolumina.
	 * 
	 * 
	 * @param x x-Komponente des Translationsvektors
	 * @param y y-Komponente des Translationsvektors
	 * @param z z-Komponente des Translationsvektors
	 * 
	 * 
	 */
	public static void translate(float x, float y, float z) {
		for (int i = 0; i < CubeArray.size(); i++) {

			((Selection_Cube) CubeArray.elementAt(i)).translate(x, y, z);
		} 
	} 


	/**
	 * Die Methode rotiert die Schichtvolumina um die y-Achse mit dem Winkel "step".
	 * 
	 * 
	 * @param step Drehwinkel
	 * 
	 */
	public static void rotateY(float step) {
		float AvgX = 0;
		float AvgZ = 0;

		for (int i = 0; i < CubeArray.size(); i++) {
			Selection_Cube	sc = ((Selection_Cube) CubeArray.elementAt(i));

			AvgX += sc.getAverageX();
			AvgZ += sc.getAverageZ();
		} 

		AvgX /= CubeArray.size();
		AvgZ /= CubeArray.size();

		translate(-AvgX, 0, -AvgZ);

		for (int q = 0; q < CubeArray.size(); q++) {
			Selection_Cube	sc = ((Selection_Cube) CubeArray.elementAt(q));

			for (byte i = 1; i <= 8; i++) {
				sc.getPoint(i).rotateY(step);
			} 
		} 

		translate(AvgX, 0, AvgZ);
		reset();
	} 


	/**
	 * Die Methode rotiert die Schichtvolumina um die x-Achse mit dem Winkel "step".
	 * 
	 * 
	 * @param step Drehwinkel
	 * 
	 * 
	 */
	public static void rotateX(float step) {
		float AvgY = 0;
		float AvgZ = 0;

		for (int i = 0; i < CubeArray.size(); i++) {
			Selection_Cube	sc = ((Selection_Cube) CubeArray.elementAt(i));

			AvgY += sc.getAverageY();
			AvgZ += sc.getAverageZ();
		} 
		AvgY /= CubeArray.size();
		AvgZ /= CubeArray.size();

		translate(0, -AvgY, -AvgZ);

		for (int q = 0; q < CubeArray.size(); q++) {
			Selection_Cube	sc = ((Selection_Cube) CubeArray.elementAt(q));

			for (byte i = 1; i <= 8; i++) {
				sc.getPoint(i).rotateX(step);
			} 

			reset();
		} 

		translate(0, AvgY, AvgZ);
	} 


	/**
	 * Die Methode rotiert die Schichtvolumina um die z-Achse mit dem Winkel "step".
	 * 
	 * 
	 * @param step Drehwinkel
	 */
	public static void rotateZ(float step) {
		float AvgX = 0;
		float AvgY = 0;

		for (int i = 0; i < CubeArray.size(); i++) {
			Selection_Cube	sc = ((Selection_Cube) CubeArray.elementAt(i));

			AvgX += sc.getAverageX();
			AvgY += sc.getAverageY();
		} 

		AvgX /= CubeArray.size();
		AvgY /= CubeArray.size();

		translate(-AvgX, -AvgY, 0);

		for (int q = 0; q < CubeArray.size(); q++) {
			Selection_Cube	sc = ((Selection_Cube) CubeArray.elementAt(q));

			for (byte i = 1; i <= 8; i++) {
				sc.getPoint(i).rotateZ(step);
			} 
		} 

		translate(AvgX, AvgY, 0);
		reset();
	} 


	/**
	 * Die Methode ndert die Schichtbreite, indem die
	 * linke und rechte Seite um den Wert "step" verschoben werden.
	 * 
	 * 
	 * @param step Breitennderung
	 * 
	 * 
	 */
	public static void translateWidth(float step) {
		for (int i = 0; i < CubeArray.size(); i++) {

			((Selection_Cube) CubeArray.elementAt(i)).translateWidth(step);
		} 
		reset();
	} 


	/**
	 * Die Methode ndert die Schichthhe, indem die
	 * obere und untere Seite um den Wert "step" verschoben werden.
	 * 
	 * 
	 * @param step Hhennderung
	 * 
	 * 
	 */
	public static void translateHeigth(float step) {
		for (int i = 0; i < CubeArray.size(); i++) {

			((Selection_Cube) CubeArray.elementAt(i)).translateHeigth(step);
		} 
		reset();
	} 


	/**
	 * Die Methode ndert die Schichttiefe, indem die
	 * vordere und hintere Seite um den Wert "step" verschoben werden.
	 * 
	 * 
	 * @param step Tiefennderung
	 * 
	 * 
	 */

	public static void translateDepth(float step) {
		for (int i = 0; i < CubeArray.size(); i++) {

			((Selection_Cube) CubeArray.elementAt(i)).translateDepth(step);
		} 
		slicedist -= step;
		reset();
	} 


	/**
	 * Die Methode prft, ob die aktuelle Schicht die letzte im Schichtstapel ist.
	 * 
	 * 
	 * @return wahr, falls aktuelle Schicht die letzte im Schichtstapel
	 * 
	 * 
	 */
	public static boolean isLast() {
		return currentSlice == (CubeArray.size() - 1);
	} 


	/**
	 * Die Methode berechnet die Lagevektoren und Positionsvektoren der Schichten neu.
	 * Dies wird notwendig, falls eine Rotation oder Translation vorgenommen wurde.
	 * 
	 * 
	 */

	public static void reset() {

		// Neuberechnung der Vektoren
		if (CubeArray == null || CubeArray.size() <= 0) {
			return;
		} 
		Selection_Cube	sc = (Selection_Cube) CubeArray.elementAt(0);

		RowVec = sc.getPoint(2).VC_Min(sc.getPoint(1));
		width = RowVec.Length();
		RowVec.norm();

		ColVec = sc.getPoint(3).VC_Min(sc.getPoint(1));
		heigth = ColVec.Length();
		ColVec.norm();

		SliceVec = sc.getPoint(5).VC_Min(sc.getPoint(1));
		depth = SliceVec.Length();
		SliceVec.norm();

		Point3D og = sc.getPoint(1);

		Origin = new Point3D(og.getX(), og.getY(), og.getZ());

		Cols = (int) (width / ColSpacing);
		Rows = (int) (heigth / RowSpacing);

		// Slice Distant !!!
	} 

}






/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

