/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

package mrcp.gui;
import javax.swing.*;
import java.awt.*;
import ij.*;
import javax.swing.JTree;
import javax.swing.tree.*;
import java.awt.Color;

import mrcp.gui.*;
import mrcp.graphics.*;
import mrcp.tools.*;
import mrcp.dd.*;
import mrcp.ddd.*;
import mrcp.control.*;


/**
 * Die Klasse beschreibt die grafische Oberflche der Karteikarte Bildberlagerung.
 * Zur Ereignisbehandlung wird eine eigene Klasse vom Typ "Composite_control" verwendet.
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class JPanel_Composite extends JPanel {


	/**
	 * Verweis auf die gui der Pluginklasse
	 */
	gui															Document;


	/**
	 * Kontrollmodul zur Ereignisehandlung
	 */
	Composite_control								control;


	/**
	 * Layout
	 */
	GridBagLayout										gridBagLayout1 = new GridBagLayout();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JButton													jButton1 = new JButton();


	/**
	 * grafische Oberflche der Bildflche zur Darstellung der Bildberlagerung
	 */
	public JPanel_CompositePicture	Picture;


	/**
	 * Auswahlliste fr Kanal2
	 */
	public JList										jList_ser2 = new JList();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JSlider													jSlider_source = new JSlider();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JSlider													jSlider_contrast1 = new JSlider();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JScrollPane											jScrollPane1 = new JScrollPane();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JScrollPane											jScrollPane2 = new JScrollPane();


	/**
	 * Auswahlliste fr Kanal1
	 */
	public JList										jList1 = new JList();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JLabel													jLabel3 = new JLabel();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JLabel													jLabel4 = new JLabel();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JSlider													jSlider_dest = new JSlider();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JButton													jButton_up = new JButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JButton													jButton_down = new JButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JButton													jButton_left = new JButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JButton													jButton_rigth = new JButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JButton													jButton_rotl = new JButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JButton													jButton_rotr = new JButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JLabel													jLabel6 = new JLabel();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JSlider													jSlider_bright = new JSlider();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JSlider													jSlider_contrast2 = new JSlider();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JSlider													jSlider_bright2 = new JSlider();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JButton													jButton_rigthsl = new JButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JButton													jButton_leftsl = new JButton();


	/**
	 * Icon zur grafischen Darstellung einer Schaltflche
	 */
	ImageIcon												icon_left = new ImageIcon(getClass().getResource("resources/left.gif"));


	/**
	 * Icon zur grafischen Darstellung einer Schaltflche
	 */
	ImageIcon												icon_rigth = new ImageIcon(getClass().getResource("resources/right.gif"));


	/**
	 * Icon zur grafischen Darstellung einer Schaltflche
	 */
	ImageIcon												icon_up = new ImageIcon(getClass().getResource("resources/up.gif"));


	/**
	 * Icon zur grafischen Darstellung einer Schaltflche
	 */

	ImageIcon												icon_down = new ImageIcon(getClass().getResource("resources/down.gif"));


	/**
	 * Icon zur grafischen Darstellung einer Schaltflche
	 */
	ImageIcon												icon_rr = new ImageIcon(getClass().getResource("resources/rotrigth.gif"));


	/**
	 * Icon zur grafischen Darstellung einer Schaltflche
	 */
	ImageIcon												icon_rl = new ImageIcon(getClass().getResource("resources/rotleft.gif"));


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JLabel													jLabel2 = new JLabel();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JLabel													jLabel1 = new JLabel();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JLabel													jLabel5 = new JLabel();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JLabel													jLabel7 = new JLabel();


	/**
	 * Fortschrittsbalken
	 */
	public JProgressBar							jProgressBar1 = new JProgressBar();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JPanel													jPanel1 = new JPanel();



	/**
	 * Standardkonstruktor
	 * 
	 * 
	 */
	public JPanel_Composite() {
		try {
			jbInit();
		} catch (Exception e) {
			e.printStackTrace();
		} 
	}


	/**
	 * Konstruktor mit bergebenden Verweis auf die gui der Pluginklasse und das Kontrollmodul
	 * Zur Darstellung der Oberflche wird "jbInit" aufgerufen.
	 * 
	 * @param Document gui der Pluginklasee
	 * @param control Kontrollklasse
	 * 
	 */
	public JPanel_Composite(gui Document, Composite_control control) {
		this.Document = Document;
		this.control = control;
		try {
			jbInit();
			validate();
		} catch (Exception e) {
			e.printStackTrace();
		} 
	}


	/**
	 * Von JBuilder automatisch generierte Initialisierungsmethode fuer die
	 * grafischen Elemente.
	 * 
	 * 
	 * @throws Exception
	 * 
	 * 
	 */
	private void jbInit() throws Exception {
		Picture = new JPanel_CompositePicture(control);
		this.setLayout(gridBagLayout1);
		jLabel1.setForeground(Color.black);
		jLabel2.setForeground(Color.black);
		jLabel3.setFont(new java.awt.Font("SansSerif", 1, 13));
		jLabel3.setForeground(Color.black);
		jLabel4.setFont(new java.awt.Font("SansSerif", 1, 13));
		jLabel4.setForeground(Color.black);
		jLabel5.setForeground(Color.black);
		jLabel6.setForeground(Color.black);
		jLabel7.setForeground(Color.black);
		jScrollPane1.setMaximumSize(new Dimension(150, 150));
		jScrollPane1.setMinimumSize(new Dimension(150, 150));
		jScrollPane1.setPreferredSize(new Dimension(150, 150));
		jScrollPane2.setMinimumSize(new Dimension(150, 150));
		jScrollPane2.setPreferredSize(new Dimension(150, 150));
		jLabel3.setText("Bild 02   Quellenwahl");
		jLabel4.setText("Bild 01  Quellenwahl");
		jLabel6.setMinimumSize(new Dimension(70, 17));
		jLabel6.setPreferredSize(new Dimension(70, 17));
		jLabel6.setHorizontalAlignment(SwingConstants.CENTER);
		jLabel6.setHorizontalTextPosition(SwingConstants.CENTER);
		jLabel6.setText("Kanal 2");
		jSlider_source.setPreferredSize(new Dimension(100, 24));
		jSlider_source.setMaximumSize(new Dimension(100, 24));
		jSlider_source.setMinimumSize(new Dimension(100, 24));
		jSlider_dest.setPreferredSize(new Dimension(100, 24));
		jSlider_dest.setMaximumSize(new Dimension(100, 24));
		jSlider_dest.setMinimumSize(new Dimension(100, 24));
		jSlider_contrast1.setPreferredSize(new Dimension(90, 24));
		jSlider_bright.setPreferredSize(new Dimension(90, 24));
		jSlider_bright2.setPreferredSize(new Dimension(90, 24));
		jSlider_contrast2.setPreferredSize(new Dimension(90, 24));
		jButton_rigthsl.setIcon(icon_rigth);
		jButton_leftsl.setIcon(icon_left);
		jLabel2.setText("Kanal 1");
		jButton_up.setIcon(icon_up);
		jButton_down.setIcon(icon_down);
		jButton_rigth.setIcon(icon_rigth);
		jButton_left.setIcon(icon_left);
		jButton_rotl.setIcon(icon_rl);
		jButton_rotr.setIcon(icon_rr);
		jLabel1.setText("Alpha");
		jLabel5.setText("Helligkeit");
		jLabel7.setText("Kontrast");
		jProgressBar1.setMinimumSize(new Dimension(150, 16));
		this.add(Picture, new GridBagConstraints(4, 2, 1, 11, 0.5, 0.5, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jScrollPane1, new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jScrollPane2, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jLabel3, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jLabel4, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(10, 0, 0, 0), 0, 0));
		this.add(jButton_left, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jButton_down, new GridBagConstraints(0, 11, 3, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jButton_rotl, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jButton_rigth, new GridBagConstraints(2, 10, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jButton_rotr, new GridBagConstraints(2, 12, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jButton_up, new GridBagConstraints(0, 9, 3, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jButton1, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jSlider_contrast1, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jSlider_source, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jLabel2, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jSlider_bright, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jSlider_contrast2, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jLabel6, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jSlider_bright2, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jSlider_dest, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jLabel1, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jLabel5, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jLabel7, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jProgressBar1, new GridBagConstraints(4, 13, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jPanel1, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jButton_leftsl, null);
		jPanel1.add(jButton_rigthsl, null);

		jScrollPane2.getViewport().add(jList1, null);
		jScrollPane1.getViewport().add(jList_ser2, null);


		// Buttons
		jButton1.setText("Aktualisieren");
		jButton1.setActionCommand("Draw");
		jButton1.addActionListener(control);


		// Buttons
		jButton_up.setActionCommand("up");
		jButton_up.addActionListener(control);


		// Buttons
		jButton_down.setActionCommand("down");
		jButton_down.addActionListener(control);

		jButton_left.setActionCommand("left");
		jButton_left.addActionListener(control);

		jButton_rigth.setActionCommand("rigth");
		jButton_rigth.addActionListener(control);

		jButton_rotl.setActionCommand("rotl");
		jButton_rotl.addActionListener(control);

		jButton_rotr.setActionCommand("rotr");
		jButton_rotr.addActionListener(control);


		jButton_leftsl.setActionCommand("sll");
		jButton_leftsl.addActionListener(control);


		jButton_rigthsl.setActionCommand("slr");
		jButton_rigthsl.addActionListener(control);


		// sliders
		jSlider_source.addChangeListener(control);
		jSlider_source.setName("Source");

		jSlider_dest.addChangeListener(control);
		jSlider_dest.setName("Dest");

		jSlider_contrast1.addChangeListener(control);
		jSlider_contrast1.setName("Contrast1");

		jSlider_bright.addChangeListener(control);
		jSlider_bright.setName("Bright1");

		jSlider_contrast2.addChangeListener(control);
		jSlider_contrast2.setName("Contrast2");

		jSlider_bright2.addChangeListener(control);
		jSlider_bright2.setName("Bright2");

	} 


	/**
	 * Die Methode aktualisiert den Inhalt der Auswahllisten, die die mglichen Quelldatenstze beinhalten.
	 * 
	 * 
	 * 
	 */
	public void setSeriesStrings() {

		DefaultMutableTreeNode	top = (DefaultMutableTreeNode) Document.top;
		int											number = top.getChildCount();
		String[]								ser = new String[number];

		for (int i = 0; i < number; i++) {
			DefaultMutableTreeNode	Serie = (DefaultMutableTreeNode) top.getChildAt(i);
			Series_Node							sn = (Series_Node) Serie.getUserObject();

			ser[i] = sn.name;
		} 
		this.jList1.setListData(ser);
		this.jList_ser2.setListData(ser);

	} 


}





/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

