/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

package mrcp.gui;

import java.awt.*;
import javax.swing.JPanel;
import ij.*;
import ij.process.*;

import mrcp.control.*;
import mrcp.graphics.*;


/**
 * Die Klasse verwaltet die Bildflche zur Darstellung der Bildberlagerung.
 * Zur Ereignisbehandlung wird eine eigene Klasse vom Typ "Composite_control" verwendet.
 * Insbesondere wird die Methode "paint" berschrieben, um das Zeichenen in der Bildflche zu ermglichen.
 * Alpha-Werte und Java-Bilder werden dazu aus der zugehrigen Kontrollklasse gewonnen.
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class JPanel_CompositePicture extends JPanel {


	/**
	 * Verweis auf die Kontrollklassse
	 */
	Composite_control control;


	/**
	 * Angezeigte Breite des Bildes
	 */
	public float			wid = 0;


	/**
	 * Erzeugt ein neues Exemplar mit zugehriger Kontrollklasse.
	 * 
	 * 
	 * @param control Kontrollklasse
	 * 
	 */
	public JPanel_CompositePicture(Composite_control control) {
		this.setLayout(null);
		this.control = control;

	}


	/**
	 * Die Methode steuert die Bildberlagerung des grafischen Kontextes durch Zuordnung
	 * des Alpha-Wertes und der Pixelberlagerung.
	 * 
	 * 
	 * @param alpha Transparenzwert
	 * 
	 * @return Instanz der aktuellen Einstellungen von "AlphaComposite"
	 * 
	 * 
	 */
	private AlphaComposite makeComposite(float alpha) {

		int type = AlphaComposite.SRC_OVER;

		return (AlphaComposite.getInstance(type, alpha));
	} 


	/**
	 * Die Methode zeichnet die Bildflche neu.
	 * Dazu wird die Methode "paint" aufgerufen.
	 * 
	 * 
	 */
	public void Update_Pic() {
		paint(this.getGraphics());
	} 


	/**
	 * Die Methode "paint" wird hier berschrieben, um die Darstellung der
	 * Bildberlagerung mglich zu machen. Dazu werden die aktuellen Bilder
	 * aus der Kontrollklasse mit den entsprechenden Transparenzeinstellungen gezeichnet.
	 * 
	 * 
	 * @param g grafischer Kontext
	 * 
	 * 
	 */
	public void paint(Graphics g) {

		if (control.sp == null || control.sp2 == null) {
			IJ.write("Keine Quellbilder vorhanden");
			g.clearRect(0, 0, 800, 800);
			return;
		} 

		// IJ.write("Paint aufgerufen");

		// Image pic = control.sp.createImage() ;
		// Image pic2 = control.sp2.createImage() ;


		Image				pic = control.i1;
		Image				pic2 = control.i2;



		Graphics2D	g2d = (Graphics2D) g;
		Rectangle		rec = this.getBounds();

		g2d.setPaint(Color.black);
		g2d.fillRect(0, 0, rec.width, rec.height);

		// g2d.clearRect(0,0,400,400);
		Composite orginal = g2d.getComposite();

		// g2d.setPaint(Color.blue);
		// g2d.fill(new Rectangle (20,20,100,100));
		g2d.setComposite(makeComposite(control.alpha_one));


		// Ausdehnungen berechnen
		// Mastab angleichen und vergern bzw verkleinern !

		Rectangle r = this.getBounds();

		// Rahmen zum bewegen lassen
		r.width -= 20;
		r.x += 10;
		r.height -= 20;
		r.y += 10;


		float fac1 = (float) r.width / (float) Update_control.Cols;
		float fac2 = (float) r.height / (float) Update_control.Rows;
		float fac = Math.min(fac1, fac2);
		float wi = (Update_control.Cols * fac);
		float he = (Update_control.Rows * fac);

		// zentrieren
		int		left = (int) ((r.width - wi) / 2);
		int		top = (int) ((r.height - he) / 2);


		g2d.drawImage(pic, left, top, (int) wi, (int) he, null);

		g2d.translate(control.trans.getX(), control.trans.getY());
		g2d.rotate(control.rotation, r.width / 2, r.height / 2);
		g2d.setComposite(makeComposite(control.alpha_two));

		// g2d.setPaint(Color.red);
		// g2d.fill(new Rectangle (30,30,100,100));

		g2d.drawImage(pic2, left, top, (int) wi, (int) he, null);
		wid = (int) wi;
		g2d.setComposite(orginal);
		g2d.translate(0, 0);


	} 

}




/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

