/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/


package mrcp.gui;
import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.image.*;
import ij.*;

import mrcp.graphics.*;
import mrcp.tools.*;

// gui fr die Pseudo 3D Ansicht


/**
 * Die Klasse verwaltet die Bildflche zur Darstellung der schiefen Projektion in der Schichtselektion.
 * Insbesondere wird die Methode "paint" berschrieben, um das Zeichnen in der Bildflche zu ermglichen.
 * Hier wird eine Methode angewand, die sich "Double-Buffer" nennt, da das eigentlich zu zeichnende Bild
 * nicht direkt, sondern zunchst als "Offscreenbild" gezeichnet wird. Erst dieses Bild wird in der Oberflche dargestellt.
 * Je nach Einstellung mssen die Projektionspunkte, Umgebungs- und der Quader des Aufnahmebereichs gezeichnet werden.
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class JPanel_Cube extends JPanel {


	/**
	 * Verweis auf die gui der Pluginklasse
	 */
	gui						Document;


	/**
	 * Offscreenbild, das als Puffer dient.
	 */
	BufferedImage offscreen = null;


	/**
	 * Breite des Bildes
	 */
	int						width = 0;


	/**
	 * Hhe des Bildes
	 */
	int						height = 0;



	/**
	 * Der Konstruktur erzeugt ein neues Exemplar durch Angabe der gui zugehriger Pluginklasse.
	 * 
	 * 
	 * @param Document gui der Pluginklasse
	 * 
	 */
	public JPanel_Cube(gui Document) {

		this.setCursor(new Cursor(Cursor.HAND_CURSOR));
		this.Document = Document;
	}


	/**
	 * Die Methode liefert die zugehrige gui der Pluginklasse zurck.
	 * 
	 * 
	 * @return Pluginklasse
	 * 
	 */
	public gui getDocument() {
		return this.Document;
	} 


	/**
	 * Die Methode bewirkt ein Neuzeichnen der schiefen Projektion.
	 * 
	 * 
	 * @param g grafischer Kontext
	 * 
	 * 
	 */
	public void update(Graphics g) {
		paint(g);
	} 


	/**
	 * Die Methode "paint" wird hier berschrieben, um die Darstellung der
	 * schiefen Projektion mglich zu machen. Dazu wird geprft, on eine Neuberechnug
	 * ntig ist. Falls ja, wird ein neues Offscreenbild gezeichnet und dieses ausgegeben.
	 * Falls nein, kann ohne Berechnung sofort gezeichnet werden.
	 * 
	 * @param g grafischer Kontext
	 * 
	 * 
	 */
	public void paint(Graphics g) {

		if (width != getSize().width || height != getSize().height) {

			// neues Bild erstellen
			if (offscreen != null) {
				offscreen.flush();
			} 
			offscreen = null;
		} 


		if (offscreen == null) {
			width = getSize().width;
			height = getSize().height;

			offscreen = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);

		} 
		Graphics2D	og = offscreen.createGraphics();

		og.setClip(0, 0, getSize().width, getSize().height);
		super.paint(og);
		og.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);


		og.translate(Update_control.View3D_transX, Update_control.View3D_transY);




		// MRT Quader
		(Update_control.DicomQuader).setColor(Global_Options.GlobalCubeColor);
		(Update_control.DicomQuader).drawCube(og, Update_control.SelectioncubeY, Update_control.SelectioncubeX, Update_control.scale);

		// Auswahl Quader

		if (Update_control.getSlice() == null) {
			return;
		} 
		if (!Update_control.showAll) {
			Update_control.getSlice().setProjection(Global_Options.P_Kabinett);
			Update_control.getSlice().setColor(Global_Options.SelectionColor);
			Update_control.getSlice().drawCube(og, Update_control.SelectioncubeY, Update_control.SelectioncubeX, Update_control.scale);
		} else {
			int old = Update_control.currentSlice;

			for (int i = 0; i < Update_control.CubeArray.size(); i++) {
				Selection_Cube	sc = ((Selection_Cube) Update_control.CubeArray.elementAt(i));

				sc.setProjection(Global_Options.P_Kabinett);
				sc.setColor(Global_Options.SelectionColor);
				if (i == old) {
					sc.setColor(Global_Options.CurrentSliceColor);
				} 
				sc.drawCube(og, Update_control.SelectioncubeY, Update_control.SelectioncubeX, Update_control.scale);
				sc.setColor(Global_Options.SelectionColor);
			} 

		} 

		// Bounding Quader
		if (Update_control.BB == null) {
			return;
		} else {
			(Update_control.BB).setColor(Global_Options.BoundingColor);
			(Update_control.BB).drawCube(og, Update_control.SelectioncubeY, Update_control.SelectioncubeX, Update_control.scale);
		} 

		g.drawImage(offscreen, 0, 0, null);

	} 





}




/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

