/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

package mrcp.gui;
import javax.swing.*;
import java.awt.*;
import java.awt.image.*;
import ij.*;

import mrcp.control.*;
import mrcp.ddd.*;


/**
 * Die Klasse verwaltet die Bildflche zur Darstellung der schiefen Projektion in der Quellenselektion.
 * Insbesondere wird die Methode "paint" berschrieben, um das Zeichnen in der Bildflche zu ermglichen.
 * Hier wird eine Methode angewand, die sich "Double-Buffer" nennt, da das eigentlich zu zeichnende Bild
 * nicht direkt, sondern zunchst als "Offscreenbild" gezeichnet wird. Erst dieses Bild wird in der Oberflche dargestellt.
 * Je nach Einstellung mssen die Projektionspunkte, der Umgebungs- und Schnittquader gezeichnet werden.
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class JPanel_DicomCube extends JPanel {


	/**
	 * Verweis auf die Pluginklasse
	 */

	gui										Document;


	/**
	 * Verweis auf die zugehrige Kontrollklasse
	 */
	public Source_control control;


	/**
	 * Verweis auf die zugehrige grafische Oberflche
	 */
	public JPanel_Source	source;


	/**
	 * Boolesche Variable, die angibt, ob eine Vernderung des "Offscreenbildes" vorgenommen wurde.
	 */
	public boolean				update = true;


	/**
	 * Offscreenbild, das als Puffer fungiert.
	 */
	BufferedImage					offscreen = null;


	/**
	 * Offscreenbild, das als Puffer fungiert.
	 */
	BufferedImage					tripple = null;


	/**
	 * Breite des Bildes
	 */
	int										width = 0;


	/**
	 * Hhe des Bildes
	 */
	int										height = 0;


	/**
	 * Konstruktor mit bergebenden Verweis auf die gui der Pluginklasse, das Kontrollmodul
	 * und die zugehrige grafische Oberflche. Diese werden als "Member" gespeichert.
	 * 
	 * 
	 * @param Document gui der Pluginklasse
	 * @param control Kontrollklasse
	 * @param source grafische Oberflche
	 * 
	 */
	public JPanel_DicomCube(gui Document, Source_control control, JPanel_Source source) {
		this.Document = Document;
		this.control = control;
		this.source = source;


	}


	/**
	 * Die Methode liefert das zugehrige Kontrollmodul zurck.
	 * 
	 * 
	 * @return Verweis auf Kontrollklasse
	 * 
	 * 
	 */
	public Source_control getControl() {
		return control;
	} 


	/**
	 * Die Methode bewirkt ein Neuzeichnen der schiefen Projektion.
	 * 
	 * 
	 * @param g grafischer Kontext
	 * 
	 * 
	 */

	public void update(Graphics g) {
		paint(g);
	} 


	/**
	 * Die Methode "paint" wird hier berschrieben, um die Darstellung der
	 * schiefen Projektion mglich zu machen. Dazu wird geprft, on eine Neuberechnug
	 * ntig ist. Falls ja, wird ein neues Offscreenbild gezeichnet und diese ausgegeben.
	 * Falls nein, kann ohne Berechnung sofort gezeichnet werden.
	 * Zustzlich kann ber "redraw" festgestellt werden, ob ein Zeichnen des Umgebungsquader ausreicht.
	 * Diese wird immer dann getan, falls eine Bewegung der Projektion visualisiert werden soll.
	 * @param g grafischer Kontext
	 * 
	 * 
	 * 
	 */
	public void paint(Graphics g) {

		if (width != getSize().width || height != getSize().height) {

			// neues Bild erstellen

			if (offscreen != null) {
				offscreen.flush();
			} 
			offscreen = null;
		} 


		if (offscreen == null) {
			width = getSize().width;
			height = getSize().height;

			offscreen = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
			tripple = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
			update = true;
		} 

		boolean temp = getControl().redraw;

		if (!update) {
			getControl().redraw = false;

		} 
		if (update) {
			Graphics2D	og = offscreen.createGraphics();

			og.setClip(0, 0, getSize().width, getSize().height);
			super.paint(og);
			og.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
			control.showDicomSlices(og);
			if (tripple != null) {
				tripple.flush();
			} 
			tripple = offscreen.getSubimage(0, 0, offscreen.getWidth(), offscreen.getHeight());
			g.drawImage(offscreen, 0, 0, null);
		} else {

			// not to update

			Graphics2D	tp = null;

			if (tripple != null) {
				tp = tripple.createGraphics();
				tp.setClip(0, 0, 0, 0);
				super.paint(tp);
			} 
			Rectangle r = g.getClipBounds();

			g.clearRect(r.x, r.y, r.width, r.height);

			g.drawImage(tripple, 0, 0, null);
		} 

		update = false;
		getControl().redraw = temp;

	} 


}






/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

