/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

package mrcp.gui;
import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import ij.process.*;
import java.awt.image.ColorModel;
import java.awt.image.*;
import ij.gui.*;
import ij.*;


/**
 * Dies ist die Oberklasse fr alle grafischen Oberflchen, die die Orthogonalprojektionen
 * in Schichtselektion verwalten. Hier werden alle bentigten Member-Variablen definiert und
 * eine Mglichkeit zur optimalen Kontrast- und Helligkeitseinstellung der Hintergrundbilder implementiet.
 * 
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class JPanel_Ortho_All extends JPanel {


	/**
	 * Verweis auf die gui der Pluginklasse
	 */
	gui					Document;


	/**
	 * Farbmodell des Hintergrundbildes
	 */
	ColorModel	cModel;


	/**
	 * Bildbreite
	 */
	float				Imagewidth = 192;


	/**
	 * Bildhhe
	 */
	float				Imageheigth = 192;


	/**
	 * Hintergrudbild
	 */
	Image				im;


	/**
	 * Korrekturfaktor in x-Richtung zur Anpassung an gewhlten Mastab
	 */
	int					Imagex = 0;


	/**
	 * Korrekturfaktor in y-Richtung zur Anpassung an gewhlten Mastab
	 */
	int					Imagey = 0;


	/**
	 * Vergrerungsfaktor
	 */
	float				factor = 1;


	/**
	 * Reihenauflsung zur Mastabsbestimmung
	 */
	float				RowSpacing = 0;


	/**
	 * Spaltenauflsung zur Mastabsbestimmung
	 */
	float				ColSpacing = 0;


	/**
	 * Konstruiert ein neues Exemplar mit zugehriger gui der Pluginklasse
	 * Es wird ein Standardfarbmodell verwaltet, das ein Darstellung mittels 256 Graustufen erlaubt.
	 * 
	 * 
	 * @param Document gui der Pluginklasse
	 * 
	 */
	public JPanel_Ortho_All(gui Document) {

		this.Document = Document;
		byte[]	cTab = new byte[256];

		for (int i = 0; i < 256; i++) {
			cTab[i] = (byte) i;
		} 
		cModel = new IndexColorModel(8, 256, cTab, cTab, cTab);
	}


	/**
	 * Die Methode liefert die zugehrige gui der Pluginklasse zurck.
	 * 
	 * 
	 * @return Pluginklasse
	 * 
	 * 
	 */
	public gui getDocument() {
		return this.Document;
	} 


	/**
	 * Die Methode berechnet mit Hilfe einer Prozedur in ImageJ eine
	 * optimale Kontrats- und Helligkeitseinstellung fr die Hintergrundbilder.
	 * 
	 * 
	 * @param imp ImagePlus Bild (ImgageJ Bildformat)
	 * @param ip 16-bit Pixeldaten
	 * 
	 * 
	 */
	void autoAdjust(ImagePlus imp, ImageProcessor ip) {

		ImageStatistics stats = imp.getStatistics();
		int[]						histogram = stats.histogram;
		int							threshold = stats.pixelCount / 5000;
		int							i = -1;
		boolean					found = false;

		do {
			i++;
			found = histogram[i] > threshold;
		} while (!found && i < 255);
		int hmin = i;

		i = 256;
		do {
			i--;
			found = histogram[i] > threshold;
		} while (!found && i > 0);
		int hmax = i;

		if (hmax > hmin) {
			imp.killRoi();
			double	min = stats.histMin + hmin * stats.binSize;
			double	max = stats.histMin + hmax * stats.binSize;

			ip.setMinAndMax(min, max);
		} 


	} 

}




/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

