/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

package mrcp.gui;
import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import ij.process.*;
import java.awt.image.ColorModel;
import java.awt.image.*;
import ij.gui.*;
import ij.*;

import mrcp.tools.*;
import mrcp.graphics.*;


/**
 * Die Klasse verwaltet die Orthogonalprojektion "sagittal" in Schichtselektion.
 * Dazu mssen ein Hintergrundbild aus der entsprechenden Ebene und je nach Einstellung die Seitenrisse
 * der ausgewhlten Schichten gezeichnet werden. Eine aktuelle Schicht, die im Vorschaubild zu sehen ist,
 * wird farblich hervorgehoben. Alle Mastbe sind auf das Hintergrundbild einzustellen.
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class JPanel_Ortho_S extends JPanel_Ortho_All {

	// member


	/**
	 * Schichtvektor fr eine exakte Sagittalansicht
	 */
	final Point3D SliceVector = new Point3D(1, 0, 0);


	/**
	 * Schichtvektor fr eine exakte Sagittalansicht
	 */
	final Point3D RowVector = new Point3D(0, 1, 0);


	/**
	 * Schichtvektor fr eine exakte Sagittalansicht
	 */
	final Point3D ColVector = new Point3D(0, 0, -1);


	/**
	 * Ankerpunkt der aktuell zu zeichnenden Projektion
	 */

	Point3D				Origin = null;

	// Konstruktor


	/**
	 * Konstruiert ein neues Exemplar mit zugehriger gui Pluginklasse
	 * 
	 * 
	 * @param Document gui der Pluginklasse
	 * 
	 */
	public JPanel_Ortho_S(gui Document) {

		super(Document);
	}



	/**
	 * Die Methode zeichnet das Hintergrundbild und die Projektion der gewhlten Schichten.
	 * Dazu werden die Daten aus "Update_control" bentigt und umgesetzt.
	 * Es erfolgt eine automatische Kontrast-Helligkeitseinstellung des Hintergrundbildes.
	 * @param g grafischer Kontext
	 * 
	 * 
	 */
	public void paint(Graphics g) {
		Graphics2D	g2 = (Graphics2D) g;
		Rectangle		rc = g2.getClipBounds();

		g2.clearRect(rc.x, rc.y, rc.width, rc.height);

		// g2.clearRect (0,0,this.getBounds ().width,this.getBounds ().height) ;


		if (im == null && getDocument().slicetree.NumberOfSelectesSeries > 0) {
			setImage();
		} else {

			if (getDocument().slicetree.NumberOfSelectesSeries == 0)	// Keine Serien vorhanden, dann weg hier !
 
			{
				im = null;
				return;
			} 
		} 

		g2.drawImage(im, Imagex, Imagey, this);
		if (!Update_control.showAll) {
			if (Update_control.getSlice() == null) {
				return;
			} 
			Update_control.getSlice().setProjection(Global_Options.P_Parallel_Sag2);
			Update_control.getSlice().setCorrectionFactor(-im.getHeight(this) / (getDocument().slicetree.MaxZ - getDocument().slicetree.MinZ));
			Update_control.getSlice().drawCube(g2, Imagey + getDocument().slicetree.MaxZ * im.getHeight(this) / (getDocument().slicetree.MaxZ - getDocument().slicetree.MinZ), Imagex - Origin.getY() * im.getWidth(this) / (getDocument().slicetree.MaxY - getDocument().slicetree.MinY), im.getWidth(this) / (getDocument().slicetree.MaxY - getDocument().slicetree.MinY));
		} else	// show all
		 {
			int old = Update_control.currentSlice;

			Update_control.currentSlice = -1;
			do {
				Update_control.increment();
				if (Update_control.getSlice() == null) {
					return;
				} 
				if (Update_control.currentSlice == old) {
					Update_control.getSlice().setColor(Global_Options.CurrentSliceColor);
				} 
				Update_control.getSlice().setProjection(Global_Options.P_Parallel_Sag2);
				Update_control.getSlice().setCorrectionFactor(-im.getHeight(this) / (getDocument().slicetree.MaxZ - getDocument().slicetree.MinZ));
				Update_control.getSlice().drawCube(g2, Imagey + getDocument().slicetree.MaxZ * im.getHeight(this) / (getDocument().slicetree.MaxZ - getDocument().slicetree.MinZ), Imagex - Origin.getY() * im.getWidth(this) / (getDocument().slicetree.MaxY - getDocument().slicetree.MinY), im.getWidth(this) / (getDocument().slicetree.MaxY - getDocument().slicetree.MinY));
				Update_control.getSlice().setColor(Global_Options.SelectionColor);
			} while (!Update_control.isLast());
			Update_control.currentSlice = old;
		}				// else show all
 
	} 


	/**
	 * Die Methode berechnet das Hintergrundbild neu.
	 * Dies geschieht beim ersten Aufruf, oder dann, wenn der Benutzer die Position des Hintergrundbildes
	 * verndert.
	 */
	public void setImage() {
		Origin = new Point3D(Update_control.Sag_X, getDocument().slicetree.MinY, getDocument().slicetree.MaxZ);

		float Imagewidth = (getDocument().slicetree.MaxY - getDocument().slicetree.MinY);
		float Imageheigth = (getDocument().slicetree.MaxZ - getDocument().slicetree.MinZ);

		if (Imagewidth > 192) {
			factor = 192 / Imagewidth;
			Imagewidth *= factor;
			Imageheigth *= factor;
		} 

		if (Imageheigth > 192) {
			factor = 192 / Imageheigth;
			Imagewidth *= factor;
			Imageheigth *= factor;
		} 

		RowSpacing = (getDocument().slicetree.MaxY - getDocument().slicetree.MinY) / Imagewidth;
		ColSpacing = (getDocument().slicetree.MaxZ - getDocument().slicetree.MinZ) / Imageheigth;
		factor = 1 / RowSpacing;

		Imagex = (int) (192 - Imagewidth) / 2;
		Imagey = (int) (192 - Imageheigth) / 2;

		short[][] Pixels;

		getDocument().slicetree.setSelectedSeries();
		getDocument().slicetree.setSelectedSeries();
		JProgressBar	bar = Document.jProgressBar_Adjustment;

		Pixels = getDocument().slicetree.getSlices_2(Origin, RowVector, ColVector, SliceVector, RowSpacing, ColSpacing, 5, (int) Imageheigth, (int) Imagewidth, bar, 1, Update_control.slicedist);
		ShortProcessor	proc = new ShortProcessor((int) Imagewidth, (int) Imageheigth, Pixels[0], cModel, false);
		ImagePlus				imp = new ImagePlus("", proc);

		autoAdjust(imp, proc);
		im = proc.createImage();

	} 


}




/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

