/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

package mrcp.gui;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import ij.process.*;
import java.awt.image.ColorModel;
import java.awt.image.*;
import ij.gui.*;
import ij.*;
import mrcp.tools.*;
import mrcp.graphics.*;


/**
 * Die Klasse verwaltet das Vorschaubild bezglich der aktuellen Schichtselektion.
 * Die aktuelle Schicht beschreibt dazu ein Volumen, da mit dem vorher selektierten 2D-Datenstzen
 * in eine Bildmatrix umgestzt wird. Dabei werden alle globalen Einstellung, die die Berechnung
 * steuern, verwendet und umgesetzt. Falls das zu berechnende Bild grer als 192 x 192 wird,
 * dann erfolgt eine Skalierung.
 * 
 * @author Thomas Demuth
 * @version 2000.08.28
 */
public class JPanel_Preview extends JPanel_Ortho_All {


	// Konstruktor


	/**
	 * Konstruiert ein neues Exemplar mit zugehriger gui Pluginklasse
	 * 
	 * 
	 * @param Document gui der Pluginklasse
	 * 
	 */
	public JPanel_Preview(gui Document) {

		super(Document);

	}


	/**
	 * Die Methode zeichnet das berechnete Vorschaubild in die Bildflche.
	 * Dazu werden die Daten aus "Update_control" bentigt und umgesetzt.
	 * Es erfolgt eine automatische Kontrast-Helligkeitseinstellung.
	 * @param g grafischer Kontext
	 * 
	 * 
	 */
	public void paint(Graphics g) {
		Graphics2D	g2 = (Graphics2D) g;

		if (im == null) {
			return;

		} 
		g2.clearRect(0, 0, this.getBounds().width, this.getBounds().height);

		// (getDocument ().GlobalQuader).DrawCube (g2,200,0,Global_Options.scale) ;
		// (getDocument().Quader).DrawCube (g2,200,0,Global_Options.scale) ;

		if (Update_control.NewPreView) {
			Document.jButton_Update.setBackground(Color.red);

		} 

		// Ausdehnungen berechnen
		Rectangle r = this.getBounds();
		float			fac1 = (float) r.width / (float) im.getWidth(this);
		float			fac2 = (float) r.height / (float) im.getHeight(this);
		float			fac = Math.min(fac1, fac2);
		float			wi = (im.getWidth(this) * fac);
		float			he = (im.getHeight(this) * fac);

		// zentrieren
		int				left = (int) ((r.width - wi) / 2);
		int				top = (int) ((r.height - he) / 2);


		g2.drawImage(im, left, top, (int) wi, (int) he, this);

		// weitere Informationen anzeigen !
		// validate () ;
	} 


	/**
	 * Die Methode berechnet das Vorschaubild neu.
	 * Dies geschieht beim ersten Aufruf, oder dann, wenn der Benutzer die Position der Schichten
	 * verndert.
	 * 
	 * 
	 */
	public void setImage() {

		Point3D Origin = Update_control.getOrigin();

		if (Origin == null) {
			return;
		} 
		Point3D RowVector = Update_control.RowVec;
		Point3D ColVector = Update_control.ColVec;
		Point3D SliceVector = Update_control.SliceVec;

		RowSpacing = Update_control.width / Update_control.Cols;
		ColSpacing = Update_control.heigth / Update_control.Rows;

		JProgressBar	bar = Document.jProgressBar_Adjustment;

		bar.setMinimum(0);
		bar.setMaximum((int) Update_control.Rows);
		short[][] Pixels;

		Pixels = getDocument().slicetree.getSlices_2(Origin, RowVector, ColVector, SliceVector, RowSpacing, ColSpacing, Update_control.depth, Update_control.Rows, Update_control.Cols, bar, 1, Update_control.slicedist);


		ShortProcessor	proc = new ShortProcessor(Update_control.Cols, Update_control.Rows, Pixels[0], cModel, false);

		ImagePlus				imp = new ImagePlus("", proc);

		// imp.show () ;
		autoAdjust(imp, proc);
		im = proc.createImage();

		Update_control.NewPreView = false;
		Document.jButton_Update.setBackground(Color.lightGray);
	} 

}





/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

